/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.go.linter.handler;

import com.goide.psi.impl.GoElementFactory;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.go.linter.GoLinterBundle;
import com.intellij.go.linter.handler.ProblemHandler;
import com.intellij.go.linter.model.LintIssue;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0004\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/go/linter/handler/NlReturnHandler;", "Lcom/intellij/go/linter/handler/ProblemHandler;", "<init>", "()V", "doSuggestFix", "Lkotlin/Pair;", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/openapi/util/TextRange;", "file", "Lcom/intellij/psi/PsiFile;", "document", "Lcom/intellij/openapi/editor/Document;", "issue", "Lcom/intellij/go/linter/model/LintIssue;", "overrideLine", "", "intellij.go.linter"})
public final class NlReturnHandler
extends ProblemHandler {
    @NotNull
    public static final NlReturnHandler INSTANCE = new NlReturnHandler();

    private NlReturnHandler() {
    }

    @Override
    @NotNull
    public Pair<IntentionAction[], TextRange> doSuggestFix(@NotNull PsiFile file2, @NotNull Document document, @NotNull LintIssue issue, int overrideLine) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        PsiElement element = file2.findElementAt(document.getLineStartOffset(overrideLine));
        if (element instanceof PsiWhiteSpace) {
            IntentionAction[] intentionActionArray = new IntentionAction[]{new LocalQuickFixAndIntentionActionOnPsiElement(element){

                public String getFamilyName() {
                    return this.getText();
                }

                public String getText() {
                    return GoLinterBundle.message("intention.name.insert.new.line.before", new Object[0]);
                }

                public void invoke(Project project, PsiFile psiFile, Editor editor, PsiElement startElement, PsiElement endElement) {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
                    Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
                    Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
                    startElement.getParent().addBefore(GoElementFactory.createNewLine((Project)project, (int)2), startElement);
                }
            }};
            PsiElement psiElement = file2.findElementAt(this.calcPos(document, issue, overrideLine));
            pair = TuplesKt.to((Object)intentionActionArray, (Object)(psiElement != null ? psiElement.getTextRange() : null));
        } else {
            pair = ProblemHandler.Companion.getNonAvailableFix();
        }
        return pair;
    }
}

