/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.go.linter.platform;

import com.intellij.go.linter.platform.Platform;
import com.intellij.go.linter.platform.PlatformKt;
import com.intellij.go.linter.platform.UnixLikePlatform;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.io.Decompressor;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u0007H\u0016J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0096@\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/go/linter/platform/UnixLikePlatform;", "Lcom/intellij/go/linter/platform/Platform;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "tempPath", "", "decompress", "", "archive", "Ljava/io/File;", "targetDir", "fileName", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "linterName", "defaultPaths", "", "Ljava/nio/file/Path;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.go.linter"})
@SourceDebugExtension(value={"SMAP\nUnixLike.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnixLike.kt\ncom/intellij/go/linter/platform/UnixLikePlatform\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,47:1\n1#2:48\n*E\n"})
public abstract class UnixLikePlatform
extends Platform {
    public UnixLikePlatform(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @Override
    @NotNull
    protected String tempPath() {
        return "/tmp";
    }

    @Override
    protected void decompress(@NotNull File archive, @NotNull File targetDir, @NotNull String fileName, @NotNull ProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)archive, (String)"archive");
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        progressIndicator.setIndeterminate(true);
        String string = archive.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String directoryPrefix = StringsKt.substringBefore$default((String)string, (String)".tar.gz", null, (int)2, null);
        new Decompressor.Tar((InputStream)new FileInputStream(archive)).entryFilter(arg_0 -> UnixLikePlatform.decompress$lambda$1(arg_0 -> UnixLikePlatform.decompress$lambda$0(directoryPrefix, fileName, arg_0), arg_0)).removePrefixPath(directoryPrefix).extract(targetDir.toPath());
    }

    @Override
    @NotNull
    public String linterName() {
        return "golangci-lint";
    }

    @Override
    @Nullable
    public Object defaultPaths(@NotNull Continuation<? super Iterable<? extends Path>> $completion) {
        return UnixLikePlatform.defaultPaths$suspendImpl(this, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object defaultPaths$suspendImpl(UnixLikePlatform $this, Continuation<? super Iterable<? extends Path>> $completion) {
        if (!($completion instanceof defaultPaths.1)) ** GOTO lbl-1000
        var8_2 = $completion;
        if ((var8_2.label & -2147483648) != 0) {
            var8_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ UnixLikePlatform this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return UnixLikePlatform.defaultPaths$suspendImpl(this.this$0, (Continuation<? super Iterable<? extends Path>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this);
                $continuation.label = 1;
                v0 = PlatformKt.getPathFromCommand($this.getProject(), "which", CollectionsKt.listOf((Object)"golangci-lint"), (Continuation<? super String>)$continuation);
                if (v0 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                $this = (UnixLikePlatform)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                var3_5 = v0;
                it = (String)var3_5;
                $i$a$-takeIf-UnixLikePlatform$defaultPaths$pathFromWhichCommand$1 = false;
                var6_8 = it;
                pathFromWhichCommand = (String)((var6_8 == null || StringsKt.isBlank((CharSequence)var6_8) != false) == false != false ? var3_5 : null);
                v1 = pathFromWhichCommand;
                if (v1 == null) {
                    v1 = "/usr/local/bin";
                }
                path = v1;
                v2 = Paths.get(path, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"get(...)");
                return CollectionsKt.listOf((Object)v2);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean decompress$lambda$0(String $directoryPrefix, String $fileName, Decompressor.Entry it) {
        if (it.type != Decompressor.Entry.Type.FILE) return false;
        String string = it.name;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        if (!Intrinsics.areEqual((Object)StringsKt.substringAfter$default((String)string, (String)($directoryPrefix + "/"), null, (int)2, null), (Object)$fileName)) return false;
        return true;
    }

    private static final boolean decompress$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

