/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.go.linter.platform;

import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslPath;
import com.intellij.go.linter.platform.Linux;
import com.intellij.go.linter.platform.WSL;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0096@\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0002J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0016J$\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u00142\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/go/linter/platform/WSL;", "Lcom/intellij/go/linter/platform/Linux;", "project", "Lcom/intellij/openapi/project/Project;", "distribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/wsl/WSLDistribution;)V", "tempPath", "", "defaultPaths", "", "Ljava/nio/file/Path;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isWSLAvailablePath", "", "path", "canExecute", "canWrite", "fetchLatestGoLinter", "Lkotlin/Pair;", "destDir", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.go.linter"})
@SourceDebugExtension(value={"SMAP\nWSL.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WSL.kt\ncom/intellij/go/linter/platform/WSL\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n1563#2:53\n1634#2,3:54\n*S KotlinDebug\n*F\n+ 1 WSL.kt\ncom/intellij/go/linter/platform/WSL\n*L\n17#1:53\n17#1:54,3\n*E\n"})
public final class WSL
extends Linux {
    @NotNull
    private final WSLDistribution distribution;

    public WSL(@NotNull Project project, @NotNull WSLDistribution distribution) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)distribution, (String)"distribution");
        super(project);
        this.distribution = distribution;
    }

    @Override
    @NotNull
    protected String tempPath() {
        String string = System.getenv("TEMP");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getenv(...)");
        return string;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object defaultPaths(@NotNull Continuation<? super Iterable<? extends Path>> $completion) {
        if (!($completion instanceof defaultPaths.1)) ** GOTO lbl-1000
        var13_2 = $completion;
        if ((var13_2.label & -2147483648) != 0) {
            var13_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ WSL this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.defaultPaths((Continuation<? super Iterable<? extends Path>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var14_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = super.defaultPaths((Continuation<? super Iterable<? extends Path>>)$continuation);
                if (v0 == var14_4) {
                    return var14_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                $this$map$iv = (Iterable)v0;
                $i$f$map = false;
                var4_7 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var9_12 = (Path)item$iv$iv;
                    var11_14 = destination$iv$iv;
                    $i$a$-map-WSL$defaultPaths$2 = false;
                    v1 = this.distribution.getWindowsPath(it.toString());
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getWindowsPath(...)");
                    v2 = Paths.get(v1, new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"get(...)");
                    var11_14.add(v2);
                }
                return (List)destination$iv$iv;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final boolean isWSLAvailablePath(Path path) {
        WSLDistribution wSLDistribution = WslPath.Companion.getDistributionByWindowsUncPath(((Object)path).toString());
        return wSLDistribution != null ? wSLDistribution.equals((Object)this.distribution) : true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canExecute(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!this.isWSLAvailablePath(path)) return false;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isRegularFile(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return false;
        return true;
    }

    @Override
    public boolean canWrite(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.isWSLAvailablePath(path);
    }

    @Override
    @NotNull
    public Pair<Path, String> fetchLatestGoLinter(@NotNull Path destDir, @NotNull ProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)destDir, (String)"destDir");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        WSLDistribution wSLDistribution = WslPath.Companion.getDistributionByWindowsUncPath(((Object)destDir).toString());
        if (wSLDistribution == null) {
            return super.fetchLatestGoLinter(destDir, progressIndicator);
        }
        WSLDistribution d = wSLDistribution;
        if (!Intrinsics.areEqual((Object)d, (Object)this.distribution)) {
            throw new Exception("cannot download to a different WSL distribution " + d.getMsId() + " other than " + this.distribution.getMsId());
        }
        progressIndicator.setText("Copy into WSL");
        String tempDir = System.getenv("TEMP");
        Intrinsics.checkNotNull((Object)tempDir);
        Path path = Paths.get(tempDir, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Pair<Path, String> pair = super.fetchLatestGoLinter(path, progressIndicator);
        Path binary = (Path)pair.component1();
        String version2 = (String)pair.component2();
        String string = this.distribution.getWslPath(destDir);
        Intrinsics.checkNotNull((Object)string);
        String wslPath = string + "/" + this.linterName();
        Object[] objectArray = new String[]{"cp", this.distribution.getWslPath(binary), wslPath};
        ProcessOutput processOutput = this.distribution.executeOnWsl(CollectionsKt.listOf((Object[])objectArray), new WSLCommandLineOptions(), 2000, null);
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"executeOnWsl(...)");
        ProcessOutput cp = processOutput;
        if (cp.getExitCode() != 0) {
            throw new Exception("Failed to copy " + binary + " into WSL " + wslPath + ": " + cp.getStderr());
        }
        String string2 = this.distribution.getWindowsPath(wslPath);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getWindowsPath(...)");
        Path path2 = Paths.get(string2, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        return TuplesKt.to((Object)path2, (Object)version2);
    }
}

