/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.go.linter.quickfix;

import com.goide.psi.GoStringLiteral;
import com.intellij.go.linter.GoLinterBundle;
import com.intellij.go.linter.quickfix.GoReplaceStringFix;
import com.intellij.go.linter.quickfix.GoReplaceStringFixKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0003H\u0016J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/go/linter/quickfix/GoEscapeStringFix;", "Lcom/intellij/go/linter/quickfix/GoReplaceStringFix;", "utfChar", "", "element", "Lcom/goide/psi/GoStringLiteral;", "<init>", "(Ljava/lang/String;Lcom/goide/psi/GoStringLiteral;)V", "getText", "transform", "text", "intellij.go.linter"})
public final class GoEscapeStringFix
extends GoReplaceStringFix {
    @NotNull
    private final String utfChar;

    public GoEscapeStringFix(@NotNull String utfChar, @NotNull GoStringLiteral element) {
        Intrinsics.checkNotNullParameter((Object)utfChar, (String)"utfChar");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super(element);
        this.utfChar = utfChar;
    }

    @NotNull
    public String getText() {
        return GoLinterBundle.message("intention.name.escape.string", new Object[0]);
    }

    @Override
    @NotNull
    public String transform(@NotNull String text) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String string = this.utfChar.substring(2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        int hex = Integer.parseInt(string, CharsKt.checkRadix((int)16));
        StringBuilder $this$transform_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            StringBuilder stringBuilder2;
            char c = text.charAt(i);
            if (c == hex) {
                String string2 = Integer.toString(c, CharsKt.checkRadix((int)16));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                stringBuilder2 = $this$transform_u24lambda_u240.append("\\u" + string2);
                continue;
            }
            stringBuilder2 = $this$transform_u24lambda_u240.append(c);
        }
        return GoReplaceStringFixKt.access$enquote(stringBuilder.toString());
    }
}

