/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.ssh.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remoteDev.hostStatus.UnattendedHostStatus;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.gateway.ssh.CachingProductsJsonWrapperKt;
import com.jetbrains.gateway.ssh.HostDeployContext;
import com.jetbrains.gateway.ssh.LocalRecentConnectionsManager;
import com.jetbrains.gateway.ssh.util.RemoteRecentProjectsHelper$DeployInfo$;
import com.jetbrains.gateway.ssh.util.RemoteRecentProjectsHelperExtension;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\b&\u0018\u0000  *\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0002 !B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007H$J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u000bJ\u0017\u0010\f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\r\u001a\u00020\u000eH$\u00a2\u0006\u0002\u0010\u000fJ\u001c\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\tH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\tH\u0016R\u0012\u0010\u0018\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001a\u00a8\u0006\""}, d2={"Lcom/jetbrains/gateway/ssh/util/RemoteRecentProjectsHelper;", "TConfig", "", "Lcom/jetbrains/gateway/ssh/util/RemoteRecentProjectsHelperExtension;", "<init>", "()V", "getRecentConnectionsManager", "Lcom/jetbrains/gateway/ssh/LocalRecentConnectionsManager;", "getConfigId", "", "config", "(Ljava/lang/Object;)Ljava/lang/String;", "findConfigById", "deployInfo", "Lcom/jetbrains/gateway/ssh/util/RemoteRecentProjectsHelper$DeployInfo;", "(Lcom/jetbrains/gateway/ssh/util/RemoteRecentProjectsHelper$DeployInfo;)Ljava/lang/Object;", "addToRecent", "", "context", "Lcom/jetbrains/gateway/ssh/HostDeployContext;", "status", "Lcom/intellij/remoteDev/hostStatus/UnattendedHostStatus;", "createSuccessfulDeployMessage", "configId", "customDeployPrefix", "getCustomDeployPrefix", "()Ljava/lang/String;", "fullDeployPrefix", "getFullDeployPrefix", "canHandleMessage", "", "message", "Companion", "DeployInfo", "intellij.gateway.core"})
@SourceDebugExtension(value={"SMAP\nAddToRecent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddToRecent.kt\ncom/jetbrains/gateway/ssh/util/RemoteRecentProjectsHelper\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,111:1\n13#2:112\n*S KotlinDebug\n*F\n+ 1 AddToRecent.kt\ncom/jetbrains/gateway/ssh/util/RemoteRecentProjectsHelper\n*L\n30#1:112\n*E\n"})
public abstract class RemoteRecentProjectsHelper<TConfig>
implements RemoteRecentProjectsHelperExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;
    @NotNull
    public static final String SuccessfulDeployPrefix = "Deployment Successful #$hi#";
    @NotNull
    private static final String messageSuffix = "#$poka#";

    @NotNull
    protected abstract LocalRecentConnectionsManager<TConfig> getRecentConnectionsManager();

    @NotNull
    protected abstract String getConfigId(@NotNull TConfig var1);

    @Nullable
    protected abstract TConfig findConfigById(@NotNull DeployInfo var1);

    public final void addToRecent(@NotNull HostDeployContext<TConfig> context, @NotNull UnattendedHostStatus status2) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)status2, (String)"status");
        ThreadingAssertions.assertEventDispatchThread();
        TConfig TConfig = context.getConfig();
        if (TConfig == null) {
            return;
        }
        TConfig config = TConfig;
        try {
            logger.info("Add to Recent. sshConfig: " + config);
            this.getRecentConnectionsManager().registerHost(config);
        }
        catch (Throwable e) {
            logger.error("Failed to register host", e);
        }
        logger.warn(this.createSuccessfulDeployMessage(this.getConfigId(config)));
    }

    private final String createSuccessfulDeployMessage(String configId) {
        return this.getFullDeployPrefix() + new DeployInfo(configId).toJson() + messageSuffix;
    }

    @NotNull
    public abstract String getCustomDeployPrefix();

    private final String getFullDeployPrefix() {
        return SuccessfulDeployPrefix + this.getCustomDeployPrefix() + "#";
    }

    @Override
    public boolean canHandleMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return StringsKt.contains$default((CharSequence)message, (CharSequence)this.getFullDeployPrefix(), (boolean)false, (int)2, null);
    }

    @Override
    public void addToRecent(@NotNull String message) {
        DeployInfo deployInfo;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ThreadingAssertions.assertEventDispatchThread();
        logger.info("Got match for successful deploy: '" + message + "'");
        String jsonStr = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)message, (String)this.getFullDeployPrefix(), null, (int)2, null), (String)messageSuffix, null, (int)2, null);
        try {
            deployInfo = DeployInfo.Companion.fromJson(jsonStr);
        }
        catch (SerializationException e) {
            logger.warn("Failed to parse DeployInfo from '" + jsonStr + "'", (Throwable)e);
            return;
        }
        DeployInfo deployInfo2 = deployInfo;
        TConfig TConfig = this.findConfigById(deployInfo2);
        if (TConfig == null) {
            return;
        }
        TConfig config = TConfig;
        logger.info("Add to Recent. sshConfig: " + config);
        this.getRecentConnectionsManager().registerHost(config);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RemoteRecentProjectsHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RemoteRecentProjectsHelper.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003R\u000e\u0010\u0007\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/gateway/ssh/util/RemoteRecentProjectsHelper$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger$annotations", "SuccessfulDeployPrefix", "", "messageSuffix", "intellij.gateway.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getLogger$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B%\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0004\u0010\nJ\u0006\u0010\r\u001a\u00020\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0001\u00a2\u0006\u0002\b\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/gateway/ssh/util/RemoteRecentProjectsHelper$DeployInfo;", "", "configId", "", "<init>", "(Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getConfigId", "()Ljava/lang/String;", "toJson", "component1", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_gateway_core", "Companion", "$serializer", "intellij.gateway.core"})
    @SourceDebugExtension(value={"SMAP\nAddToRecent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddToRecent.kt\ncom/jetbrains/gateway/ssh/util/RemoteRecentProjectsHelper$DeployInfo\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,111:1\n205#2:112\n*S KotlinDebug\n*F\n+ 1 AddToRecent.kt\ncom/jetbrains/gateway/ssh/util/RemoteRecentProjectsHelper$DeployInfo\n*L\n64#1:112\n*E\n"})
    public static final class DeployInfo {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String configId;

        public DeployInfo(@NotNull String configId) {
            Intrinsics.checkNotNullParameter((Object)configId, (String)"configId");
            this.configId = configId;
        }

        @NotNull
        public final String getConfigId() {
            return this.configId;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String toJson() {
            void this_$iv;
            Json json = CachingProductsJsonWrapperKt.getJsonFormat();
            DeployInfo value$iv = this;
            boolean $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            return this_$iv.encodeToString((SerializationStrategy)Companion.serializer(), (Object)value$iv);
        }

        @NotNull
        public final String component1() {
            return this.configId;
        }

        @NotNull
        public final DeployInfo copy(@NotNull String configId) {
            Intrinsics.checkNotNullParameter((Object)configId, (String)"configId");
            return new DeployInfo(configId);
        }

        public static /* synthetic */ DeployInfo copy$default(DeployInfo deployInfo, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = deployInfo.configId;
            }
            return deployInfo.copy(string);
        }

        @NotNull
        public String toString() {
            return "DeployInfo(configId=" + this.configId + ")";
        }

        public int hashCode() {
            return this.configId.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DeployInfo)) {
                return false;
            }
            DeployInfo deployInfo = (DeployInfo)other;
            return Intrinsics.areEqual((Object)this.configId, (Object)deployInfo.configId);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_gateway_core(DeployInfo self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeStringElement(serialDesc, 0, self.configId);
        }

        public /* synthetic */ DeployInfo(int seen0, String configId, SerializationConstructorMarker serializationConstructorMarker) {
            if (1 != (1 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)DeployInfo$$serializer.INSTANCE.getDescriptor());
            }
            this.configId = configId;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/gateway/ssh/util/RemoteRecentProjectsHelper$DeployInfo$Companion;", "", "<init>", "()V", "fromJson", "Lcom/jetbrains/gateway/ssh/util/RemoteRecentProjectsHelper$DeployInfo;", "json", "", "serializer", "Lkotlinx/serialization/KSerializer;", "intellij.gateway.core"})
        @SourceDebugExtension(value={"SMAP\nAddToRecent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddToRecent.kt\ncom/jetbrains/gateway/ssh/util/RemoteRecentProjectsHelper$DeployInfo$Companion\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,111:1\n222#2:112\n*S KotlinDebug\n*F\n+ 1 AddToRecent.kt\ncom/jetbrains/gateway/ssh/util/RemoteRecentProjectsHelper$DeployInfo$Companion\n*L\n61#1:112\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final DeployInfo fromJson(@NotNull String json) {
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                Json json2 = CachingProductsJsonWrapperKt.getJsonFormat();
                String string$iv = json;
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                return (DeployInfo)this_$iv.decodeFromString((DeserializationStrategy)Companion.serializer(), string$iv);
            }

            @NotNull
            public final KSerializer<DeployInfo> serializer() {
                return (KSerializer)DeployInfo$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

