/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terraform.template;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.ConfigurableTemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.terraform.template.TftplFileViewProviderKt;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.hil.psi.template.TftplLanguage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0014J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0016J\b\u0010\u0013\u001a\u00020\nH\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0006H\u0014J\b\u0010\u0018\u001a\u00020\nH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/terraform/template/TftplFileViewProvider;", "Lcom/intellij/psi/MultiplePsiFilesPerDocumentFileViewProvider;", "Lcom/intellij/psi/templateLanguages/ConfigurableTemplateLanguageFileViewProvider;", "psiManager", "Lcom/intellij/psi/PsiManager;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "eventSystemEnabled", "", "givenDataLanguage", "Lcom/intellij/lang/Language;", "<init>", "(Lcom/intellij/psi/PsiManager;Lcom/intellij/openapi/vfs/VirtualFile;ZLcom/intellij/lang/Language;)V", "createFile", "Lcom/intellij/psi/PsiFile;", "lang", "getContentElementType", "Lcom/intellij/psi/tree/IElementType;", "language", "getBaseLanguage", "getLanguages", "", "cloneInner", "fileCopy", "getTemplateDataLanguage", "intellij.terraform.template"})
public final class TftplFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements ConfigurableTemplateLanguageFileViewProvider {
    @NotNull
    private final Language givenDataLanguage;

    public TftplFileViewProvider(@NotNull PsiManager psiManager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled, @NotNull Language givenDataLanguage) {
        Intrinsics.checkNotNullParameter((Object)psiManager, (String)"psiManager");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)givenDataLanguage, (String)"givenDataLanguage");
        super(psiManager, virtualFile, eventSystemEnabled);
        this.givenDataLanguage = givenDataLanguage;
    }

    public /* synthetic */ TftplFileViewProvider(PsiManager psiManager, VirtualFile virtualFile, boolean bl, Language language, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            Project project = psiManager.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            language = TftplFileViewProviderKt.doComputeTemplateDataLanguage(virtualFile, project);
        }
        this(psiManager, virtualFile, bl, language);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        PsiFile psiFile;
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (parserDefinition == null) {
            return null;
        }
        ParserDefinition dataLanguageParser = parserDefinition;
        if (lang == this.getBaseLanguage()) {
            psiFile = dataLanguageParser.createFile((FileViewProvider)this);
        } else if (lang == this.getTemplateDataLanguage()) {
            void var3_3;
            PsiFile psiFile2 = dataLanguageParser.createFile((FileViewProvider)this);
            Intrinsics.checkNotNull((Object)psiFile2, (String)"null cannot be cast to non-null type com.intellij.psi.impl.source.PsiFileImpl");
            PsiFileImpl file = (PsiFileImpl)psiFile2;
            file.setContentElementType(TftplFileViewProviderKt.access$getTEMPLATE_DATA$p());
            psiFile = (PsiFile)var3_3;
        } else {
            psiFile = null;
        }
        return psiFile;
    }

    @Nullable
    public IElementType getContentElementType(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return language == this.getTemplateDataLanguage() ? TftplFileViewProviderKt.access$getTEMPLATE_DATA$p() : null;
    }

    @NotNull
    public Language getBaseLanguage() {
        return (Language)TftplLanguage.INSTANCE;
    }

    @NotNull
    public Set<Language> getLanguages() {
        Object[] objectArray = new Language[]{this.getBaseLanguage(), this.getTemplateDataLanguage()};
        return SetsKt.hashSetOf((Object[])objectArray);
    }

    @NotNull
    protected MultiplePsiFilesPerDocumentFileViewProvider cloneInner(@NotNull VirtualFile fileCopy) {
        Intrinsics.checkNotNullParameter((Object)fileCopy, (String)"fileCopy");
        PsiManagerEx psiManagerEx = this.getManager();
        Intrinsics.checkNotNullExpressionValue((Object)psiManagerEx, (String)"getManager(...)");
        PsiManager psiManager = (PsiManager)psiManagerEx;
        VirtualFile virtualFile = this.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        Project project = this.getManager().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new TftplFileViewProvider(psiManager, fileCopy, false, TftplFileViewProviderKt.doComputeTemplateDataLanguage(virtualFile, project));
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        return this.givenDataLanguage;
    }
}

