/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terraform.template;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.templateLanguages.TemplateDataElementType;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.OuterLanguageElementType;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.terraform.hil.psi.template.TftplLanguage;
import org.intellij.terraform.hil.psi.template.TftplTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0012\u0010\t\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\bH\u0000\"\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"doComputeTemplateDataLanguage", "Lcom/intellij/lang/Language;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "tryGuessLanguageByCompositeExtension", "fileName", "", "getLanguageByExtension", "maybeDataLanguageExtension", "knownTemplateExtensions", "", "getKnownTemplateExtensions", "()Ljava/util/Set;", "TEMPLATE_FRAGMENT", "Lcom/intellij/psi/tree/IElementType;", "TEMPLATE_DATA", "intellij.terraform.template"})
@SourceDebugExtension(value={"SMAP\nTftplFileViewProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TftplFileViewProvider.kt\ncom/intellij/terraform/template/TftplFileViewProviderKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,106:1\n1#2:107\n19#3:108\n*S KotlinDebug\n*F\n+ 1 TftplFileViewProvider.kt\ncom/intellij/terraform/template/TftplFileViewProviderKt\n*L\n96#1:108\n*E\n"})
public final class TftplFileViewProviderKt {
    @NotNull
    private static final Set<String> knownTemplateExtensions;
    @NotNull
    private static final IElementType TEMPLATE_FRAGMENT;
    @NotNull
    private static final IElementType TEMPLATE_DATA;

    @NotNull
    public static final Language doComputeTemplateDataLanguage(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        Language language;
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        TemplateDataLanguageMappings templateDataLanguageMappings = TemplateDataLanguageMappings.getInstance((Project)project);
        if (templateDataLanguageMappings == null || (templateDataLanguageMappings = templateDataLanguageMappings.getMapping(virtualFile)) == null) {
            String string = virtualFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            templateDataLanguageMappings = TftplFileViewProviderKt.tryGuessLanguageByCompositeExtension(string);
            if (templateDataLanguageMappings == null) {
                templateDataLanguageMappings = (Language)PlainTextLanguage.INSTANCE;
            }
        }
        TemplateDataLanguageMappings dataLanguage = templateDataLanguageMappings;
        Language language2 = LanguageSubstitutors.getInstance().substituteLanguage((Language)dataLanguage, virtualFile, project);
        Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"substituteLanguage(...)");
        Language substituteLang = language2;
        if (TemplateDataLanguageMappings.getTemplateableLanguages().contains(substituteLang)) {
            language = substituteLang;
        } else {
            TemplateDataLanguageMappings templateDataLanguageMappings2 = dataLanguage;
            Intrinsics.checkNotNull((Object)templateDataLanguageMappings2);
            language = templateDataLanguageMappings2;
        }
        return language;
    }

    private static final Language tryGuessLanguageByCompositeExtension(String fileName) {
        Pair pair;
        block5: {
            block4: {
                char[] cArray;
                Object object = new char[]{'.'};
                char[] it = object = (Object)StringsKt.split$default((CharSequence)fileName, (char[])object, (boolean)false, (int)0, (int)6, null);
                boolean bl = false;
                char[] cArray2 = cArray = it.size() == 3 ? object : null;
                if (cArray == null || (object = CollectionsKt.takeLast((List)cArray, (int)2)) == null) break block4;
                char[] it2 = object;
                boolean bl2 = false;
                pair = TuplesKt.to((Object)CollectionsKt.first((List)it2), (Object)CollectionsKt.last((List)it2));
                if (pair != null) break block5;
            }
            return null;
        }
        Pair pair2 = pair;
        String maybeDataLanguageExtension = (String)pair2.component1();
        String maybeTemplateLanguageExtension = (String)pair2.component2();
        if (!knownTemplateExtensions.contains(maybeTemplateLanguageExtension)) {
            return null;
        }
        return TftplFileViewProviderKt.getLanguageByExtension(maybeDataLanguageExtension);
    }

    @Nullable
    public static final Language getLanguageByExtension(@NotNull String maybeDataLanguageExtension) {
        LanguageFileType languageFileType;
        Intrinsics.checkNotNullParameter((Object)maybeDataLanguageExtension, (String)"maybeDataLanguageExtension");
        FileType $this$asSafely$iv = FileTypeManager.getInstance().getFileTypeByExtension(maybeDataLanguageExtension);
        boolean $i$f$asSafely = false;
        FileType fileType = $this$asSafely$iv;
        if (!(fileType instanceof LanguageFileType)) {
            fileType = null;
        }
        return (languageFileType = (LanguageFileType)fileType) != null ? languageFileType.getLanguage() : null;
    }

    @NotNull
    public static final Set<String> getKnownTemplateExtensions() {
        return knownTemplateExtensions;
    }

    public static final /* synthetic */ IElementType access$getTEMPLATE_DATA$p() {
        return TEMPLATE_DATA;
    }

    static {
        Object[] objectArray = new String[]{"tftpl", "tfpl"};
        knownTemplateExtensions = SetsKt.setOf((Object[])objectArray);
        TEMPLATE_FRAGMENT = (IElementType)new OuterLanguageElementType("TerraformTemplateSegmentElementType", (Language)TftplLanguage.INSTANCE);
        TEMPLATE_DATA = (IElementType)new TemplateDataElementType("TerraformTemplateTextElementType", (Language)TftplLanguage.INSTANCE, TftplTokenTypes.DATA_LANGUAGE_TOKEN_UNPARSED, TEMPLATE_FRAGMENT);
    }
}

