/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terraform.template.editor;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.terraform.template.TftplFileViewProvider;
import com.intellij.terraform.template.model.TftplVariable;
import com.intellij.terraform.template.psi.TftplFile;
import com.intellij.util.ProcessingContext;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.hil.HILElementTypes;
import org.intellij.terraform.hil.psi.ILExpressionHolder;
import org.intellij.terraform.hil.psi.ILVariable;
import org.intellij.terraform.hil.psi.template.TftplLanguage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0000\u001a$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\u0014\b\u0002\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\u0015H\u0000\u001a$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\u0014\b\u0002\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\u0015H\u0000\u001a\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013H\u0002\u001a\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"HIGH_COMPLETION_PRIORITY", "", "translateToTemplateLanguageElement", "Lcom/intellij/psi/PsiElement;", "position", "computeAbsoluteOffsetInFile", "", "getTemplateFileViewProvider", "Lcom/intellij/terraform/template/TftplFileViewProvider;", "element", "hilVariablePattern", "Lcom/intellij/patterns/ElementPattern;", "getHilVariablePattern", "()Lcom/intellij/patterns/ElementPattern;", "isTemplateFileElement", "", "psiElement", "isInjectedHil", "createHilVariablePattern", "Lcom/intellij/patterns/PsiElementPattern$Capture;", "test", "Lkotlin/Function1;", "createPattern", "isRightAfterControlKeyword", "createVariableLookupSkeleton", "Lcom/intellij/codeInsight/lookup/LookupElementBuilder;", "variable", "Lcom/intellij/terraform/template/model/TftplVariable;", "intellij.terraform.template"})
public final class TftplTemplateVariableSearchUtilsKt {
    public static final double HIGH_COMPLETION_PRIORITY = 100.0;
    @NotNull
    private static final ElementPattern<PsiElement> hilVariablePattern;

    @Nullable
    public static final PsiElement translateToTemplateLanguageElement(@NotNull PsiElement position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        TftplFileViewProvider tftplFileViewProvider = TftplTemplateVariableSearchUtilsKt.getTemplateFileViewProvider(position);
        if (tftplFileViewProvider == null) {
            return null;
        }
        TftplFileViewProvider viewProvider = tftplFileViewProvider;
        int offsetInFile = TftplTemplateVariableSearchUtilsKt.computeAbsoluteOffsetInFile(position);
        return viewProvider.findElementAt(offsetInFile, (Language)TftplLanguage.INSTANCE);
    }

    private static final int computeAbsoluteOffsetInFile(PsiElement position) {
        PsiLanguageInjectionHost psiLanguageInjectionHost = InjectedLanguageManager.getInstance((Project)position.getProject()).getInjectionHost(position);
        int injectionHostStartOffsetIfAny = psiLanguageInjectionHost != null ? PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)psiLanguageInjectionHost)) : 0;
        int elementUnderCaretOffset = PsiTreeUtilKt.getStartOffset((PsiElement)position);
        return elementUnderCaretOffset + injectionHostStartOffsetIfAny;
    }

    @Nullable
    public static final TftplFileViewProvider getTemplateFileViewProvider(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile psiFile = InjectedLanguageManager.getInstance((Project)element.getProject()).getTopLevelFile(element);
        FileViewProvider fileViewProvider = psiFile != null ? psiFile.getViewProvider() : null;
        return fileViewProvider instanceof TftplFileViewProvider ? (TftplFileViewProvider)fileViewProvider : null;
    }

    @NotNull
    public static final ElementPattern<PsiElement> getHilVariablePattern() {
        return hilVariablePattern;
    }

    public static final boolean isTemplateFileElement(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        return psiElement.getContainingFile() instanceof TftplFile;
    }

    public static final boolean isInjectedHil(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        return InjectedLanguageManager.getInstance((Project)psiElement.getProject()).isInjectedFragment(psiElement.getContainingFile());
    }

    @NotNull
    public static final PsiElementPattern.Capture<PsiElement> createHilVariablePattern(@NotNull Function1<? super PsiElement, Boolean> test) {
        Intrinsics.checkNotNullParameter(test, (String)"test");
        ObjectPattern objectPattern = ((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)HILElementTypes.ID).withParent(ILVariable.class)).withSuperParent(2, ILExpressionHolder.class)).with((PatternCondition)new PatternCondition<PsiElement>(test){
            final /* synthetic */ Function1<PsiElement, Boolean> $test;
            {
                this.$test = $test;
                super("isVariableWithoutSiblings");
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean accepts(PsiElement element, ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if ((Boolean)this.$test.invoke((Object)element) == false) return false;
                PsiElement psiElement = PsiTreeUtil.prevCodeLeaf((PsiElement)element);
                if (!Intrinsics.areEqual((Object)(psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null), (Object)HILElementTypes.INTERPOLATION_START)) return false;
                PsiElement psiElement2 = PsiTreeUtil.nextCodeLeaf((PsiElement)element);
                if (!Intrinsics.areEqual((Object)(psiElement2 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement2) : null), (Object)HILElementTypes.R_CURLY)) return false;
                return true;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"with(...)");
        return (PsiElementPattern.Capture)objectPattern;
    }

    public static /* synthetic */ PsiElementPattern.Capture createHilVariablePattern$default(Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = TftplTemplateVariableSearchUtilsKt::createHilVariablePattern$lambda$0;
        }
        return TftplTemplateVariableSearchUtilsKt.createHilVariablePattern((Function1<? super PsiElement, Boolean>)function1);
    }

    @NotNull
    public static final PsiElementPattern.Capture<PsiElement> createPattern(@NotNull Function1<? super PsiElement, Boolean> test) {
        Intrinsics.checkNotNullParameter(test, (String)"test");
        ObjectPattern objectPattern = PlatformPatterns.psiElement().with((PatternCondition)new PatternCondition<PsiElement>(test){
            final /* synthetic */ Function1<PsiElement, Boolean> $test;
            {
                this.$test = $test;
                super("commonHilElementPattern");
            }

            public boolean accepts(PsiElement element, ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                return (Boolean)this.$test.invoke((Object)element);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"with(...)");
        return (PsiElementPattern.Capture)objectPattern;
    }

    public static /* synthetic */ PsiElementPattern.Capture createPattern$default(Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = TftplTemplateVariableSearchUtilsKt::createPattern$lambda$0;
        }
        return TftplTemplateVariableSearchUtilsKt.createPattern((Function1<? super PsiElement, Boolean>)function1);
    }

    private static final PsiElementPattern.Capture<PsiElement> isRightAfterControlKeyword() {
        ObjectPattern objectPattern = PlatformPatterns.psiElement((IElementType)HILElementTypes.ID).with((PatternCondition)new PatternCondition<PsiElement>(){

            public boolean accepts(PsiElement element, ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement psiElement = PsiTreeUtil.prevCodeLeaf((PsiElement)element);
                IElementType previousElementType = psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null;
                return Intrinsics.areEqual((Object)previousElementType, (Object)HILElementTypes.IN_KEYWORD) || Intrinsics.areEqual((Object)previousElementType, (Object)HILElementTypes.IF_KEYWORD);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"with(...)");
        return (PsiElementPattern.Capture)objectPattern;
    }

    @NotNull
    public static final LookupElementBuilder createVariableLookupSkeleton(@NotNull TftplVariable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)variable.getName()).withTypeText(variable.getType().getPresentableName()).withIcon(variable.getType().getIcon()).withPsiElement(variable.getNavigationElement());
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"withPsiElement(...)");
        return lookupElementBuilder;
    }

    private static final boolean hilVariablePattern$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return TftplTemplateVariableSearchUtilsKt.isTemplateFileElement(it) || TftplTemplateVariableSearchUtilsKt.isInjectedHil(it);
    }

    private static final boolean createHilVariablePattern$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean createPattern$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    static {
        ElementPattern[] elementPatternArray = new ElementPattern[]{TftplTemplateVariableSearchUtilsKt.createHilVariablePattern((Function1<? super PsiElement, Boolean>)((Function1)TftplTemplateVariableSearchUtilsKt::hilVariablePattern$lambda$0)), TftplTemplateVariableSearchUtilsKt.isRightAfterControlKeyword()};
        ElementPattern elementPattern = PlatformPatterns.or((ElementPattern[])elementPatternArray);
        Intrinsics.checkNotNullExpressionValue((Object)elementPattern, (String)"or(...)");
        hilVariablePattern = elementPattern;
    }
}

