/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.model;

import com.intellij.kubernetes.model.KubernetesModelDefinition;
import com.intellij.kubernetes.model.ResourceIdentity;
import com.intellij.kubernetes.model.SchemaSpecInfo;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.meta.model.YamlAnything;
import org.jetbrains.yaml.meta.model.YamlMetaClass;
import org.jetbrains.yaml.meta.model.YamlMetaType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018J\u0014\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001cJ\u0016\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\fJ\u0006\u0010 \u001a\u00020\u001aJ\u0006\u0010\u000b\u001a\u00020\fR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006!"}, d2={"Lcom/intellij/kubernetes/model/GenericKubernetesModelDefinition;", "Lcom/intellij/kubernetes/model/KubernetesModelDefinition;", "Lorg/jetbrains/yaml/meta/model/YamlMetaClass;", "typeName", "", "specInfo", "Lcom/intellij/kubernetes/model/SchemaSpecInfo;", "<init>", "(Ljava/lang/String;Lcom/intellij/kubernetes/model/SchemaSpecInfo;)V", "getSpecInfo", "()Lcom/intellij/kubernetes/model/SchemaSpecInfo;", "hasAnyNameFeature", "", "applicableResources", "", "Lcom/intellij/kubernetes/model/ResourceIdentity;", "getApplicableResources", "()Ljava/util/Set;", "addFeature", "Lorg/jetbrains/yaml/meta/model/Field;", "name", "type", "Lorg/jetbrains/yaml/meta/model/YamlMetaType;", "typeSupplier", "Lorg/jetbrains/yaml/meta/model/Field$MetaTypeSupplier;", "addApplicableResources", "", "keys", "", "addAnyNameFeature", "fieldType", "isArray", "addUnstructuredAnyNameFeature", "intellij.clouds.kubernetes.backend"})
public class GenericKubernetesModelDefinition
extends YamlMetaClass
implements KubernetesModelDefinition {
    @Nullable
    private final SchemaSpecInfo specInfo;
    private boolean hasAnyNameFeature;
    @NotNull
    private final Set<ResourceIdentity> applicableResources;

    public GenericKubernetesModelDefinition(@NotNull String typeName, @Nullable SchemaSpecInfo specInfo) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        super(typeName);
        this.specInfo = specInfo;
        this.applicableResources = new HashSet();
    }

    @Override
    @Nullable
    public SchemaSpecInfo getSpecInfo() {
        return this.specInfo;
    }

    @Override
    @NotNull
    public Set<ResourceIdentity> getApplicableResources() {
        return this.applicableResources;
    }

    @NotNull
    public final Field addFeature(@NotNull String name, @NotNull YamlMetaType type) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Field field2 = this.addFeature(new Field(name, type));
        Intrinsics.checkNotNullExpressionValue((Object)field2, (String)"addFeature(...)");
        return field2;
    }

    @NotNull
    public final Field addFeature(@NotNull String name, @NotNull Field.MetaTypeSupplier typeSupplier) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)typeSupplier, (String)"typeSupplier");
        Field field2 = this.addFeature(new Field(name, typeSupplier));
        Intrinsics.checkNotNullExpressionValue((Object)field2, (String)"addFeature(...)");
        return field2;
    }

    public final void addApplicableResources(@NotNull Collection<ResourceIdentity> keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Set<ResourceIdentity> set = this.getApplicableResources();
        Intrinsics.checkNotNull(set, (String)"null cannot be cast to non-null type java.util.HashSet<com.intellij.kubernetes.model.ResourceIdentity>");
        ((HashSet)set).addAll(keys);
    }

    public final void addAnyNameFeature(@NotNull YamlMetaType fieldType, boolean isArray) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)fieldType, (String)"fieldType");
        boolean bl2 = bl = !this.hasAnyNameFeature;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Field field2 = this.addFeature(new Field("<any-name>", fieldType)).withAnyName();
        Intrinsics.checkNotNullExpressionValue((Object)field2, (String)"withAnyName(...)");
        Field feature = field2;
        if (isArray) {
            feature.withMultiplicityMany();
        }
        this.hasAnyNameFeature = true;
    }

    public final void addUnstructuredAnyNameFeature() {
        boolean bl;
        boolean bl2 = bl = !this.hasAnyNameFeature;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        YamlMetaType yamlMetaType = YamlAnything.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)yamlMetaType, (String)"getInstance(...)");
        this.addFeature("<any-key>", yamlMetaType).withAnyName().withRelationSpecificType(Field.Relation.SEQUENCE_ITEM, YamlAnything.getInstance()).withEmptyValueAllowed(true);
        this.hasAnyNameFeature = true;
    }

    public final boolean hasAnyNameFeature() {
        return this.hasAnyNameFeature;
    }
}

