/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.DatabaseSessionActionBase;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.run.session.Session;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class RenameSessionAction
extends DatabaseSessionActionBase {
    @Override
    protected boolean isEnabled(@NotNull AnActionEvent e, @NotNull DatabaseSession session) {
        if (e == null) {
            RenameSessionAction.$$$reportNull$$$0(0);
        }
        if (session == null) {
            RenameSessionAction.$$$reportNull$$$0(1);
        }
        return e.getData(Session.SESSION_KEY) == session && !session.isService();
    }

    @Override
    protected void performAction(@NotNull AnActionEvent e, @NotNull DatabaseSession session) {
        Project project;
        if (e == null) {
            RenameSessionAction.$$$reportNull$$$0(2);
        }
        if (session == null) {
            RenameSessionAction.$$$reportNull$$$0(3);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        String title = DatabaseBundle.message((String)"dialog.title.rename.session", (Object[])new Object[]{session.getTitle()});
        Icon idon = Messages.getQuestionIcon();
        String newName = Messages.showInputDialog((Project)project, (String)DatabaseBundle.message((String)"dialog.message.enter.new.name", (Object[])new Object[0]), (String)title, (Icon)idon, (String)session.getTitle(), (InputValidator)new MyValidator(project, session));
        if (StringUtil.isNotEmpty((String)newName)) {
            session.setTitle(StringUtil.trim((String)newName));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/actions/RenameSessionAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "performAction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyValidator
    implements InputValidator {
        private final Project myProject;
        private final DatabaseSession mySession;

        MyValidator(@NotNull Project project, @NotNull DatabaseSession session) {
            if (project == null) {
                MyValidator.$$$reportNull$$$0(0);
            }
            if (session == null) {
                MyValidator.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.mySession = session;
        }

        public boolean checkInput(String inputString) {
            List sessions = DatabaseSessionManager.getSessions((Project)this.myProject, (LocalDataSource)((DatabaseConnectionPoint)this.mySession.getTarget()).getDataSource());
            return !ContainerUtil.exists((Iterable)sessions, s -> StringUtil.equals((CharSequence)s.getTitle(), (CharSequence)inputString)) && !"default".equals(inputString);
        }

        public boolean canClose(String inputString) {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "session";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/actions/RenameSessionAction$MyValidator";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

