/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.cloud;

import ai.grazie.model.cloud.exceptions.HttpExceptionBase;
import com.intellij.grazie.cloud.BackgroundCloudService;
import com.intellij.grazie.cloud.GrazieCloudConnectionState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/intellij/grazie/cloud/GrazieCloudNotifications;", "", "<init>", "()V", "Connection", "intellij.grazie.core"})
public final class GrazieCloudNotifications {
    @NotNull
    public static final GrazieCloudNotifications INSTANCE = new GrazieCloudNotifications();

    private GrazieCloudNotifications() {
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001a\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/grazie/cloud/GrazieCloudNotifications$Connection;", "", "<init>", "()V", "connectionError", "", "project", "Lcom/intellij/openapi/project/Project;", "service", "Lcom/intellij/grazie/cloud/BackgroundCloudService;", "e", "", "connectionStable", "intellij.grazie.core"})
    @SourceDebugExtension(value={"SMAP\nGrazieCloudNotifications.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieCloudNotifications.kt\ncom/intellij/grazie/cloud/GrazieCloudNotifications$Connection\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,38:1\n23#2:39\n*S KotlinDebug\n*F\n+ 1 GrazieCloudNotifications.kt\ncom/intellij/grazie/cloud/GrazieCloudNotifications$Connection\n*L\n22#1:39\n*E\n"})
    public static final class Connection {
        @NotNull
        public static final Connection INSTANCE = new Connection();

        private Connection() {
        }

        @JvmStatic
        public static final synchronized void connectionError(@NotNull Project project, @Nullable BackgroundCloudService service, @NotNull Throwable e) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Object msg = "Cloud connection error";
            if (e instanceof HttpExceptionBase) {
                String traceId;
                Object[] objectArray = ((HttpExceptionBase)e).getHeaders().get("Grazie-Trace-Id");
                String string = traceId = objectArray != null ? (String)ArraysKt.singleOrNull((Object[])objectArray) : null;
                if (traceId != null) {
                    msg = (String)msg + "; traceId=" + traceId;
                }
            }
            Connection $this$thisLogger$iv = INSTANCE;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(Connection.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info((String)msg, (Throwable)new RuntimeException(e));
            if (service == null) {
                return;
            }
            GrazieCloudConnectionState.Companion.stateChanged(GrazieCloudConnectionState.ConnectionState.Error, service);
        }

        @JvmStatic
        public static final synchronized void connectionStable(@NotNull Project project, @Nullable BackgroundCloudService service) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (service == null || GrazieCloudConnectionState.Companion.stateChanged(GrazieCloudConnectionState.ConnectionState.Stable, service) == GrazieCloudConnectionState.ConnectionState.Error) {
                return;
            }
        }
    }
}

