/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.spellcheck.settings;

import com.intellij.grazie.spellcheck.settings.CustomDictionariesPanel;
import com.intellij.grazie.spellcheck.settings.SpellCheckerSettingsPane;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.options.BoundSearchableConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.profile.codeInspection.ui.ErrorsConfigurable;
import com.intellij.spellchecker.DictionaryLayer;
import com.intellij.spellchecker.DictionaryLayersProvider;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.dictionary.CustomDictionaryProvider;
import com.intellij.spellchecker.settings.SpellCheckerSettings;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.LabelPosition;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ComponentPredicateKt;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/grazie/spellcheck/settings/SpellCheckerConfigurable;", "Lcom/intellij/openapi/options/BoundSearchableConfigurable;", "Lcom/intellij/openapi/options/Configurable$NoScroll;", "Lcom/intellij/openapi/options/Configurable$WithEpDependencies;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "settings", "Lcom/intellij/spellchecker/settings/SpellCheckerSettings;", "Lorg/jetbrains/annotations/NotNull;", "manager", "Lcom/intellij/spellchecker/SpellCheckerManager;", "myUseSingleDictionary", "Lcom/intellij/ui/components/JBCheckBox;", "myDictionariesComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "", "myDictionariesPanel", "Lcom/intellij/grazie/spellcheck/settings/CustomDictionariesPanel;", "wordsPanel", "Lcom/intellij/grazie/spellcheck/settings/SpellCheckerSettingsPane$WordsPanel;", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "apply", "", "getDependencies", "", "Lcom/intellij/openapi/extensions/BaseExtensionPointName;", "getSupportedDictionariesDescription", "intellij.grazie.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSpellCheckerConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpellCheckerConfigurable.kt\ncom/intellij/grazie/spellcheck/settings/SpellCheckerConfigurable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n1586#2:112\n1661#2,3:113\n*S KotlinDebug\n*F\n+ 1 SpellCheckerConfigurable.kt\ncom/intellij/grazie/spellcheck/settings/SpellCheckerConfigurable\n*L\n50#1:112\n50#1:113,3\n*E\n"})
public final class SpellCheckerConfigurable
extends BoundSearchableConfigurable
implements Configurable.NoScroll,
Configurable.WithEpDependencies {
    @NotNull
    private final Project project;
    @NotNull
    private final SpellCheckerSettings settings;
    @NotNull
    private final SpellCheckerManager manager;
    private JBCheckBox myUseSingleDictionary;
    private ComboBox<String> myDictionariesComboBox;
    private CustomDictionariesPanel myDictionariesPanel;
    private SpellCheckerSettingsPane.WordsPanel wordsPanel;

    public SpellCheckerConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(SpellCheckerBundle.message((String)"spelling", (Object[])new Object[0]), "reference.settings.ide.settings.spelling", null, 4, null);
        this.project = project;
        SpellCheckerSettings spellCheckerSettings = SpellCheckerSettings.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)spellCheckerSettings, (String)"getInstance(...)");
        this.settings = spellCheckerSettings;
        this.manager = SpellCheckerManager.Companion.getInstance(this.project);
    }

    @NotNull
    public DialogPanel createPanel() {
        this.myDictionariesPanel = new CustomDictionariesPanel(this.settings, this.project, this.manager);
        Disposable disposable = this.getDisposable();
        Intrinsics.checkNotNull((Object)disposable);
        this.wordsPanel = new SpellCheckerSettingsPane.WordsPanel(this.manager, disposable);
        return BuilderKt.panel(arg_0 -> SpellCheckerConfigurable.createPanel$lambda$0(this, arg_0));
    }

    public void apply() {
        super.apply();
        SpellCheckerSettingsPane.WordsPanel wordsPanel = this.wordsPanel;
        if (wordsPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"wordsPanel");
            wordsPanel = null;
        }
        if (wordsPanel.isModified()) {
            SpellCheckerSettingsPane.WordsPanel wordsPanel2 = this.wordsPanel;
            if (wordsPanel2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"wordsPanel");
                wordsPanel2 = null;
            }
            List<String> list = wordsPanel2.getWords();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getWords(...)");
            this.manager.updateUserDictionary((Collection)list);
        }
        SpellCheckerManager.Companion.restartInspections((Object)this);
        CustomDictionariesPanel customDictionariesPanel = this.myDictionariesPanel;
        if (customDictionariesPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myDictionariesPanel");
            customDictionariesPanel = null;
        }
        if (customDictionariesPanel.isModified()) {
            CustomDictionariesPanel customDictionariesPanel2 = this.myDictionariesPanel;
            if (customDictionariesPanel2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myDictionariesPanel");
                customDictionariesPanel2 = null;
            }
            customDictionariesPanel2.apply();
        }
    }

    @NotNull
    public Collection<BaseExtensionPointName<?>> getDependencies() {
        return SetsKt.setOf((Object)CustomDictionaryProvider.EP_NAME);
    }

    private final String getSupportedDictionariesDescription() {
        return CollectionsKt.joinToString$default((Iterable)CustomDictionaryProvider.EP_NAME.getExtensionList(), (CharSequence)", ", (CharSequence)", ", null, (int)0, null, SpellCheckerConfigurable::getSupportedDictionariesDescription$lambda$0, (int)28, null);
    }

    private static final boolean createPanel$lambda$0$1$0(SpellCheckerConfigurable this$0) {
        CustomDictionariesPanel customDictionariesPanel = this$0.myDictionariesPanel;
        if (customDictionariesPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myDictionariesPanel");
            customDictionariesPanel = null;
        }
        return customDictionariesPanel.isModified();
    }

    private static final Unit createPanel$lambda$0$1$1(SpellCheckerConfigurable this$0) {
        CustomDictionariesPanel customDictionariesPanel = this$0.myDictionariesPanel;
        if (customDictionariesPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myDictionariesPanel");
            customDictionariesPanel = null;
        }
        customDictionariesPanel.reset();
        return Unit.INSTANCE;
    }

    private static final boolean createPanel$lambda$0$2$0(SpellCheckerConfigurable this$0) {
        SpellCheckerSettingsPane.WordsPanel wordsPanel = this$0.wordsPanel;
        if (wordsPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"wordsPanel");
            wordsPanel = null;
        }
        return wordsPanel.isModified();
    }

    private static final Unit createPanel$lambda$0$2$1(SpellCheckerConfigurable this$0) {
        SpellCheckerSettingsPane.WordsPanel wordsPanel = this$0.wordsPanel;
        if (wordsPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"wordsPanel");
            wordsPanel = null;
        }
        wordsPanel.reset();
        return Unit.INSTANCE;
    }

    private static final void createPanel$lambda$0$3$0$0(ErrorsConfigurable $errorsConfigurable) {
        $errorsConfigurable.selectInspectionTool("SpellCheckingInspection");
    }

    private static final Unit createPanel$lambda$0$3$0(ActionEvent it) {
        ErrorsConfigurable errorsConfigurable;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it.getSource();
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)(object instanceof JComponent ? (JComponent)object : null));
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        Settings allSettings = (Settings)Settings.KEY.getData(dataContext);
        if (allSettings != null && (errorsConfigurable = (ErrorsConfigurable)allSettings.find(ErrorsConfigurable.class)) != null) {
            allSettings.select((Configurable)errorsConfigurable).doWhenDone(() -> SpellCheckerConfigurable.createPanel$lambda$0$3$0$0(errorsConfigurable));
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createPanel$lambda$0$0(SpellCheckerConfigurable this$0, Row $this$row) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.myUseSingleDictionary = (JBCheckBox)ButtonKt.bindSelected((Cell)$this$row.checkBox(SpellCheckerBundle.message((String)"use.single.dictionary", (Object[])new Object[0])).gap(RightGap.SMALL), (Function0)((Function0)new Function0<Boolean>((Object)this$0.settings){

            public final Boolean invoke() {
                return ((SpellCheckerSettings)this.receiver).isUseSingleDictionaryToSave();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)this$0.settings){

            public final void invoke(boolean p0) {
                ((SpellCheckerSettings)this.receiver).setUseSingleDictionaryToSave(p0);
            }
        })).getComponent();
        Iterable iterable = DictionaryLayersProvider.Companion.getAllLayers(this$0.project);
        Row row = $this$row;
        SpellCheckerConfigurable spellCheckerConfigurable = this$0;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DictionaryLayer dictionaryLayer = (DictionaryLayer)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        collection = (List)destination$iv$iv;
        Cell cell = Row.comboBox$default((Row)row, (Collection)collection, null, (int)2, null);
        JBCheckBox jBCheckBox = this$0.myUseSingleDictionary;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myUseSingleDictionary");
            jBCheckBox = null;
        }
        spellCheckerConfigurable.myDictionariesComboBox = (ComboBox)ComboBoxKt.bindItem((Cell)cell.enabledIf(ComponentPredicateKt.getSelected((AbstractButton)((AbstractButton)jBCheckBox))), (Function0)((Function0)new Function0<String>((Object)this$0.settings){

            public final String invoke() {
                return ((SpellCheckerSettings)this.receiver).getDictionaryToSave();
            }
        }), (Function1)((Function1)new Function1<String, Unit>((Object)this$0.settings){

            public final void invoke(String p0) {
                ((SpellCheckerSettings)this.receiver).setDictionaryToSave(p0);
            }
        })).applyIfEnabled().getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$1(SpellCheckerConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        CustomDictionariesPanel customDictionariesPanel = this$0.myDictionariesPanel;
        if (customDictionariesPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myDictionariesPanel");
            customDictionariesPanel = null;
        }
        Object[] objectArray = new Object[]{this$0.getSupportedDictionariesDescription()};
        $this$row.cell((JComponent)customDictionariesPanel).label(SpellCheckerBundle.message((String)"add.dictionary.description", (Object[])objectArray), LabelPosition.TOP).align((Align)AlignX.FILL.INSTANCE).onIsModified(() -> SpellCheckerConfigurable.createPanel$lambda$0$1$0(this$0)).onReset(() -> SpellCheckerConfigurable.createPanel$lambda$0$1$1(this$0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$2(SpellCheckerConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        SpellCheckerSettingsPane.WordsPanel wordsPanel = this$0.wordsPanel;
        if (wordsPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"wordsPanel");
            wordsPanel = null;
        }
        $this$row.cell((JComponent)((Object)wordsPanel)).label(SpellCheckerBundle.message((String)"settings.tab.accepted.words", (Object[])new Object[0]), LabelPosition.TOP).align((Align)AlignX.FILL.INSTANCE).onIsModified(() -> SpellCheckerConfigurable.createPanel$lambda$0$2$0(this$0)).onReset(() -> SpellCheckerConfigurable.createPanel$lambda$0$2$1(this$0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$3(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.link(SpellCheckerBundle.message((String)"link.to.inspection.settings", (Object[])new Object[0]), SpellCheckerConfigurable::createPanel$lambda$0$3$0);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0(SpellCheckerConfigurable this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> SpellCheckerConfigurable.createPanel$lambda$0$0(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> SpellCheckerConfigurable.createPanel$lambda$0$1(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> SpellCheckerConfigurable.createPanel$lambda$0$2(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, SpellCheckerConfigurable::createPanel$lambda$0$3, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final CharSequence getSupportedDictionariesDescription$lambda$0(CustomDictionaryProvider it) {
        String string = it.getDictionaryType();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDictionaryType(...)");
        return string;
    }
}

