/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.inspection.ai;

import ai.grazie.nlp.langs.Language;
import ai.grazie.nlp.langs.utils.NamesKt;
import ai.grazie.nlp.tokenizer.Tokenizer;
import ai.grazie.nlp.tokenizer.word.StandardWordTokenizer;
import com.intellij.codeInsight.intention.CustomizableIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.grazie.GrazieBundle;
import com.intellij.grazie.cloud.APIQueries;
import com.intellij.grazie.cloud.GrazieCloudConnector;
import com.intellij.grazie.cloud.PrematureEndException;
import com.intellij.grazie.detection.LangDetector;
import com.intellij.grazie.ide.fus.GrazieFUSCounter;
import com.intellij.grazie.ide.ui.PaddedListCellRenderer;
import com.intellij.grazie.rule.SentenceTokenizer;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.grazie.utils.NaturalTextDetector;
import com.intellij.ide.ui.IdeUiService;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.swing.ListCellRenderer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class TranslateAction
implements IntentionAction,
CustomizableIntentionAction {
    @IntentionName
    @NotNull
    public String getText() {
        String string = GrazieBundle.message("intention.translate.text", new Object[0]);
        if (string == null) {
            TranslateAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            TranslateAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public List<CustomizableIntentionAction.RangeToHighlight> getRangesToHighlight(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            TranslateAction.$$$reportNull$$$0(2);
        }
        if (file == null) {
            TranslateAction.$$$reportNull$$$0(3);
        }
        int selStart = editor.getSelectionModel().getSelectionStart();
        int selEnd = editor.getSelectionModel().getSelectionEnd();
        List<RangeToTranslate> toTranslate = TranslateAction.findAffectedRanges(file, selStart, selEnd);
        List list = ContainerUtil.map(toTranslate, p -> new CustomizableIntentionAction.RangeToHighlight((PsiElement)file, p.fileRange, EditorColors.SEARCH_RESULT_ATTRIBUTES));
        if (list == null) {
            TranslateAction.$$$reportNull$$$0(4);
        }
        return list;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            TranslateAction.$$$reportNull$$$0(5);
        }
        SelectionModel model = editor.getSelectionModel();
        return !CommitMessage.isCommitMessage((PsiElement)psiFile) && GrazieCloudConnector.Companion.seemsCloudConnected() && !TranslateAction.getAffectedTexts(psiFile, model.getSelectionStart(), model.getSelectionEnd()).isEmpty();
    }

    @VisibleForTesting
    public static String presentableLanguageName(Language language) {
        String nativeName = NamesKt.getNativeName((Language)language);
        Font font = UIUtil.getLabelFont();
        return nativeName.codePoints().allMatch(font::canDisplay) ? nativeName : NamesKt.getEnglishName((Language)language);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        int selEnd;
        int selStart;
        List<RangeToTranslate> toTranslate;
        if (project == null) {
            TranslateAction.$$$reportNull$$$0(6);
        }
        if ((toTranslate = TranslateAction.findAffectedRanges(psiFile, selStart = editor.getSelectionModel().getSelectionStart(), selEnd = editor.getSelectionModel().getSelectionEnd())).isEmpty()) {
            GrazieFUSCounter.INSTANCE.reportTranslateError(Language.UNKNOWN, Language.UNKNOWN, 0);
            Messages.showErrorDialog((Project)project, (String)GrazieBundle.message("intention.translate.nothing.to.translate", new Object[0]), (String)this.getText());
            return;
        }
        List detected = ((StreamEx)((StreamEx)StreamEx.of(toTranslate).map(pair -> LangDetector.INSTANCE.getLanguage(pair.contentFragment())).filter(Objects::nonNull)).distinct()).toList();
        List<Language> targets = Arrays.stream(Language.values()).filter(l -> l != Language.UNKNOWN && !detected.contains(l)).toList();
        Language fromLang = detected.isEmpty() ? Language.UNKNOWN : (Language)detected.getFirst();
        JBPopupFactory.getInstance().createPopupChooserBuilder(ContainerUtil.map(targets, it -> new TranslationTarget((Language)it))).setRenderer((ListCellRenderer)new PaddedListCellRenderer()).setSelectionMode(0).setNamerForFiltering(t -> t.display + " " + NamesKt.getEnglishName((Language)t.language)).setItemChosenCallback(toLang -> {
            GrazieFUSCounter.INSTANCE.reportTranslateRequested(fromLang, toLang.language, TranslateAction.getWordCount(toTranslate));
            TranslateAction.doTranslate(project, editor, psiFile, toTranslate, fromLang, toLang.language);
        }).createPopup().showInBestPositionFor(editor);
    }

    private static List<RangeToTranslate> findAffectedRanges(PsiFile file, int selStart, int selEnd) {
        ArrayList<RangeToTranslate> texts = new ArrayList<RangeToTranslate>();
        List<TextContent> contents = TranslateAction.getAffectedTexts(file, selStart, selEnd);
        for (TextContent content : contents) {
            int textStart = 0;
            int textEnd = content.length();
            for (SentenceTokenizer.Sentence token : SentenceTokenizer.tokenize(content)) {
                int sentenceStart = CharArrayUtil.shiftForward((CharSequence)content, (int)token.start(), (String)" \t\n");
                int sentenceEnd = CharArrayUtil.shiftBackward((CharSequence)content, (int)(token.end() - 1), (String)" \t\n") + 1;
                if (content.textOffsetToFile(sentenceEnd) < selStart) {
                    textStart = sentenceEnd;
                }
                if (content.textOffsetToFile(sentenceStart) <= selEnd || textEnd <= sentenceStart) continue;
                textEnd = sentenceStart;
            }
            if ((textStart = CharArrayUtil.shiftForward((CharSequence)content, (int)textStart, (String)" \t\n")) >= (textEnd = CharArrayUtil.shiftBackward((CharSequence)content, (int)(textEnd - 1), (String)" \t\n") + 1)) continue;
            TextRange textRange = new TextRange(textStart, textEnd);
            texts.add(new RangeToTranslate(content, textRange, content.textRangeToFile(textRange)));
        }
        return texts;
    }

    private static void doTranslate(Project project, Editor editor, PsiFile file, List<RangeToTranslate> toTranslate, Language from, Language target) {
        try {
            TranslateAction.tryTranslate(project, editor, file, toTranslate, from, target);
        }
        catch (PrematureEndException e) {
            IdeUiService.getInstance().showErrorHint(editor, GrazieBundle.message("intention.translate.unavailable", new Object[0]));
        }
    }

    private static void tryTranslate(Project project, Editor editor, PsiFile file, List<RangeToTranslate> toTranslate, Language from, Language target) {
        String fileText = file.getViewProvider().getContents().toString();
        List translations = (List)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> APIQueries.getTranslator().translate(ContainerUtil.map((Collection)toTranslate, p -> p.fileRange.substring(fileText)), target, project), GrazieBundle.message("intention.translate.progress.title", new Object[0]), true, project);
        if (translations == null) {
            return;
        }
        if (translations.size() != toTranslate.size()) {
            throw new AssertionError((Object)"Translation server result mismatch");
        }
        HashMap<TextRange, String> replacements = new HashMap<TextRange, String>();
        for (int i = 0; i < translations.size(); ++i) {
            replacements.put(toTranslate.get((int)i).fileRange, ((String)translations.get(i)).strip());
        }
        int translationWordCount = replacements.values().stream().mapToInt(p -> TranslateAction.words(p).size()).sum();
        WriteCommandAction.runWriteCommandAction((Project)project, (String)GrazieBundle.message("intention.translate.command.name", TranslateAction.presentableLanguageName(target)), null, () -> {
            GrazieFUSCounter.INSTANCE.reportTranslateReplaced(from, target, TranslateAction.getWordCount(toTranslate), translationWordCount);
            ((StreamEx)StreamEx.of((Collection)toTranslate).map(p -> p.fileRange).sorted(Segment.BY_START_OFFSET_THEN_END_OFFSET.reversed())).forEach(range -> editor.getDocument().replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)replacements.get(range)));
        }, (PsiFile[])new PsiFile[]{file});
    }

    private static List<TextContent> getAffectedTexts(PsiFile file, int selStart, int selEnd) {
        if (selStart == selEnd) {
            TextContent textContent = TextExtractor.findTextAt(file, selStart, TextContent.TextDomain.ALL);
            if (textContent == null || !NaturalTextDetector.seemsNatural(textContent)) {
                return Collections.emptyList();
            }
            return List.of(textContent);
        }
        return ContainerUtil.filter(TextExtractor.findAllTextContents(file.getViewProvider(), TextContent.TextDomain.ALL), tc -> tc.intersectsRange(new TextRange(selStart, selEnd)));
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static List<Tokenizer.Token> words(String text) {
        return StandardWordTokenizer.INSTANCE.tokenize(text).stream().filter(token -> !token.getText().getValue().isBlank()).toList();
    }

    private static int getWordCount(List<RangeToTranslate> texts) {
        if (texts.isEmpty()) {
            return 0;
        }
        return texts.stream().mapToInt(p -> TranslateAction.words(p.contentFragment()).size()).sum();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/grazie/ide/inspection/ai/TranslateAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/grazie/ide/inspection/ai/TranslateAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangesToHighlight";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRangesToHighlight";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 5, 6 -> new IllegalArgumentException(string);
        };
    }

    private record RangeToTranslate(TextContent content, TextRange contentRange, TextRange fileRange) {
        String contentFragment() {
            return this.contentRange.substring(this.content.toString());
        }
    }

    static class TranslationTarget {
        public String display;
        public Language language;

        TranslationTarget(Language language) {
            this.display = TranslateAction.presentableLanguageName(language);
            this.language = language;
        }

        public String toString() {
            return this.display;
        }
    }
}

