/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.inspection.grammar;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.UnfairLocalInspectionTool;
import com.intellij.codeWithMe.ClientId;
import com.intellij.grazie.GrazieBundle;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.spellcheck.GrazieSpellCheckingInspection;
import com.intellij.grazie.text.CheckerRunner;
import com.intellij.grazie.text.ProblemFilter;
import com.intellij.grazie.text.TextChecker;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.grazie.text.TextProblem;
import com.intellij.grazie.text.TreeRuleChecker;
import com.intellij.grazie.utils.GrazieUtilsKt;
import com.intellij.grazie.utils.HighlightingUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spellchecker.inspections.SpellCheckingInspection;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.ui.SpellCheckingEditorCustomization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 '2\u00020\u00012\u00020\u00022\u00020\u0003:\u0003%&'B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\u0019H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J2\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002J\u001e\u0010#\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\u0019H\u0002J\u001e\u0010$\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\u0019H\u0002\u00a8\u0006("}, d2={"Lcom/intellij/grazie/ide/inspection/grammar/GrazieInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/codeInspection/ex/UnfairLocalInspectionTool;", "<init>", "()V", "getDisplayName", "", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "checkTextLevel", "", "file", "Lcom/intellij/psi/PsiFile;", "reportProblem", "problem", "Lcom/intellij/grazie/text/TextProblem;", "isDisabled", "inspections", "", "buildCheckers", "Lcom/intellij/grazie/text/TextChecker;", "filterCheckers", "checkers", "element", "Lcom/intellij/psi/PsiElement;", "scopes", "", "Lcom/intellij/spellchecker/inspections/SpellCheckingInspection$SpellCheckingScope;", "hasTooLowSeverity", "areInspectionsDisabled", "Grammar", "Style", "Companion", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nGrazieInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieInspection.kt\ncom/intellij/grazie/ide/inspection/grammar/GrazieInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,236:1\n1915#2,2:237\n1915#2,2:239\n832#2:241\n862#2,2:242\n1786#2,3:244\n2792#2,3:247\n*S KotlinDebug\n*F\n+ 1 GrazieInspection.kt\ncom/intellij/grazie/ide/inspection/grammar/GrazieInspection\n*L\n102#1:237,2\n107#1:239,2\n123#1:241\n123#1:242,2\n129#1:244,3\n132#1:247,3\n*E\n"})
public final class GrazieInspection
extends LocalInspectionTool
implements DumbAware,
UnfairLocalInspectionTool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<LocalInspectionTool> grammarInspections;
    @NotNull
    private static final List<LocalInspectionTool> spellCheckingInspections;
    private static final int MAX_TEXT_LENGTH_IN_PSI_ELEMENT = 50000;
    private static final int MAX_TEXT_LENGTH_IN_FILE = 200000;
    @NotNull
    public static final String GRAMMAR_INSPECTION = "GrazieInspection";
    @NotNull
    public static final String STYLE_INSPECTION = "GrazieStyle";
    @NotNull
    public static final String RUNNER = "GrazieInspectionRunner";
    @NotNull
    private static final Lazy<Boolean> hasSpellChecking$delegate;

    @NotNull
    public String getDisplayName() {
        return GrazieBundle.message("grazie.grammar.inspection.grammar.text", new Object[0]);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        PsiFile file = psiFile;
        PsiFile psiFile2 = session.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getFile(...)");
        if (Companion.ignoreGrammarChecking(psiFile2) || CommitMessage.isCommitMessage((PsiElement)((PsiElement)file))) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        List<TextChecker> checkers = this.buildCheckers(session);
        if (checkers.isEmpty()) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        Function1<PsiElement, Boolean> areChecksDisabled = Companion.getDisabledChecker(file);
        Set<TextContent.TextDomain> checkedDomains = Companion.checkedDomains();
        Set<SpellCheckingInspection.SpellCheckingScope> scopes = GrazieSpellCheckingInspection.buildAllowedScopes((PsiElement)file);
        return new PsiElementVisitor(areChecksDisabled, session, file, this, holder, checkers, scopes, checkedDomains){
            final /* synthetic */ Function1<PsiElement, Boolean> $areChecksDisabled;
            final /* synthetic */ LocalInspectionToolSession $session;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ GrazieInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ List<TextChecker> $checkers;
            final /* synthetic */ Set<SpellCheckingInspection.SpellCheckingScope> $scopes;
            final /* synthetic */ Set<TextContent.TextDomain> $checkedDomains;
            {
                this.$areChecksDisabled = $areChecksDisabled;
                this.$session = $session;
                this.$file = $file;
                this.this$0 = $receiver;
                this.$holder = $holder;
                this.$checkers = $checkers;
                this.$scopes = $scopes;
                this.$checkedDomains = $checkedDomains;
            }

            public void visitWhiteSpace(PsiWhiteSpace space) {
                Intrinsics.checkNotNullParameter((Object)space, (String)"space");
            }

            /*
             * WARNING - void declaration
             */
            public void visitElement(PsiElement element) {
                void $this$forEach$iv;
                Collection collection;
                List<TextChecker> $this$mapTo$iv$iv2;
                boolean bl;
                TextContent it;
                Iterable $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (((Boolean)this.$areChecksDisabled.invoke((Object)element)).booleanValue()) {
                    return;
                }
                List<TextContent> list = TextExtractor.findUniqueTextsAt(element, TextContent.TextDomain.ALL);
                Intrinsics.checkNotNullExpressionValue(list, (String)"findUniqueTextsAt(...)");
                Iterable $this$filter$iv = list;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T t : $this$filterTo$iv$iv) {
                    it = (TextContent)t;
                    bl = false;
                    if (!ProblemFilter.allIgnoringFilters(it).findAny().isEmpty()) continue;
                    destination$iv$iv.add(t);
                }
                List texts = (List)destination$iv$iv;
                if (GrazieInspection.Companion.skipCheckingTooLargeTexts(texts)) {
                    return;
                }
                TextRange textRange = this.$session.getPriorityRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getPriorityRange(...)");
                Iterable $this$map$iv = GrazieInspection.Companion.sortByPriority(texts, textRange);
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo232 = false;
                for (T t : $this$mapTo$iv$iv2) {
                    it = (TextContent)t;
                    collection = destination$iv$iv;
                    bl = false;
                    collection.add(new CheckerRunner(it));
                }
                $this$map$iv = (List)destination$iv$iv;
                GrazieInspection grazieInspection = this.this$0;
                $this$mapTo$iv$iv2 = this.$checkers;
                Set<SpellCheckingInspection.SpellCheckingScope> set = this.$scopes;
                Set<TextContent.TextDomain> $i$f$mapTo232 = this.$checkedDomains;
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv3 : iterable2) {
                    void it2;
                    CheckerRunner checkerRunner = (CheckerRunner)item$iv$iv3;
                    collection = destination$iv$iv2;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)set);
                    collection.add(TuplesKt.to((Object)it2, it2.run((List<? extends TextChecker>)GrazieInspection.access$filterCheckers(grazieInspection, $this$mapTo$iv$iv2, element, set), $i$f$mapTo232)));
                }
                $this$map$iv = (List)destination$iv$iv2;
                grazieInspection = this.$holder;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl3 = false;
                    CheckerRunner runner = (CheckerRunner)pair.component1();
                    List problems = (List)pair.component2();
                    Iterable $this$forEach$iv2 = problems;
                    boolean $i$f$forEach2 = false;
                    for (E element$iv2 : $this$forEach$iv2) {
                        void $this$forEach$iv3;
                        TextProblem problem = (TextProblem)element$iv2;
                        boolean bl2 = false;
                        Iterable iterable3 = runner.toProblemDescriptors(problem, grazieInspection.isOnTheFly());
                        boolean $i$f$forEach3 = false;
                        for (T element$iv3 : $this$forEach$iv3) {
                            ProblemDescriptor p0 = (ProblemDescriptor)element$iv3;
                            boolean bl32 = false;
                            grazieInspection.registerProblem(p0);
                        }
                    }
                }
                if (Intrinsics.areEqual((Object)element, (Object)this.$file) && !GrazieInspection.access$isDisabled(this.this$0, this.$session, GrazieInspection.access$getGrammarInspections$cp())) {
                    GrazieInspection.access$checkTextLevel(this.this$0, this.$file, this.$holder);
                }
            }
        };
    }

    private final void checkTextLevel(PsiFile file, ProblemsHolder holder) {
        List<TreeRuleChecker.TreeProblem> list = TreeRuleChecker.checkTextLevelProblems(file);
        Intrinsics.checkNotNullExpressionValue(list, (String)"checkTextLevelProblems(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TreeRuleChecker.TreeProblem it = (TreeRuleChecker.TreeProblem)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.reportProblem(it, holder);
        }
    }

    private final void reportProblem(TextProblem problem, ProblemsHolder holder) {
        TextContent textContent = problem.getText();
        Intrinsics.checkNotNullExpressionValue((Object)textContent, (String)"getText(...)");
        Iterable $this$forEach$iv = new CheckerRunner(textContent).toProblemDescriptors(problem, holder.isOnTheFly());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProblemDescriptor it = (ProblemDescriptor)element$iv;
            boolean bl = false;
            holder.registerProblem(it);
        }
    }

    private final boolean isDisabled(LocalInspectionToolSession session, List<? extends LocalInspectionTool> inspections) {
        return this.hasTooLowSeverity(session, inspections) || this.areInspectionsDisabled(session, inspections);
    }

    private final List<TextChecker> buildCheckers(LocalInspectionToolSession session) {
        ArrayList<Object> allCheckers = new ArrayList<Object>((Collection)TextChecker.allCheckers());
        if (this.isDisabled(session, spellCheckingInspections)) {
            allCheckers.removeIf(arg_0 -> GrazieInspection.buildCheckers$lambda$1(GrazieInspection::buildCheckers$lambda$0, arg_0));
        }
        if (this.isDisabled(session, grammarInspections)) {
            allCheckers.removeIf(arg_0 -> GrazieInspection.buildCheckers$lambda$3(GrazieInspection::buildCheckers$lambda$2, arg_0));
        }
        return allCheckers;
    }

    /*
     * WARNING - void declaration
     */
    private final List<TextChecker> filterCheckers(List<? extends TextChecker> checkers, PsiElement element, Set<? extends SpellCheckingInspection.SpellCheckingScope> scopes) {
        SpellcheckingStrategy strategy = SpellcheckingStrategy.getSpellcheckingStrategy((PsiElement)element);
        if (strategy == null || !strategy.elementFitsScope(element, scopes) || !strategy.useTextLevelSpellchecking(element)) {
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = checkers;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                TextChecker it = (TextChecker)element$iv$iv;
                boolean bl = false;
                if (GrazieUtilsKt.isSpelling(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        return checkers;
    }

    private final boolean hasTooLowSeverity(LocalInspectionToolSession session, List<? extends LocalInspectionTool> inspections) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = inspections;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    LocalInspectionTool it = (LocalInspectionTool)element$iv;
                    boolean bl2 = false;
                    if (InspectionProfileManager.hasTooLowSeverity((LocalInspectionToolSession)session, (LocalInspectionTool)it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean areInspectionsDisabled(LocalInspectionToolSession session, List<? extends LocalInspectionTool> inspections) {
        boolean bl;
        block3: {
            Iterable $this$none$iv = inspections;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    LocalInspectionTool it = (LocalInspectionTool)element$iv;
                    boolean bl2 = false;
                    if (!HighlightingUtil.isInspectionEnabled(it.getShortName(), session.getFile())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean buildCheckers$lambda$0(TextChecker it) {
        Intrinsics.checkNotNull((Object)it);
        return GrazieUtilsKt.isSpelling(it);
    }

    private static final boolean buildCheckers$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean buildCheckers$lambda$2(TextChecker it) {
        Intrinsics.checkNotNull((Object)it);
        return GrazieUtilsKt.isGrammar(it);
    }

    private static final boolean buildCheckers$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean hasSpellChecking_delegate$lambda$0() {
        boolean bl;
        try {
            Class.forName("com.intellij.spellchecker.ui.SpellCheckingEditorCustomization");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    public static final boolean skipCheckingTooLargeTexts(@NotNull Collection<? extends TextContent> texts) {
        return Companion.skipCheckingTooLargeTexts(texts);
    }

    @JvmStatic
    public static final boolean ignoreGrammarChecking(@NotNull PsiFile file) {
        return Companion.ignoreGrammarChecking(file);
    }

    @JvmStatic
    @NotNull
    public static final Set<TextContent.TextDomain> checkedDomains() {
        return Companion.checkedDomains();
    }

    @JvmStatic
    @NotNull
    public static final Function1<PsiElement, Boolean> getDisabledChecker(@NotNull PsiFile file) {
        return Companion.getDisabledChecker(file);
    }

    @JvmStatic
    @NotNull
    public static final List<TextContent> sortByPriority(@NotNull List<? extends TextContent> texts, @NotNull TextRange priorityRange) {
        return Companion.sortByPriority(texts, priorityRange);
    }

    public static final /* synthetic */ List access$filterCheckers(GrazieInspection $this, List checkers, PsiElement element, Set scopes) {
        return $this.filterCheckers(checkers, element, scopes);
    }

    public static final /* synthetic */ boolean access$isDisabled(GrazieInspection $this, LocalInspectionToolSession session, List inspections) {
        return $this.isDisabled(session, inspections);
    }

    public static final /* synthetic */ List access$getGrammarInspections$cp() {
        return grammarInspections;
    }

    public static final /* synthetic */ void access$checkTextLevel(GrazieInspection $this, PsiFile file, ProblemsHolder holder) {
        $this.checkTextLevel(file, holder);
    }

    static {
        Object[] objectArray = new LocalInspectionTool[]{new Grammar(), new Style()};
        grammarInspections = CollectionsKt.listOf((Object[])objectArray);
        spellCheckingInspections = CollectionsKt.listOf((Object)((Object)new GrazieSpellCheckingInspection()));
        hasSpellChecking$delegate = LazyKt.lazy(GrazieInspection::hasSpellChecking_delegate$lambda$0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001&B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0015\u001a\u00020\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0007J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0007J\u001c\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00100!2\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J$\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00180\u00052\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00052\u0006\u0010$\u001a\u00020%H\u0007R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006'"}, d2={"Lcom/intellij/grazie/ide/inspection/grammar/GrazieInspection$Companion;", "", "<init>", "()V", "grammarInspections", "", "Lcom/intellij/codeInspection/LocalInspectionTool;", "spellCheckingInspections", "MAX_TEXT_LENGTH_IN_PSI_ELEMENT", "", "MAX_TEXT_LENGTH_IN_FILE", "GRAMMAR_INSPECTION", "", "STYLE_INSPECTION", "RUNNER", "hasSpellChecking", "", "getHasSpellChecking", "()Z", "hasSpellChecking$delegate", "Lkotlin/Lazy;", "skipCheckingTooLargeTexts", "texts", "", "Lcom/intellij/grazie/text/TextContent;", "ignoreGrammarChecking", "file", "Lcom/intellij/psi/PsiFile;", "isSpellCheckingDisabled", "checkedDomains", "", "Lcom/intellij/grazie/text/TextContent$TextDomain;", "getDisabledChecker", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiElement;", "sortByPriority", "priorityRange", "Lcom/intellij/openapi/util/TextRange;", "TextContentRelatedData", "intellij.grazie.core"})
    @SourceDebugExtension(value={"SMAP\nGrazieInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieInspection.kt\ncom/intellij/grazie/ide/inspection/grammar/GrazieInspection$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,236:1\n1#2:237\n1068#3:238\n13#4:239\n42#5,3:240\n*S KotlinDebug\n*F\n+ 1 GrazieInspection.kt\ncom/intellij/grazie/ide/inspection/grammar/GrazieInspection$Companion\n*L\n214#1:238\n169#1:239\n171#1:240,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean getHasSpellChecking() {
            Lazy lazy = hasSpellChecking$delegate;
            return (Boolean)lazy.getValue();
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final boolean skipCheckingTooLargeTexts(@NotNull Collection<? extends TextContent> texts) {
            Intrinsics.checkNotNullParameter(texts, (String)"texts");
            if (texts.isEmpty()) {
                return false;
            }
            Iterable iterable = texts;
            int n = 0;
            for (Object t : iterable) {
                void it;
                TextContent textContent = (TextContent)t;
                int n2 = n;
                boolean bl = false;
                int n3 = it.length();
                n = n2 + n3;
            }
            if (n > 50000) {
                return true;
            }
            PsiFile psiFile = ((TextContent)CollectionsKt.first((Iterable)texts)).getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            PsiFile file = psiFile;
            if (file.getTextLength() <= 200000) {
                return false;
            }
            Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)file), () -> Companion.skipCheckingTooLargeTexts$lambda$1(file));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
            return (Boolean)object;
        }

        @JvmStatic
        public final boolean ignoreGrammarChecking(@NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return this.getHasSpellChecking() && this.isSpellCheckingDisabled(file);
        }

        private final boolean isSpellCheckingDisabled(PsiFile file) {
            return SpellCheckingEditorCustomization.isSpellCheckingDisabled((PsiFile)file);
        }

        @JvmStatic
        @NotNull
        public final Set<TextContent.TextDomain> checkedDomains() {
            GrazieConfig.State config = GrazieConfig.Companion.get();
            EnumSet<Enum> result = EnumSet.of((Enum)TextContent.TextDomain.PLAIN_TEXT);
            if (config.getCheckingContext().isCheckInStringLiteralsEnabled()) {
                result.add(TextContent.TextDomain.LITERALS);
            }
            if (config.getCheckingContext().isCheckInCommentsEnabled()) {
                result.add(TextContent.TextDomain.COMMENTS);
            }
            if (config.getCheckingContext().isCheckInDocumentationEnabled()) {
                result.add(TextContent.TextDomain.DOCUMENTATION);
            }
            Intrinsics.checkNotNull(result);
            return result;
        }

        @JvmStatic
        @NotNull
        public final Function1<PsiElement, Boolean> getDisabledChecker(@NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Language language = file.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
            Language fileLanguage = language;
            Set<Language> supportedLanguages = TextExtractor.getSupportedLanguages();
            Set<String> disabledLanguages = GrazieConfig.Companion.get().getCheckingContext().getEffectivelyDisabledLanguageIds();
            return arg_0 -> Companion.getDisabledChecker$lambda$0(fileLanguage, supportedLanguages, disabledLanguages, arg_0);
        }

        @JvmStatic
        @NotNull
        public final List<TextContent> sortByPriority(@NotNull List<? extends TextContent> texts, @NotNull TextRange priorityRange) {
            Intrinsics.checkNotNullParameter(texts, (String)"texts");
            Intrinsics.checkNotNullParameter((Object)priorityRange, (String)"priorityRange");
            Iterable $this$sortedBy$iv = texts;
            boolean $i$f$sortedBy = false;
            return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(priorityRange){
                final /* synthetic */ TextRange $priorityRange$inlined;
                {
                    this.$priorityRange$inlined = textRange;
                }

                public final int compare(T a, T b) {
                    TextContent text = (TextContent)a;
                    boolean bl = false;
                    TextRange textRange = text.textRangeToFile(new TextRange(0, text.length()));
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"textRangeToFile(...)");
                    TextRange textRangeInFile = textRange;
                    text = (TextContent)b;
                    Comparable comparable = Integer.valueOf(textRangeInFile.contains(this.$priorityRange$inlined) ? 0 : (textRangeInFile.intersects(this.$priorityRange$inlined) ? 1 : 2));
                    bl = false;
                    TextRange textRange2 = text.textRangeToFile(new TextRange(0, text.length()));
                    Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"textRangeToFile(...)");
                    textRangeInFile = textRange2;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(textRangeInFile.contains(this.$priorityRange$inlined) ? 0 : (textRangeInFile.intersects(this.$priorityRange$inlined) ? 1 : 2)));
                }
            });
        }

        private static final boolean skipCheckingTooLargeTexts$lambda$1$0(Set $checkedDomains, TextContent it) {
            return $checkedDomains.contains((Object)it.getDomain());
        }

        /*
         * WARNING - void declaration
         */
        private static final CachedValueProvider.Result skipCheckingTooLargeTexts$lambda$1(PsiFile $file) {
            Set<TextContent.TextDomain> checkedDomains = Companion.checkedDomains();
            Set<TextContent> contents = TextExtractor.findAllTextContents($file.getViewProvider(), TextContent.TextDomain.ALL);
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(GrazieInspection.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            Intrinsics.checkNotNull(contents);
            logger.debug("Evaluating text length of: " + new TextContentRelatedData($file, contents));
            Object[] objectArray = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)contents), arg_0 -> Companion.skipCheckingTooLargeTexts$lambda$1$0(checkedDomains, arg_0));
            int n = 0;
            for (Object e : objectArray) {
                void it;
                TextContent textContent = (TextContent)e;
                int n2 = n;
                boolean bl = false;
                int n3 = it.length();
                n = n2 + n3;
            }
            int length = n;
            boolean bl = length > 200000;
            objectArray = new Object[2];
            boolean $i$f$service = false;
            Class<GrazieConfig> serviceClass$iv = GrazieConfig.class;
            if (ApplicationManager.getApplication().getService(serviceClass$iv) == null) {
                Object cfr_ignored_0 = objectArray[0];
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            objectArray[1] = $file;
            return CachedValueProvider.Result.create((Object)bl, (Object[])objectArray);
        }

        private static final boolean getDisabledChecker$lambda$0(Language $fileLanguage, Set $supportedLanguages, Set $disabledLanguages, PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Language lang = element.getLanguage();
            if ($fileLanguage.isKindOf(lang)) {
                lang = $fileLanguage;
            }
            while (lang != null && !$supportedLanguages.contains(lang)) {
                lang = lang.getBaseLanguage();
            }
            return lang != null && $disabledLanguages.contains(lang.getID());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\u000b\u001a\u00020\fH\u0096\u0080\u0004J\t\u0010\r\u001a\u00020\u0003H\u00c2\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0014\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/grazie/ide/inspection/grammar/GrazieInspection$Companion$TextContentRelatedData;", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "contents", "", "Lcom/intellij/grazie/text/TextContent;", "<init>", "(Lcom/intellij/psi/PsiFile;Ljava/util/Set;)V", "getContents", "()Ljava/util/Set;", "toString", "", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "intellij.grazie.core"})
        @SourceDebugExtension(value={"SMAP\nGrazieInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieInspection.kt\ncom/intellij/grazie/ide/inspection/grammar/GrazieInspection$Companion$TextContentRelatedData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,236:1\n1586#2:237\n1661#2,3:238\n1586#2:241\n1661#2,3:242\n1586#2:245\n1661#2,3:246\n1586#2:249\n1661#2,3:250\n*S KotlinDebug\n*F\n+ 1 GrazieInspection.kt\ncom/intellij/grazie/ide/inspection/grammar/GrazieInspection$Companion$TextContentRelatedData\n*L\n228#1:237\n228#1:238,3\n229#1:241\n229#1:242,3\n229#1:245\n229#1:246,3\n231#1:249\n231#1:250,3\n*E\n"})
        public static final class TextContentRelatedData {
            @NotNull
            private final PsiFile psiFile;
            @NotNull
            private final Set<TextContent> contents;

            public TextContentRelatedData(@NotNull PsiFile psiFile, @NotNull Set<? extends TextContent> contents) {
                Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
                Intrinsics.checkNotNullParameter(contents, (String)"contents");
                this.psiFile = psiFile;
                this.contents = contents;
            }

            @NotNull
            public final Set<TextContent> getContents() {
                return this.contents;
            }

            @NotNull
            public String toString() {
                Collection<Integer> collection;
                Collection<Language> collection2;
                TextContent it;
                Collection collection3;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                FileType fileType = this.psiFile.getViewProvider().getVirtualFile().getFileType();
                Language language = this.psiFile.getLanguage();
                List list = this.psiFile.getViewProvider().getAllFiles();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllFiles(...)");
                Iterable iterable = list;
                Language language2 = language;
                FileType fileType2 = fileType;
                boolean $i$f$map = false;
                void var3_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    PsiFile psiFile = (PsiFile)item$iv$iv;
                    collection3 = destination$iv$iv;
                    boolean bl = false;
                    collection3.add(it.getLanguage());
                }
                collection3 = (List)destination$iv$iv;
                $this$map$iv = this.contents;
                collection3 = CollectionsKt.toSet((Iterable)collection3);
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (TextContent)item$iv$iv;
                    collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add((Language)it.getCommonParent());
                }
                collection2 = (List)destination$iv$iv;
                $this$map$iv = collection2;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (PsiElement)item$iv$iv;
                    collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(it.getLanguage());
                }
                collection2 = (List)destination$iv$iv;
                $this$map$iv = this.contents;
                boolean bl = this.psiFile.isPhysical();
                collection2 = CollectionsKt.toSet((Iterable)collection2);
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (TextContent)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.length());
                }
                collection = (List)destination$iv$iv;
                return "[fileType = " + fileType2 + ", fileLanguage = " + language2 + ", viewProviderLanguages = " + (Set)collection3 + ", parentLanguages = " + collection2 + ",isPhysical = " + bl + ", contentLengths = " + (List)collection + "]";
            }

            private final PsiFile component1() {
                return this.psiFile;
            }

            @NotNull
            public final Set<TextContent> component2() {
                return this.contents;
            }

            @NotNull
            public final TextContentRelatedData copy(@NotNull PsiFile psiFile, @NotNull Set<? extends TextContent> contents) {
                Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
                Intrinsics.checkNotNullParameter(contents, (String)"contents");
                return new TextContentRelatedData(psiFile, contents);
            }

            public static /* synthetic */ TextContentRelatedData copy$default(TextContentRelatedData textContentRelatedData, PsiFile psiFile, Set set, int n, Object object) {
                if ((n & 1) != 0) {
                    psiFile = textContentRelatedData.psiFile;
                }
                if ((n & 2) != 0) {
                    set = textContentRelatedData.contents;
                }
                return textContentRelatedData.copy(psiFile, set);
            }

            public int hashCode() {
                int result = this.psiFile.hashCode();
                result = result * 31 + ((Object)this.contents).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof TextContentRelatedData)) {
                    return false;
                }
                TextContentRelatedData textContentRelatedData = (TextContentRelatedData)other;
                if (!Intrinsics.areEqual((Object)this.psiFile, (Object)textContentRelatedData.psiFile)) {
                    return false;
                }
                return Intrinsics.areEqual(this.contents, textContentRelatedData.contents);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0016J\r\u0010\b\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/grazie/ide/inspection/grammar/GrazieInspection$Grammar;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getShortName", "", "Lorg/jetbrains/annotations/NonNls;", "getMainToolId", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "intellij.grazie.core"})
    public static final class Grammar
    extends LocalInspectionTool
    implements DumbAware {
        @NotNull
        public String getShortName() {
            return GrazieInspection.GRAMMAR_INSPECTION;
        }

        @NotNull
        public String getMainToolId() {
            return GrazieInspection.RUNNER;
        }

        @NotNull
        public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0016J\r\u0010\b\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/grazie/ide/inspection/grammar/GrazieInspection$Style;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getShortName", "", "Lorg/jetbrains/annotations/NonNls;", "getMainToolId", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "intellij.grazie.core"})
    public static final class Style
    extends LocalInspectionTool
    implements DumbAware {
        @NotNull
        public String getShortName() {
            return GrazieInspection.STYLE_INSPECTION;
        }

        @NotNull
        public String getMainToolId() {
            return GrazieInspection.RUNNER;
        }

        @NotNull
        public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
    }
}

