/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.text;

import ai.grazie.gec.model.CorrectionServiceType;
import ai.grazie.gec.model.problem.Problem;
import ai.grazie.gec.model.problem.ProblemAggregator;
import ai.grazie.gec.model.problem.ProblemFix;
import ai.grazie.gec.model.problem.ProblemUtilsKt;
import ai.grazie.text.TextRange;
import com.intellij.grazie.text.GrazieProblem;
import com.intellij.grazie.text.TextProblem;
import com.intellij.grazie.utils.UtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0002H\u0014J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0014J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0007\u001a\u00020\u0002H\u0014J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\f2\u0006\u0010\u0007\u001a\u00020\u0002H\u0014J \u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\u00022\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fH\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u0002H\u0014\u00a8\u0006\u0013"}, d2={"Lcom/intellij/grazie/text/TextProblemAggregator;", "Lai/grazie/gec/model/problem/ProblemAggregator;", "Lcom/intellij/grazie/text/TextProblem;", "<init>", "()V", "concedeToOtherGrammarCheckers", "", "problem", "service", "Lai/grazie/gec/model/CorrectionServiceType;", "isSpellingProblem", "highlightingRanges", "", "Lai/grazie/text/TextRange;", "fixes", "Lai/grazie/gec/model/problem/ProblemFix;", "withFixes", "problemPriority", "", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nTextProblemAggregator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextProblemAggregator.kt\ncom/intellij/grazie/text/TextProblemAggregator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n1586#2:53\n1661#2,3:54\n*S KotlinDebug\n*F\n+ 1 TextProblemAggregator.kt\ncom/intellij/grazie/text/TextProblemAggregator\n*L\n28#1:53\n28#1:54,3\n*E\n"})
public final class TextProblemAggregator
extends ProblemAggregator<TextProblem> {
    @NotNull
    public static final TextProblemAggregator INSTANCE = new TextProblemAggregator();

    private TextProblemAggregator() {
    }

    protected boolean concedeToOtherGrammarCheckers(@NotNull TextProblem problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        if (!(problem instanceof GrazieProblem)) {
            return false;
        }
        return ProblemUtilsKt.concedeToOtherGrammarCheckers((Problem)((GrazieProblem)problem).getSource());
    }

    @NotNull
    protected CorrectionServiceType service(@NotNull TextProblem problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        if (!(problem instanceof GrazieProblem)) {
            return CorrectionServiceType.OTHER;
        }
        String string = ((GrazieProblem)problem).getRule().getGlobalId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getGlobalId(...)");
        return StringsKt.startsWith$default((String)string, (String)"Grazie.MLEC", (boolean)false, (int)2, null) ? CorrectionServiceType.MLEC : CorrectionServiceType.RULE;
    }

    protected boolean isSpellingProblem(@NotNull TextProblem problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        return problem.isSpellingProblem();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<TextRange> highlightingRanges(@NotNull TextProblem problem) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        List<com.intellij.openapi.util.TextRange> list = problem.getHighlightRanges();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getHighlightRanges(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            com.intellij.openapi.util.TextRange textRange = (com.intellij.openapi.util.TextRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(UtilsKt.aiRange((com.intellij.openapi.util.TextRange)it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected List<ProblemFix> fixes(@NotNull TextProblem problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        if (!(problem instanceof GrazieProblem)) {
            return CollectionsKt.emptyList();
        }
        return ArraysKt.toList((Object[])((GrazieProblem)problem).getSource().getFixes());
    }

    @Nullable
    protected TextProblem withFixes(@NotNull TextProblem problem, @NotNull List<ProblemFix> fixes) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        Intrinsics.checkNotNullParameter(fixes, (String)"fixes");
        if (!(problem instanceof GrazieProblem)) {
            return null;
        }
        return ((GrazieProblem)problem).copyWithProblemFixes(fixes);
    }

    protected int problemPriority(@NotNull TextProblem problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        boolean concedeToOtherCheckers = this.concedeToOtherGrammarCheckers(problem);
        CorrectionServiceType service = this.service(problem);
        boolean styleLike = problem.isStyleLike();
        if (service == CorrectionServiceType.RULE && !concedeToOtherCheckers && !styleLike) {
            return 40;
        }
        if (service == CorrectionServiceType.OTHER && !styleLike) {
            return 30;
        }
        if (service == CorrectionServiceType.MLEC) {
            return 20;
        }
        if (service == CorrectionServiceType.RULE && !styleLike) {
            return 10;
        }
        return 0;
    }
}

