/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie;

import com.intellij.DynamicBundle;
import com.intellij.grazie.GrazieBundle;
import com.intellij.grazie.GraziePlugin;
import com.intellij.grazie.jlanguage.Lang;
import com.intellij.grazie.remote.GrazieRemote;
import com.intellij.grazie.remote.LanguageToolDescriptor;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.util.lang.UrlClassLoader;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.Language;
import org.languagetool.Languages;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0006J\b\u0010\u001c\u001a\u00020\u000eH\u0002J\u000e\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0014\u0010'\u001a\b\u0012\u0002\b\u0003\u0018\u00010(2\u0006\u0010)\u001a\u00020!J\u0010\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020!J\u0010\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010,\u001a\u00020!J\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020.0\r2\u0006\u0010,\u001a\u00020!J\u0016\u00100\u001a\u0002012\u0006\u00102\u001a\u00020!2\u0006\u00103\u001a\u000204J2\u00105\u001a\u0004\u0018\u0001H6\"\b\b\u0000\u00106*\u0002072\u0016\b\u0004\u00108\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u0001H609H\u0082\b\u00a2\u0006\u0002\u0010:R+\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\"\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006;"}, d2={"Lcom/intellij/grazie/GrazieDynamic;", "Lcom/intellij/ide/plugins/DynamicPluginListener;", "<init>", "()V", "myDynClassLoaders", "Ljava/util/HashSet;", "Ljava/lang/ClassLoader;", "Lkotlin/collections/HashSet;", "getMyDynClassLoaders", "()Ljava/util/HashSet;", "myDynClassLoaders$delegate", "Lkotlin/Lazy;", "getOldFiles", "", "Ljava/nio/file/Path;", "collectValidLocalBundles", "beforePluginUnload", "", "pluginDescriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "isUpdate", "", "addDynClassLoader", "classLoader", "dynClassLoaders", "", "getDynClassLoaders", "()Ljava/util/Set;", "getDynamicFolderPath", "getLangDynamicFolder", "lang", "Lcom/intellij/grazie/jlanguage/Lang;", "getStorageDescriptor", "", "dynamicFolder", "getDynamicFolder", "()Ljava/nio/file/Path;", "loadLang", "Lorg/languagetool/Language;", "loadClass", "Ljava/lang/Class;", "className", "getResourceAsStream", "Ljava/io/InputStream;", "path", "getResource", "Ljava/net/URL;", "getResources", "getResourceBundle", "Ljava/util/ResourceBundle;", "baseName", "locale", "Ljava/util/Locale;", "forClassLoader", "T", "", "body", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "intellij.grazie.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nGrazieDynamic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieDynamic.kt\ncom/intellij/grazie/GrazieDynamic\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,167:1\n160#1,5:173\n160#1,5:178\n160#1,5:183\n160#1,5:188\n160#1,5:193\n774#2:168\n865#2,2:169\n2746#2,3:198\n23#3:171\n1#4:172\n*S KotlinDebug\n*F\n+ 1 GrazieDynamic.kt\ncom/intellij/grazie/GrazieDynamic\n*L\n124#1:173,5\n135#1:178,5\n139#1:183,5\n143#1:188,5\n149#1:193,5\n53#1:168\n53#1:169,2\n48#1:198,3\n60#1:171\n*E\n"})
public final class GrazieDynamic
implements DynamicPluginListener {
    @NotNull
    public static final GrazieDynamic INSTANCE = new GrazieDynamic();
    @NotNull
    private static final Lazy myDynClassLoaders$delegate = LazyKt.lazy(GrazieDynamic::myDynClassLoaders_delegate$lambda$0);

    private GrazieDynamic() {
    }

    private final HashSet<ClassLoader> getMyDynClassLoaders() {
        Lazy lazy = myDynClassLoaders$delegate;
        return (HashSet)lazy.getValue();
    }

    private final List<Path> getOldFiles() {
        List<Object> list = Files.list(this.getDynamicFolder()).filter(arg_0 -> GrazieDynamic.getOldFiles$lambda$1(GrazieDynamic::getOldFiles$lambda$0, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Path> collectValidLocalBundles() {
        Set set;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = (Iterable)Lang.getEntries();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Lang it = (Lang)((Object)element$iv$iv);
            boolean bl = false;
            if (!GrazieRemote.INSTANCE.isJLangAvailableLocally(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List languages2 = (List)destination$iv$iv;
        Set $this$collectValidLocalBundles_u24lambda_u241 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        for (Lang language : languages2) {
            Path path;
            block5: {
                block4: {
                    Path path2 = INSTANCE.getLangDynamicFolder(language);
                    LanguageToolDescriptor languageToolDescriptor = language.getLtRemote();
                    Intrinsics.checkNotNull((Object)languageToolDescriptor);
                    path = path2.resolve(languageToolDescriptor.getFile());
                    if (language.isEnglish()) break block4;
                    Intrinsics.checkNotNull((Object)path);
                    if (!GrazieRemote.INSTANCE.isValidBundleForLanguage(language, path)) break block5;
                }
                $this$collectValidLocalBundles_u24lambda_u241.add(path);
                continue;
            }
            Set $this$thisLogger$iv = $this$collectValidLocalBundles_u24lambda_u241;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(Set.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error(StringsKt.trimIndent((String)("\n          Skipping local bundle " + path + " for language " + language.getNativeName() + ". \n          Failed to verify integrity of local language bundle before adding it to class loader.\n          ")));
        }
        Set bundles2 = SetsKt.build((Set)set);
        return CollectionsKt.toList((Iterable)bundles2);
    }

    public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        if (Intrinsics.areEqual((Object)pluginDescriptor.getPluginId().getIdString(), (Object)"tanvd.grazi")) {
            this.getMyDynClassLoaders().clear();
        }
    }

    public final boolean addDynClassLoader(@NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        return this.getMyDynClassLoaders().add(classLoader);
    }

    private final Set<ClassLoader> getDynClassLoaders() {
        return CollectionsKt.toSet((Iterable)this.getMyDynClassLoaders());
    }

    private final Path getDynamicFolderPath() {
        String customFolder = System.getProperty("grazie.dynamic.customJarDirectory");
        if (customFolder != null) {
            Path path = Path.of(customFolder, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            return path;
        }
        Path path = PathManager.getConfigDir().resolve("grazie");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final Path getLangDynamicFolder(@NotNull Lang lang) {
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        Path path = this.getDynamicFolder().resolve(this.getStorageDescriptor(lang));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private final String getStorageDescriptor(Lang lang) {
        if (lang.getHunspellRemote() != null) {
            return lang.getIso() + "-LT6.7.19-HN0.2.318";
        }
        return lang.getIso() + "-LT6.7.19";
    }

    @NotNull
    public final Path getDynamicFolder() {
        Path result = this.getDynamicFolderPath();
        Files.createDirectories(result, new FileAttribute[0]);
        return result;
    }

    @Nullable
    public final Language loadLang(@NotNull Lang lang) {
        Object v2;
        block5: {
            Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
            LanguageToolDescriptor languageToolDescriptor = lang.getLtRemote();
            if (languageToolDescriptor == null) {
                return null;
            }
            LanguageToolDescriptor remote = languageToolDescriptor;
            for (String className : remote.getLangsClasses()) {
                try {
                    Languages.getOrAddLanguageByClassName((String)("org.languagetool.language." + className));
                }
                catch (RuntimeException e) {
                    if (e.getCause() instanceof ClassNotFoundException) continue;
                    throw e;
                }
            }
            List list = Languages.get();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"get(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                Language it = (Language)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getClass().getSimpleName(), (Object)lang.getClassName())) continue;
                v2 = t;
                break block5;
            }
            v2 = null;
        }
        return v2;
    }

    @Nullable
    public final Class<?> loadClass(@NotNull String className) {
        Class<?> clazz;
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        GrazieDynamic this_$iv = this;
        boolean $i$f$forClassLoader = false;
        ClassLoader it = GraziePlugin.INSTANCE.getClassLoader();
        boolean bl = false;
        try {
            clazz = Class.forName(className, true, it);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = null;
        }
        Class<?> clazz2 = clazz;
        Object object = clazz2;
        if (clazz2 == null) {
            object = SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this_$iv.getDynClassLoaders()), (Function1)new Function1<ClassLoader, Class<?>>(className){
                final /* synthetic */ String $className$inlined;
                {
                    this.$className$inlined = string;
                }

                public final Class<?> invoke(ClassLoader it) {
                    Class<?> clazz;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    ClassLoader it2 = it;
                    boolean bl = false;
                    try {
                        clazz = Class.forName(this.$className$inlined, true, it2);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        clazz = null;
                    }
                    return clazz;
                }
            }));
        }
        return object;
    }

    @Nullable
    public final InputStream getResourceAsStream(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        GrazieDynamic this_$iv = this;
        boolean $i$f$forClassLoader = false;
        ClassLoader it = GraziePlugin.INSTANCE.getClassLoader();
        boolean bl = false;
        Object object = it.getResourceAsStream(StringsKt.removePrefix((String)path, (CharSequence)"/"));
        if (object == null) {
            object = SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this_$iv.getDynClassLoaders()), (Function1)((Function1)new Function1<ClassLoader, InputStream>(path){
                final /* synthetic */ String $path$inlined;
                {
                    this.$path$inlined = string;
                }

                public final InputStream invoke(ClassLoader it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    ClassLoader it2 = it;
                    boolean bl = false;
                    return it2.getResourceAsStream(StringsKt.removePrefix((String)this.$path$inlined, (CharSequence)"/"));
                }
            })));
        }
        return object;
    }

    @Nullable
    public final URL getResource(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        GrazieDynamic this_$iv = this;
        boolean $i$f$forClassLoader = false;
        ClassLoader it = GraziePlugin.INSTANCE.getClassLoader();
        boolean bl = false;
        Object object = it.getResource(StringsKt.removePrefix((String)path, (CharSequence)"/"));
        if (object == null) {
            object = SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this_$iv.getDynClassLoaders()), (Function1)((Function1)new Function1<ClassLoader, URL>(path){
                final /* synthetic */ String $path$inlined;
                {
                    this.$path$inlined = string;
                }

                public final URL invoke(ClassLoader it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    ClassLoader it2 = it;
                    boolean bl = false;
                    return it2.getResource(StringsKt.removePrefix((String)this.$path$inlined, (CharSequence)"/"));
                }
            })));
        }
        return object;
    }

    @NotNull
    public final List<URL> getResources(@NotNull String path) {
        List list;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        GrazieDynamic this_$iv = this;
        boolean $i$f$forClassLoader = false;
        ClassLoader loader = GraziePlugin.INSTANCE.getClassLoader();
        boolean bl = false;
        Enumeration<URL> enumeration = loader.getResources(StringsKt.removePrefix((String)path, (CharSequence)"/"));
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getResources(...)");
        ArrayList<URL> arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
        List it = list = (List)arrayList;
        boolean bl2 = false;
        List list2 = !((Collection)it).isEmpty() ? list : null;
        Object object = list2;
        if (list2 == null) {
            object = SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this_$iv.getDynClassLoaders()), (Function1)((Function1)new Function1<ClassLoader, List<? extends URL>>(path){
                final /* synthetic */ String $path$inlined;
                {
                    this.$path$inlined = string;
                }

                public final List<? extends URL> invoke(ClassLoader it) {
                    List<E> list;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    ClassLoader loader = it;
                    boolean bl = false;
                    Enumeration<URL> enumeration = loader.getResources(StringsKt.removePrefix((String)this.$path$inlined, (CharSequence)"/"));
                    Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getResources(...)");
                    ArrayList<URL> arrayList = Collections.list(enumeration);
                    Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
                    List<E> it2 = list = (List<E>)arrayList;
                    boolean bl2 = false;
                    return !((Collection)it2).isEmpty() ? list : null;
                }
            })));
        }
        List list3 = object;
        if (object == null) {
            list3 = CollectionsKt.emptyList();
        }
        return list3;
    }

    @NotNull
    public final ResourceBundle getResourceBundle(@NotNull String baseName, @NotNull Locale locale) {
        ResourceBundle resourceBundle;
        Intrinsics.checkNotNullParameter((Object)baseName, (String)"baseName");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        GrazieDynamic this_$iv = this;
        boolean $i$f$forClassLoader = false;
        ClassLoader it = GraziePlugin.INSTANCE.getClassLoader();
        boolean bl = false;
        try {
            resourceBundle = DynamicBundle.getResourceBundle((ClassLoader)GrazieBundle.class.getClassLoader(), (String)baseName);
        }
        catch (MissingResourceException e) {
            resourceBundle = null;
        }
        ResourceBundle resourceBundle2 = resourceBundle;
        Object object = resourceBundle2;
        if (resourceBundle2 == null) {
            object = SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this_$iv.getDynClassLoaders()), (Function1)((Function1)new Function1<ClassLoader, ResourceBundle>(baseName){
                final /* synthetic */ String $baseName$inlined;
                {
                    this.$baseName$inlined = string;
                }

                public final ResourceBundle invoke(ClassLoader it) {
                    ResourceBundle resourceBundle;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    ClassLoader it2 = it;
                    boolean bl = false;
                    try {
                        resourceBundle = DynamicBundle.getResourceBundle((ClassLoader)GrazieBundle.class.getClassLoader(), (String)this.$baseName$inlined);
                    }
                    catch (MissingResourceException e) {
                        resourceBundle = null;
                    }
                    return resourceBundle;
                }
            })));
        }
        if (object == null) {
            throw new MissingResourceException("Missing resource bundle for " + baseName + " with locale " + locale, INSTANCE.getClass().getName(), baseName);
        }
        return object;
    }

    private final <T> T forClassLoader(Function1<? super ClassLoader, ? extends T> body) {
        boolean $i$f$forClassLoader = false;
        Object object = body.invoke((Object)GraziePlugin.INSTANCE.getClassLoader());
        if (object == null) {
            object = SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.getDynClassLoaders()), (Function1)new Function1<ClassLoader, T>(body){
                final /* synthetic */ Function1<ClassLoader, T> $body;
                {
                    this.$body = $body;
                }

                public final T invoke(ClassLoader it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return (T)this.$body.invoke((Object)it);
                }
            }));
        }
        return (T)object;
    }

    private static final HashSet myDynClassLoaders_delegate$lambda$0() {
        for (Path file : INSTANCE.getOldFiles()) {
            NioFiles.deleteRecursively((Path)file);
        }
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(DynamicPluginListener.TOPIC, (Object)INSTANCE);
        Object[] objectArray = new ClassLoader[1];
        Intrinsics.checkNotNullExpressionValue((Object)UrlClassLoader.build().parent(GraziePlugin.INSTANCE.getClassLoader()).files(INSTANCE.collectValidLocalBundles()).get(), (String)"get(...)");
        return SetsKt.hashSetOf((Object[])objectArray);
    }

    private static final boolean getOldFiles$lambda$0(Path file) {
        boolean bl;
        block3: {
            Iterable $this$none$iv = (Iterable)Lang.getEntries();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Lang it = (Lang)((Object)element$iv);
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)((Object)file.getFileName()).toString(), (Object)INSTANCE.getStorageDescriptor(it))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean getOldFiles$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

