/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.inspection.rephrase;

import ai.grazie.nlp.langs.Language;
import ai.grazie.nlp.tokenizer.word.StandardWordTokenizer;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.grazie.GrazieBundle;
import com.intellij.grazie.cloud.APIQueries;
import com.intellij.grazie.cloud.GrazieCloudConnector;
import com.intellij.grazie.detection.LangDetector;
import com.intellij.grazie.ide.fus.GrazieFUSCounter;
import com.intellij.grazie.ide.ui.PaddedListCellRenderer;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.grazie.utils.HighlightingUtil;
import com.intellij.grazie.utils.NaturalTextDetector;
import com.intellij.grazie.utils.Text;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RephraseAction
extends IntentionAndQuickFixAction {
    @IntentionName
    @NotNull
    public String getName() {
        String string = GrazieBundle.message("intention.rephrase.text", new Object[0]);
        if (string == null) {
            RephraseAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            RephraseAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            RephraseAction.$$$reportNull$$$0(2);
        }
        if (editor == null || CommitMessage.isCommitMessage((PsiElement)psiFile)) {
            return false;
        }
        if (!GrazieCloudConnector.Companion.seemsCloudConnected()) {
            return false;
        }
        TextContent content = TextExtractor.findTextAt(psiFile, editor.getCaretModel().getOffset(), TextContent.TextDomain.ALL);
        TextRange range = HighlightingUtil.selectionRange(editor);
        if (content == null || range.isEmpty() && !NaturalTextDetector.seemsNatural(content)) {
            return false;
        }
        return content.fileRangeToText(range) != null;
    }

    public void applyFix(@NotNull Project project, PsiFile psiFile, @Nullable Editor editor) {
        if (project == null) {
            RephraseAction.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            return;
        }
        SuggestionsWithLanguage rephraseData = (SuggestionsWithLanguage)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> (SuggestionsWithLanguage)ReadAction.compute(() -> {
            TextContent content = TextExtractor.findTextAt(psiFile, editor.getSelectionModel().getSelectionStart(), TextContent.TextDomain.ALL);
            if (content == null) {
                return new SuggestionsWithLanguage(Language.UNKNOWN, Collections.emptyList(), null, null, null);
            }
            TextRange textRange = content.fileRangeToText(HighlightingUtil.selectionRange(editor));
            if (textRange == null) {
                return new SuggestionsWithLanguage(Language.UNKNOWN, Collections.emptyList(), content.length(), null, null);
            }
            Language iso = LangDetector.INSTANCE.getLanguage(content.toString());
            if (iso == null) {
                return new SuggestionsWithLanguage(Language.UNKNOWN, Collections.emptyList(), content.length(), null, null);
            }
            int wordRangeCount = StandardWordTokenizer.INSTANCE.words(content.toString()).size();
            int rangeLength = textRange.getLength();
            GrazieFUSCounter.INSTANCE.reportRephraseRequested(iso, content.length(), rangeLength, wordRangeCount);
            TextRange wordBoundRange = Text.alignToWordBounds(textRange, content.toString());
            List<String> rephrasedSentences = APIQueries.getRephraser().rephrase(content.toString(), wordBoundRange, iso, project);
            if (rephrasedSentences == null) {
                return new SuggestionsWithLanguage(iso, Collections.emptyList(), content.length(), rangeLength, wordRangeCount);
            }
            List suggestions = ContainerUtil.mapNotNull(rephrasedSentences, rephrasedSentence -> RephraseAction.toListItem(wordBoundRange, content, rephrasedSentence));
            return new SuggestionsWithLanguage(iso, suggestions, content.length(), rangeLength, wordRangeCount);
        }), GrazieBundle.message("intention.rephrase.progress.title", new Object[0]), true, project);
        if (rephraseData.suggestions().isEmpty()) {
            GrazieFUSCounter.INSTANCE.reportRephraseEmpty(rephraseData.language, rephraseData.textLength, rephraseData.rangeLength, rephraseData.wordRangeCount);
            HintManager.getInstance().showErrorHint(editor, GrazieBundle.message("intention.rephrase.no.results.popup", new Object[0]));
            return;
        }
        this.showPopup(project, editor, psiFile, rephraseData);
    }

    private static ListItem toListItem(TextRange minRange, TextContent content, String suggestion) {
        int commonPrefix = StringUtil.commonPrefixLength((CharSequence)content.toString(), (CharSequence)suggestion);
        int commonSuffix = StringUtil.commonSuffixLength((CharSequence)content.toString(), (CharSequence)suggestion.substring(commonPrefix));
        if (commonPrefix == 0 && commonSuffix == 0) {
            return new ListItem(content.textRangeToFile(minRange), suggestion);
        }
        if (commonPrefix > minRange.getEndOffset() + 1 || content.length() - commonSuffix < minRange.getStartOffset() - 1) {
            return null;
        }
        TextRange range = Text.alignToWordBounds(new TextRange(Math.min(minRange.getStartOffset(), commonPrefix), Math.max(content.length() - commonSuffix, minRange.getEndOffset())), content);
        String replacement = suggestion.substring(range.getStartOffset(), suggestion.length() - (content.length() - range.getEndOffset()));
        TextRange fileRange = new TextRange(content.textOffsetToFile(range.getStartOffset()), content.textOffsetToFile(range.getEndOffset()));
        return new ListItem(fileRange, replacement);
    }

    private void showPopup(Project project, Editor editor, PsiFile file, final SuggestionsWithLanguage descriptor) {
        final Ref highlighter = new Ref();
        final List<ListItem> suggestions = descriptor.suggestions();
        JBPopup popup = JBPopupFactory.getInstance().createPopupChooserBuilder(suggestions).setSelectionMode(0).setRenderer((ListCellRenderer)new PaddedListCellRenderer()).setItemChosenCallback(item -> WriteCommandAction.runWriteCommandAction((Project)project, (String)this.getName(), null, () -> {
            int selectedRank = suggestions.indexOf(item);
            editor.getDocument().replaceString(item.fileRange.getStartOffset(), item.fileRange.getEndOffset(), (CharSequence)item.replacement);
            int rephraseLength = item.replacement.length();
            int rephraseWordCount = StandardWordTokenizer.INSTANCE.words(item.replacement).size();
            GrazieFUSCounter.INSTANCE.reportRephraseApplied(descriptor.language, suggestions.size(), rephraseLength, rephraseWordCount, selectedRank);
        }, (PsiFile[])new PsiFile[]{file})).setNamerForFiltering(i -> i.replacement).setItemSelectedCallback(item -> {
            RephraseAction.dropHighlighter((Ref<RangeHighlighter>)highlighter);
            if (item != null) {
                highlighter.set((Object)editor.getMarkupModel().addRangeHighlighter(EditorColors.SEARCH_RESULT_ATTRIBUTES, item.fileRange.getStartOffset(), item.fileRange.getEndOffset(), 6001, HighlighterTargetArea.EXACT_RANGE));
            }
        }).addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                RephraseAction.dropHighlighter((Ref<RangeHighlighter>)highlighter);
                if (!event.isOk()) {
                    GrazieFUSCounter.INSTANCE.reportRephraseRejected(descriptor.language(), suggestions.size());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/grazie/ide/inspection/rephrase/RephraseAction$1", "onClosed"));
            }
        }).createPopup();
        popup.showInBestPositionFor(editor);
    }

    private static void dropHighlighter(Ref<RangeHighlighter> highlighter) {
        RangeHighlighter rh = (RangeHighlighter)highlighter.get();
        if (rh != null) {
            rh.dispose();
        }
        highlighter.set(null);
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/grazie/ide/inspection/rephrase/RephraseAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/grazie/ide/inspection/rephrase/RephraseAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }

    public record SuggestionsWithLanguage(@NotNull Language language, @NotNull List<ListItem> suggestions, @Nullable Integer textLength, @Nullable Integer rangeLength, @Nullable Integer wordRangeCount) {
        @NotNull
        private final Language language;
        @NotNull
        private final List<ListItem> suggestions;

        public SuggestionsWithLanguage(@NotNull Language language, @NotNull List<ListItem> suggestions, @Nullable Integer textLength, @Nullable Integer rangeLength, @Nullable Integer wordRangeCount) {
            if (language == null) {
                SuggestionsWithLanguage.$$$reportNull$$$0(0);
            }
            if (suggestions == null) {
                SuggestionsWithLanguage.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public Language language() {
            Language language = this.language;
            if (language == null) {
                SuggestionsWithLanguage.$$$reportNull$$$0(2);
            }
            return language;
        }

        @NotNull
        public List<ListItem> suggestions() {
            List<ListItem> list = this.suggestions;
            if (list == null) {
                SuggestionsWithLanguage.$$$reportNull$$$0(3);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suggestions";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/grazie/ide/inspection/rephrase/RephraseAction$SuggestionsWithLanguage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/grazie/ide/inspection/rephrase/RephraseAction$SuggestionsWithLanguage";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "language";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "suggestions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private record ListItem(TextRange fileRange, String replacement) {
        @Override
        public String toString() {
            return this.replacement;
        }
    }
}

