/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.text;

import ai.grazie.nlp.langs.Language;
import ai.grazie.nlp.tokenizer.Tokenizer;
import ai.grazie.nlp.tokenizer.sentence.StandardSentenceTokenizer;
import ai.grazie.text.TextRange;
import ai.grazie.utils.CollectionsKt;
import com.intellij.codeInsight.daemon.impl.ProblemDescriptorWithReporterName;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.codeWithMe.ClientId;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.grammar.strategy.GrammarCheckingStrategy;
import com.intellij.grazie.ide.fus.AcceptanceRateTracker;
import com.intellij.grazie.ide.fus.GrazieFUSCounter;
import com.intellij.grazie.ide.inspection.grammar.quickfix.GrazieAddExceptionQuickFix;
import com.intellij.grazie.ide.inspection.grammar.quickfix.GrazieCustomFixWrapper;
import com.intellij.grazie.ide.inspection.grammar.quickfix.GrazieEnableCloudAction;
import com.intellij.grazie.ide.inspection.grammar.quickfix.GrazieReplaceTypoQuickFix;
import com.intellij.grazie.ide.inspection.grammar.quickfix.GrazieRuleSettingsAction;
import com.intellij.grazie.ide.language.LanguageGrammarChecking;
import com.intellij.grazie.text.CachedResults;
import com.intellij.grazie.text.CheckerRunnerKt;
import com.intellij.grazie.text.ExternalTextChecker;
import com.intellij.grazie.text.ProblemFilter;
import com.intellij.grazie.text.Rule;
import com.intellij.grazie.text.RuleGroup;
import com.intellij.grazie.text.SuppressionPattern;
import com.intellij.grazie.text.TextChecker;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextProblem;
import com.intellij.grazie.utils.GrazieUtilsKt;
import com.intellij.grazie.utils.HighlightingUtil;
import com.intellij.grazie.utils.NaturalTextDetector;
import com.intellij.grazie.utils.TextUtilsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.YieldKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001AB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\rJ0\u0010\u0014\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\r2\u0018\u0010\u0019\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\r\u0012\u0004\u0012\u00020\u00160\u001aH\u0007J\u0018\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\r2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J$\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00150\r2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\r2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00150\r2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00150\rH\u0002J\u001e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00152\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00150'H\u0002J\u001c\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\r2\u0006\u0010%\u001a\u00020\u00152\u0006\u0010*\u001a\u00020$J\"\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010%\u001a\u00020\u0015H\u0002J\u0010\u00100\u001a\u00020$2\u0006\u00101\u001a\u00020\u0015H\u0002J\u0010\u00102\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0015H\u0002J\u0010\u00103\u001a\u0002042\u0006\u00101\u001a\u00020\u0015H\u0002J\u0010\u00105\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0015H\u0002J\u0012\u00106\u001a\u0004\u0018\u0001072\u0006\u0010%\u001a\u00020\u0015H\u0007J!\u00108\u001a\b\u0012\u0004\u0012\u00020:092\u0006\u0010%\u001a\u00020\u00152\u0006\u00101\u001a\u00020)\u00a2\u0006\u0002\u0010;J\u0016\u0010<\u001a\b\u0012\u0004\u0012\u00020/0\r2\u0006\u0010%\u001a\u00020\u0015H\u0002J\u001a\u0010=\u001a\u00020>2\u0006\u0010%\u001a\u00020\u00152\b\u0010?\u001a\u0004\u0018\u000107H\u0007J\u0010\u0010@\u001a\u00020/2\u0006\u0010%\u001a\u00020\u0015H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006B"}, d2={"Lcom/intellij/grazie/text/CheckerRunner;", "", "text", "Lcom/intellij/grazie/text/TextContent;", "<init>", "(Lcom/intellij/grazie/text/TextContent;)V", "getText", "()Lcom/intellij/grazie/text/TextContent;", "tokenizer", "Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer;", "getTokenizer", "()Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer;", "sentences", "", "Lai/grazie/nlp/tokenizer/Tokenizer$Token;", "getSentences", "()Ljava/util/List;", "sentences$delegate", "Lkotlin/Lazy;", "tokenize", "run", "Lcom/intellij/grazie/text/TextProblem;", "", "checkers", "Lcom/intellij/grazie/text/TextChecker;", "consumer", "Lkotlin/Function1;", "getCachedProblems", "configStamp", "", "doRun", "context", "Lcom/intellij/grazie/text/TextChecker$ProofreadingContext;", "filter", "problems", "processProblem", "", "problem", "filtered", "", "toProblemDescriptors", "Lcom/intellij/codeInspection/ProblemDescriptor;", "isOnTheFly", "validateRangeInElement", "psi", "Lcom/intellij/psi/PsiElement;", "rangeInElement", "Lcom/intellij/openapi/util/TextRange;", "isIgnoredByStrategies", "descriptor", "hasIgnoredCategory", "ignoredRules", "Lcom/intellij/grazie/text/RuleGroup;", "isSuppressed", "findSentence", "", "toFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "(Lcom/intellij/grazie/text/TextProblem;Lcom/intellij/codeInspection/ProblemDescriptor;)[Lcom/intellij/codeInspection/LocalQuickFix;", "fileHighlightRanges", "defaultSuppressionPattern", "Lcom/intellij/grazie/text/SuppressionPattern;", "sentenceText", "highlightSpan", "GrazieProblemDescriptor", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nCheckerRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckerRunner.kt\ncom/intellij/grazie/text/CheckerRunner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,305:1\n1563#2:306\n1634#2,3:307\n1869#2,2:313\n2746#2,2:315\n1761#2,3:317\n2748#2:320\n1563#2:321\n1634#2,3:322\n1761#2,3:326\n1563#2:329\n1634#2,3:330\n1878#2,3:333\n42#3,3:310\n1#4:325\n37#5,2:336\n*S KotlinDebug\n*F\n+ 1 CheckerRunner.kt\ncom/intellij/grazie/text/CheckerRunner\n*L\n64#1:306\n64#1:307,3\n128#1:313,2\n144#1:315,2\n144#1:317,3\n144#1:320\n155#1:321\n155#1:322,3\n253#1:326,3\n260#1:329\n260#1:330,3\n267#1:333,3\n73#1:310,3\n278#1:336,2\n*E\n"})
public final class CheckerRunner {
    @NotNull
    private final TextContent text;
    @NotNull
    private final Lazy sentences$delegate;

    public CheckerRunner(@NotNull TextContent text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.text = text;
        this.sentences$delegate = LazyKt.lazy(() -> CheckerRunner.sentences_delegate$lambda$0(this));
    }

    @NotNull
    public final TextContent getText() {
        return this.text;
    }

    private final StandardSentenceTokenizer getTokenizer() {
        return StandardSentenceTokenizer.Companion.getDefault();
    }

    private final List<Tokenizer.Token> getSentences() {
        Lazy lazy = this.sentences$delegate;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final List<Tokenizer.Token> tokenize(TextContent text) {
        void $this$mapTo$iv$iv;
        String string = ((Object)text).toString();
        StringUtil.BombedCharSequence sequence2 = new StringUtil.BombedCharSequence(string){

            protected void checkCanceled() {
                ProgressManager.checkCanceled();
            }
        };
        List ranges = this.getTokenizer().tokenRanges((CharSequence)sequence2);
        Iterable $this$map$iv = ranges;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TextRange textRange = (TextRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Tokenizer.Token(((Object)((CharSequence)text).subSequence(it.getStart(), it.getEndExclusive())).toString(), new IntRange(it.getStart(), it.getEndExclusive())));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<TextProblem> run() {
        List<TextProblem> cachedProblems;
        if (StringsKt.isBlank((CharSequence)this.text) || !NaturalTextDetector.seemsNatural(this.text)) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        TextChecker.ProofreadingContext context = GrazieUtilsKt.toProofreadingContext(this.text);
        if (context.getLanguage() == Language.UNKNOWN || HighlightingUtil.findInstalledLang(context.getLanguage()) == null) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        boolean $i$f$service = false;
        Class<GrazieConfig> serviceClass$iv = GrazieConfig.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        long configStamp = ((GrazieConfig)object).getModificationCount();
        List<TextProblem> list = cachedProblems = this.getCachedProblems(configStamp);
        if (list != null) {
            return list;
        }
        List<TextChecker> list2 = TextChecker.allCheckers();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"allCheckers(...)");
        cachedProblems = this.filter(this.doRun(list2, context));
        this.text.putUserData(CheckerRunnerKt.access$getProblemsKey$p(), new CachedResults(configStamp, cachedProblems));
        return cachedProblems;
    }

    @Deprecated(message="This method is deprecated and does nothing. Use run() instead.")
    @ApiStatus.ScheduledForRemoval
    public final void run(@NotNull List<? extends TextChecker> checkers, @NotNull Function1<? super List<? extends TextProblem>, Unit> consumer) {
        Intrinsics.checkNotNullParameter(checkers, (String)"checkers");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
    }

    private final List<TextProblem> getCachedProblems(long configStamp) {
        CachedResults cache = (CachedResults)this.text.getUserData(CheckerRunnerKt.access$getProblemsKey$p());
        if (cache != null && cache.getConfigStamp() == configStamp) {
            return cache.getProblems();
        }
        return null;
    }

    private final List<TextProblem> doRun(List<? extends TextChecker> checkers, TextChecker.ProofreadingContext context) {
        return (List)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends TextProblem>>, Object>(checkers, context, null){
            Object L$1;
            Object L$2;
            Object L$3;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ List<TextChecker> $checkers;
            final /* synthetic */ TextChecker.ProofreadingContext $context;
            {
                this.$checkers = $checkers;
                this.$context = $context;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var15_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var4_4 = this.$checkers;
                        var5_5 = this.$context;
                        $i$f$map = false;
                        var7_7 = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            var12_12 = (TextChecker)item$iv$iv;
                            var14_14 = destination$iv$iv;
                            $i$a$-map-CheckerRunner$doRun$1$deferred$1 = false;
                            var14_14.add(checker instanceof ExternalTextChecker ? BuildersKt.async$default((CoroutineScope)$this$runBlockingCancellable, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Collection<? extends TextProblem>>, Object>((TextChecker)checker, var5_5, null){
                                int label;
                                final /* synthetic */ TextChecker $checker;
                                final /* synthetic */ TextChecker.ProofreadingContext $context;
                                {
                                    this.$checker = $checker;
                                    this.$context = $context;
                                    super(2, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            Object object2 = ((ExternalTextChecker)this.$checker).checkExternally(this.$context, (Continuation<? super Collection<? extends TextProblem>>)((Continuation)this));
                                            if (object2 != object) return object2;
                                            return object;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            return object2;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Collection<? extends TextProblem>> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null) : BuildersKt.async$default((CoroutineScope)$this$runBlockingCancellable, null, (CoroutineStart)CoroutineStart.LAZY, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Collection<? extends TextProblem>>, Object>((TextChecker)checker, var5_5, null){
                                int label;
                                final /* synthetic */ TextChecker $checker;
                                final /* synthetic */ TextChecker.ProofreadingContext $context;
                                {
                                    this.$checker = $checker;
                                    this.$context = $context;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Collection<? extends TextProblem> collection = this.$checker.check(this.$context);
                                            Intrinsics.checkNotNullExpressionValue(collection, (String)"check(...)");
                                            return collection;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Collection<? extends TextProblem>> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)1, null));
                        }
                        deferred = (List)destination$iv$iv;
                        var4_4 = deferred.iterator();
lbl21:
                        // 2 sources

                        while (var4_4.hasNext()) {
                            job = (Deferred)var4_4.next();
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$runBlockingCancellable);
                            this.L$1 = deferred;
                            this.L$2 = var4_4;
                            this.L$3 = job;
                            this.label = 1;
                            v0 = YieldKt.yield((Continuation)((Continuation)this));
                            if (v0 == var15_3) {
                                return var15_3;
                            }
                            ** GOTO lbl39
                        }
                        break;
                    }
                    case 1: {
                        job = (Deferred)this.L$3;
                        var4_4 = (Iterator)this.L$2;
                        deferred = (List)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl39:
                        // 2 sources

                        job.start();
                        ** GOTO lbl21
                    }
                }
                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$runBlockingCancellable);
                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)deferred);
                this.L$2 = null;
                this.L$3 = null;
                this.label = 2;
                v1 = AwaitKt.awaitAll((Collection)deferred, (Continuation)((Continuation)this));
                if (v1 == var15_3) {
                    return var15_3;
                }
                ** GOTO lbl55
                {
                    case 2: {
                        deferred = (List)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl55:
                        // 2 sources

                        return kotlin.collections.CollectionsKt.flatten((Iterable)((Iterable)v1));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<? extends TextProblem>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final List<TextProblem> filter(List<? extends TextProblem> problems) {
        ArrayList filtered = new ArrayList();
        Iterable $this$forEach$iv = problems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextProblem problem = (TextProblem)element$iv;
            boolean bl = false;
            this.processProblem(problem, filtered);
        }
        return filtered;
    }

    private final boolean processProblem(TextProblem problem, List<TextProblem> filtered) {
        boolean bl;
        block14: {
            if (!Intrinsics.areEqual((Object)problem.getText(), (Object)this.text)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (this.isSuppressed(problem) || this.hasIgnoredCategory(problem) || this.isIgnoredByStrategies(problem) || ProblemFilter.allIgnoringFilters(problem).findAny().isPresent()) {
                return false;
            }
            Iterable $this$none$iv = filtered;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    boolean bl2;
                    block13: {
                        TextProblem it = (TextProblem)element$iv;
                        boolean bl3 = false;
                        List<com.intellij.openapi.util.TextRange> list = it.getHighlightRanges();
                        Intrinsics.checkNotNullExpressionValue(list, (String)"getHighlightRanges(...)");
                        Iterable $this$any$iv = list;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                boolean bl4;
                                block12: {
                                    com.intellij.openapi.util.TextRange r1 = (com.intellij.openapi.util.TextRange)element$iv2;
                                    boolean bl5 = false;
                                    List<com.intellij.openapi.util.TextRange> list2 = problem.getHighlightRanges();
                                    Intrinsics.checkNotNullExpressionValue(list2, (String)"getHighlightRanges(...)");
                                    Iterable $this$any$iv2 = list2;
                                    boolean $i$f$any2 = false;
                                    if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                        bl4 = false;
                                    } else {
                                        for (Object element$iv3 : $this$any$iv2) {
                                            com.intellij.openapi.util.TextRange r2 = (com.intellij.openapi.util.TextRange)element$iv3;
                                            boolean bl6 = false;
                                            if (!r1.intersects(r2)) continue;
                                            bl4 = true;
                                            break block12;
                                        }
                                        bl4 = false;
                                    }
                                }
                                if (!bl4) continue;
                                bl2 = true;
                                break block13;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = false;
                    break block14;
                }
                bl = true;
            }
        }
        if (bl) {
            filtered.add(problem);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ProblemDescriptor> toProblemDescriptors(@NotNull TextProblem problem, boolean isOnTheFly) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        PsiElement psiElement = this.text.getCommonParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getCommonParent(...)");
        PsiElement parent = psiElement;
        String string = problem.getTooltipTemplate();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTooltipTemplate(...)");
        String tooltip = string;
        String string2 = problem.getDescriptionTemplate(isOnTheFly);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDescriptionTemplate(...)");
        String description = string2;
        Iterable $this$map$iv = this.fileHighlightRanges(problem);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            com.intellij.openapi.util.TextRange rangeInElement;
            void range;
            com.intellij.openapi.util.TextRange textRange = (com.intellij.openapi.util.TextRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)range.shiftLeft(PsiTreeUtilKt.getStartOffset((PsiElement)parent)), (String)"shiftLeft(...)");
            this.validateRangeInElement(parent, rangeInElement, problem);
            GrazieProblemDescriptor grazieDescriptor = new GrazieProblemDescriptor(parent, description, rangeInElement, isOnTheFly, tooltip);
            if (isOnTheFly) {
                grazieDescriptor.setQuickFixes(this.toFixes(problem, (ProblemDescriptor)grazieDescriptor));
            }
            String shortName = problem.isStyleLike() ? "GrazieStyle" : "GrazieInspection";
            ProblemDescriptorWithReporterName descriptor = new ProblemDescriptorWithReporterName((ProblemDescriptorBase)grazieDescriptor, shortName);
            descriptor.setProblemGroup(() -> CheckerRunner.toProblemDescriptors$lambda$0$0(shortName));
            collection.add(descriptor);
        }
        return (List)destination$iv$iv;
    }

    private final void validateRangeInElement(PsiElement psi, com.intellij.openapi.util.TextRange rangeInElement, TextProblem problem) {
        if (rangeInElement != null && psi.getTextRange() != null) {
            com.intellij.openapi.util.TextRange.assertProperRange((Segment)((Segment)rangeInElement));
            int psiTextLength = psi.getTextRange().getLength();
            if (rangeInElement.getEndOffset() > psiTextLength) {
                CheckerRunnerKt.access$getLOG$p().error("Argument rangeInElement (" + rangeInElement + ") endOffset must not exceed descriptor text range (" + psi.getTextRange().getStartOffset() + ", " + psi.getTextRange().getEndOffset() + ") length (" + psiTextLength + "). PSI language: " + psi.getLanguage().getID() + ", TextContent.fileRanges: " + problem.getText().getRangesInFile());
            }
        }
    }

    private final boolean isIgnoredByStrategies(TextProblem descriptor) {
        PsiElement psiElement = this.text.findPsiElementAt(0);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"findPsiElementAt(...)");
        for (PsiElement root : PsiTreeUtilKt.parents((PsiElement)psiElement, (boolean)true)) {
            for (GrammarCheckingStrategy strategy : LanguageGrammarChecking.INSTANCE.allForLanguage(root.getLanguage())) {
                com.intellij.openapi.util.TextRange patternRange;
                com.intellij.openapi.util.TextRange errorRange;
                if (!strategy.isMyContextRoot(root)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)this.text.textRangeToFile(this.highlightSpan(descriptor)).shiftLeft(PsiTreeUtilKt.getStartOffset((PsiElement)root)), (String)"shiftLeft(...)");
                com.intellij.openapi.util.TextRange textRange = descriptor.getPatternRange();
                if (textRange == null) {
                    textRange = this.highlightSpan(descriptor);
                }
                Intrinsics.checkNotNullExpressionValue((Object)this.text.textRangeToFile(textRange).shiftLeft(PsiTreeUtilKt.getStartOffset((PsiElement)root)), (String)"shiftLeft(...)");
                IntRange typoRange = RangesKt.until((int)errorRange.getStartOffset(), (int)errorRange.getEndOffset());
                IntRange ruleRange = RangesKt.until((int)patternRange.getStartOffset(), (int)patternRange.getEndOffset());
                PsiElement psiElement2 = this.text.getCommonParent();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getCommonParent(...)");
                if (strategy.isTypoAccepted(psiElement2, strategy.getRootsChain(root), typoRange, ruleRange) && strategy.isTypoAccepted(root, typoRange, ruleRange)) continue;
                return true;
            }
        }
        return false;
    }

    private final boolean hasIgnoredCategory(TextProblem problem) {
        RuleGroup ignored = this.ignoredRules(problem);
        return !((Collection)ignored.getRules()).isEmpty() && problem.fitsGroup(ignored);
    }

    private final RuleGroup ignoredRules(TextProblem descriptor) {
        List<com.intellij.openapi.util.TextRange> list = descriptor.getHighlightRanges();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getHighlightRanges(...)");
        LinkedHashSet leaves = CollectionsKt.toLinkedSet((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMapIterable((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)list), CheckerRunner::ignoredRules$lambda$0), arg_0 -> CheckerRunner.ignoredRules$lambda$1(this, arg_0)));
        LinkedHashSet ignored = new LinkedHashSet();
        Iterator iterator = leaves.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            PsiElement leaf = (PsiElement)e;
            for (PsiElement root : PsiTreeUtilKt.parents((PsiElement)leaf, (boolean)true)) {
                block2: for (GrammarCheckingStrategy strategy : LanguageGrammarChecking.INSTANCE.allForLanguage(root.getLanguage())) {
                    for (PsiElement child : PsiTreeUtilKt.parents((PsiElement)leaf, (boolean)true)) {
                        com.intellij.grazie.grammar.strategy.impl.RuleGroup group = strategy.getIgnoredRuleGroup(root, child);
                        if (group != null) {
                            ignored.addAll(group.getRules());
                        }
                        if (!Intrinsics.areEqual((Object)child, (Object)root)) continue;
                        continue block2;
                    }
                }
            }
        }
        return new RuleGroup(ignored);
    }

    private final boolean isSuppressed(TextProblem problem) {
        String sentence = this.findSentence(problem);
        if (this.defaultSuppressionPattern(problem, sentence).isSuppressed()) {
            return true;
        }
        com.intellij.openapi.util.TextRange patternRange = problem.getPatternRange();
        CharSequence charSequence = this.highlightSpan(problem).subSequence((CharSequence)this.text);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"subSequence(...)");
        CharSequence errorText = charSequence;
        return patternRange != null && sentence != null && new SuppressionPattern(errorText, sentence).isSuppressed();
    }

    @ApiStatus.Experimental
    @Nullable
    public final String findSentence(@NotNull TextProblem problem) {
        Object v2;
        block5: {
            Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
            Iterable iterable = this.getSentences();
            for (Object t : iterable) {
                boolean bl;
                block4: {
                    Tokenizer.Token sentence = (Tokenizer.Token)t;
                    boolean bl2 = false;
                    List<com.intellij.openapi.util.TextRange> list = problem.getHighlightRanges();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getHighlightRanges(...)");
                    Iterable $this$any$iv = list;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            com.intellij.openapi.util.TextRange range = (com.intellij.openapi.util.TextRange)element$iv;
                            boolean bl3 = false;
                            if (!range.intersectsStrict(sentence.getRange().getFirst(), sentence.getRange().getLast())) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                v2 = t;
                break block5;
            }
            v2 = null;
        }
        Tokenizer.Token token = v2;
        return token != null ? token.getToken() : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LocalQuickFix[] toFixes(@NotNull TextProblem problem, @NotNull ProblemDescriptor descriptor) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiFile psiFile = this.text.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        PsiFile file = psiFile;
        ArrayList<Object> result = new ArrayList<Object>();
        SmartPointerManager spm = SmartPointerManager.getInstance((Project)file.getProject());
        Iterable $this$map$iv = this.fileHighlightRanges(problem);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            com.intellij.openapi.util.TextRange textRange = (com.intellij.openapi.util.TextRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(spm.createSmartPsiFileRangePointer(file, (com.intellij.openapi.util.TextRange)it));
        }
        List underline = (List)destination$iv$iv;
        List<TextProblem.Suggestion> list = problem.getSuggestions();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getSuggestions(...)");
        if (!((Collection)list).isEmpty()) {
            GrazieFUSCounter.INSTANCE.typoFound(problem);
            result.addAll((Collection)GrazieReplaceTypoQuickFix.getReplacementFixes(problem, underline));
        }
        List<LocalQuickFix> list2 = problem.getCustomFixes();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getCustomFixes(...)");
        Iterable $this$forEachIndexed$iv = list2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void fix;
            int n;
            Object item$iv$iv;
            if ((n = index$iv++) < 0) {
                kotlin.collections.CollectionsKt.throwIndexOverflow();
            }
            item$iv$iv = (LocalQuickFix)item$iv;
            int index = n;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)fix);
            result.add(new GrazieCustomFixWrapper(problem, (LocalQuickFix)fix, descriptor, index));
        }
        SuppressionPattern suppressionPattern = this.defaultSuppressionPattern(problem, this.findSentence(problem));
        result.add(new GrazieAddExceptionQuickFix(suppressionPattern, underline, problem){
            final /* synthetic */ TextProblem $problem;
            {
                this.$problem = $problem;
                super($suppressionPattern, $underline);
            }

            public void applyFix(Project project, PsiFile psiFile, Editor editor) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
                GrazieFUSCounter.INSTANCE.exceptionAdded(project, new AcceptanceRateTracker(this.$problem));
                super.applyFix(project, psiFile, editor);
            }
        });
        Rule rule = problem.getRule();
        Intrinsics.checkNotNullExpressionValue((Object)rule, (String)"getRule(...)");
        TextContent textContent = problem.getText();
        Intrinsics.checkNotNullExpressionValue((Object)textContent, (String)"getText(...)");
        result.add(new GrazieRuleSettingsAction(rule, TextUtilsKt.getTextDomain(textContent)));
        result.add((Object)new GrazieEnableCloudAction());
        Collection $this$toTypedArray$iv = result;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new LocalQuickFix[0]);
    }

    private final List<com.intellij.openapi.util.TextRange> fileHighlightRanges(TextProblem problem) {
        List<com.intellij.openapi.util.TextRange> list = problem.getHighlightRanges();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getHighlightRanges(...)");
        return SequencesKt.toList((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.map((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)list), arg_0 -> CheckerRunner.fileHighlightRanges$lambda$0(this, arg_0)), arg_0 -> CheckerRunner.fileHighlightRanges$lambda$1(this, arg_0)), CheckerRunner::fileHighlightRanges$lambda$2));
    }

    @ApiStatus.Experimental
    @NotNull
    public final SuppressionPattern defaultSuppressionPattern(@NotNull TextProblem problem, @Nullable String sentenceText) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        TextContent textContent = problem.getText();
        Intrinsics.checkNotNullExpressionValue((Object)textContent, (String)"getText(...)");
        TextContent text = textContent;
        com.intellij.openapi.util.TextRange patternRange = problem.getPatternRange();
        if (patternRange != null) {
            CharSequence charSequence = patternRange.subSequence((CharSequence)text);
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"subSequence(...)");
            return new SuppressionPattern(charSequence, null);
        }
        CharSequence charSequence = this.highlightSpan(problem).subSequence((CharSequence)text);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"subSequence(...)");
        return new SuppressionPattern(charSequence, sentenceText);
    }

    private final com.intellij.openapi.util.TextRange highlightSpan(TextProblem problem) {
        int n = problem.getHighlightRanges().get(0).getStartOffset();
        List<com.intellij.openapi.util.TextRange> list = problem.getHighlightRanges();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getHighlightRanges(...)");
        return new com.intellij.openapi.util.TextRange(n, ((com.intellij.openapi.util.TextRange)kotlin.collections.CollectionsKt.last(list)).getEndOffset());
    }

    private static final List sentences_delegate$lambda$0(CheckerRunner this$0) {
        return this$0.tokenize(this$0.text);
    }

    private static final String toProblemDescriptors$lambda$0$0(String $shortName) {
        return $shortName;
    }

    private static final Iterable ignoredRules$lambda$0(com.intellij.openapi.util.TextRange it) {
        return (Iterable)RangesKt.until((int)it.getStartOffset(), (int)it.getEndOffset());
    }

    private static final PsiElement ignoredRules$lambda$1(CheckerRunner this$0, int it) {
        return this$0.text.findPsiElementAt(it);
    }

    private static final com.intellij.openapi.util.TextRange fileHighlightRanges$lambda$0(CheckerRunner this$0, com.intellij.openapi.util.TextRange it) {
        return this$0.text.textRangeToFile(it);
    }

    private static final Iterable fileHighlightRanges$lambda$1(CheckerRunner this$0, com.intellij.openapi.util.TextRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        List<com.intellij.openapi.util.TextRange> list = this$0.text.intersection(range);
        Intrinsics.checkNotNullExpressionValue(list, (String)"intersection(...)");
        return list;
    }

    private static final boolean fileHighlightRanges$lambda$2(com.intellij.openapi.util.TextRange it) {
        return it.isEmpty();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0001\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0013\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0014\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lcom/intellij/grazie/text/CheckerRunner$GrazieProblemDescriptor;", "Lcom/intellij/codeInspection/ProblemDescriptorBase;", "psi", "Lcom/intellij/psi/PsiElement;", "descriptionTemplate", "", "rangeInElement", "Lcom/intellij/openapi/util/TextRange;", "onTheFly", "", "tooltip", "<init>", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;Lcom/intellij/openapi/util/TextRange;ZLjava/lang/String;)V", "quickFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "getQuickFixes", "()[Lcom/intellij/codeInspection/LocalQuickFix;", "setQuickFixes", "([Lcom/intellij/codeInspection/LocalQuickFix;)V", "[Lcom/intellij/codeInspection/LocalQuickFix;", "getFixes", "intellij.grazie.core"})
    private static final class GrazieProblemDescriptor
    extends ProblemDescriptorBase {
        @NotNull
        private final String tooltip;
        @NotNull
        private LocalQuickFix[] quickFixes;

        public GrazieProblemDescriptor(@NotNull PsiElement psi, @InspectionMessage @NotNull String descriptionTemplate, @Nullable com.intellij.openapi.util.TextRange rangeInElement, boolean onTheFly, @NlsContexts.Tooltip @NotNull String tooltip) {
            Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
            Intrinsics.checkNotNullParameter((Object)descriptionTemplate, (String)"descriptionTemplate");
            Intrinsics.checkNotNullParameter((Object)tooltip, (String)"tooltip");
            super(psi, psi, descriptionTemplate, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, rangeInElement, true, onTheFly, tooltip);
            this.tooltip = tooltip;
            Intrinsics.checkNotNullExpressionValue((Object)LocalQuickFix.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            this.quickFixes = LocalQuickFix.EMPTY_ARRAY;
        }

        @NotNull
        public final LocalQuickFix[] getQuickFixes() {
            return this.quickFixes;
        }

        public final void setQuickFixes(@NotNull LocalQuickFix[] localQuickFixArray) {
            Intrinsics.checkNotNullParameter((Object)localQuickFixArray, (String)"<set-?>");
            this.quickFixes = localQuickFixArray;
        }

        @NotNull
        public LocalQuickFix[] getFixes() {
            return this.quickFixes;
        }
    }
}

