/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grid.charts.impl;

import com.intellij.charts.core.ChartPage;
import com.intellij.charts.settings.SeriesSettingsPanel;
import com.intellij.database.run.ui.table.TableResultView;
import com.intellij.database.run.ui.table.statisticsPanel.HistogramSettings;
import com.intellij.database.run.ui.table.statisticsPanel.HtmlSettings;
import com.intellij.database.run.ui.table.statisticsPanel.types.ColumnVisualizationDataAxisXLabels;
import com.intellij.database.run.ui.table.statisticsPanel.types.ColumnVisualizationDataTooltip;
import com.intellij.database.run.ui.table.statisticsPanel.types.HistogramData;
import com.intellij.database.run.ui.table.statisticsPanel.types.StatisticsDescriptionUnit;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBFont;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.html.ApiKt;
import kotlinx.html.BODY;
import kotlinx.html.CoreAttributeGroupFacade;
import kotlinx.html.FlowContent;
import kotlinx.html.Gen_attr_traitsKt;
import kotlinx.html.HTML;
import kotlinx.html.TABLE;
import kotlinx.html.TD;
import kotlinx.html.TR;
import kotlinx.html.Tag;
import kotlinx.html.TagConsumer;
import kotlinx.html.stream.StreamKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.GgplotKt;
import org.jetbrains.letsPlot.coord.CoordKt;
import org.jetbrains.letsPlot.geom.geomBar;
import org.jetbrains.letsPlot.geom.geomText;
import org.jetbrains.letsPlot.intern.Feature;
import org.jetbrains.letsPlot.intern.OptionsMap;
import org.jetbrains.letsPlot.intern.Plot;
import org.jetbrains.letsPlot.intern.ToSpecConvertersKt;
import org.jetbrains.letsPlot.intern.layer.SamplingOptions;
import org.jetbrains.letsPlot.intern.layer.geom.BarMapping;
import org.jetbrains.letsPlot.sampling.SamplingKt;
import org.jetbrains.letsPlot.scale.LimsKt;
import org.jetbrains.letsPlot.themes.ThemeKt;
import org.jetbrains.letsPlot.themes.ThemeSetKt;
import org.jetbrains.letsPlot.themes.theme;
import org.jetbrains.letsPlot.tooltips.layerTooltips;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0005\u0018\u0000 12\u00020\u0001:\u00011B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J)\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0002\u001a\u00020\u001c2\u000b\u0010\u001d\u001a\u00070\u001e\u00a2\u0006\u0002\b\u001fJ\u001a\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001e2\b\b\u0001\u0010\"\u001a\u00020\u001eH\u0007J$\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(2\b\u0010)\u001a\u0004\u0018\u00010*J6\u0010+\u001a\u00020\u001e2\u001a\u0010,\u001a\u0016\u0012\u0004\u0012\u00020\u001e\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001a0-2\u0006\u0010.\u001a\u00020\u001e2\b\b\u0001\u0010/\u001a\u00020\u001eH\u0007J\u0016\u00100\u001a\u00020\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/grid/charts/impl/StatisticsPanelRenderer;", "", "table", "Ljavax/swing/JTable;", "component", "Ljavax/swing/JComponent;", "<init>", "(Ljavax/swing/JTable;Ljavax/swing/JComponent;)V", "originalTableFont", "Ljava/awt/Font;", "kotlin.jvm.PlatformType", "SCALE_FACTOR", "", "scaledTableFont", "originalIdeFont", "Lcom/intellij/util/ui/JBFont;", "Lorg/jetbrains/annotations/NotNull;", "scaledIdeFont", "ellipsisWidthFontIde", "", "maxWidthPanel", "maxWidthStatisticsNames", "maxWidthStatisticsValues", "composeStatisticsTableHtml", "", "columnStatistics", "", "Lcom/intellij/database/run/ui/table/statisticsPanel/types/StatisticsDescriptionUnit;", "Lkotlinx/html/TABLE;", "labelForMissingField", "", "Lcom/intellij/openapi/util/NlsSafe;", "createVisualizationUniqueValues", "numberOfUniqueValues", "messageForUnique", "createVisualizationHistogram", "Ljava/awt/Component;", "data", "Lcom/intellij/database/run/ui/table/statisticsPanel/types/HistogramData;", "tooltips", "Lorg/jetbrains/letsPlot/tooltips/layerTooltips;", "axisXLabels", "Lcom/intellij/database/run/ui/table/statisticsPanel/types/ColumnVisualizationDataAxisXLabels;", "createVisualizationPercentage", "rows", "", "keywordForOthers", "messageForOthers", "computeMaxStatValueWidth", "Companion", "intellij.grid.charts.impl"})
@SourceDebugExtension(value={"SMAP\nStatisticsPanelRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatisticsPanelRenderer.kt\ncom/intellij/grid/charts/impl/StatisticsPanelRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 gen-tags-t.kt\nkotlinx/html/Gen_tags_tKt\n+ 4 api.kt\nkotlinx/html/ApiKt\n+ 5 visit.kt\nkotlinx/html/VisitKt\n+ 6 gen-consumer-tags.kt\nkotlinx/html/Gen_consumer_tagsKt\n+ 7 gen-tags-h.kt\nkotlinx/html/Gen_tags_hKt\n+ 8 gen-tag-groups.kt\nkotlinx/html/Gen_tag_groupsKt\n+ 9 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 10 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,302:1\n1869#2:303\n1870#2:337\n1878#2,2:462\n1880#2:497\n1869#2,2:514\n76#3,5:304\n301#3,5:312\n306#3:322\n301#3,5:323\n306#3:333\n81#3:336\n76#3,5:369\n301#3,5:377\n306#3:387\n81#3:390\n76#3,5:391\n301#3,5:399\n306#3:409\n81#3:412\n76#3,5:464\n301#3,5:472\n306#3:482\n301#3,5:483\n306#3:493\n81#3:496\n76#4:309\n76#4:317\n76#4:328\n79#4:345\n76#4:358\n76#4:366\n76#4:374\n76#4:382\n76#4:396\n76#4:404\n79#4:436\n76#4:449\n76#4:457\n76#4:469\n76#4:477\n76#4:488\n4#5,2:310\n4#5,4:318\n4#5,4:329\n6#5,2:334\n10#5,5:346\n4#5,2:351\n4#5,2:359\n4#5,2:367\n4#5,2:375\n4#5,4:383\n6#5,2:388\n4#5,2:397\n4#5,4:405\n6#5,2:410\n6#5,2:413\n6#5,2:416\n6#5,10:419\n10#5,5:437\n4#5,2:442\n4#5,2:450\n4#5,2:458\n4#5,2:470\n4#5,4:478\n4#5,4:489\n6#5,2:494\n6#5,2:498\n6#5,2:501\n6#5,10:504\n782#6,7:338\n782#6,7:429\n200#7,5:353\n205#7:418\n200#7,5:444\n205#7:503\n229#8,5:361\n234#8:415\n229#8,5:452\n234#8:500\n651#9:460\n1#10:461\n*S KotlinDebug\n*F\n+ 1 StatisticsPanelRenderer.kt\ncom/intellij/grid/charts/impl/StatisticsPanelRenderer\n*L\n67#1:303\n67#1:337\n168#1:462,2\n168#1:497\n201#1:514,2\n71#1:304,5\n72#1:312,5\n72#1:322\n77#1:323,5\n77#1:333\n71#1:336\n104#1:369,5\n105#1:377,5\n105#1:387\n104#1:390\n111#1:391,5\n112#1:399,5\n112#1:409\n111#1:412\n181#1:464,5\n182#1:472,5\n182#1:482\n187#1:483,5\n187#1:493\n181#1:496\n71#1:309\n72#1:317\n77#1:328\n101#1:345\n102#1:358\n103#1:366\n104#1:374\n105#1:382\n111#1:396\n112#1:404\n165#1:436\n166#1:449\n167#1:457\n181#1:469\n182#1:477\n187#1:488\n71#1:310,2\n72#1:318,4\n77#1:329,4\n71#1:334,2\n101#1:346,5\n101#1:351,2\n102#1:359,2\n103#1:367,2\n104#1:375,2\n105#1:383,4\n104#1:388,2\n111#1:397,2\n112#1:405,4\n111#1:410,2\n103#1:413,2\n102#1:416,2\n101#1:419,10\n165#1:437,5\n165#1:442,2\n166#1:450,2\n167#1:458,2\n181#1:470,2\n182#1:478,4\n187#1:489,4\n181#1:494,2\n167#1:498,2\n166#1:501,2\n165#1:504,10\n101#1:338,7\n165#1:429,7\n102#1:353,5\n102#1:418\n166#1:444,5\n166#1:503\n103#1:361,5\n103#1:415\n167#1:452,5\n167#1:500\n168#1:460\n168#1:461\n*E\n"})
public final class StatisticsPanelRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JTable table;
    @NotNull
    private final JComponent component;
    private final Font originalTableFont;
    private final double SCALE_FACTOR;
    @NotNull
    private final Font scaledTableFont;
    @NotNull
    private final JBFont originalIdeFont;
    @NotNull
    private final Font scaledIdeFont;
    private final int ellipsisWidthFontIde;
    private final int maxWidthPanel;
    private final int maxWidthStatisticsNames;
    private final int maxWidthStatisticsValues;

    public StatisticsPanelRenderer(@NotNull JTable table, @NotNull JComponent component) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.table = table;
        this.component = component;
        this.originalTableFont = this.table.getFont();
        this.SCALE_FACTOR = 0.9;
        this.scaledTableFont = new Font(this.originalTableFont.getName(), this.originalTableFont.getStyle(), (int)((double)this.originalTableFont.getSize() * this.SCALE_FACTOR));
        JBFont jBFont = JBFont.label();
        Intrinsics.checkNotNullExpressionValue((Object)jBFont, (String)"label(...)");
        this.originalIdeFont = jBFont;
        this.scaledIdeFont = new Font(this.originalIdeFont.getName(), this.originalIdeFont.getStyle(), (int)((double)this.originalIdeFont.getSize() * this.SCALE_FACTOR));
        this.ellipsisWidthFontIde = this.component.getFontMetrics(this.scaledIdeFont).stringWidth("\u2026");
        this.maxWidthPanel = 200 - this.ellipsisWidthFontIde - 13;
        this.maxWidthStatisticsNames = 50;
        this.maxWidthStatisticsValues = this.maxWidthPanel - this.maxWidthStatisticsNames;
    }

    public final void composeStatisticsTableHtml(@NotNull List<StatisticsDescriptionUnit> columnStatistics, @NotNull TABLE table, @NotNull String labelForMissingField) {
        Intrinsics.checkNotNullParameter(columnStatistics, (String)"columnStatistics");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)labelForMissingField, (String)"labelForMissingField");
        int maxStatValueWidth = 0;
        maxStatValueWidth = Math.min(this.maxWidthStatisticsValues, this.computeMaxStatValueWidth(columnStatistics));
        int ellipsisWidthForValues = this.component.getFontMetrics(this.scaledTableFont).stringWidth("\u2026");
        int curMaxWidthStatNames = this.maxWidthPanel - (maxStatValueWidth += ellipsisWidthForValues);
        String commonStyle = "margin: 0; padding: 0; border-collapse: collapse;";
        String styleStatisticsName = commonStyle + "text-align: left;" + HtmlSettings.INSTANCE.getCOLOR_GRAY() + "width: " + (curMaxWidthStatNames + this.ellipsisWidthFontIde) + "px;font-size: " + this.scaledIdeFont.getSize() + "};";
        String styleStatisticsValue = commonStyle + "text-align: right;width: " + maxStatValueWidth + "px;font-family: " + this.scaledTableFont.getName() + ";font-size: " + this.scaledTableFont.getSize() + ";";
        Iterable $this$forEach$iv = columnStatistics;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StatisticsDescriptionUnit it = (StatisticsDescriptionUnit)element$iv;
            boolean bl = false;
            String shortenStatisticsName = StatisticsPanelRenderer.Companion.makeShortenedText(it.getStatisticsName(), curMaxWidthStatNames, this.scaledIdeFont, this.component);
            String shortenStatisticsValue = StatisticsPanelRenderer.Companion.makeShortenedText(it.getStatisticsValue(), maxStatValueWidth - ellipsisWidthForValues, this.scaledTableFont, this.component);
            TABLE $this$tr_u24default$iv = table;
            String classes$iv = null;
            boolean $i$f$tr = false;
            Tag $this$visit$iv$iv = (Tag)new TR(ApiKt.attributesMapOf((String)"class", classes$iv), $this$tr_u24default$iv.getConsumer());
            boolean $i$f$visit = false;
            Tag $this$visitTag$iv$iv$iv = $this$visit$iv$iv;
            boolean $i$f$visitTag = false;
            $this$visitTag$iv$iv$iv.getConsumer().onTagStart($this$visitTag$iv$iv$iv);
            Tag $this$visit_u24lambda_u240$iv$iv = $this$visitTag$iv$iv$iv;
            boolean bl2 = false;
            TR $this$composeStatisticsTableHtml_u24lambda_u240_u240 = (TR)$this$visit_u24lambda_u240$iv$iv;
            boolean bl3 = false;
            TR $this$td_u24default$iv = $this$composeStatisticsTableHtml_u24lambda_u240_u240;
            String classes$iv2 = null;
            boolean $i$f$td = false;
            Tag $this$visit$iv$iv2 = (Tag)new TD(ApiKt.attributesMapOf((String)"class", classes$iv2), $this$td_u24default$iv.getConsumer());
            boolean $i$f$visit2 = false;
            Tag $this$visitTag$iv$iv$iv2 = $this$visit$iv$iv2;
            boolean $i$f$visitTag2 = false;
            $this$visitTag$iv$iv$iv2.getConsumer().onTagStart($this$visitTag$iv$iv$iv2);
            Tag $this$visit_u24lambda_u240$iv$iv2 = $this$visitTag$iv$iv$iv2;
            $i$a$-visitTag-ApiKt$visit$1$iv$iv = false;
            TD $this$composeStatisticsTableHtml_u24lambda_u240_u240_u240 = (TD)$this$visit_u24lambda_u240$iv$iv2;
            boolean bl4 = false;
            ((Map)$this$composeStatisticsTableHtml_u24lambda_u240_u240_u240.getAttributes()).put("valign", "top");
            Gen_attr_traitsKt.setStyle((CoreAttributeGroupFacade)((CoreAttributeGroupFacade)$this$composeStatisticsTableHtml_u24lambda_u240_u240_u240), (String)styleStatisticsName);
            $this$composeStatisticsTableHtml_u24lambda_u240_u240_u240.unaryPlus(shortenStatisticsName);
            $this$visitTag$iv$iv$iv2.getConsumer().onTagEnd($this$visitTag$iv$iv$iv2);
            $this$td_u24default$iv = $this$composeStatisticsTableHtml_u24lambda_u240_u240;
            classes$iv2 = null;
            $i$f$td = false;
            $this$visit$iv$iv2 = (Tag)new TD(ApiKt.attributesMapOf((String)"class", classes$iv2), $this$td_u24default$iv.getConsumer());
            $i$f$visit2 = false;
            $this$visitTag$iv$iv$iv2 = $this$visit$iv$iv2;
            $i$f$visitTag2 = false;
            $this$visitTag$iv$iv$iv2.getConsumer().onTagStart($this$visitTag$iv$iv$iv2);
            $this$visit_u24lambda_u240$iv$iv2 = $this$visitTag$iv$iv$iv2;
            $i$a$-visitTag-ApiKt$visit$1$iv$iv = false;
            TD $this$composeStatisticsTableHtml_u24lambda_u240_u240_u241 = (TD)$this$visit_u24lambda_u240$iv$iv2;
            boolean bl5 = false;
            Gen_attr_traitsKt.setStyle((CoreAttributeGroupFacade)((CoreAttributeGroupFacade)$this$composeStatisticsTableHtml_u24lambda_u240_u240_u241), (String)styleStatisticsValue);
            if (Intrinsics.areEqual((Object)it.getStatisticsName(), (Object)labelForMissingField) && !Intrinsics.areEqual((Object)it.getStatisticsValue(), (Object)"0")) {
                Gen_attr_traitsKt.setStyle((CoreAttributeGroupFacade)((CoreAttributeGroupFacade)$this$composeStatisticsTableHtml_u24lambda_u240_u240_u241), (String)(Gen_attr_traitsKt.getStyle((CoreAttributeGroupFacade)((CoreAttributeGroupFacade)$this$composeStatisticsTableHtml_u24lambda_u240_u240_u241)) + HtmlSettings.INSTANCE.getCOLOR_RED()));
            }
            $this$composeStatisticsTableHtml_u24lambda_u240_u240_u241.unaryPlus(shortenStatisticsValue);
            $this$visitTag$iv$iv$iv2.getConsumer().onTagEnd($this$visitTag$iv$iv$iv2);
            $this$visitTag$iv$iv$iv.getConsumer().onTagEnd($this$visitTag$iv$iv$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NlsSafe
    @NotNull
    public final String createVisualizationUniqueValues(@NotNull String numberOfUniqueValues, @NlsSafe @NotNull String messageForUnique) {
        void $this$visitAndFinalize$iv$iv;
        Intrinsics.checkNotNullParameter((Object)numberOfUniqueValues, (String)"numberOfUniqueValues");
        Intrinsics.checkNotNullParameter((Object)messageForUnique, (String)"messageForUnique");
        String commonStyle = "text-align: center;width: " + this.maxWidthPanel + "px; margin: 0; padding: 0; border-collapse: collapse;";
        TagConsumer $this$html_u24default$iv = StreamKt.createHTML$default((boolean)false, (boolean)false, (int)3, null);
        String namespace$iv = null;
        boolean $i$f$html = false;
        Tag tag = (Tag)new HTML(ApiKt.getEmptyMap(), $this$html_u24default$iv, namespace$iv);
        boolean $i$f$visitAndFinalize = false;
        void $this$visitTagAndFinalize$iv$iv$iv = $this$visitAndFinalize$iv$iv;
        boolean $i$f$visitTagAndFinalize = false;
        if ($this$visitTagAndFinalize$iv$iv$iv.getConsumer() != $this$html_u24default$iv) {
            throw new IllegalArgumentException("Wrong exception");
        }
        void $this$visitTag$iv$iv$iv$iv = $this$visitTagAndFinalize$iv$iv$iv;
        boolean $i$f$visitTag = false;
        $this$visitTag$iv$iv$iv$iv.getConsumer().onTagStart((Tag)$this$visitTag$iv$iv$iv$iv);
        void $this$visitAndFinalize_u24lambda_u241$iv$iv = $this$visitTag$iv$iv$iv$iv;
        boolean bl = false;
        HTML $this$createVisualizationUniqueValues_u24lambda_u240 = (HTML)$this$visitAndFinalize_u24lambda_u241$iv$iv;
        boolean bl2 = false;
        HTML $this$body_u24default$iv = $this$createVisualizationUniqueValues_u24lambda_u240;
        String classes$iv = null;
        boolean $i$f$body = false;
        Tag $this$visit$iv$iv = (Tag)new BODY(ApiKt.attributesMapOf((String)"class", classes$iv), $this$body_u24default$iv.getConsumer());
        boolean $i$f$visit = false;
        Tag $this$visitTag$iv$iv$iv = $this$visit$iv$iv;
        boolean $i$f$visitTag2 = false;
        $this$visitTag$iv$iv$iv.getConsumer().onTagStart($this$visitTag$iv$iv$iv);
        Tag $this$visit_u24lambda_u240$iv$iv = $this$visitTag$iv$iv$iv;
        boolean bl3 = false;
        BODY $this$createVisualizationUniqueValues_u24lambda_u240_u240 = (BODY)$this$visit_u24lambda_u240$iv$iv;
        boolean bl4 = false;
        FlowContent $this$table_u24default$iv = (FlowContent)$this$createVisualizationUniqueValues_u24lambda_u240_u240;
        String classes$iv2 = null;
        boolean $i$f$table = false;
        Tag $this$visit$iv$iv2 = (Tag)new TABLE(ApiKt.attributesMapOf((String)"class", classes$iv2), $this$table_u24default$iv.getConsumer());
        boolean $i$f$visit2 = false;
        Tag $this$visitTag$iv$iv$iv2 = $this$visit$iv$iv2;
        boolean $i$f$visitTag3 = false;
        $this$visitTag$iv$iv$iv2.getConsumer().onTagStart($this$visitTag$iv$iv$iv2);
        Tag $this$visit_u24lambda_u240$iv$iv2 = $this$visitTag$iv$iv$iv2;
        $i$a$-visitTag-ApiKt$visit$1$iv$iv = false;
        TABLE $this$createVisualizationUniqueValues_u24lambda_u240_u240_u240 = (TABLE)$this$visit_u24lambda_u240$iv$iv2;
        boolean bl5 = false;
        TABLE $this$tr_u24default$iv = $this$createVisualizationUniqueValues_u24lambda_u240_u240_u240;
        String classes$iv3 = null;
        boolean $i$f$tr = false;
        Tag $this$visit$iv$iv3 = (Tag)new TR(ApiKt.attributesMapOf((String)"class", classes$iv3), $this$tr_u24default$iv.getConsumer());
        boolean $i$f$visit3 = false;
        Tag $this$visitTag$iv$iv$iv3 = $this$visit$iv$iv3;
        boolean $i$f$visitTag4 = false;
        $this$visitTag$iv$iv$iv3.getConsumer().onTagStart($this$visitTag$iv$iv$iv3);
        Tag $this$visit_u24lambda_u240$iv$iv3 = $this$visitTag$iv$iv$iv3;
        $i$a$-visitTag-ApiKt$visit$1$iv$iv = false;
        TR $this$createVisualizationUniqueValues_u24lambda_u240_u240_u240_u240 = (TR)$this$visit_u24lambda_u240$iv$iv3;
        boolean bl6 = false;
        TR $this$td_u24default$iv = $this$createVisualizationUniqueValues_u24lambda_u240_u240_u240_u240;
        String classes$iv4 = null;
        boolean $i$f$td = false;
        Tag $this$visit$iv$iv4 = (Tag)new TD(ApiKt.attributesMapOf((String)"class", classes$iv4), $this$td_u24default$iv.getConsumer());
        boolean $i$f$visit4 = false;
        Tag $this$visitTag$iv$iv$iv4 = $this$visit$iv$iv4;
        boolean $i$f$visitTag5 = false;
        $this$visitTag$iv$iv$iv4.getConsumer().onTagStart($this$visitTag$iv$iv$iv4);
        Tag $this$visit_u24lambda_u240$iv$iv4 = $this$visitTag$iv$iv$iv4;
        $i$a$-visitTag-ApiKt$visit$1$iv$iv = false;
        TD $this$createVisualizationUniqueValues_u24lambda_u240_u240_u240_u240_u240 = (TD)$this$visit_u24lambda_u240$iv$iv4;
        boolean bl7 = false;
        ((Map)$this$createVisualizationUniqueValues_u24lambda_u240_u240_u240_u240_u240.getAttributes()).put("valign", "top");
        Gen_attr_traitsKt.setStyle((CoreAttributeGroupFacade)((CoreAttributeGroupFacade)$this$createVisualizationUniqueValues_u24lambda_u240_u240_u240_u240_u240), (String)(HtmlSettings.INSTANCE.getCOLOR_BAR_FILL_COLOR() + commonStyle + "font-size: " + (double)this.originalTableFont.getSize() * 1.5 + "px"));
        $this$createVisualizationUniqueValues_u24lambda_u240_u240_u240_u240_u240.unaryPlus(numberOfUniqueValues);
        $this$visitTag$iv$iv$iv4.getConsumer().onTagEnd($this$visitTag$iv$iv$iv4);
        $this$visitTag$iv$iv$iv3.getConsumer().onTagEnd($this$visitTag$iv$iv$iv3);
        $this$tr_u24default$iv = $this$createVisualizationUniqueValues_u24lambda_u240_u240_u240;
        classes$iv3 = null;
        $i$f$tr = false;
        $this$visit$iv$iv3 = (Tag)new TR(ApiKt.attributesMapOf((String)"class", classes$iv3), $this$tr_u24default$iv.getConsumer());
        $i$f$visit3 = false;
        $this$visitTag$iv$iv$iv3 = $this$visit$iv$iv3;
        $i$f$visitTag4 = false;
        $this$visitTag$iv$iv$iv3.getConsumer().onTagStart($this$visitTag$iv$iv$iv3);
        $this$visit_u24lambda_u240$iv$iv3 = $this$visitTag$iv$iv$iv3;
        $i$a$-visitTag-ApiKt$visit$1$iv$iv = false;
        TR $this$createVisualizationUniqueValues_u24lambda_u240_u240_u240_u241 = (TR)$this$visit_u24lambda_u240$iv$iv3;
        boolean bl8 = false;
        $this$td_u24default$iv = $this$createVisualizationUniqueValues_u24lambda_u240_u240_u240_u241;
        classes$iv4 = null;
        $i$f$td = false;
        $this$visit$iv$iv4 = (Tag)new TD(ApiKt.attributesMapOf((String)"class", classes$iv4), $this$td_u24default$iv.getConsumer());
        $i$f$visit4 = false;
        $this$visitTag$iv$iv$iv4 = $this$visit$iv$iv4;
        $i$f$visitTag5 = false;
        $this$visitTag$iv$iv$iv4.getConsumer().onTagStart($this$visitTag$iv$iv$iv4);
        $this$visit_u24lambda_u240$iv$iv4 = $this$visitTag$iv$iv$iv4;
        $i$a$-visitTag-ApiKt$visit$1$iv$iv = false;
        TD $this$createVisualizationUniqueValues_u24lambda_u240_u240_u240_u241_u240 = (TD)$this$visit_u24lambda_u240$iv$iv4;
        boolean bl9 = false;
        ((Map)$this$createVisualizationUniqueValues_u24lambda_u240_u240_u240_u241_u240.getAttributes()).put("valign", "top");
        Gen_attr_traitsKt.setStyle((CoreAttributeGroupFacade)((CoreAttributeGroupFacade)$this$createVisualizationUniqueValues_u24lambda_u240_u240_u240_u241_u240), (String)(HtmlSettings.INSTANCE.getCOLOR_GRAY() + commonStyle));
        $this$createVisualizationUniqueValues_u24lambda_u240_u240_u240_u241_u240.unaryPlus(messageForUnique);
        $this$visitTag$iv$iv$iv4.getConsumer().onTagEnd($this$visitTag$iv$iv$iv4);
        $this$visitTag$iv$iv$iv3.getConsumer().onTagEnd($this$visitTag$iv$iv$iv3);
        $this$visitTag$iv$iv$iv2.getConsumer().onTagEnd($this$visitTag$iv$iv$iv2);
        $this$visitTag$iv$iv$iv.getConsumer().onTagEnd($this$visitTag$iv$iv$iv);
        $this$visitTag$iv$iv$iv$iv.getConsumer().onTagEnd((Tag)$this$visitTag$iv$iv$iv$iv);
        return (String)$this$html_u24default$iv.finalize();
    }

    @Nullable
    public final Component createVisualizationHistogram(@NotNull HistogramData data, @Nullable layerTooltips tooltips, @Nullable ColumnVisualizationDataAxisXLabels axisXLabels) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ChartPage letsPlot = new ChartPage(null, SeriesSettingsPanel.Mode.WITH_COLUMNS_LIST, 1, null);
        OptionsMap optionsMap = ThemeSetKt.themeClassic();
        JTable jTable = this.table;
        Intrinsics.checkNotNull((Object)jTable, (String)"null cannot be cast to non-null type com.intellij.database.run.ui.table.TableResultView");
        JBColor jBColor = HistogramSettings.INSTANCE.getTOOLTIP_BACKGROUND();
        Feature histogramTheme = optionsMap.plus((Feature)new theme(null, null, null, null, null, (Object)"blank", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"fill", (Object)((TableResultView)jTable).getBackground())), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, (Object)ThemeKt.elementRect$default((Object)HistogramSettings.INSTANCE.getTOOLTIP_BACKGROUND(), (Object)jBColor, (Number)2, null, (boolean)false, (int)24, null), (Object)ThemeKt.elementText$default((Object)HistogramSettings.INSTANCE.getTOOLTIP_FOREGROUND(), null, null, null, null, null, null, null, (boolean)false, (int)510, null), null, null, null, -33, -67108865, 0x39FFFFF, null));
        int numberOfHistogramBars = data.getXLabel().size();
        Plot processedSpec = GgplotKt.letsPlot$default(null, null, (int)3, null).plus(LimsKt.ylim((Object)TuplesKt.to((Object)-0.2, (Object)1)));
        Map map = data.toMap();
        SamplingOptions samplingOptions = SamplingKt.getSamplingNone();
        Color color = ((TableResultView)this.table).getBackground();
        JBColor jBColor2 = HistogramSettings.INSTANCE.getBAR_FILL_COLOR();
        processedSpec = processedSpec.plus(new geomBar(map, null, null, false, null, null, samplingOptions, tooltips, null, null, null, null, null, (Object)color, (Object)jBColor2, (Number)1.0, null, null, null, null, StatisticsPanelRenderer::createVisualizationHistogram$lambda$0, 991038, null).plus(histogramTheme).plus((Feature)CoordKt.coordCartesian$default((Pair)new Pair((Object)-0.5, (Object)((double)numberOfHistogramBars - 0.5)), null, (boolean)false, (int)6, null)));
        if (axisXLabels != null) {
            processedSpec = processedSpec.plus((Feature)StatisticsPanelRenderer.Companion.makeGeomText(axisXLabels.getXCoordLeft(), axisXLabels.getLeftValue(), axisXLabels.getHjustLeft(), this.scaledTableFont));
            processedSpec = processedSpec.plus((Feature)StatisticsPanelRenderer.Companion.makeGeomText(axisXLabels.getXCoordRight(), axisXLabels.getRightValue(), axisXLabels.getHjustRight(), this.scaledTableFont));
        }
        return (Component)letsPlot.createPlot(ToSpecConvertersKt.toSpec((Plot)processedSpec));
    }

    /*
     * WARNING - void declaration
     */
    @NlsSafe
    @NotNull
    public final String createVisualizationPercentage(@NotNull Map<String, ? extends List<String>> rows, @NotNull String keywordForOthers, @NlsSafe @NotNull String messageForOthers) {
        Map<String, ? extends List<String>> map;
        void $this$visitAndFinalize$iv$iv;
        Intrinsics.checkNotNullParameter(rows, (String)"rows");
        Intrinsics.checkNotNullParameter((Object)keywordForOthers, (String)"keywordForOthers");
        Intrinsics.checkNotNullParameter((Object)messageForOthers, (String)"messageForOthers");
        int maxPercentageWidth = this.component.getFontMetrics(this.originalTableFont).stringWidth("99.9%");
        int maxValueNameWidth = this.maxWidthPanel - maxPercentageWidth - this.ellipsisWidthFontIde;
        Object[] objectArray = new String[]{"-1", "0"};
        List<String> list = rows.get(keywordForOthers);
        boolean toShowOtherValueName = !CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])objectArray), (Object)(list != null ? (String)CollectionsKt.first(list) : null));
        String commonStyle = "margin: 0; padding: 0; border-collapse: collapse;";
        String styleValuePercentage = commonStyle + "text-align: right;" + HtmlSettings.INSTANCE.getCOLOR_TOOLTIP_FOREGROUND() + "width: " + maxPercentageWidth + "px; font-family: " + this.originalTableFont.getName() + ";font-size: " + this.originalTableFont.getSize() + ";";
        String styleValueName = commonStyle + "text-align: left;width: " + (this.maxWidthPanel - maxPercentageWidth) + "px; font-family: " + this.scaledIdeFont.getName() + ";font-size: " + this.originalIdeFont.getSize() + ";";
        TagConsumer $this$html_u24default$iv = StreamKt.createHTML$default((boolean)false, (boolean)false, (int)3, null);
        String namespace$iv = null;
        boolean $i$f$html = false;
        Tag tag = (Tag)new HTML(ApiKt.getEmptyMap(), $this$html_u24default$iv, namespace$iv);
        boolean $i$f$visitAndFinalize = false;
        void $this$visitTagAndFinalize$iv$iv$iv = $this$visitAndFinalize$iv$iv;
        boolean $i$f$visitTagAndFinalize = false;
        if ($this$visitTagAndFinalize$iv$iv$iv.getConsumer() != $this$html_u24default$iv) {
            throw new IllegalArgumentException("Wrong exception");
        }
        void $this$visitTag$iv$iv$iv$iv = $this$visitTagAndFinalize$iv$iv$iv;
        boolean $i$f$visitTag = false;
        $this$visitTag$iv$iv$iv$iv.getConsumer().onTagStart((Tag)$this$visitTag$iv$iv$iv$iv);
        void $this$visitAndFinalize_u24lambda_u241$iv$iv = $this$visitTag$iv$iv$iv$iv;
        boolean bl = false;
        HTML $this$createVisualizationPercentage_u24lambda_u240 = (HTML)$this$visitAndFinalize_u24lambda_u241$iv$iv;
        boolean bl2 = false;
        HTML $this$body_u24default$iv = $this$createVisualizationPercentage_u24lambda_u240;
        String classes$iv = null;
        boolean $i$f$body = false;
        Tag $this$visit$iv$iv = (Tag)new BODY(ApiKt.attributesMapOf((String)"class", classes$iv), $this$body_u24default$iv.getConsumer());
        boolean $i$f$visit = false;
        Tag $this$visitTag$iv$iv$iv = $this$visit$iv$iv;
        boolean $i$f$visitTag2 = false;
        $this$visitTag$iv$iv$iv.getConsumer().onTagStart($this$visitTag$iv$iv$iv);
        Tag $this$visit_u24lambda_u240$iv$iv = $this$visitTag$iv$iv$iv;
        boolean bl3 = false;
        BODY $this$createVisualizationPercentage_u24lambda_u240_u240 = (BODY)$this$visit_u24lambda_u240$iv$iv;
        boolean bl4 = false;
        FlowContent $this$table_u24default$iv = (FlowContent)$this$createVisualizationPercentage_u24lambda_u240_u240;
        String classes$iv2 = null;
        boolean $i$f$table = false;
        Tag $this$visit$iv$iv2 = (Tag)new TABLE(ApiKt.attributesMapOf((String)"class", classes$iv2), $this$table_u24default$iv.getConsumer());
        boolean $i$f$visit2 = false;
        Tag $this$visitTag$iv$iv$iv2 = $this$visit$iv$iv2;
        boolean $i$f$visitTag3 = false;
        $this$visitTag$iv$iv$iv2.getConsumer().onTagStart($this$visitTag$iv$iv$iv2);
        Tag $this$visit_u24lambda_u240$iv$iv2 = $this$visitTag$iv$iv$iv2;
        $i$a$-visitTag-ApiKt$visit$1$iv$iv = false;
        TABLE $this$createVisualizationPercentage_u24lambda_u240_u240_u240 = (TABLE)$this$visit_u24lambda_u240$iv$iv2;
        boolean bl5 = false;
        Map<String, ? extends List<String>> $this$onEachIndexed$iv = rows;
        boolean $i$f$onEachIndexed = false;
        Map<String, ? extends List<String>> $this$onEachIndexed_u24lambda_u240$iv = map = $this$onEachIndexed$iv;
        boolean bl6 = false;
        Iterable $this$forEachIndexed$iv$iv = $this$onEachIndexed_u24lambda_u240$iv.entrySet();
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Map.Entry entry = (Map.Entry)item$iv$iv;
            int index = n;
            boolean bl7 = false;
            String valueName = (String)entry.getKey();
            List valuePercentage = (List)entry.getValue();
            String color = null;
            color = HtmlSettings.INSTANCE.getCOLOR_TOOLTIP_FOREGROUND();
            String valueNameToShow = valueName;
            if (index == rows.size() - 1 && !toShowOtherValueName) continue;
            if (index == rows.size() - 1) {
                color = HtmlSettings.INSTANCE.getCOLOR_GRAY();
                valueNameToShow = messageForOthers;
            }
            String shortenValueName = StatisticsPanelRenderer.Companion.makeShortenedText(valueNameToShow, maxValueNameWidth, this.scaledIdeFont, this.component);
            TABLE $this$tr_u24default$iv = $this$createVisualizationPercentage_u24lambda_u240_u240_u240;
            String classes$iv3 = null;
            boolean $i$f$tr = false;
            Tag $this$visit$iv$iv3 = (Tag)new TR(ApiKt.attributesMapOf((String)"class", classes$iv3), $this$tr_u24default$iv.getConsumer());
            boolean $i$f$visit3 = false;
            Tag $this$visitTag$iv$iv$iv3 = $this$visit$iv$iv3;
            boolean $i$f$visitTag4 = false;
            $this$visitTag$iv$iv$iv3.getConsumer().onTagStart($this$visitTag$iv$iv$iv3);
            Tag $this$visit_u24lambda_u240$iv$iv3 = $this$visitTag$iv$iv$iv3;
            $i$a$-visitTag-ApiKt$visit$1$iv$iv = false;
            TR $this$createVisualizationPercentage_u24lambda_u240_u240_u240_u240_u240 = (TR)$this$visit_u24lambda_u240$iv$iv3;
            boolean bl8 = false;
            TR $this$td_u24default$iv = $this$createVisualizationPercentage_u24lambda_u240_u240_u240_u240_u240;
            String classes$iv4 = null;
            boolean $i$f$td = false;
            Tag $this$visit$iv$iv4 = (Tag)new TD(ApiKt.attributesMapOf((String)"class", classes$iv4), $this$td_u24default$iv.getConsumer());
            boolean $i$f$visit4 = false;
            Tag $this$visitTag$iv$iv$iv4 = $this$visit$iv$iv4;
            boolean $i$f$visitTag5 = false;
            $this$visitTag$iv$iv$iv4.getConsumer().onTagStart($this$visitTag$iv$iv$iv4);
            Tag $this$visit_u24lambda_u240$iv$iv4 = $this$visitTag$iv$iv$iv4;
            $i$a$-visitTag-ApiKt$visit$1$iv$iv = false;
            TD $this$createVisualizationPercentage_u24lambda_u240_u240_u240_u240_u240_u240 = (TD)$this$visit_u24lambda_u240$iv$iv4;
            boolean bl9 = false;
            ((Map)$this$createVisualizationPercentage_u24lambda_u240_u240_u240_u240_u240_u240.getAttributes()).put("valign", "top");
            Gen_attr_traitsKt.setStyle((CoreAttributeGroupFacade)((CoreAttributeGroupFacade)$this$createVisualizationPercentage_u24lambda_u240_u240_u240_u240_u240_u240), (String)(styleValueName + color));
            $this$createVisualizationPercentage_u24lambda_u240_u240_u240_u240_u240_u240.unaryPlus(shortenValueName);
            $this$visitTag$iv$iv$iv4.getConsumer().onTagEnd($this$visitTag$iv$iv$iv4);
            $this$td_u24default$iv = $this$createVisualizationPercentage_u24lambda_u240_u240_u240_u240_u240;
            classes$iv4 = null;
            $i$f$td = false;
            $this$visit$iv$iv4 = (Tag)new TD(ApiKt.attributesMapOf((String)"class", classes$iv4), $this$td_u24default$iv.getConsumer());
            $i$f$visit4 = false;
            $this$visitTag$iv$iv$iv4 = $this$visit$iv$iv4;
            $i$f$visitTag5 = false;
            $this$visitTag$iv$iv$iv4.getConsumer().onTagStart($this$visitTag$iv$iv$iv4);
            $this$visit_u24lambda_u240$iv$iv4 = $this$visitTag$iv$iv$iv4;
            $i$a$-visitTag-ApiKt$visit$1$iv$iv = false;
            TD $this$createVisualizationPercentage_u24lambda_u240_u240_u240_u240_u240_u241 = (TD)$this$visit_u24lambda_u240$iv$iv4;
            boolean bl10 = false;
            ((Map)$this$createVisualizationPercentage_u24lambda_u240_u240_u240_u240_u240_u241.getAttributes()).put("valign", "top");
            Gen_attr_traitsKt.setStyle((CoreAttributeGroupFacade)((CoreAttributeGroupFacade)$this$createVisualizationPercentage_u24lambda_u240_u240_u240_u240_u240_u241), (String)styleValuePercentage);
            $this$createVisualizationPercentage_u24lambda_u240_u240_u240_u240_u240_u241.unaryPlus(CollectionsKt.first((List)valuePercentage) + "%");
            $this$visitTag$iv$iv$iv4.getConsumer().onTagEnd($this$visitTag$iv$iv$iv4);
            $this$visitTag$iv$iv$iv3.getConsumer().onTagEnd($this$visitTag$iv$iv$iv3);
        }
        $this$visitTag$iv$iv$iv2.getConsumer().onTagEnd($this$visitTag$iv$iv$iv2);
        $this$visitTag$iv$iv$iv.getConsumer().onTagEnd($this$visitTag$iv$iv$iv);
        $this$visitTag$iv$iv$iv$iv.getConsumer().onTagEnd((Tag)$this$visitTag$iv$iv$iv$iv);
        return (String)$this$html_u24default$iv.finalize();
    }

    private final int computeMaxStatValueWidth(List<StatisticsDescriptionUnit> columnStatistics) {
        int maxWidth = 0;
        maxWidth = -1;
        Iterable $this$forEach$iv = columnStatistics;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StatisticsDescriptionUnit it = (StatisticsDescriptionUnit)element$iv;
            boolean bl = false;
            int curValueWidth = this.component.getFontMetrics(this.scaledTableFont).stringWidth(it.getStatisticsValue());
            if (curValueWidth <= maxWidth) continue;
            maxWidth = curValueWidth;
        }
        return maxWidth;
    }

    private static final Unit createVisualizationHistogram$lambda$0(BarMapping $this$geomBar) {
        Intrinsics.checkNotNullParameter((Object)$this$geomBar, (String)"$this$geomBar");
        $this$geomBar.setX((Object)"x");
        $this$geomBar.setY((Object)"y");
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\f\u001a\u00020\u0007J/\u0010\r\u001a\u00070\u0007\u00a2\u0006\u0002\b\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J,\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00192\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002J(\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0013H\u0002\u00a8\u0006!"}, d2={"Lcom/intellij/grid/charts/impl/StatisticsPanelRenderer$Companion;", "", "<init>", "()V", "getTooltips", "Lcom/intellij/database/run/ui/table/statisticsPanel/types/ColumnVisualizationDataTooltip;", "type", "", "getAxisXLabels", "Lcom/intellij/database/run/ui/table/statisticsPanel/types/ColumnVisualizationDataAxisXLabels;", "xList", "", "columnDataType", "makeShortenedText", "Lcom/intellij/openapi/util/NlsSafe;", "text", "maxTextWidth", "", "font", "Ljava/awt/Font;", "comp", "Ljavax/swing/JComponent;", "formatFloat", "x", "determineLeftRightValues", "Lkotlin/Pair;", "makeGeomText", "Lorg/jetbrains/letsPlot/geom/geomText;", "labelXCoord", "", "labelText", "horizontalTextAlignment", "scaledTableFont", "intellij.grid.charts.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ColumnVisualizationDataTooltip getTooltips(@NotNull String type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Object[] objectArray = new ColumnVisualizationDataTooltip.Format[]{new ColumnVisualizationDataTooltip.Format("@yLabel", "{.0f}"), new ColumnVisualizationDataTooltip.Format("@percentage", "{.0f}")};
            return new ColumnVisualizationDataTooltip("top_center", "@xLabel\nCount: @yLabel " + (StringsKt.startsWith$default((String)type, (String)"bool", (boolean)false, (int)2, null) ? "(@percentage%)" : ""), CollectionsKt.listOf((Object[])objectArray));
        }

        @Nullable
        public final ColumnVisualizationDataAxisXLabels getAxisXLabels(@NotNull List<String> xList, @NotNull String columnDataType) {
            Intrinsics.checkNotNullParameter(xList, (String)"xList");
            Intrinsics.checkNotNullParameter((Object)columnDataType, (String)"columnDataType");
            if (xList.size() == 1) {
                return null;
            }
            Pair<String, String> pair = this.determineLeftRightValues(xList, columnDataType);
            if (pair == null) {
                return null;
            }
            Pair<String, String> pair2 = pair;
            String leftValue = (String)pair2.component1();
            String rightValue = (String)pair2.component2();
            int lenWidth = leftValue.length() + rightValue.length();
            int fontSize = lenWidth > 30 ? 4 : 5;
            String string = columnDataType.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return StringsKt.startsWith$default((String)string, (String)"bool", (boolean)false, (int)2, null) ? new ColumnVisualizationDataAxisXLabels(leftValue, rightValue, 0.0, 1.0, "middle", "middle", fontSize) : new ColumnVisualizationDataAxisXLabels(leftValue, rightValue, -0.5, (double)xList.size() - 0.5, "left", "right", fontSize);
        }

        private final String makeShortenedText(@Nls String text, int maxTextWidth, Font font, JComponent comp) {
            return UiUtils.shortenTextWithEllipsis((String)text, (int)1, (int)0, (float)1.0f, (int)maxTextWidth, arg_0 -> Companion.makeShortenedText$lambda$0(comp, font, arg_0), (boolean)true);
        }

        private final String formatFloat(String x) {
            Integer n = StringsKt.toIntOrNull((String)x);
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                return x;
            }
            Float f = StringsKt.toFloatOrNull((String)x);
            if (f != null) {
                float it = ((Number)f).floatValue();
                boolean bl = false;
                String string = "%.1f";
                Locale locale = Locale.US;
                Object[] objectArray = new Object[]{Float.valueOf(it)};
                String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                return string2;
            }
            return null;
        }

        private final Pair<String, String> determineLeftRightValues(List<String> xList, String columnDataType) {
            Pair pair;
            String string = columnDataType.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            if (StringsKt.startsWith$default((String)string, (String)"bool", (boolean)false, (int)2, null)) {
                pair = new Pair(CollectionsKt.first(xList), CollectionsKt.last(xList));
            } else {
                String string2 = this.formatFloat(StringsKt.substringBefore$default((String)((String)CollectionsKt.first(xList)), (String)" \u2014", null, (int)2, null));
                if (string2 == null) {
                    return null;
                }
                String leftValue = string2;
                String string3 = this.formatFloat(StringsKt.substringAfter$default((String)((String)CollectionsKt.last(xList)), (String)"\u2014 ", null, (int)2, null));
                if (string3 == null) {
                    return null;
                }
                String rightValue = string3;
                pair = new Pair((Object)leftValue, (Object)rightValue);
            }
            return pair;
        }

        private final geomText makeGeomText(double labelXCoord, String labelText, String horizontalTextAlignment, Font scaledTableFont) {
            Color color = HistogramSettings.INSTANCE.getLABEL_COLOR_GRAY();
            String string = scaledTableFont.getFamily();
            return new geomText(null, null, null, false, null, null, null, null, null, null, null, (Number)labelXCoord, (Number)-0.05, labelText, null, (Object)color, (Number)4, string, null, (Object)horizontalTextAlignment, (Object)"top", null, null, null, null, null, null, null, null, null, null, null, -1816577, null);
        }

        private static final int makeShortenedText$lambda$0(JComponent $comp, Font $font, String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return $comp.getFontMetrics($font).stringWidth(it);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

