/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grid.charts.impl;

import com.intellij.charts.analyser.SeriesSuggester;
import com.intellij.charts.core.ChartPage;
import com.intellij.charts.core.ChartPageKt;
import com.intellij.charts.core.axes.settings.AxesSettings;
import com.intellij.charts.core.settings.ChartSettings;
import com.intellij.charts.dataframe.DataFrame;
import com.intellij.charts.settings.SeriesSettingsPanel;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridListener;
import com.intellij.database.datagrid.GridPanel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.RemovableView;
import com.intellij.grid.charts.impl.DataGridConversionUtil;
import com.intellij.grid.charts.impl.ShowChartUnderTableAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/grid/charts/impl/ShowChartUnderTableAction;", "Lcom/intellij/openapi/project/DumbAwareToggleAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isSelected", "", "setSelected", "state", "showChart", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "Companion", "intellij.grid.charts.impl"})
@SourceDebugExtension(value={"SMAP\nShowChartUnderTableAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShowChartUnderTableAction.kt\ncom/intellij/grid/charts/impl/ShowChartUnderTableAction\n+ 2 UiUtils.kt\ncom/intellij/openapi/ui/UiUtils\n*L\n1#1,131:1\n61#2:132\n*S KotlinDebug\n*F\n+ 1 ShowChartUnderTableAction.kt\ncom/intellij/grid/charts/impl/ShowChartUnderTableAction\n*L\n47#1:132\n*E\n"})
public final class ShowChartUnderTableAction
extends DumbAwareToggleAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<Boolean> CHART_UPDATE_SCHEDULED = new Key("CHART_UPDATE_SCHEDULED");

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(e.getData(DatabaseDataKeys.DATA_GRID_KEY) != null && Registry.Companion.is("database.grid.show.chart.tab"));
        super.update(e);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isSelected(@NotNull AnActionEvent e) {
        ChartPage chartPage;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataGrid dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (dataGrid == null) {
            return false;
        }
        DataGrid grid = dataGrid;
        Object object = grid.getPanel().getSideView(GridPanel.ViewPosition.BOTTOM);
        if (object != null && (object = object.getViewComponent()) != null) {
            void $this$getUserData$iv;
            Object object2 = object;
            Key key$iv = ChartPageKt.getCHART_PAGE_KEY();
            boolean $i$f$getUserData = false;
            Object object3 = $this$getUserData$iv.getClientProperty(key$iv);
            if (!(object3 instanceof ChartPage)) {
                object3 = null;
            }
            chartPage = (ChartPage)object3;
        } else {
            chartPage = null;
        }
        return chartPage != null;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataGrid dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (dataGrid == null) {
            return;
        }
        DataGrid grid = dataGrid;
        if (state) {
            this.showChart(grid);
        } else {
            Companion.hideChart(grid);
        }
    }

    private final void showChart(DataGrid grid) {
        ChartPage chartPage;
        Companion.hideChart(grid);
        DataFrame dataFrame = DataGridConversionUtil.INSTANCE.getDataFrameFromDataGrid(grid);
        List settings = SeriesSuggester.INSTANCE.getSingleSuggestion(dataFrame);
        ChartPage $this$showChart_u24lambda_u240 = chartPage = new ChartPage(new ChartSettings(new AxesSettings(false, false, 3, null), settings), SeriesSettingsPanel.Mode.WITHOUT_COLUMNS_LIST);
        boolean bl = false;
        $this$showChart_u24lambda_u240.assignDataFrame(dataFrame);
        ShowChartUnderTableAction.Companion.addChartToolbar($this$showChart_u24lambda_u240);
        $this$showChart_u24lambda_u240.getComponent().setBorder(IdeBorderFactory.createBorder((Color)JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground(), (int)2));
        ChartPage chartPage2 = chartPage;
        UiUtils.putUserData((JComponent)chartPage2.getComponent(), (Key)ChartPageKt.getCHART_PAGE_KEY(), (Object)chartPage2);
        Disposer.register((Disposable)((Disposable)grid), (Disposable)((Disposable)chartPage2));
        Companion.addGridContentListener(grid, chartPage2);
        grid.getPanel().putSideView(new RemovableView(chartPage2){
            final /* synthetic */ ChartPage $chartPage;
            {
                this.$chartPage = $chartPage;
            }

            public JComponent getViewComponent() {
                return this.$chartPage.getComponent();
            }

            public void onRemoved() {
            }
        }, GridPanel.ViewPosition.BOTTOM, null);
    }

    public static final /* synthetic */ Key access$getCHART_UPDATE_SCHEDULED$cp() {
        return CHART_UPDATE_SCHEDULED;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/grid/charts/impl/ShowChartUnderTableAction$Companion;", "", "<init>", "()V", "CHART_UPDATE_SCHEDULED", "Lcom/intellij/openapi/util/Key;", "", "addGridContentListener", "", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "chartPage", "Lcom/intellij/charts/core/ChartPage;", "addChartToolbar", "hideChart", "intellij.grid.charts.impl"})
    @SourceDebugExtension(value={"SMAP\nShowChartUnderTableAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShowChartUnderTableAction.kt\ncom/intellij/grid/charts/impl/ShowChartUnderTableAction$Companion\n+ 2 UiUtils.kt\ncom/intellij/openapi/ui/UiUtils\n*L\n1#1,131:1\n61#2:132\n*S KotlinDebug\n*F\n+ 1 ShowChartUnderTableAction.kt\ncom/intellij/grid/charts/impl/ShowChartUnderTableAction$Companion\n*L\n125#1:132\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void addGridContentListener(@NotNull DataGrid grid, @NotNull ChartPage chartPage) {
            Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
            Intrinsics.checkNotNullParameter((Object)chartPage, (String)"chartPage");
            CheckedDisposable checkedDisposable = Disposer.newCheckedDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)checkedDisposable, (String)"newCheckedDisposable(...)");
            CheckedDisposable checkedDisposable2 = checkedDisposable;
            Disposer.register((Disposable)((Disposable)chartPage), (Disposable)((Disposable)checkedDisposable2));
            grid.addDataGridListener(new DataGridListener(checkedDisposable2, chartPage, grid){
                final /* synthetic */ CheckedDisposable $checkedDisposable;
                final /* synthetic */ ChartPage $chartPage;
                final /* synthetic */ DataGrid $grid;
                {
                    this.$checkedDisposable = $checkedDisposable;
                    this.$chartPage = $chartPage;
                    this.$grid = $grid;
                }

                public void onContentChanged(DataGrid dataGrid, GridRequestSource.RequestPlace place) {
                    Intrinsics.checkNotNullParameter((Object)dataGrid, (String)"dataGrid");
                    if (Intrinsics.areEqual((Object)dataGrid.getUserData(ShowChartUnderTableAction.access$getCHART_UPDATE_SCHEDULED$cp()), (Object)true)) {
                        return;
                    }
                    dataGrid.putUserData(ShowChartUnderTableAction.access$getCHART_UPDATE_SCHEDULED$cp(), (Object)true);
                    AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> addGridContentListener.1.onContentChanged$lambda$0(this.$checkedDisposable, dataGrid, this.$chartPage, this.$grid), 200L, TimeUnit.MILLISECONDS);
                }

                private static final void onContentChanged$lambda$0$0(ChartPage $chartPage, DataGrid $grid) {
                    $chartPage.assignDataFrame(DataGridConversionUtil.INSTANCE.getDataFrameFromDataGrid($grid));
                }

                private static final void onContentChanged$lambda$0(CheckedDisposable $checkedDisposable, DataGrid $dataGrid, ChartPage $chartPage, DataGrid $grid) {
                    if (!$checkedDisposable.isDisposed()) {
                        ApplicationManager.getApplication().invokeLater(() -> addGridContentListener.1.onContentChanged$lambda$0$0($chartPage, $grid));
                    }
                    $dataGrid.putUserData(ShowChartUnderTableAction.access$getCHART_UPDATE_SCHEDULED$cp(), (Object)false);
                }
            }, (Disposable)chartPage);
        }

        private final void addChartToolbar(ChartPage chartPage) {
            ActionToolbar actionToolbar;
            ActionManager actionManager = ActionManager.getInstance();
            ActionToolbar $this$addChartToolbar_u24lambda_u240 = actionToolbar = actionManager.createActionToolbar("BDTChartToolbar", (ActionGroup)new DefaultActionGroup(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)actionManager.getAction("Console.TableResult.CloseChart")), (Iterable)chartPage.createActions())), false);
            boolean bl = false;
            $this$addChartToolbar_u24lambda_u240.getComponent().setOpaque(false);
            ActionToolbar actionToolbar2 = actionToolbar;
            Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"apply(...)");
            ActionToolbar chartToolbar = actionToolbar2;
            chartToolbar.setTargetComponent((JComponent)chartPage.getComponent());
            chartPage.getComponent().add((Component)chartToolbar.getComponent(), "East");
        }

        /*
         * WARNING - void declaration
         */
        public final void hideChart(@NotNull DataGrid grid) {
            Object object;
            RemovableView view;
            block5: {
                block4: {
                    void $this$getUserData$iv;
                    Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
                    view = grid.getPanel().getSideView(GridPanel.ViewPosition.BOTTOM);
                    object = view;
                    if (object == null || (object = object.getViewComponent()) == null) break block4;
                    Object object2 = object;
                    Key key$iv = ChartPageKt.getCHART_PAGE_KEY();
                    boolean $i$f$getUserData = false;
                    Object object3 = $this$getUserData$iv.getClientProperty(key$iv);
                    if (!(object3 instanceof ChartPage)) {
                        object3 = null;
                    }
                    if ((object = (ChartPage)object3) != null) break block5;
                }
                return;
            }
            Object chartPage = object;
            grid.getPanel().removeSideView(view);
            Disposer.dispose((Disposable)((Disposable)chartPage));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

