/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.JdbcColumnDescriptor;
import com.intellij.database.datagrid.JdbcGridColumn;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.BinaryDisplayType;
import com.intellij.database.extractors.TextInfo;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.GridCellEditorHelper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectFormatterUtil {
    private static StringBuilder appendHex(StringBuilder sb, long value, int padTo) {
        String hex = Long.toHexString(value);
        for (int i = hex.length(); i < padTo; ++i) {
            sb.append("0");
        }
        return sb.append(StringUtil.toUpperCase((String)hex));
    }

    @NotNull
    public static String toHexString(byte @NotNull [] bytes) {
        if (bytes == null) {
            ObjectFormatterUtil.$$$reportNull$$$0(0);
        }
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            ObjectFormatterUtil.appendHex(sb, (long)b & 0xFFL, 2);
        }
        String string = sb.toString();
        if (string == null) {
            ObjectFormatterUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static void swapBytes(byte @NotNull [] bytes, int i, int j) {
        if (bytes == null) {
            ObjectFormatterUtil.$$$reportNull$$$0(2);
        }
        if (i >= bytes.length || i < 0 || j >= bytes.length || j < 0 || i == j) {
            return;
        }
        byte tmp = bytes[i];
        bytes[i] = bytes[j];
        bytes[j] = tmp;
    }

    private static void swapUUIDBytes(byte @NotNull [] bytes) {
        if (bytes == null) {
            ObjectFormatterUtil.$$$reportNull$$$0(3);
        }
        if (bytes.length != 16) {
            return;
        }
        ObjectFormatterUtil.swapBytes(bytes, 0, 4);
        ObjectFormatterUtil.swapBytes(bytes, 1, 5);
        ObjectFormatterUtil.swapBytes(bytes, 2, 6);
        ObjectFormatterUtil.swapBytes(bytes, 3, 7);
        ObjectFormatterUtil.swapBytes(bytes, 4, 6);
        ObjectFormatterUtil.swapBytes(bytes, 5, 7);
    }

    private static void swapUUIDBytesReverse(byte @NotNull [] bytes) {
        if (bytes == null) {
            ObjectFormatterUtil.$$$reportNull$$$0(4);
        }
        if (bytes.length != 16) {
            return;
        }
        ObjectFormatterUtil.swapBytes(bytes, 5, 7);
        ObjectFormatterUtil.swapBytes(bytes, 4, 6);
        ObjectFormatterUtil.swapBytes(bytes, 3, 7);
        ObjectFormatterUtil.swapBytes(bytes, 2, 6);
        ObjectFormatterUtil.swapBytes(bytes, 1, 5);
        ObjectFormatterUtil.swapBytes(bytes, 0, 4);
    }

    private static boolean isNilUUID(UUID uuid) {
        return StringUtil.equals((CharSequence)uuid.toString(), (CharSequence)"00000000-0000-0000-0000-000000000000");
    }

    @Contract(value="null->false")
    public static boolean isValidUUIDWithKnownVersion(@Nullable UUID uuid) {
        return uuid != null && (1 <= uuid.version() && uuid.version() <= 5 || ObjectFormatterUtil.isNilUUID(uuid));
    }

    @Nullable
    public static UUID toUUID(byte @NotNull [] bytes, boolean swapFlag) {
        if (bytes == null) {
            ObjectFormatterUtil.$$$reportNull$$$0(5);
        }
        if (bytes.length != 16) {
            return null;
        }
        byte[] resultBytes = (byte[])bytes.clone();
        if (swapFlag) {
            ObjectFormatterUtil.swapUUIDBytes(resultBytes);
        }
        ByteBuffer bb = ByteBuffer.wrap(resultBytes);
        long high = bb.getLong();
        long low = bb.getLong();
        return new UUID(high, low);
    }

    public static byte[] UUIDtoBytes(@NotNull UUID uuid, boolean swapFlag) {
        if (uuid == null) {
            ObjectFormatterUtil.$$$reportNull$$$0(6);
        }
        ByteBuffer bytes = ByteBuffer.allocate(16);
        bytes.putLong(uuid.getMostSignificantBits());
        bytes.putLong(uuid.getLeastSignificantBits());
        byte[] resultBytes = bytes.array();
        if (swapFlag) {
            ObjectFormatterUtil.swapUUIDBytesReverse(resultBytes);
        }
        return resultBytes;
    }

    private static void toPresentableHexString(@NotNull InputStream input, @NotNull StringBuilder sb) throws IOException {
        if (input == null) {
            ObjectFormatterUtil.$$$reportNull$$$0(7);
        }
        if (sb == null) {
            ObjectFormatterUtil.$$$reportNull$$$0(8);
        }
        long i = 0L;
        StringBuilder sb2 = new StringBuilder();
        boolean first = true;
        while (input.available() > 0) {
            if (first) {
                first = false;
            } else {
                sb.append("\n");
            }
            sb2.setLength(0);
            ObjectFormatterUtil.appendHex(sb, i * 16L, 8).append("  ");
            for (int j = 0; j < 16; ++j) {
                if (input.available() > 0) {
                    int value = input.read();
                    ObjectFormatterUtil.appendHex(sb, value, 2).append(" ");
                    sb2.append((char)(!Character.isISOControl(value) ? (int)value : 46));
                    continue;
                }
                while (j < 16) {
                    sb.append("   ");
                    ++j;
                }
            }
            sb.append("   ").append((CharSequence)sb2);
            ++i;
        }
        input.close();
    }

    @NotNull
    private static String toPresentableHexString(byte @NotNull [] bytes) {
        String string;
        if (bytes == null) {
            ObjectFormatterUtil.$$$reportNull$$$0(9);
        }
        try {
            int expectedLength = (bytes.length / 16 + 1) * 78;
            StringBuilder sb = new StringBuilder(expectedLength);
            ObjectFormatterUtil.toPresentableHexString(new ByteArrayInputStream(bytes), sb);
            string = sb.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (string == null) {
            ObjectFormatterUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static String toTextString(byte @NotNull [] bytes) {
        TextInfo result;
        if (bytes == null) {
            ObjectFormatterUtil.$$$reportNull$$$0(11);
        }
        if ((result = TextInfo.tryDetectString(bytes)) != null) {
            return result.text;
        }
        return null;
    }

    @NotNull
    public static String toPresentableString(byte @NotNull [] bytes, @Nullable BinaryDisplayType displayType) {
        if (bytes == null) {
            ObjectFormatterUtil.$$$reportNull$$$0(12);
        }
        if (displayType == null) {
            String string = "0x" + ObjectFormatterUtil.toHexString(bytes);
            if (string == null) {
                ObjectFormatterUtil.$$$reportNull$$$0(13);
            }
            return string;
        }
        return switch (displayType) {
            default -> throw new MatchException(null, null);
            case BinaryDisplayType.DETECT -> {
                String result = bytes.length == 16 ? ObjectFormatterUtil.toString(ObjectFormatterUtil.toUUID(bytes, false)) : ObjectFormatterUtil.toTextString(bytes);
                yield Objects.requireNonNullElseGet(result, () -> "0x" + ObjectFormatterUtil.toHexString(bytes));
            }
            case BinaryDisplayType.UUID -> {
                String result = ObjectFormatterUtil.toString(ObjectFormatterUtil.toUUID(bytes, false));
                yield Objects.requireNonNullElseGet(result, () -> "0x" + ObjectFormatterUtil.toHexString(bytes));
            }
            case BinaryDisplayType.UUID_SWAP -> {
                String result = ObjectFormatterUtil.toString(ObjectFormatterUtil.toUUID(bytes, true));
                yield Objects.requireNonNullElseGet(result, () -> "0x" + ObjectFormatterUtil.toHexString(bytes));
            }
            case BinaryDisplayType.TEXT -> {
                String result = ObjectFormatterUtil.toTextString(bytes);
                yield Objects.requireNonNullElseGet(result, () -> "0x" + ObjectFormatterUtil.toHexString(bytes));
            }
            case BinaryDisplayType.HEX -> "0x" + ObjectFormatterUtil.toHexString(bytes);
            case BinaryDisplayType.HEX_ASCII -> ObjectFormatterUtil.toPresentableHexString(bytes);
        };
    }

    @Contract(value="null->null;!null->!null")
    @Nullable
    private static String toString(@Nullable UUID uuid) {
        return uuid == null ? null : uuid.toString().toLowerCase(Locale.ENGLISH);
    }

    public static boolean isBooleanColumn(@NotNull GridColumn column, int type) {
        if (column == null) {
            ObjectFormatterUtil.$$$reportNull$$$0(14);
        }
        String className = column instanceof JdbcColumnDescriptor ? ((JdbcColumnDescriptor)((Object)column)).getJavaClassName() : null;
        return type == 16 || (ObjectFormatterUtil.isBit(column.getTypeName(), type) || "java.lang.Boolean".equals(className)) && ((JdbcGridColumn)column).getSize() <= 1;
    }

    public static boolean isBooleanCell(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        if (grid == null) {
            ObjectFormatterUtil.$$$reportNull$$$0(15);
        }
        if (row == null) {
            ObjectFormatterUtil.$$$reportNull$$$0(16);
        }
        if (column == null) {
            ObjectFormatterUtil.$$$reportNull$$$0(17);
        }
        return ObjectFormatterUtil.isBooleanColumn(Objects.requireNonNull(grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(column)), GridCellEditorHelper.get(grid).guessJdbcTypeForEditing(grid, row, column));
    }

    public static boolean isNumericCell(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        if (grid == null) {
            ObjectFormatterUtil.$$$reportNull$$$0(18);
        }
        if (row == null) {
            ObjectFormatterUtil.$$$reportNull$$$0(19);
        }
        if (column == null) {
            ObjectFormatterUtil.$$$reportNull$$$0(20);
        }
        return ObjectFormatterUtil.isNumericValue(GridCellEditorHelper.get(grid).guessJdbcTypeForEditing(grid, row, column));
    }

    public static boolean isNumericValue(int type) {
        return ArrayUtil.contains((Object)type, (Object[])new Integer[]{4, 5, -6, -5, 7, 6, 8, 3, 2});
    }

    public static boolean isBinary(@Nullable GridColumn column, int type) {
        String typeName = column == null ? null : column.getTypeName();
        return type == -2 || type == -3 || type == -4 || type == 2004 || ObjectFormatterUtil.isBit(typeName, type) && (column == null || !ObjectFormatterUtil.isBooleanColumn(column, type)) || typeName != null && StringUtil.containsIgnoreCase((String)typeName, (String)"BINARY");
    }

    protected static boolean isBit(@Nullable String typeName, int jdbcType) {
        return jdbcType == -7 || typeName != null && StringUtil.findIgnoreCase((String)typeName, (String[])new String[]{"bit", "bit varying", "varbit"});
    }

    public static boolean isNumberType(int jdbcType) {
        boolean result = switch (jdbcType) {
            case -5, 2, 3, 4, 6, 8 -> true;
            default -> false;
        };
        return result;
    }

    public static boolean isStringType(int jdbcType) {
        return switch (jdbcType) {
            case -16, -15, -9, -1, 1, 12, 2005, 2011 -> true;
            default -> false;
        };
    }

    public static boolean isIntegerOrBigInt(int type) {
        return switch (type) {
            case -5, 4 -> true;
            default -> false;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 10, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 1: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/ObjectFormatterUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uuid";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/ObjectFormatterUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toHexString";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toPresentableHexString";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "toPresentableString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toHexString";
                break;
            }
            case 1: 
            case 10: 
            case 13: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "swapBytes";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "swapUUIDBytes";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "swapUUIDBytesReverse";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toUUID";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "UUIDtoBytes";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "toPresentableHexString";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "toTextString";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "toPresentableString";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isBooleanColumn";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isBooleanCell";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isNumericCell";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 10, 13 -> new IllegalStateException(string);
        };
    }
}

