/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.data.types.BaseDataTypeConversion;
import com.intellij.database.data.types.DataTypeConversion;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DocumentDataHookUp;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridHelperPropertyProvider;
import com.intellij.database.datagrid.GridHelperPropertyProviderImpl;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.IdentityDataProducerImpl;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.dump.BaseGridHandler;
import com.intellij.database.dump.DumpHandler;
import com.intellij.database.dump.ExtractionHelper;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.run.actions.DumpSource;
import com.intellij.database.run.actions.DumpSourceNameProvider;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0013\b\u0017\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J*\u0010\u0011\u001a\u00020\u00072\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0017H\u0016J,\u0010\u0018\u001a\u0004\u0018\u00010\u00152\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0017H\u0016J.\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0007H\u0016J\u001e\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u0016J\"\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J\"\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u0016J\u001c\u0010*\u001a\u00020\u00072\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u0016J\u001e\u0010+\u001a\u0004\u0018\u00010)2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u0016J\u0012\u0010,\u001a\u0004\u0018\u00010)2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020)2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u00100\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020.H\u0016J\u001e\u00101\u001a\b\u0012\u0002\b\u0003\u0018\u0001022\u0006\u0010\u0012\u001a\u00020.2\u0006\u00103\u001a\u000204H\u0016J0\u00105\u001a\u0006\u0012\u0002\b\u0003062\n\u0010-\u001a\u0006\u0012\u0002\b\u0003022\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0016J\u001c\u0010=\u001a\u00020\u00072\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u0016J\b\u0010>\u001a\u00020\u0007H\u0016J\u001c\u0010?\u001a\u00020\u00072\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u0016J\u001c\u0010@\u001a\u00020\u00072\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u0016J\u001c\u0010A\u001a\u00020\u00072\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u0016J,\u0010B\u001a\u00020 2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\u0006\u0010C\u001a\u00020)2\u0006\u0010D\u001a\u00020EH\u0016J:\u0010F\u001a\u0004\u0018\u00010G2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00140I2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00150IH\u0016JJ\u0010J\u001a\u0004\u0018\u00010K2\u0006\u0010C\u001a\u00020)2\u0006\u0010!\u001a\u00020\"2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00140I2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00150IH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006L"}, d2={"Lcom/intellij/database/datagrid/GridHelperImpl;", "Lcom/intellij/database/datagrid/GridHelper;", "properties", "Lcom/intellij/database/datagrid/GridHelperPropertyProvider;", "<init>", "(Lcom/intellij/database/datagrid/GridHelperPropertyProvider;)V", "insideNotebook", "", "(Z)V", "getProperties", "()Lcom/intellij/database/datagrid/GridHelperPropertyProvider;", "createDataTypeConversionBuilder", "Lcom/intellij/database/data/types/DataTypeConversion$Builder;", "defaultMode", "Lcom/intellij/database/extractors/ObjectFormatterMode;", "getDefaultMode", "()Lcom/intellij/database/extractors/ObjectFormatterMode;", "canEditTogether", "grid", "Lcom/intellij/database/datagrid/CoreGrid;", "Lcom/intellij/database/datagrid/GridRow;", "Lcom/intellij/database/datagrid/GridColumn;", "columns", "", "findUniqueColumn", "getColumnIcon", "Ljavax/swing/Icon;", "column", "forDisplay", "getVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "fix", "Lcom/intellij/database/connection/throwable/info/ErrorInfo$Fix;", "editor", "", "getUnambiguousColumnNames", "", "", "canAddRow", "getTableName", "getNameForDump", "source", "Lcom/intellij/database/datagrid/DataGrid;", "getQueryText", "isDatabaseHookUp", "createDumpSource", "Lcom/intellij/database/run/actions/DumpSource;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createDumpHandler", "Lcom/intellij/database/dump/DumpHandler;", "manager", "Lcom/intellij/database/dump/ExtractionHelper;", "factory", "Lcom/intellij/database/extractors/DataExtractorFactory;", "config", "Lcom/intellij/database/extractors/ExtractionConfig;", "isMixedTypeColumns", "isSortingApplicable", "hasTargetForEditing", "canMutateColumns", "isEditable", "setFilterText", "text", "caretPosition", "", "getCellLanguage", "Lcom/intellij/lang/Language;", "row", "Lcom/intellij/database/datagrid/ModelIndex;", "createCellCodeFragment", "Lcom/intellij/psi/PsiCodeFragment;", "intellij.grid.impl"})
public class GridHelperImpl
implements GridHelper {
    @NotNull
    private final GridHelperPropertyProvider properties;

    public GridHelperImpl(@NotNull GridHelperPropertyProvider properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this.properties = properties;
    }

    @Override
    @NotNull
    public GridHelperPropertyProvider getProperties() {
        return this.properties;
    }

    @JvmOverloads
    public GridHelperImpl(boolean insideNotebook) {
        this(new GridHelperPropertyProviderImpl(insideNotebook));
    }

    public /* synthetic */ GridHelperImpl(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    @Override
    @NotNull
    public DataTypeConversion.Builder createDataTypeConversionBuilder() {
        return new BaseDataTypeConversion.Builder();
    }

    @Override
    @NotNull
    public ObjectFormatterMode getDefaultMode() {
        return ObjectFormatterMode.SQL_SCRIPT;
    }

    @Override
    public boolean canEditTogether(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull List<GridColumn> columns) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        return true;
    }

    @Override
    @Nullable
    public GridColumn findUniqueColumn(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull List<GridColumn> columns) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        return null;
    }

    @Override
    @Nullable
    public Icon getColumnIcon(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull GridColumn column, boolean forDisplay) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        return null;
    }

    @Override
    @Nullable
    public VirtualFile getVirtualFile(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        return GridUtil.getVirtualFile(grid);
    }

    @Override
    public void applyFix(@NotNull Project project, @NotNull ErrorInfo.Fix fix, @Nullable Object editor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fix, (String)"fix");
    }

    @Override
    @NotNull
    public List<String> getUnambiguousColumnNames(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean canAddRow(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        return true;
    }

    @Override
    @Nullable
    public String getTableName(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        return null;
    }

    @Override
    @Nullable
    public String getNameForDump(@NotNull DataGrid source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return GridUtil.getEditorTabName(source);
    }

    @Override
    @NotNull
    public String getQueryText(@NotNull DataGrid source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return "";
    }

    @Override
    public boolean isDatabaseHookUp(@NotNull DataGrid grid) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        return false;
    }

    @Override
    @Nullable
    public DumpSource<?> createDumpSource(@NotNull DataGrid grid, @NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return new DumpSource.DataGridSource(grid);
    }

    @Override
    @NotNull
    public DumpHandler<?> createDumpHandler(@NotNull DumpSource<?> source, @NotNull ExtractionHelper manager, @NotNull DataExtractorFactory factory, @NotNull ExtractionConfig config) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        DumpSource.DataGridSource gridSource = (DumpSource.DataGridSource)source;
        DataGrid dataGrid = gridSource.getGrid();
        Intrinsics.checkNotNullExpressionValue((Object)dataGrid, (String)"getGrid(...)");
        DataGrid grid = dataGrid;
        Project project = grid.getProject();
        DumpSourceNameProvider<DataGrid> dumpSourceNameProvider = gridSource.getNameProvider();
        return new BaseGridHandler(grid, manager, factory, config, project, dumpSourceNameProvider){

            protected DataProducer createProducer(DataGrid grid, int index) {
                Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
                GridModel gridModel = grid.getDataModel(DataAccessType.DATABASE_DATA);
                Intrinsics.checkNotNullExpressionValue((Object)gridModel, (String)"getDataModel(...)");
                GridModel model2 = gridModel;
                return new IdentityDataProducerImpl((DataConsumer)new DataConsumer.Composite(new DataConsumer[0]), model2.getColumns(), (List<? extends GridRow>)new ArrayList<E>(model2.getRows()), 0, 0);
            }
        };
    }

    public boolean isMixedTypeColumns(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        return true;
    }

    public boolean isSortingApplicable() {
        return true;
    }

    @Override
    public boolean hasTargetForEditing(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        return true;
    }

    public boolean canMutateColumns(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        return grid.isEditable() && grid.isReady() && grid.getDataHookup() instanceof DocumentDataHookUp && grid.getDataHookup().getMutator() instanceof GridMutator.ColumnsMutator && grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getRowCount() != 0;
    }

    @Override
    public boolean isEditable(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        return true;
    }

    public void setFilterText(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull String text, int caretPosition) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        grid.setFilterText(text, caretPosition);
    }

    @Nullable
    public Language getCellLanguage(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        Intrinsics.checkNotNullParameter(row, (String)"row");
        Intrinsics.checkNotNullParameter(column, (String)"column");
        return null;
    }

    @Nullable
    public PsiCodeFragment createCellCodeFragment(@NotNull String text, @NotNull Project project, @NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        Intrinsics.checkNotNullParameter(row, (String)"row");
        Intrinsics.checkNotNullParameter(column, (String)"column");
        return null;
    }

    @JvmOverloads
    public GridHelperImpl() {
        this(false, 1, null);
    }
}

