/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DataGridBundle;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.run.actions.ChangePageSizeActionState;
import com.intellij.database.run.actions.ChangePageSizeUtilKt;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.util.Key;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010!\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"DEFAULT_PAGE_SIZES", "", "", "PAGE_SIZE_KEY", "Lcom/intellij/openapi/util/Key;", "SHOW_COUNT_ALL_ACTION_KEY", "", "getActionState", "Lcom/intellij/database/run/actions/ChangePageSizeActionState;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "updateIsTotalRowCountUpdateable", "", "intellij.grid.impl"})
public final class ChangePageSizeActionGroupKt {
    @NotNull
    private static final List<Integer> DEFAULT_PAGE_SIZES;
    @NotNull
    private static final Key<Integer> PAGE_SIZE_KEY;
    @NotNull
    private static final Key<Boolean> SHOW_COUNT_ALL_ACTION_KEY;

    private static final ChangePageSizeActionState getActionState(Presentation presentation) {
        Boolean showCountAllAction;
        JComponent component = (JComponent)presentation.getClientProperty(CustomComponentAction.COMPONENT_KEY);
        String text = presentation.getText();
        String description = presentation.getDescription();
        JComponent jComponent = component;
        String tooltip = jComponent != null ? jComponent.getToolTipText() : null;
        boolean loading = presentation.isEnabled();
        Integer pageSize = (Integer)presentation.getClientProperty(PAGE_SIZE_KEY);
        if (pageSize == null) {
            pageSize = -2;
        }
        if ((showCountAllAction = (Boolean)presentation.getClientProperty(SHOW_COUNT_ALL_ACTION_KEY)) == null) {
            showCountAllAction = false;
        }
        return new ChangePageSizeActionState(text, description, tooltip, loading, pageSize, showCountAllAction, 0, 64, null);
    }

    private static final ChangePageSizeActionState getActionState(DataGrid grid) {
        String string;
        GridPagingModel gridPagingModel = grid.getDataHookup().getPageModel();
        Intrinsics.checkNotNullExpressionValue((Object)gridPagingModel, (String)"getPageModel(...)");
        GridPagingModel pageModel = gridPagingModel;
        int pageStartIdx = pageModel.getPageStart();
        int pageEndIdx = pageModel.getPageEnd();
        long totalRowCount = pageModel.getTotalRowCount();
        boolean rowsWereDeleted = totalRowCount < (long)pageEndIdx;
        boolean isSinglePage = pageModel.isFirstPage() && pageModel.isLastPage() && !rowsWereDeleted;
        if (isSinglePage) {
            String string2 = totalRowCount == 1L ? DataGridBundle.message((String)"action.Console.TableResult.ChangePageSize.row", (Object[])new Object[0]) : DataGridBundle.message((String)"action.Console.TableResult.ChangePageSize.rows", (Object[])new Object[0]);
            Intrinsics.checkNotNull((Object)string2);
            String rowLabel = string2;
            string = ChangePageSizeUtilKt.format(totalRowCount) + " " + rowLabel;
        } else {
            string = pageEndIdx == 0 ? "0 " + DataGridBundle.message((String)"action.Console.TableResult.ChangePageSize.rows", (Object[])new Object[0]) : ChangePageSizeUtilKt.format(pageStartIdx) + "-" + ChangePageSizeUtilKt.format(pageEndIdx);
        }
        String text = string;
        boolean querying = grid.getDataHookup().getBusyCount() > 0;
        boolean enabled = !querying && grid.isReady();
        String string3 = DataGridBundle.message((String)"group.Console.TableResult.ChangePageSize.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        String description = string3;
        String string4 = DataGridBundle.message((String)"group.Console.TableResult.ChangePageSize.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        String tooltip = string4;
        if (!enabled) {
            String unavailableText;
            String string5 = querying ? DataGridBundle.message((String)"action.Console.TableResult.ChangePageSize.querying", (Object[])new Object[0]) : "";
            Intrinsics.checkNotNull((Object)string5);
            description = unavailableText = string5;
            tooltip = unavailableText;
        }
        boolean showCountRowsAction = isSinglePage && pageModel.isTotalRowCountUpdateable() && !querying && grid.isReady();
        return new ChangePageSizeActionState(text, description, tooltip, enabled, pageModel.getPageSize(), showCountRowsAction, GridHelper.Companion.get(grid).getProperties().getDefaultPageSize());
    }

    private static final void updateIsTotalRowCountUpdateable(DataGrid grid) {
        grid.getDataHookup().getLoader().updateIsTotalRowCountUpdateable();
    }

    public static final /* synthetic */ List access$getDEFAULT_PAGE_SIZES$p() {
        return DEFAULT_PAGE_SIZES;
    }

    public static final /* synthetic */ ChangePageSizeActionState access$getActionState(DataGrid grid) {
        return ChangePageSizeActionGroupKt.getActionState(grid);
    }

    public static final /* synthetic */ ChangePageSizeActionState access$getActionState(Presentation presentation) {
        return ChangePageSizeActionGroupKt.getActionState(presentation);
    }

    public static final /* synthetic */ Key access$getPAGE_SIZE_KEY$p() {
        return PAGE_SIZE_KEY;
    }

    public static final /* synthetic */ Key access$getSHOW_COUNT_ALL_ACTION_KEY$p() {
        return SHOW_COUNT_ALL_ACTION_KEY;
    }

    public static final /* synthetic */ void access$updateIsTotalRowCountUpdateable(DataGrid grid) {
        ChangePageSizeActionGroupKt.updateIsTotalRowCountUpdateable(grid);
    }

    static {
        Object[] objectArray = new Integer[]{10, 100, 500, 1000};
        DEFAULT_PAGE_SIZES = CollectionsKt.mutableListOf((Object[])objectArray);
        PAGE_SIZE_KEY = new Key("DATA_GRID_PAGE_SIZE_KEY");
        SHOW_COUNT_ALL_ACTION_KEY = new Key("DATA_GRID_SHOW_COUNT_ALL_ACTION_KEY");
    }
}

