/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.jam.JamService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.contexts.model.CacheableCommonSpringModel;
import com.intellij.spring.contexts.model.ComponentScanSearchContext;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.SpringJamModel;
import com.intellij.spring.model.jam.javaConfig.ImplicitlyRegisteredBeansProvider;
import com.intellij.spring.model.jam.javaConfig.SpringJavaBean;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.spring.search.SpringGlobalSearchScopes;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class ComponentScanPackagesModel
extends CacheableCommonSpringModel {
    private final NotNullLazyValue<? extends Set<PsiPackage>> myPackages;
    private volatile Collection<SpringBeanPointer<?>> myScannedBeans;
    private final Map<SpringQualifier, List<SpringBeanPointer<?>>> myLocalBeansByQualifier;
    protected final boolean includeTests;
    @NotNull
    private final Module myModule;
    private static boolean ourAllowDefaultPackageForTests = false;

    public ComponentScanPackagesModel(@NotNull NotNullLazyValue<? extends Set<PsiPackage>> packages, @NotNull Module module, boolean includeTests) {
        if (packages == null) {
            ComponentScanPackagesModel.$$$reportNull$$$0(0);
        }
        if (module == null) {
            ComponentScanPackagesModel.$$$reportNull$$$0(1);
        }
        this.myPackages = packages;
        this.myModule = module;
        this.myLocalBeansByQualifier = ConcurrentFactoryMap.createMap(key -> ComponentScanPackagesModel.findLocalBeansByQualifier(this, key));
        this.includeTests = includeTests;
    }

    @Override
    public Collection<SpringBeanPointer<?>> getLocalBeans() {
        return this.myScannedBeans == null ? (this.myScannedBeans = this.calculateLocalBeans(this.includeTests)) : this.myScannedBeans;
    }

    protected final Collection<SpringBeanPointer<?>> calculateLocalBeans(boolean includeTests) {
        Collection<SpringBeanPointer<?>> pointers = this.calculateScannedBeans(includeTests);
        LinkedHashSet<CommonSpringBean> javaBeans = new LinkedHashSet<CommonSpringBean>();
        for (SpringBeanPointer<?> pointer : pointers) {
            SpringStereotypeElement stereotypeElement;
            PsiClass psiClass;
            Object springBean = pointer.getSpringBean();
            if (!(springBean instanceof SpringStereotypeElement) || JamService.getJamService((Project)(psiClass = (stereotypeElement = (SpringStereotypeElement)springBean).getPsiElement()).getProject()).getJamElement(JamPsiMemberSpringBean.PSI_MEMBER_SPRING_BEAN_JAM_KEY, (PsiElement)psiClass) != null) continue;
            for (SpringJavaBean springJavaBean : stereotypeElement.getBeans()) {
                javaBeans.add(springJavaBean);
                if (!(springJavaBean instanceof ImplicitlyRegisteredBeansProvider)) continue;
                javaBeans.addAll(((ImplicitlyRegisteredBeansProvider)((Object)springJavaBean)).getImplicitlyRegistered());
            }
        }
        LinkedHashSet beans2 = new LinkedHashSet();
        beans2.addAll(pointers);
        beans2.addAll(BeanService.getInstance().mapSpringBeans(javaBeans));
        return beans2;
    }

    protected Collection<SpringBeanPointer<?>> calculateScannedBeans(boolean includeTests) {
        return ComponentScanPackagesModel.getScannedComponents(ComponentScanSearchContext.create((Set)this.myPackages.getValue(), this.getModule()).profiles(this.getActiveProfiles()).includeTests(includeTests));
    }

    public static Collection<SpringBeanPointer<?>> getScannedComponents(@NotNull ComponentScanSearchContext context) {
        if (context == null) {
            ComponentScanPackagesModel.$$$reportNull$$$0(2);
        }
        Module module = context.getModule();
        return BeanService.getInstance().mapSpringBeans(ComponentScanPackagesModel.getScannedComponents(scope -> SpringJamModel.getModel(module.getProject()).getStereotypeComponents((GlobalSearchScope)scope, module), context));
    }

    public static <T extends SpringStereotypeElement> List<CommonSpringBean> getScannedComponents(@NotNull NotNullFunction<? super GlobalSearchScope, ? extends List<T>> components, @NotNull ComponentScanSearchContext context) {
        if (components == null) {
            ComponentScanPackagesModel.$$$reportNull$$$0(3);
        }
        if (context == null) {
            ComponentScanPackagesModel.$$$reportNull$$$0(4);
        }
        if (context.getModule().isDisposed() || context.getPackages().isEmpty()) {
            return new SmartList();
        }
        ComponentScanPackagesModel.assertDefaultPackagesInTests(context.getPackages());
        GlobalSearchScope effectiveSearchScope = ComponentScanPackagesModel.getEffectiveScanScope(context);
        List allPointers = (List)components.fun((Object)effectiveSearchScope);
        Set<CommonSpringBean> filteredBeans = SpringJamUtils.getInstance().filterComponentScannedStereotypes(context.getModule(), allPointers, context.getPackages(), context.isUseDefaultFilters(), context.getExcludeContextFilters(), context.getIncludeContextFilters());
        return SpringProfileUtils.filterBeansInActiveProfiles(filteredBeans, context.getProfiles());
    }

    private static void assertDefaultPackagesInTests(@NotNull Set<PsiPackage> packages) {
        if (packages == null) {
            ComponentScanPackagesModel.$$$reportNull$$$0(5);
        }
        for (PsiPackage psiPackage : packages) {
            if (!psiPackage.getQualifiedName().isEmpty() || !ApplicationManager.getApplication().isUnitTestMode() || ourAllowDefaultPackageForTests) continue;
            throw new IllegalArgumentException("Do not use component-scan with <default> package in tests");
        }
    }

    @NotNull
    private static GlobalSearchScope getEffectiveScanScope(@NotNull ComponentScanSearchContext context) {
        if (context == null) {
            ComponentScanPackagesModel.$$$reportNull$$$0(6);
        }
        GlobalSearchScope[] scopes = (GlobalSearchScope[])context.getPackages().stream().map(psiPackage -> PackageScope.packageScope((PsiPackage)psiPackage, (boolean)true)).toArray(GlobalSearchScope[]::new);
        GlobalSearchScope globalSearchScope = SpringGlobalSearchScopes.runtime(context.getModule(), context.isIncludeTests()).intersectWith(GlobalSearchScope.union((GlobalSearchScope[])scopes));
        if (globalSearchScope == null) {
            ComponentScanPackagesModel.$$$reportNull$$$0(7);
        }
        return globalSearchScope;
    }

    @TestOnly
    public static void setAllowDefaultPackageForTests(boolean value) {
        ourAllowDefaultPackageForTests = value;
    }

    @Override
    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            ComponentScanPackagesModel.$$$reportNull$$$0(8);
        }
        return module;
    }

    @Override
    protected Collection<Object> getCachingProcessorsDependencies() {
        return Collections.singleton(PsiModificationTracker.MODIFICATION_COUNT);
    }

    @Override
    @NotNull
    public List<SpringBeanPointer<?>> findQualified(@NotNull SpringQualifier qualifier) {
        if (qualifier == null) {
            ComponentScanPackagesModel.$$$reportNull$$$0(9);
        }
        List<SpringBeanPointer<?>> list = this.myLocalBeansByQualifier.get(qualifier);
        if (list == null) {
            ComponentScanPackagesModel.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/contexts/model/ComponentScanPackagesModel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/contexts/model/ComponentScanPackagesModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveScanScope";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findQualified";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getScannedComponents";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "assertDefaultPackagesInTests";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveScanScope";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findQualified";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 10 -> new IllegalStateException(string);
        };
    }
}

