/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.completion.spec;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.terminal.completion.spec.ShellCommandResult;
import com.intellij.terminal.completion.spec.ShellFileInfo;
import com.intellij.terminal.completion.spec.ShellRuntimeContext;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.completion.spec.ShellRuntimeContextExtensionsKt;
import org.jetbrains.plugins.terminal.block.completion.spec.impl.ShellFileInfoImpl;
import org.jetbrains.plugins.terminal.block.session.ShellIntegrationFunctions;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u001a*\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\nH\u0087@\u00a2\u0006\u0002\u0010\u0014\u001a(\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0082@\u00a2\u0006\u0002\u0010\u0014\u001a(\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0082@\u00a2\u0006\u0002\u0010\u0014\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028G\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\n*\u00020\u00028G\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\"\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\b\u00a8\u0006\u0017"}, d2={"project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/terminal/completion/spec/ShellRuntimeContext;", "getProject", "(Lcom/intellij/terminal/completion/spec/ShellRuntimeContext;)Lcom/intellij/openapi/project/Project;", "PROJECT_KEY", "Lcom/intellij/openapi/util/Key;", "getPROJECT_KEY", "()Lcom/intellij/openapi/util/Key;", "isReworkedTerminal", "", "(Lcom/intellij/terminal/completion/spec/ShellRuntimeContext;)Z", "IS_REWORKED_KEY", "getIS_REWORKED_KEY", "getChildFiles", "", "Lcom/intellij/terminal/completion/spec/ShellFileInfo;", "path", "", "onlyDirectories", "(Lcom/intellij/terminal/completion/spec/ShellRuntimeContext;Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getChildFilesReworked", "getChildFilesExp", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nShellRuntimeContextExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellRuntimeContextExtensions.kt\norg/jetbrains/plugins/terminal/block/completion/spec/ShellRuntimeContextExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,96:1\n1#2:97\n13#3:98\n*S KotlinDebug\n*F\n+ 1 ShellRuntimeContextExtensions.kt\norg/jetbrains/plugins/terminal/block/completion/spec/ShellRuntimeContextExtensionsKt\n*L\n81#1:98\n*E\n"})
public final class ShellRuntimeContextExtensionsKt {
    @ApiStatus.Internal
    @NotNull
    private static final Key<Project> PROJECT_KEY;
    @ApiStatus.Internal
    @NotNull
    private static final Key<Boolean> IS_REWORKED_KEY;

    @ApiStatus.Experimental
    @NotNull
    public static final Project getProject(@NotNull ShellRuntimeContext $this$project) {
        Intrinsics.checkNotNullParameter((Object)$this$project, (String)"<this>");
        Project project = $this$project.getUserData(PROJECT_KEY);
        if (project == null) {
            throw new IllegalStateException(("No project data in " + $this$project).toString());
        }
        return project;
    }

    @NotNull
    public static final Key<Project> getPROJECT_KEY() {
        return PROJECT_KEY;
    }

    @ApiStatus.Experimental
    public static final boolean isReworkedTerminal(@NotNull ShellRuntimeContext $this$isReworkedTerminal) {
        Intrinsics.checkNotNullParameter((Object)$this$isReworkedTerminal, (String)"<this>");
        Boolean bl = $this$isReworkedTerminal.getUserData(IS_REWORKED_KEY);
        return bl != null ? bl : false;
    }

    @NotNull
    public static final Key<Boolean> getIS_REWORKED_KEY() {
        return IS_REWORKED_KEY;
    }

    @ApiStatus.Experimental
    @Nullable
    public static final Object getChildFiles(@NotNull ShellRuntimeContext $this$getChildFiles, @NotNull String path, boolean onlyDirectories, @NotNull Continuation<? super List<? extends ShellFileInfo>> $completion) {
        if (ShellRuntimeContextExtensionsKt.isReworkedTerminal($this$getChildFiles)) {
            return ShellRuntimeContextExtensionsKt.getChildFilesReworked($this$getChildFiles, path, onlyDirectories, $completion);
        }
        return ShellRuntimeContextExtensionsKt.getChildFilesExp($this$getChildFiles, path, onlyDirectories, $completion);
    }

    public static /* synthetic */ Object getChildFiles$default(ShellRuntimeContext shellRuntimeContext, String string, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return ShellRuntimeContextExtensionsKt.getChildFiles(shellRuntimeContext, string, bl, (Continuation<? super List<? extends ShellFileInfo>>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    private static final Object getChildFilesReworked(ShellRuntimeContext $this$getChildFilesReworked, String path, boolean onlyDirectories, Continuation<? super List<? extends ShellFileInfo>> $completion) {
        if (!($completion instanceof getChildFilesReworked.1)) ** GOTO lbl-1000
        var10_4 = $completion;
        if ((var10_4.label & -2147483648) != 0) {
            var10_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                boolean Z$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ShellRuntimeContextExtensionsKt.access$getChildFilesReworked(null, null, false, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!ShellRuntimeContextExtensionsKt.isReworkedTerminal($this$getChildFilesReworked)) {
                    throw new IllegalStateException("Check failed.");
                }
                v0 = OSAgnosticPathUtil.expandUserHome((String)path);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"expandUserHome(...)");
                adjustedPath = v0;
                try {
                    v1 = Paths.get(adjustedPath, new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"get(...)");
                    nioPath = v1;
                    if (nioPath.isAbsolute()) {
                        v2 = nioPath.toString();
                    } else {
                        var7_10 = $this$getChildFilesReworked.getCurrentDirectory();
                        var8_12 = new String[]{path};
                        v3 = Paths.get(var7_10, Arrays.copyOf(var8_12, var8_12.length));
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"get(...)");
                        v2 = v3.toString();
                    }
                    nioPath = v2;
                }
                catch (InvalidPathException <unused var>) {
                    return CollectionsKt.emptyList();
                }
                absolutePath = nioPath;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$getChildFilesReworked);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)path);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)adjustedPath);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)absolutePath);
                $continuation.Z$0 = onlyDirectories;
                $continuation.label = 1;
                v4 = $this$getChildFilesReworked.listDirectoryFiles((String)absolutePath, (Continuation<? super List<? extends ShellFileInfo>>)$continuation);
                if (v4 == var11_6) {
                    return var11_6;
                }
                ** GOTO lbl53
            }
            case 1: {
                onlyDirectories = $continuation.Z$0;
                absolutePath = (String)$continuation.L$3;
                adjustedPath = (String)$continuation.L$2;
                path = (String)$continuation.L$1;
                $this$getChildFilesReworked = (ShellRuntimeContext)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl53:
                // 2 sources

                files = (List)v4;
                return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)files), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getChildFilesReworked$lambda$0(boolean com.intellij.terminal.completion.spec.ShellFileInfo ), (Lcom/intellij/terminal/completion/spec/ShellFileInfo;)Ljava/lang/Boolean;)((boolean)(onlyDirectories != false))));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private static final Object getChildFilesExp(ShellRuntimeContext $this$getChildFilesExp, String path, boolean onlyDirectories, Continuation<? super List<? extends ShellFileInfo>> $completion) {
        if (!($completion instanceof getChildFilesExp.1)) ** GOTO lbl-1000
        var10_4 = $completion;
        if ((var10_4.label & -2147483648) != 0) {
            var10_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                boolean Z$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ShellRuntimeContextExtensionsKt.access$getChildFilesExp(null, null, false, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!(ShellRuntimeContextExtensionsKt.isReworkedTerminal($this$getChildFilesExp) == false)) {
                    throw new IllegalStateException("Check failed.");
                }
                var5_7 = path;
                if (var5_7.length() == 0) {
                    $i$a$-ifEmpty-ShellRuntimeContextExtensionsKt$getChildFilesExp$adjustedPath$1 = false;
                    v0 = ".";
                } else {
                    v0 = var5_7;
                }
                adjustedPath = (String)v0;
                command = ShellIntegrationFunctions.GET_DIRECTORY_FILES.getFunctionName() + " " + adjustedPath;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$getChildFilesExp);
                $continuation.L$1 = path;
                $continuation.L$2 = adjustedPath;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)command);
                $continuation.Z$0 = onlyDirectories;
                $continuation.label = 1;
                v1 = $this$getChildFilesExp.runShellCommand(command, (Continuation<? super ShellCommandResult>)$continuation);
                if (v1 == var11_6) {
                    return var11_6;
                }
                ** GOTO lbl40
            }
            case 1: {
                onlyDirectories = $continuation.Z$0;
                command = (String)$continuation.L$3;
                adjustedPath = (String)$continuation.L$2;
                path = (String)$continuation.L$1;
                $this$getChildFilesExp = (ShellRuntimeContext)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl40:
                // 2 sources

                if ((result = (ShellCommandResult)v1).getExitCode() != 0) {
                    $i$f$logger = false;
                    v2 = Logger.getInstance(ShellRuntimeContext.class);
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getInstance(...)");
                    v2.warn("Get files command for path '" + adjustedPath + "' failed with exit code " + result.getExitCode() + ", output: " + result.getOutput());
                    return CollectionsKt.emptyList();
                }
                separator = File.separatorChar;
                var8_14 = new String[]{"\n"};
                return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)StringsKt.splitToSequence$default((CharSequence)result.getOutput(), (String[])var8_14, (boolean)false, (int)0, (int)6, null), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getChildFilesExp$lambda$1(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Boolean;)()), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getChildFilesExp$lambda$2(boolean char java.lang.String ), (Ljava/lang/String;)Ljava/lang/Boolean;)((boolean)(onlyDirectories != false), (char)separator)), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getChildFilesExp$lambda$3(java.lang.String char java.lang.String ), (Ljava/lang/String;)Ljava/lang/Boolean;)((String)path, (char)separator)), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getChildFilesExp$lambda$4(char java.lang.String ), (Ljava/lang/String;)Lorg/jetbrains/plugins/terminal/block/completion/spec/impl/ShellFileInfoImpl;)((char)separator)));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final boolean getChildFilesReworked$lambda$0(boolean $onlyDirectories, ShellFileInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !$onlyDirectories || it.getType() == ShellFileInfo.Type.DIRECTORY;
    }

    private static final boolean getChildFilesExp$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !StringsKt.isBlank((CharSequence)it);
    }

    private static final boolean getChildFilesExp$lambda$2(boolean $onlyDirectories, char $separator, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !$onlyDirectories || StringsKt.endsWith$default((CharSequence)it, (char)$separator, (boolean)false, (int)2, null);
    }

    private static final boolean getChildFilesExp$lambda$3(String $path, char $separator, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((CharSequence)$path).length() == 0 || !Intrinsics.areEqual((Object)it, (Object)("." + $separator)) && !Intrinsics.areEqual((Object)it, (Object)(".." + $separator));
    }

    private static final ShellFileInfoImpl getChildFilesExp$lambda$4(char $separator, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ShellFileInfo.Type type = StringsKt.endsWith$default((CharSequence)it, (char)$separator, (boolean)false, (int)2, null) ? ShellFileInfo.Type.DIRECTORY : ShellFileInfo.Type.FILE;
        return new ShellFileInfoImpl(StringsKt.removeSuffix((String)it, (CharSequence)String.valueOf($separator)), type);
    }

    public static final /* synthetic */ Object access$getChildFilesReworked(ShellRuntimeContext $receiver, String path, boolean onlyDirectories, Continuation $completion) {
        return ShellRuntimeContextExtensionsKt.getChildFilesReworked($receiver, path, onlyDirectories, (Continuation<? super List<? extends ShellFileInfo>>)$completion);
    }

    public static final /* synthetic */ Object access$getChildFilesExp(ShellRuntimeContext $receiver, String path, boolean onlyDirectories, Continuation $completion) {
        return ShellRuntimeContextExtensionsKt.getChildFilesExp($receiver, path, onlyDirectories, (Continuation<? super List<? extends ShellFileInfo>>)$completion);
    }

    static {
        Key key = Key.create((String)"Project");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        PROJECT_KEY = key;
        Key key2 = Key.create((String)"isReworked");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        IS_REWORKED_KEY = key2;
    }
}

