/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common.ddl.model;

import com.intellij.liquibase.common.ddl.model.JTable;
import java.util.ArrayList;
import java.util.List;
import liquibase.structure.core.ForeignKeyConstraintType;

public class JForeignKey {
    private final String name;
    private final JTable primaryKeyTable;
    private final JTable foreignKeyTable;
    private final ForeignKeyConstraintType onDeleteAction;
    private final List<String> foreignKeyColumns = new ArrayList<String>();
    private final List<String> primaryKeyColumn = new ArrayList<String>();

    public JForeignKey(String name, JTable primaryKeyTable, JTable foreignKeyTable, ForeignKeyConstraintType onDeleteAction) {
        this.name = name;
        this.primaryKeyTable = primaryKeyTable;
        this.foreignKeyTable = foreignKeyTable;
        this.onDeleteAction = onDeleteAction;
    }

    public JForeignKey(String name, JTable primaryKeyTable, JTable foreignKeyTable) {
        this.name = name;
        this.primaryKeyTable = primaryKeyTable;
        this.foreignKeyTable = foreignKeyTable;
        this.onDeleteAction = ForeignKeyConstraintType.importedKeyNoAction;
    }

    public String getName() {
        return this.name;
    }

    public JTable getPrimaryKeyTable() {
        return this.primaryKeyTable;
    }

    public JTable getForeignKeyTable() {
        return this.foreignKeyTable;
    }

    public List<String> getForeignKeyColumns() {
        return this.foreignKeyColumns;
    }

    public List<String> getPrimaryKeyColumns() {
        return this.primaryKeyColumn;
    }

    public ForeignKeyConstraintType getOnDeleteAction() {
        return this.onDeleteAction;
    }
}

