/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.core.backend;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class PsiClassModificationHelper {
    private final PsiElementFactory elementFactory;

    public PsiClassModificationHelper(Project project) {
        this.elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
    }

    public static PsiClassModificationHelper getInstance(Project project) {
        return (PsiClassModificationHelper)project.getService(PsiClassModificationHelper.class);
    }

    public boolean removeInterface(PsiClass entityClass, String fqn) {
        PsiReferenceList implementsList = entityClass.isInterface() ? entityClass.getExtendsList() : entityClass.getImplementsList();
        if (implementsList == null) {
            return false;
        }
        for (PsiJavaCodeReferenceElement referenceElement : implementsList.getReferenceElements()) {
            if (!Objects.equals(fqn, referenceElement.getQualifiedName())) continue;
            referenceElement.delete();
            break;
        }
        return true;
    }

    @Nullable
    public PsiElement addInterface(PsiClass entityClass, String fqn) {
        PsiReferenceList implementsList = entityClass.isInterface() ? entityClass.getExtendsList() : entityClass.getImplementsList();
        if (implementsList == null) {
            return null;
        }
        if (InheritanceUtil.isInheritor((PsiClass)entityClass, (boolean)true, (String)fqn)) {
            return null;
        }
        PsiJavaCodeReferenceElement createdRefElement = this.elementFactory.createFQClassNameReferenceElement(fqn, entityClass.getResolveScope());
        return implementsList.add((PsiElement)createdRefElement);
    }

    @Nullable
    public PsiElement addSuperclass(PsiClass ownerClass, String superclassFqn) {
        PsiReferenceList extendsList = ownerClass.getExtendsList();
        if (extendsList == null) {
            return null;
        }
        if (InheritanceUtil.isInheritor((PsiClass)ownerClass, (boolean)true, (String)superclassFqn)) {
            return null;
        }
        PsiJavaCodeReferenceElement createdRefElement = this.elementFactory.createFQClassNameReferenceElement(superclassFqn, ownerClass.getResolveScope());
        return extendsList.add((PsiElement)createdRefElement);
    }

    public boolean removeSuperclass(PsiClass ownerClass, String superclassFqn) {
        PsiReferenceList extendsList = ownerClass.getExtendsList();
        if (extendsList == null) {
            return false;
        }
        for (PsiJavaCodeReferenceElement referenceElement : extendsList.getReferenceElements()) {
            if (!Objects.equals(superclassFqn, referenceElement.getQualifiedName())) continue;
            referenceElement.delete();
            break;
        }
        return true;
    }
}

