/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.descriptor;

import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.model.xml.JavaeeDomModelElement;
import com.intellij.javaee.oss.descriptor.JavaeeDescriptor;
import com.intellij.javaee.oss.server.JavaeeIntegration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ClassMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaeeDescriptorsManager {
    private static final Logger LOG = Logger.getInstance(JavaeeDescriptorsManager.class);
    private final ClassMap<JavaeeDescriptor> myRootElementClass2Descriptor;
    private final JavaeeIntegration myIntegration;

    public JavaeeDescriptorsManager(JavaeeIntegration integration) {
        this.myIntegration = integration;
        this.myRootElementClass2Descriptor = new ClassMap();
    }

    public Collection<JavaeeDescriptor> getItems() {
        return this.myRootElementClass2Descriptor.values();
    }

    public void addItem(@NotNull Class<? extends JavaeeDescriptor> descriptorClass, @NotNull Class<? extends JavaeeDomModelElement> rootElementClass, @NonNls String rootTagName) {
        if (descriptorClass == null) {
            JavaeeDescriptorsManager.$$$reportNull$$$0(0);
        }
        if (rootElementClass == null) {
            JavaeeDescriptorsManager.$$$reportNull$$$0(1);
        }
        try {
            Constructor<? extends JavaeeDescriptor> descriptorConstructor = descriptorClass.getConstructor(JavaeeIntegration.class, Class.class, String.class);
            JavaeeDescriptor descriptor = descriptorConstructor.newInstance(new Object[]{this.myIntegration, rootElementClass, rootTagName});
            this.myRootElementClass2Descriptor.put(rootElementClass, (Object)descriptor);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOG.error((Throwable)e);
        }
    }

    public JavaeeDescriptor getItem(Class<? extends JavaeeDomModelElement> rootClass) {
        return (JavaeeDescriptor)this.myRootElementClass2Descriptor.get(rootClass);
    }

    @Nullable
    public <T extends JavaeeDomModelElement> T getRootElement(Class<T> rootClass, JavaeeFacet f) {
        return (T)((JavaeeDomModelElement)this.getItem(rootClass).getRoot(f, rootClass));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "descriptorClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "rootElementClass";
                break;
            }
        }
        objectArray[1] = "com/intellij/javaee/oss/descriptor/JavaeeDescriptorsManager";
        objectArray[2] = "addItem";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

