/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs;

import com.intellij.kubernetes.logs.KubernetesContextLog;
import com.intellij.openapi.diagnostic.Logger;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "prettyFormatInstant", "", "time", "Ljava/time/Instant;", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nKubernetesContextLogsModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesContextLogsModel.kt\ncom/intellij/kubernetes/logs/KubernetesContextLogsModelKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,149:1\n13#2:150\n*S KotlinDebug\n*F\n+ 1 KubernetesContextLogsModel.kt\ncom/intellij/kubernetes/logs/KubernetesContextLogsModelKt\n*L\n21#1:150\n*E\n"})
public final class KubernetesContextLogsModelKt {
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final String prettyFormatInstant(@NotNull Instant time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        String string = DateTimeFormatter.ofPattern("yyyy-MM-dd  HH:mm:ss").withZone(ZoneId.systemDefault()).format(time);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(KubernetesContextLog.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

