/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.transformations.singleton.ImplKt;

public final class NewInstanceOfSingletonInspection
extends BaseInspection {
    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(this){

            @Override
            public void visitNewExpression(@NotNull GrNewExpression newExpression) {
                if (newExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (newExpression.getArrayDeclaration() != null) {
                    return;
                }
                GrCodeReferenceElement refElement = newExpression.getReferenceElement();
                if (refElement == null) {
                    return;
                }
                PsiElement resolved = refElement.resolve();
                if (!(resolved instanceof GrTypeDefinition)) {
                    return;
                }
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)((GrTypeDefinition)resolved), (String[])new String[]{"groovy.lang.Singleton"});
                if (annotation == null) {
                    return;
                }
                this.registerError((PsiElement)newExpression, GroovyBundle.message("new.instance.of.singleton", new Object[0]), (LocalQuickFix[])ContainerUtil.ar((Object[])new ReplaceWithInstanceAccessFix[]{new ReplaceWithInstanceAccessFix()}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression", "org/jetbrains/plugins/groovy/codeInspection/bugs/NewInstanceOfSingletonInspection$1", "visitNewExpression"));
            }
        };
    }

    private static class ReplaceWithInstanceAccessFix
    extends PsiUpdateModCommandQuickFix {
        private ReplaceWithInstanceAccessFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = GroovyBundle.message("replace.new.expression.with.instance.access", new Object[0]);
            if (string == null) {
                ReplaceWithInstanceAccessFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                ReplaceWithInstanceAccessFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ReplaceWithInstanceAccessFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ReplaceWithInstanceAccessFix.$$$reportNull$$$0(3);
            }
            if (!(element instanceof GrNewExpression)) {
                return;
            }
            GrNewExpression newExpression = (GrNewExpression)element;
            GrCodeReferenceElement refElement = newExpression.getReferenceElement();
            if (refElement == null) {
                return;
            }
            PsiElement resolved = refElement.resolve();
            if (!(resolved instanceof GrTypeDefinition)) {
                return;
            }
            GrTypeDefinition singleton = (GrTypeDefinition)resolved;
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)singleton, (String[])new String[]{"groovy.lang.Singleton"});
            if (annotation == null) {
                return;
            }
            String qualifiedName = singleton.getQualifiedName();
            if (qualifiedName == null) {
                return;
            }
            String propertyName = ImplKt.getPropertyName(annotation);
            GrExpression instanceRef = GroovyPsiElementFactory.getInstance(project).createExpressionFromText(qualifiedName + "." + propertyName);
            GrExpression replaced = newExpression.replaceWithExpression(instanceRef, true);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)replaced);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/bugs/NewInstanceOfSingletonInspection$ReplaceWithInstanceAccessFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/bugs/NewInstanceOfSingletonInspection$ReplaceWithInstanceAccessFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

