/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson.notification;

import com.intellij.javascript.nodejs.npm.InstallNodeLocalDependenciesAction;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.notification.Notification;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageJsonSeveralFilesAction
extends DumbAwareAction {
    private final Project myProject;
    private final List<VirtualFile> myPackageJsonFiles;
    private final Notification myNotification;

    public PackageJsonSeveralFilesAction(@NotNull Project project, @NotNull List<VirtualFile> packageJsonFiles, @NotNull Notification notification) {
        if (project == null) {
            PackageJsonSeveralFilesAction.$$$reportNull$$$0(0);
        }
        if (packageJsonFiles == null) {
            PackageJsonSeveralFilesAction.$$$reportNull$$$0(1);
        }
        if (notification == null) {
            PackageJsonSeveralFilesAction.$$$reportNull$$$0(2);
        }
        super(JavaScriptBundle.messagePointer((String)"action.view.install.text", (Object[])new Object[0]));
        this.myProject = project;
        this.myPackageJsonFiles = packageJsonFiles;
        this.myNotification = notification;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            PackageJsonSeveralFilesAction.$$$reportNull$$$0(3);
        }
        this.myNotification.expire();
        new MyDialog().show();
    }

    @NotNull
    private CheckBoxList<VirtualFile> createPanel() {
        CheckBoxList list = new CheckBoxList();
        for (VirtualFile packageJson : this.myPackageJsonFiles) {
            String presentablePath = JsbtUtil.getRelativePath(this.myProject, packageJson);
            list.addItem((Object)packageJson, presentablePath, true);
        }
        list.setSelectionMode(2);
        ListSpeedSearch.installOn((JList)list, checkbox -> checkbox.getText());
        list.setPreferredSize(new Dimension(JBUIScale.scale((int)450), JBUIScale.scale((int)400)));
        CheckBoxList checkBoxList = list;
        if (checkBoxList == null) {
            PackageJsonSeveralFilesAction.$$$reportNull$$$0(4);
        }
        return checkBoxList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonFiles";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/notification/PackageJsonSeveralFilesAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/notification/PackageJsonSeveralFilesAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private class MyDialog
    extends DialogWrapper {
        private final CheckBoxList<VirtualFile> myList;

        protected MyDialog() {
            super(PackageJsonSeveralFilesAction.this.myProject);
            this.setTitle(JavaScriptBundle.message((String)"dialog.title.missing.dependencies", (Object[])new Object[0]));
            this.myList = PackageJsonSeveralFilesAction.this.createPanel();
            this.setOKButtonText(JavaScriptBundle.message((String)"button.install.update", (Object[])new Object[0]));
            this.init();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myList;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myList;
        }

        protected void doOKAction() {
            super.doOKAction();
            InstallNodeLocalDependenciesAction.runAndShowConsole(PackageJsonSeveralFilesAction.this.myProject, PackageJsonSeveralFilesAction.this.myPackageJsonFiles);
        }
    }
}

