/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson.notification;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.npm.InstallNodeLocalDependenciesAction;
import com.intellij.javascript.nodejs.packageJson.InstalledDependenciesChangeListener;
import com.intellij.javascript.nodejs.packageJson.NodeJsEnvironmentProvider;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependenciesExternalUpdateManager;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileEditorListener;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.javascript.nodejs.packageJson.UpdateDependenciesActionListener;
import com.intellij.javascript.nodejs.packageJson.notification.EnablePackageJsonMismatchedDependenciesNotificationAction;
import com.intellij.javascript.nodejs.packageJson.notification.PackageJsonDependenciesVerifier;
import com.intellij.javascript.nodejs.packageJson.notification.PackageJsonGetDependenciesAction;
import com.intellij.javascript.nodejs.packageJson.notification.PackageJsonNotifierConfiguration;
import com.intellij.javascript.nodejs.packageJson.notification.PackageJsonSeveralFilesAction;
import com.intellij.javascript.nodejs.packageJson.notification.PackageJsonUpdateNotifier;
import com.intellij.javascript.nodejs.packageJson.notification.PackageJsonUpdateNotifierKt;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonBuildFileManager;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonCommonUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.util.Alarm;
import com.intellij.util.PsiErrorElementUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="PackageJsonUpdateNotifier", storages={@Storage(value="$WORKSPACE_FILE$")})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0010\b\u0001\u0018\u0000 E2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u00020\u0003:\u0004EFGHB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\fJ\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\fH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\f2\u0006\u0010\u001e\u001a\u00020\fH\u0002J\u001e\u0010\u001f\u001a\u00020\u001d2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\f0\"2\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020\u001dH\u0016J\b\u0010&\u001a\u00020\u001dH\u0007J\u000e\u0010'\u001a\u00020\u001dH\u0082@\u00a2\u0006\u0002\u0010(J\u001c\u0010)\u001a\u00020\u001d2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\f0*H\u0082@\u00a2\u0006\u0002\u0010+J\u0010\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020.H\u0002J\u0016\u0010/\u001a\u00020\u001d2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\f00H\u0002J\u0010\u00101\u001a\u0002022\u0006\u0010\u001e\u001a\u00020\fH\u0002J\u000e\u00103\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\fJ\u0006\u00104\u001a\u00020\u001dJ\u0016\u00105\u001a\u00020\u001d2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\f0*H\u0002J\u0016\u00106\u001a\u0002022\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\f0*H\u0002J\u001e\u00107\u001a\u00020\u001d2\u0006\u00108\u001a\u0002092\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\f0*H\u0003J\u0010\u0010:\u001a\u0002022\u0006\u0010\u001e\u001a\u00020\fH\u0007J\u0010\u0010;\u001a\u0002022\u0006\u0010\u001e\u001a\u00020\fH\u0002J\u0010\u0010<\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\fH\u0002J\u0018\u0010=\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010>\u001a\u00020\u000fH\u0002J\u001a\u0010?\u001a\u0002092\u0006\u0010@\u001a\u00020\f2\b\b\u0002\u0010A\u001a\u000202H\u0002J\b\u0010B\u001a\u00020\u0002H\u0016J\u0010\u0010C\u001a\u00020\u001d2\u0006\u0010D\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006I"}, d2={"Lcom/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "dismissedFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "shownNotifications", "", "Lcom/intellij/notification/Notification;", "testShownNotifications", "schedulingAlarm", "Lcom/intellij/util/Alarm;", "scheduledPackageJsonFiles", "Ljava/util/concurrent/LinkedBlockingQueue;", "executor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "packageJsonNotifierConfiguration", "Lcom/intellij/javascript/nodejs/packageJson/notification/PackageJsonNotifierConfiguration;", "getPackageJsonNotifierConfiguration", "()Lcom/intellij/javascript/nodejs/packageJson/notification/PackageJsonNotifierConfiguration;", "onPackageJsonUpdated", "", "packageJson", "scheduleProcessing", "findProjectPackageJson", "packageJsonFiles", "", "delayMillis", "", "dispose", "onProjectOpenedInTests", "onProjectOpened", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "init", "", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "trackOpenedFiles", "packageJsonFileManager", "Lcom/intellij/javascript/nodejs/packageJson/PackageJsonFileManager;", "processPackageJsonFiles", "", "isPackageJsonNotificationSuppressed", "", "enableNotificationForPackageJson", "enableNotificationForAllPackageJsonFiles", "showNotification", "processEnvironmentValue", "showNotificationInUiThread", "packageJsonLink", "", "isNotificationShownInTests", "isNotificationShownFor", "hideNotificationLater", "register", "notification", "createFileLink", "file", "prependContentRootName", "getState", "loadState", "state", "Companion", "PackageJsonDismissAction", "MyNotificationListener", "MyStartupActivity", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nPackageJsonUpdateNotifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageJsonUpdateNotifier.kt\ncom/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,515:1\n60#2,5:516\n60#2,5:523\n75#3:521\n75#3:522\n*S KotlinDebug\n*F\n+ 1 PackageJsonUpdateNotifier.kt\ncom/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier\n*L\n119#1:516,5\n232#1:523,5\n196#1:521\n203#1:522\n*E\n"})
public final class PackageJsonUpdateNotifier
implements PersistentStateComponent<Element>,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final Set<VirtualFile> dismissedFiles;
    @NotNull
    private final Map<VirtualFile, Notification> shownNotifications;
    @TestOnly
    @NotNull
    private final Set<VirtualFile> testShownNotifications;
    @NotNull
    private final Alarm schedulingAlarm;
    @NotNull
    private final LinkedBlockingQueue<VirtualFile> scheduledPackageJsonFiles;
    @NotNull
    private final ExecutorService executor;

    public PackageJsonUpdateNotifier(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
        Set set = Collections.synchronizedSet(new HashSet());
        Intrinsics.checkNotNullExpressionValue(set, (String)"synchronizedSet(...)");
        this.dismissedFiles = set;
        Map map = ContainerUtil.createWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"createWeakValueMap(...)");
        this.shownNotifications = map;
        Set set2 = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"createConcurrentSet(...)");
        this.testShownNotifications = set2;
        this.schedulingAlarm = new Alarm(this.coroutineScope, null, 2, null);
        this.scheduledPackageJsonFiles = new LinkedBlockingQueue();
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"PackageJsonUpdateNotifier", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
        this.executor = executorService;
        PackageJsonDependenciesExternalUpdateManager.Companion.getInstance(this.project).addUpdateActionListener(new UpdateDependenciesActionListener(){

            @Override
            public void updateActionFinished(VirtualFile packageJson) {
                if (packageJson != null) {
                    this.scheduleProcessing(packageJson);
                }
            }
        });
    }

    private final PackageJsonNotifierConfiguration getPackageJsonNotifierConfiguration() {
        Object object = this.project.getService(PackageJsonNotifierConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
        return (PackageJsonNotifierConfiguration)object;
    }

    public final void onPackageJsonUpdated(@NotNull VirtualFile packageJson) {
        Intrinsics.checkNotNullParameter((Object)packageJson, (String)"packageJson");
        Logger $this$debug_u24default$iv = PackageJsonUpdateNotifierKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("checking " + packageJson.getPath(), e$iv);
        }
        Object[] objectArray = new Object[]{new Pair((Object)this, (Object)packageJson)};
        ReadAction.nonBlocking(() -> PackageJsonUpdateNotifier.onPackageJsonUpdated$lambda$1(this, packageJson)).expireWith((Disposable)this).coalesceBy(objectArray).submit((Executor)this.executor).onSuccess(arg_0 -> PackageJsonUpdateNotifier.onPackageJsonUpdated$lambda$3(arg_0 -> PackageJsonUpdateNotifier.onPackageJsonUpdated$lambda$2(this, arg_0), arg_0));
    }

    private final void scheduleProcessing(VirtualFile packageJson) {
        this.scheduleProcessing(SetsKt.setOf((Object)packageJson), 1000L);
    }

    private final VirtualFile findProjectPackageJson(VirtualFile packageJson) {
        VirtualFile projectPackageJson;
        if (this.project.isDisposed()) {
            return null;
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        ProjectFileIndex fileIndex = projectFileIndex;
        if (fileIndex.isInContent(packageJson)) {
            return packageJson;
        }
        VirtualFile nodeModulesDir = NodeModuleSearchUtil.findAncestorNodeModulesDir(packageJson);
        if (nodeModulesDir != null && (projectPackageJson = NodeModuleUtil.findPackageJsonByNodeModules(nodeModulesDir)) != null && fileIndex.isInContent(projectPackageJson)) {
            return projectPackageJson;
        }
        return null;
    }

    private final void scheduleProcessing(Collection<? extends VirtualFile> packageJsonFiles, long delayMillis) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.processPackageJsonFiles((Set<? extends VirtualFile>)new HashSet<VirtualFile>(packageJsonFiles));
            return;
        }
        if (!this.project.isDisposed()) {
            this.schedulingAlarm.cancelAllRequests();
            this.scheduledPackageJsonFiles.addAll(packageJsonFiles);
            this.schedulingAlarm.addRequest(() -> PackageJsonUpdateNotifier.scheduleProcessing$lambda$0(this), delayMillis);
        }
    }

    public void dispose() {
    }

    @TestOnly
    public final void onProjectOpenedInTests() {
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ PackageJsonUpdateNotifier this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = PackageJsonUpdateNotifier.access$onProjectOpened(this.this$0, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object onProjectOpened(Continuation<? super Unit> $completion) {
        if (!($completion instanceof onProjectOpened.1)) ** GOTO lbl-1000
        var4_2 = $completion;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ PackageJsonUpdateNotifier this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return PackageJsonUpdateNotifier.access$onProjectOpened(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var2_5 = this;
                $continuation.L$0 = var2_5;
                $continuation.label = 1;
                v0 = this.getPackageJsonNotifierConfiguration().detectPackageJsonFiles((Continuation<? super List<? extends VirtualFile>>)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl23
            }
            case 1: {
                var2_5 = (PackageJsonUpdateNotifier)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                $continuation.L$0 = null;
                $continuation.label = 2;
                v1 = var2_5.init((List)v0, (Continuation<? super Unit>)$continuation);
                if (v1 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl32
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl32:
                // 2 sources

                v2 = this.project.getMessageBus().connect(this.coroutineScope);
                v3 = PackageJsonFileManager.CHANGES_TOPIC;
                Intrinsics.checkNotNullExpressionValue(v3, (String)"CHANGES_TOPIC");
                v2.subscribe(v3, (Object)(PackageJsonFileManager.PackageJsonChangesListener)LambdaMetafactory.metafactory(null, null, null, (Ljava/util/List;)V, onProjectOpened$lambda$0(com.intellij.javascript.nodejs.packageJson.notification.PackageJsonUpdateNotifier java.util.List ), (Ljava/util/List;)V)((PackageJsonUpdateNotifier)this));
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object init(List<? extends VirtualFile> packageJsonFiles, Continuation<? super Unit> $completion) {
        if (!($completion instanceof init.1)) ** GOTO lbl-1000
        var8_3 = $completion;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ PackageJsonUpdateNotifier this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return PackageJsonUpdateNotifier.access$init(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$serviceAsync$iv = (ComponentManager)this.project;
                $i$f$serviceAsync = 0;
                Intrinsics.checkNotNull((Object)$this$serviceAsync$iv, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
                $continuation.L$0 = packageJsonFiles;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$serviceAsync$iv);
                $continuation.I$0 = $i$f$serviceAsync;
                $continuation.label = 1;
                v0 = ((ComponentManagerEx)$this$serviceAsync$iv).getServiceAsync(PackageJsonFileManager.class, (Continuation)$continuation);
                if (v0 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl30
            }
            case 1: {
                $i$f$serviceAsync = $continuation.I$0;
                $this$serviceAsync$iv = (ComponentManager)$continuation.L$1;
                packageJsonFiles = (List)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl30:
                // 2 sources

                packageJsonFileManager = (PackageJsonFileManager)v0;
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    this.trackOpenedFiles(packageJsonFileManager);
                    return Unit.INSTANCE;
                }
                $this$serviceAsync$iv = (ComponentManager)this.project;
                $i$f$serviceAsync = 0;
                Intrinsics.checkNotNull((Object)$this$serviceAsync$iv, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
                $continuation.L$0 = packageJsonFiles;
                $continuation.L$1 = packageJsonFileManager;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)$this$serviceAsync$iv);
                $continuation.I$0 = $i$f$serviceAsync;
                $continuation.label = 2;
                v1 = ((ComponentManagerEx)$this$serviceAsync$iv).getServiceAsync(PackageJsonBuildFileManager.class, (Continuation)$continuation);
                if (v1 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl54
            }
            case 2: {
                $i$f$serviceAsync = $continuation.I$0;
                $this$serviceAsync$iv = (ComponentManager)$continuation.L$2;
                packageJsonFileManager = (PackageJsonFileManager)$continuation.L$1;
                packageJsonFiles = (List)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl54:
                // 2 sources

                jsonBuildFileManager = (PackageJsonBuildFileManager)v1;
                BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(jsonBuildFileManager, (List<? extends VirtualFile>)packageJsonFiles, packageJsonFileManager, this, null){
                    int label;
                    final /* synthetic */ PackageJsonBuildFileManager $jsonBuildFileManager;
                    final /* synthetic */ List<VirtualFile> $packageJsonFiles;
                    final /* synthetic */ PackageJsonFileManager $packageJsonFileManager;
                    final /* synthetic */ PackageJsonUpdateNotifier this$0;
                    {
                        this.$jsonBuildFileManager = $jsonBuildFileManager;
                        this.$packageJsonFiles = $packageJsonFiles;
                        this.$packageJsonFileManager = $packageJsonFileManager;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.$jsonBuildFileManager.setPackageJsonFilesFromConfiguration(this.$packageJsonFiles);
                                Set<VirtualFile> openPackageJsonFiles = this.$packageJsonFileManager.getFileEditorTracker().getOpenPackageJsonFiles$intellij_javascript_backend();
                                Set set = ContainerUtil.union((Collection)this.$packageJsonFiles, (Collection)openPackageJsonFiles);
                                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"union(...)");
                                PackageJsonUpdateNotifier.access$scheduleProcessing(this.this$0, set, 300L);
                                PackageJsonUpdateNotifier.access$trackOpenedFiles(this.this$0, this.$packageJsonFileManager);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void trackOpenedFiles(PackageJsonFileManager packageJsonFileManager) {
        packageJsonFileManager.getFileEditorTracker().addListener$intellij_javascript_backend(this, new PackageJsonFileEditorListener(this){
            final /* synthetic */ PackageJsonUpdateNotifier this$0;
            {
                this.this$0 = $receiver;
            }

            public void fileOpened(VirtualFile packageJson) {
                Intrinsics.checkNotNullParameter((Object)packageJson, (String)"packageJson");
                PackageJsonUpdateNotifier.access$scheduleProcessing(this.this$0, packageJson);
            }

            public void fileClosed(VirtualFile packageJson) {
                Intrinsics.checkNotNullParameter((Object)packageJson, (String)"packageJson");
                ReadAction.nonBlocking(() -> trackOpenedFiles.1.fileClosed$lambda$0(this.this$0, packageJson)).expireWith((Disposable)this.this$0).submit((Executor)PackageJsonUpdateNotifier.access$getExecutor$p(this.this$0)).onSuccess(arg_0 -> trackOpenedFiles.1.fileClosed$lambda$2(arg_0 -> trackOpenedFiles.1.fileClosed$lambda$1(this.this$0, packageJson, arg_0), arg_0));
            }

            private static final Boolean fileClosed$lambda$0(PackageJsonUpdateNotifier this$0, VirtualFile $packageJson) {
                return PackageJsonUpdateNotifier.access$getPackageJsonNotifierConfiguration(this$0).isEssential($packageJson);
            }

            private static final Unit fileClosed$lambda$1(PackageJsonUpdateNotifier this$0, VirtualFile $packageJson, Boolean essential) {
                if (!essential.booleanValue()) {
                    PackageJsonUpdateNotifier.access$hideNotificationLater(this$0, $packageJson);
                }
                return Unit.INSTANCE;
            }

            private static final void fileClosed$lambda$2(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }
        });
    }

    private final void processPackageJsonFiles(Set<? extends VirtualFile> packageJsonFiles) {
        Logger $this$debug_u24default$iv = PackageJsonUpdateNotifierKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("processPackageJsonFiles " + packageJsonFiles, e$iv);
        }
        ArrayList matchDepsPackageJsons = new ArrayList();
        ReadAction.run(() -> PackageJsonUpdateNotifier.processPackageJsonFiles$lambda$1(this, packageJsonFiles, matchDepsPackageJsons));
        ArrayList<VirtualFile> toShow = new ArrayList<VirtualFile>();
        Iterator iterator = matchDepsPackageJsons.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            VirtualFile packageJson = (VirtualFile)e;
            boolean depsMatched = new PackageJsonDependenciesVerifier(this.project, packageJson).verify();
            if (depsMatched) {
                this.hideNotificationLater(packageJson);
                continue;
            }
            toShow.add(packageJson);
        }
        this.showNotification((List<? extends VirtualFile>)toShow);
    }

    private final boolean isPackageJsonNotificationSuppressed(VirtualFile packageJson) {
        return this.dismissedFiles.contains(packageJson);
    }

    public final void enableNotificationForPackageJson(@NotNull VirtualFile packageJson) {
        Intrinsics.checkNotNullParameter((Object)packageJson, (String)"packageJson");
        this.dismissedFiles.remove(packageJson);
        this.scheduleProcessing(packageJson);
    }

    public final void enableNotificationForAllPackageJsonFiles() {
        List packageJsonFiles = new ArrayList(this.dismissedFiles);
        this.dismissedFiles.clear();
        this.scheduleProcessing(packageJsonFiles, 1000L);
    }

    private final void showNotification(List<? extends VirtualFile> packageJsonFiles) {
        if (packageJsonFiles.isEmpty()) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.testShownNotifications.addAll((Collection<VirtualFile>)packageJsonFiles);
            return;
        }
        if (this.processEnvironmentValue(packageJsonFiles)) {
            return;
        }
        ReadAction.nonBlocking(() -> PackageJsonUpdateNotifier.showNotification$lambda$0(this, packageJsonFiles)).expireWith((Disposable)this).finishOnUiThread(ModalityState.nonModal(), arg_0 -> PackageJsonUpdateNotifier.showNotification$lambda$2(arg_0 -> PackageJsonUpdateNotifier.showNotification$lambda$1(this, packageJsonFiles, arg_0), arg_0)).submit((Executor)this.executor);
        PackageJsonDependenciesExternalUpdateManager.Companion.getInstance(this.project).addInstalledDependenciesChangeListener(new InstalledDependenciesChangeListener(this, packageJsonFiles){
            final /* synthetic */ PackageJsonUpdateNotifier this$0;
            final /* synthetic */ List<VirtualFile> $packageJsonFiles;
            {
                this.this$0 = $receiver;
                this.$packageJsonFiles = $packageJsonFiles;
            }

            public void installedDependenciesChanged() {
                PackageJsonUpdateNotifier.access$scheduleProcessing(this.this$0, this.$packageJsonFiles, 1000L);
            }
        }, this);
    }

    private final boolean processEnvironmentValue(List<? extends VirtualFile> packageJsonFiles) {
        Boolean environmentAction = NodeJsEnvironmentProvider.Companion.getInstallActionFromEnvironment();
        if (environmentAction != null) {
            if (environmentAction.booleanValue()) {
                for (VirtualFile virtualFile : packageJsonFiles) {
                    InstallNodeLocalDependenciesAction.runAndShowConsole(this.project, virtualFile);
                }
            } else {
                this.dismissedFiles.addAll((Collection<VirtualFile>)packageJsonFiles);
            }
            return true;
        }
        return false;
    }

    @RequiresEdt(generateAssertion=false)
    private final void showNotificationInUiThread(String packageJsonLink, List<? extends VirtualFile> packageJsonFiles) {
        NotificationGroup notificationGroup = Companion.getNotificationGroup();
        VirtualFile packageJson = (VirtualFile)CollectionsKt.first(packageJsonFiles);
        if (packageJsonFiles.size() > 1) {
            String string = JavaScriptBundle.message((String)"package_json.install_dependencies.notification.title", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            Object[] objectArray = new Object[]{packageJsonLink, packageJsonFiles.size() - 1};
            String string2 = JavaScriptBundle.message((String)"package_json.install_dependencies_multiple.notification.content", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            Notification notification = notificationGroup.createNotification(string, string2, NotificationType.INFORMATION).setListener((NotificationListener)new MyNotificationListener());
            Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"setListener(...)");
            Notification notification2 = notification;
            notification2.setSuggestionType(true);
            notification2.addAction((AnAction)new PackageJsonSeveralFilesAction(this.project, packageJsonFiles, notification2));
            notification2.addAction((AnAction)new PackageJsonDismissAction((Collection<? extends VirtualFile>)packageJsonFiles));
            notification2.notify(this.project);
        } else {
            if (this.isNotificationShownFor(packageJson)) {
                return;
            }
            VirtualFile nodeModulesDir = NodeModuleUtil.findNodeModulesByPackageJson(packageJson);
            String string = nodeModulesDir == null ? JavaScriptBundle.message((String)"package_json.install_dependencies.notification.title", (Object[])new Object[0]) : JavaScriptBundle.message((String)"package_json.update_dependencies.notification.title", (Object[])new Object[0]);
            Intrinsics.checkNotNull((Object)string);
            String title = string;
            Object[] objectArray = new Object[]{packageJsonLink};
            String string3 = JavaScriptBundle.message((String)"package_json.install_dependencies.notification.content", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            Notification notification = notificationGroup.createNotification(title, string3, NotificationType.INFORMATION).setListener((NotificationListener)new MyNotificationListener());
            Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"setListener(...)");
            Notification notification3 = notification;
            notification3.setSuggestionType(true);
            notification3.addAction((AnAction)new PackageJsonGetDependenciesAction(this.project, packageJson, notification3));
            notification3.addAction((AnAction)new PackageJsonDismissAction((Collection<? extends VirtualFile>)packageJsonFiles));
            notification3.notify(this.project);
            this.register(packageJson, notification3);
        }
    }

    @TestOnly
    public final boolean isNotificationShownInTests(@NotNull VirtualFile packageJson) {
        Intrinsics.checkNotNullParameter((Object)packageJson, (String)"packageJson");
        return this.testShownNotifications.contains(packageJson);
    }

    private final boolean isNotificationShownFor(VirtualFile packageJson) {
        Notification notification = this.shownNotifications.get(packageJson);
        if (notification == null) {
            return false;
        }
        Notification notification2 = notification;
        Balloon balloon = notification2.getBalloon();
        return balloon != null && !balloon.isDisposed();
    }

    private final void hideNotificationLater(VirtualFile packageJson) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.testShownNotifications.remove(packageJson);
            return;
        }
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, packageJson, null){
            int label;
            final /* synthetic */ PackageJsonUpdateNotifier this$0;
            final /* synthetic */ VirtualFile $packageJson;
            {
                this.this$0 = $receiver;
                this.$packageJson = $packageJson;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Notification notification = (Notification)PackageJsonUpdateNotifier.access$getShownNotifications$p(this.this$0).get(this.$packageJson);
                        if (notification != null && !notification.isExpired()) {
                            notification.expire();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void register(VirtualFile packageJson, Notification notification) {
        Balloon balloon = notification.getBalloon();
        if (balloon == null) {
            return;
        }
        Balloon balloon2 = balloon;
        this.shownNotifications.put(packageJson, notification);
        balloon2.addListener(new JBPopupListener(this, packageJson){
            final /* synthetic */ PackageJsonUpdateNotifier this$0;
            final /* synthetic */ VirtualFile $packageJson;
            {
                this.this$0 = $receiver;
                this.$packageJson = $packageJson;
            }

            public void onClosed(LightweightWindowEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                PackageJsonUpdateNotifier.access$getShownNotifications$p(this.this$0).remove(this.$packageJson);
            }
        });
    }

    private final String createFileLink(VirtualFile file, boolean prependContentRootName) {
        String string = HtmlChunk.link((String)file.getPath(), (String)JsbtUtil.getRelativePath(this.project, file, prependContentRootName)).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    static /* synthetic */ String createFileLink$default(PackageJsonUpdateNotifier packageJsonUpdateNotifier, VirtualFile virtualFile, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return packageJsonUpdateNotifier.createFileLink(virtualFile, bl);
    }

    @NotNull
    public Element getState() {
        Element root = new Element("root");
        ArrayList<String> paths = new ArrayList<String>();
        Iterator<VirtualFile> iterator = this.dismissedFiles.iterator();
        while (iterator.hasNext()) {
            VirtualFile file;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            if (!file.isValid()) continue;
            paths.add(file.getPath());
        }
        CollectionsKt.sort((List)paths);
        JDOMExternalizerUtil.addChildrenWithValueAttribute((Element)root, (String)"dismissed", (List)paths);
        return root;
    }

    public void loadState(@NotNull Element state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        List list = JDOMExternalizerUtil.getChildrenValueAttributes((Element)state, (String)"dismissed");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenValueAttributes(...)");
        List paths = list;
        paths = new ArrayList(paths);
        ArrayList<VirtualFile> dismissedFiles = new ArrayList<VirtualFile>();
        Iterator iterator = ((ArrayList)paths).iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            String path2 = (String)iterator2.next();
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path2);
            if (file == null || !file.isValid() || !PackageJsonCommonUtil.isPackageJsonFile((VirtualFile)file)) continue;
            dismissedFiles.add(file);
        }
        this.dismissedFiles.clear();
        this.dismissedFiles.addAll((Collection<VirtualFile>)dismissedFiles);
    }

    private static final VirtualFile onPackageJsonUpdated$lambda$1(PackageJsonUpdateNotifier this$0, VirtualFile $packageJson) {
        return this$0.findProjectPackageJson($packageJson);
    }

    private static final Unit onPackageJsonUpdated$lambda$2(PackageJsonUpdateNotifier this$0, VirtualFile projectPackageJson) {
        if (projectPackageJson != null) {
            this$0.scheduleProcessing(projectPackageJson);
        }
        return Unit.INSTANCE;
    }

    private static final void onPackageJsonUpdated$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void scheduleProcessing$lambda$0(PackageJsonUpdateNotifier this$0) {
        HashSet copy = new HashSet(this$0.scheduledPackageJsonFiles.size());
        this$0.scheduledPackageJsonFiles.drainTo(copy);
        this$0.processPackageJsonFiles(copy);
    }

    private static final void onProjectOpened$lambda$0(PackageJsonUpdateNotifier this$0, List events) {
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        for (PackageJsonFileManager.PackageJsonChangeEvent event : events) {
            if (event.getType() != PackageJsonFileManager.PackageJsonEventType.CREATED && event.getType() != PackageJsonFileManager.PackageJsonEventType.VIRTUAL_FILE_CONTENT_CHANGED) continue;
            VirtualFile virtualFile = event.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
            this$0.onPackageJsonUpdated(virtualFile);
        }
    }

    private static final void processPackageJsonFiles$lambda$1(PackageJsonUpdateNotifier this$0, Set $packageJsonFiles, ArrayList $matchDepsPackageJsons) {
        if (this$0.project.isDisposed()) {
            return;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && !NodeJsInterpreterManager.getInstance(this$0.project).isInterpreterAvailable()) {
            return;
        }
        boolean externalUpdateRunning = PackageJsonDependenciesExternalUpdateManager.Companion.getInstance(this$0.project).isUpdateActionRunning();
        Set<VirtualFile> openPackageJsonFiles = PackageJsonFileManager.getInstance(this$0.project).getFileEditorTracker().getOpenPackageJsonFiles$intellij_javascript_backend();
        PackageJsonNotifierConfiguration packageJsonNotifierConfiguration = this$0.getPackageJsonNotifierConfiguration();
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)this$0.project);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        ProjectFileIndex fileIndex = projectFileIndex;
        for (VirtualFile file : $packageJsonFiles) {
            PackageJsonData data2;
            VirtualFile nodeModulesDir;
            if (!file.isValid() || !packageJsonNotifierConfiguration.isNpmPackageJson(file) || this$0.isPackageJsonNotificationSuppressed(file) || !PackageJsonUpdateNotifierKt.access$isNodeJsPackageJson(file, fileIndex) || (nodeModulesDir = NodeModuleUtil.findNodeModulesByPackageJson(file)) == null && !packageJsonNotifierConfiguration.isEssential(file) && !openPackageJsonFiles.contains(file) || PsiErrorElementUtil.hasErrors((Project)this$0.project, (VirtualFile)file)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)PackageJsonData.getOrCreate(file), (String)"getOrCreate(...)");
            if (data2.getAllDependencies().isEmpty()) continue;
            if (externalUpdateRunning) {
                this$0.hideNotificationLater(file);
                continue;
            }
            if (PackageJsonUpdateNotifier.Companion.isNodeModulesUpdatingExternally(file)) {
                this$0.hideNotificationLater(file);
                continue;
            }
            $matchDepsPackageJsons.add(file);
        }
    }

    private static final String showNotification$lambda$0(PackageJsonUpdateNotifier this$0, List $packageJsonFiles) {
        return PackageJsonUpdateNotifier.createFileLink$default(this$0, (VirtualFile)CollectionsKt.first((List)$packageJsonFiles), false, 2, null);
    }

    private static final Unit showNotification$lambda$1(PackageJsonUpdateNotifier this$0, List $packageJsonFiles, String packageJsonLink) {
        Intrinsics.checkNotNull((Object)packageJsonLink);
        this$0.showNotificationInUiThread(packageJsonLink, $packageJsonFiles);
        return Unit.INSTANCE;
    }

    private static final void showNotification$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final PackageJsonUpdateNotifier getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @NotNull
    public static final NotificationGroup getNotificationGroup() {
        return Companion.getNotificationGroup();
    }

    public static final /* synthetic */ Object access$onProjectOpened(PackageJsonUpdateNotifier $this, Continuation $completion) {
        return $this.onProjectOpened((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$init(PackageJsonUpdateNotifier $this, List packageJsonFiles, Continuation $completion) {
        return $this.init(packageJsonFiles, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ void access$scheduleProcessing(PackageJsonUpdateNotifier $this, Collection packageJsonFiles, long delayMillis) {
        $this.scheduleProcessing(packageJsonFiles, delayMillis);
    }

    public static final /* synthetic */ void access$trackOpenedFiles(PackageJsonUpdateNotifier $this, PackageJsonFileManager packageJsonFileManager) {
        $this.trackOpenedFiles(packageJsonFileManager);
    }

    public static final /* synthetic */ ExecutorService access$getExecutor$p(PackageJsonUpdateNotifier $this) {
        return $this.executor;
    }

    public static final /* synthetic */ PackageJsonNotifierConfiguration access$getPackageJsonNotifierConfiguration(PackageJsonUpdateNotifier $this) {
        return $this.getPackageJsonNotifierConfiguration();
    }

    public static final /* synthetic */ void access$hideNotificationLater(PackageJsonUpdateNotifier $this, VirtualFile packageJson) {
        $this.hideNotificationLater(packageJson);
    }

    public static final /* synthetic */ Map access$getShownNotifications$p(PackageJsonUpdateNotifier $this) {
        return $this.shownNotifications;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u001a\u0010\f\u001a\u00020\r8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000e\u0010\u0003\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier;", "project", "Lcom/intellij/openapi/project/Project;", "isNodeModulesUpdatingExternally", "", "packageJson", "Lcom/intellij/openapi/vfs/VirtualFile;", "notificationGroup", "Lcom/intellij/notification/NotificationGroup;", "getNotificationGroup$annotations", "getNotificationGroup", "()Lcom/intellij/notification/NotificationGroup;", "intellij.javascript.backend"})
    @SourceDebugExtension(value={"SMAP\nPackageJsonUpdateNotifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageJsonUpdateNotifier.kt\ncom/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,515:1\n30#2,2:516\n*S KotlinDebug\n*F\n+ 1 PackageJsonUpdateNotifier.kt\ncom/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier$Companion\n*L\n105#1:516,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PackageJsonUpdateNotifier getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<PackageJsonUpdateNotifier> serviceClass$iv = PackageJsonUpdateNotifier.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (PackageJsonUpdateNotifier)object;
        }

        private final boolean isNodeModulesUpdatingExternally(VirtualFile packageJson) {
            Object object = packageJson.getParent();
            if (object == null || (object = VirtualFileUtil.toNioPathOrNull((VirtualFile)object)) == null) {
                return false;
            }
            Object parent = object;
            return Files.isDirectory(parent.resolve("node_modules").resolve(".staging"), new LinkOption[0]);
        }

        @NotNull
        public final NotificationGroup getNotificationGroup() {
            return PackageJsonUpdateNotifierKt.access$getNotificationGroup("Dependencies from package.json");
        }

        @JvmStatic
        public static /* synthetic */ void getNotificationGroup$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier$MyNotificationListener;", "Lcom/intellij/notification/NotificationListener;", "<init>", "(Lcom/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier;)V", "hyperlinkUpdate", "", "notification", "Lcom/intellij/notification/Notification;", "event", "Ljavax/swing/event/HyperlinkEvent;", "intellij.javascript.backend"})
    private final class MyNotificationListener
    implements NotificationListener {
        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            VirtualFile file;
            Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (Intrinsics.areEqual((Object)event.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED) && (file = LocalFileSystem.getInstance().findFileByPath(event.getDescription())) != null && file.isValid()) {
                FileEditorManager.getInstance((Project)PackageJsonUpdateNotifier.this.project).openFile(file, true);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier$MyStartupActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.javascript.backend"})
    @SourceDebugExtension(value={"SMAP\nPackageJsonUpdateNotifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageJsonUpdateNotifier.kt\ncom/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier$MyStartupActivity\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,515:1\n75#2:516\n*S KotlinDebug\n*F\n+ 1 PackageJsonUpdateNotifier.kt\ncom/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier$MyStartupActivity\n*L\n490#1:516\n*E\n"})
    public static final class MyStartupActivity
    implements ProjectActivity {
        /*
         * Unable to fully structure code
         */
        @Nullable
        public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
            if (!($completion instanceof execute.1)) ** GOTO lbl-1000
            var6_3 = $completion;
            if ((var6_3.label & -2147483648) != 0) {
                var6_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    int I$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ MyStartupActivity this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.execute(null, (Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $this$serviceAsync$iv = (ComponentManager)project;
                    $i$f$serviceAsync = 0;
                    Intrinsics.checkNotNull((Object)$this$serviceAsync$iv, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$serviceAsync$iv);
                    $continuation.I$0 = $i$f$serviceAsync;
                    $continuation.label = 1;
                    v0 = ((ComponentManagerEx)$this$serviceAsync$iv).getServiceAsync(PackageJsonUpdateNotifier.class, (Continuation)$continuation);
                    if (v0 == var7_5) {
                        return var7_5;
                    }
                    ** GOTO lbl30
                }
                case 1: {
                    $i$f$serviceAsync = $continuation.I$0;
                    $this$serviceAsync$iv = (ComponentManager)$continuation.L$1;
                    project = (Project)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl30:
                    // 2 sources

                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                    $continuation.L$1 = null;
                    $continuation.label = 2;
                    v1 = PackageJsonUpdateNotifier.access$onProjectOpened((PackageJsonUpdateNotifier)v0, (Continuation)$continuation);
                    if (v1 == var7_5) {
                        return var7_5;
                    }
                    ** GOTO lbl41
                }
                case 2: {
                    project = (Project)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl41:
                    // 2 sources

                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier$PackageJsonDismissAction;", "Lcom/intellij/notification/NotificationAction;", "packageJsonFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier;Ljava/util/Collection;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "notification", "Lcom/intellij/notification/Notification;", "intellij.javascript.backend"})
    @SourceDebugExtension(value={"SMAP\nPackageJsonUpdateNotifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageJsonUpdateNotifier.kt\ncom/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier$PackageJsonDismissAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,515:1\n1563#2:516\n1634#2,3:517\n*S KotlinDebug\n*F\n+ 1 PackageJsonUpdateNotifier.kt\ncom/intellij/javascript/nodejs/packageJson/notification/PackageJsonUpdateNotifier$PackageJsonDismissAction\n*L\n462#1:516\n462#1:517,3\n*E\n"})
    private final class PackageJsonDismissAction
    extends NotificationAction {
        @NotNull
        private final Collection<VirtualFile> packageJsonFiles;

        public PackageJsonDismissAction(Collection<? extends VirtualFile> packageJsonFiles) {
            Intrinsics.checkNotNullParameter(packageJsonFiles, (String)"packageJsonFiles");
            super(JavaScriptBundle.messagePointer((String)"action.don.t.ask.again.text", (Object[])new Object[0]));
            this.packageJsonFiles = packageJsonFiles;
        }

        /*
         * WARNING - void declaration
         */
        public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
            notification.expire();
            PackageJsonUpdateNotifier.this.dismissedFiles.addAll(this.packageJsonFiles);
            Iterable iterable = this.packageJsonFiles;
            PackageJsonUpdateNotifier packageJsonUpdateNotifier = PackageJsonUpdateNotifier.this;
            boolean $i$f$map = false;
            void var7_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(packageJsonUpdateNotifier.createFileLink((VirtualFile)it, this.packageJsonFiles.size() > 1));
            }
            List paths = (List)destination$iv$iv;
            Object[] objectArray = new Object[]{StringUtil.join((Collection)paths, (String)", "), EnablePackageJsonMismatchedDependenciesNotificationAction.ACTION_NAME.get()};
            String string = JavaScriptBundle.message((String)"package_json.notifications_are_disabled.notification.content", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String content = string;
            PackageJsonUpdateNotifierKt.access$getLogOnlyNotificationGroup().createNotification(content, NotificationType.INFORMATION).setListener((NotificationListener)new MyNotificationListener()).notify(PackageJsonUpdateNotifier.this.project);
        }
    }
}

