/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.scale;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.function.Function;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.DiscreteTransform;
import org.jetbrains.letsPlot.core.plot.base.ScaleMapper;
import org.jetbrains.letsPlot.core.plot.base.scale.breaks.QuantizeScale;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001,B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0004\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\n\u001a\u0002H\u000b\u00a2\u0006\u0002\u0010\fJ7\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0004\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u00112\b\u0010\u0012\u001a\u0004\u0018\u0001H\u000b\u00a2\u0006\u0002\u0010\u0013J*\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005J\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0004\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\u001a\u001a\u00020\u001bJ3\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00052\b\u0010 \u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010!J&\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u00172\b\b\u0002\u0010#\u001a\u00020$J$\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0005J\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010&\u001a\u00020\u0005J\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u0005J7\u0010(\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0004\"\u0004\b\u0000\u0010\u000b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00172\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000b0)2\u0006\u0010\u0012\u001a\u0002H\u000b\u00a2\u0006\u0002\u0010*J\u0012\u0010+\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0004\"\u0004\b\u0000\u0010\u000bR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006-"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/Mappers;", "", "()V", "IDENTITY", "Lorg/jetbrains/letsPlot/core/plot/base/ScaleMapper;", "", "getIDENTITY", "()Lorg/jetbrains/letsPlot/core/plot/base/ScaleMapper;", "NUMERIC_UNDEFINED", "getNUMERIC_UNDEFINED", "constant", "T", "(Ljava/lang/Object;)Lorg/jetbrains/letsPlot/core/plot/base/ScaleMapper;", "discrete", "discreteTransform", "Lorg/jetbrains/letsPlot/core/plot/base/DiscreteTransform;", "outputValues", "", "defaultOutputValue", "(Lorg/jetbrains/letsPlot/core/plot/base/DiscreteTransform;Ljava/util/List;Ljava/lang/Object;)Lorg/jetbrains/letsPlot/core/plot/base/ScaleMapper;", "discreteToContinuous", "transformedDomain", "outputRange", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "naValue", "emptyDataMapper", "label", "", "linear", "domain", "rangeLow", "rangeHigh", "defaultValue", "(Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;DDLjava/lang/Double;)Lorg/jetbrains/letsPlot/core/plot/base/ScaleMapper;", "range", "reverse", "", "mul", "factor", "rangeSpan", "quantized", "", "(Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;Ljava/util/Collection;Ljava/lang/Object;)Lorg/jetbrains/letsPlot/core/plot/base/ScaleMapper;", "undefined", "QuantizedFun", "plot-base"})
@SourceDebugExtension(value={"SMAP\nMappers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Mappers.kt\norg/jetbrains/letsPlot/core/plot/base/scale/Mappers\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,151:1\n1#2:152\n*E\n"})
public final class Mappers {
    @NotNull
    public static final Mappers INSTANCE = new Mappers();
    @NotNull
    private static final ScaleMapper<Double> IDENTITY = new ScaleMapper<Double>(){

        @Nullable
        public Double invoke(@Nullable Double v) {
            return v;
        }
    };
    @NotNull
    private static final ScaleMapper<Double> NUMERIC_UNDEFINED = INSTANCE.undefined();

    private Mappers() {
    }

    @NotNull
    public final ScaleMapper<Double> getIDENTITY() {
        return IDENTITY;
    }

    @NotNull
    public final ScaleMapper<Double> getNUMERIC_UNDEFINED() {
        return NUMERIC_UNDEFINED;
    }

    @NotNull
    public final <T> ScaleMapper<T> undefined() {
        return new ScaleMapper<T>(){

            @Nullable
            public T invoke(@Nullable Double v) {
                throw new IllegalStateException("Undefined mapper");
            }
        };
    }

    @NotNull
    public final <T> ScaleMapper<T> emptyDataMapper(@NotNull String label2) {
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
        return new ScaleMapper<T>(label2){
            final /* synthetic */ String $label;
            {
                this.$label = $label;
            }

            @Nullable
            public T invoke(@Nullable Double v) {
                throw new IllegalStateException("Mapper for empty data series '" + this.$label + "' was invoked with arg " + v);
            }
        };
    }

    @NotNull
    public final <T> ScaleMapper<T> constant(T constant2) {
        return new ScaleMapper<T>(constant2){
            final /* synthetic */ T $constant;
            {
                this.$constant = $constant;
            }

            @Nullable
            public T invoke(@Nullable Double v) {
                return this.$constant;
            }
        };
    }

    @NotNull
    public final ScaleMapper<Double> mul(@NotNull DoubleSpan domain, double rangeSpan) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        double factor = rangeSpan / domain.getLength();
        return this.mul(factor);
    }

    @NotNull
    public final ScaleMapper<Double> mul(double factor) {
        double d = factor;
        if (!(!Double.isInfinite(d) && !Double.isNaN(d))) {
            boolean bl = false;
            String string = "Can't create mapper with ratio: " + factor;
            throw new IllegalStateException(string.toString());
        }
        return new ScaleMapper<Double>(factor){
            final /* synthetic */ double $factor;
            {
                this.$factor = $factor;
            }

            @Nullable
            public Double invoke(@Nullable Double v) {
                return v != null ? Double.valueOf(this.$factor * v) : null;
            }
        };
    }

    @NotNull
    public final ScaleMapper<Double> linear(@NotNull DoubleSpan domain, @NotNull DoubleSpan range, boolean reverse) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return this.linear(domain, reverse ? range.getUpperEnd().doubleValue() : range.getLowerEnd().doubleValue(), reverse ? range.getLowerEnd().doubleValue() : range.getUpperEnd().doubleValue(), null);
    }

    public static /* synthetic */ ScaleMapper linear$default(Mappers mappers, DoubleSpan doubleSpan, DoubleSpan doubleSpan2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return mappers.linear(doubleSpan, doubleSpan2, bl);
    }

    @NotNull
    public final ScaleMapper<Double> linear(@NotNull DoubleSpan domain, @NotNull DoubleSpan range, double defaultValue) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return this.linear(domain, range.getLowerEnd(), range.getUpperEnd(), defaultValue);
    }

    @NotNull
    public final ScaleMapper<Double> linear(@NotNull DoubleSpan domain, double rangeLow, double rangeHigh, @Nullable Double defaultValue) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        double slop = (rangeHigh - rangeLow) / (domain.getUpperEnd() - domain.getLowerEnd());
        if (!SeriesUtil.INSTANCE.isFinite(slop)) {
            double v = (rangeHigh - rangeLow) / (double)2 + rangeLow;
            return this.constant(v);
        }
        double intersect = rangeLow - domain.getLowerEnd() * slop;
        return new ScaleMapper<Double>(slop, intersect, defaultValue){
            final /* synthetic */ double $slop;
            final /* synthetic */ double $intersect;
            final /* synthetic */ Double $defaultValue;
            {
                this.$slop = $slop;
                this.$intersect = $intersect;
                this.$defaultValue = $defaultValue;
            }

            @Nullable
            public Double invoke(@Nullable Double v) {
                double d;
                return v != null && !Double.isInfinite(d = v.doubleValue()) && !Double.isNaN(d) ? Double.valueOf(v * this.$slop + this.$intersect) : this.$defaultValue;
            }
        };
    }

    @NotNull
    public final ScaleMapper<Double> discreteToContinuous(@NotNull List<Double> transformedDomain, @NotNull DoubleSpan outputRange, double naValue) {
        Intrinsics.checkNotNullParameter(transformedDomain, (String)"transformedDomain");
        Intrinsics.checkNotNullParameter((Object)outputRange, (String)"outputRange");
        DoubleSpan doubleSpan = DoubleSpan.Companion.encloseAllQ((Iterable<Double>)transformedDomain);
        if (doubleSpan == null) {
            return IDENTITY;
        }
        DoubleSpan dataRange = doubleSpan;
        return this.linear(dataRange, outputRange, naValue);
    }

    @NotNull
    public final <T> ScaleMapper<T> discrete(@NotNull DiscreteTransform discreteTransform, @NotNull List<? extends T> outputValues, @Nullable T defaultOutputValue) {
        Intrinsics.checkNotNullParameter((Object)discreteTransform, (String)"discreteTransform");
        Intrinsics.checkNotNullParameter(outputValues, (String)"outputValues");
        return new ScaleMapper<T>(discreteTransform, defaultOutputValue, outputValues){
            final /* synthetic */ DiscreteTransform $discreteTransform;
            final /* synthetic */ T $defaultOutputValue;
            final /* synthetic */ List<T> $outputValues;
            {
                this.$discreteTransform = $discreteTransform;
                this.$defaultOutputValue = $defaultOutputValue;
                this.$outputValues = $outputValues;
            }

            @Nullable
            public T invoke(@Nullable Double v) {
                Object domainValue;
                Object object = domainValue = this.$discreteTransform.applyInverse(v);
                if (object == null) {
                    return this.$defaultOutputValue;
                }
                Object object2 = object;
                DiscreteTransform discreteTransform = this.$discreteTransform;
                Object it = object2;
                boolean bl = false;
                int index = discreteTransform.indexOf(it);
                return this.$outputValues.get(index % this.$outputValues.size());
            }
        };
    }

    @NotNull
    public final <T> ScaleMapper<T> quantized(@Nullable DoubleSpan domain, @NotNull Collection<? extends T> outputValues, T defaultOutputValue) {
        Intrinsics.checkNotNullParameter(outputValues, (String)"outputValues");
        if (domain == null) {
            return this.constant(defaultOutputValue);
        }
        QuantizeScale<? extends T> quantizer = new QuantizeScale<T>();
        quantizer.domain(domain.getLowerEnd(), domain.getUpperEnd());
        quantizer.range(outputValues);
        QuantizedFun f = new QuantizedFun(quantizer, defaultOutputValue);
        return new ScaleMapper<T>(f){
            final /* synthetic */ QuantizedFun<T> $f;
            {
                this.$f = $f;
            }

            @Nullable
            public T invoke(@Nullable Double v) {
                return this.$f.apply(v);
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u0002H\u00010\u0002B\u001d\b\u0000\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0007J\u0017\u0010\t\u001a\u00028\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u000bR\u0010\u0010\u0006\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/Mappers$QuantizedFun;", "T", "Lorg/jetbrains/letsPlot/commons/intern/function/Function;", "", "myQuantizer", "Lorg/jetbrains/letsPlot/core/plot/base/scale/breaks/QuantizeScale;", "myDefaultOutputValue", "(Lorg/jetbrains/letsPlot/core/plot/base/scale/breaks/QuantizeScale;Ljava/lang/Object;)V", "Ljava/lang/Object;", "apply", "value", "(Ljava/lang/Double;)Ljava/lang/Object;", "plot-base"})
    private static final class QuantizedFun<T>
    implements Function<Double, T> {
        @NotNull
        private final QuantizeScale<T> myQuantizer;
        private final T myDefaultOutputValue;

        public QuantizedFun(@NotNull QuantizeScale<T> myQuantizer, T myDefaultOutputValue) {
            Intrinsics.checkNotNullParameter(myQuantizer, (String)"myQuantizer");
            this.myQuantizer = myQuantizer;
            this.myDefaultOutputValue = myDefaultOutputValue;
        }

        @Override
        public T apply(@Nullable Double value) {
            T t;
            if (!SeriesUtil.INSTANCE.isFinite(value)) {
                t = this.myDefaultOutputValue;
            } else {
                Double d = value;
                Intrinsics.checkNotNull((Object)d);
                t = this.myQuantizer.quantize(d);
            }
            return t;
        }
    }
}

