/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.config;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.remote.SshConnectionConfigPatch;
import com.intellij.ssh.OpenSshLikeHostKeyVerifier;
import com.intellij.ssh.SshHostKeyVerifier;
import com.intellij.ssh.X11Forwarding;
import com.intellij.ssh.config.AuthMethod;
import com.intellij.ssh.config.AuthMethods;
import com.intellij.ssh.config.EnvironmentVariable;
import com.intellij.ssh.config.IdentityAgent;
import com.intellij.ssh.config.OpenSSHConfigUtil;
import com.intellij.ssh.config.OpenSshConfigForwardInfo;
import com.intellij.ssh.config.OpenSshConfigViaToolService;
import com.intellij.ssh.config.ParsingError;
import com.intellij.ssh.config.ProxyJumpOptions;
import com.intellij.ssh.config.ServerAlive;
import com.intellij.ssh.config.SshConfigParseException;
import com.intellij.ssh.config.SshConnectionConfig;
import com.intellij.ssh.config.SshConnectionConfigKt;
import com.intellij.ssh.config.SshProxyConfig;
import com.intellij.ssh.config.ToolResult;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.ProcessKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0003H\u0007\u001a2\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002\u001a,\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0002\u001a;\u0010\u0012\u001a\u00020\u0013*\u0018\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00050\bj\u0002`\u00142\u0006\u0010\u0015\u001a\u00020\u00032\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0002\u0010\u0017\u001a*\u0010\u0018\u001a\u00020\u0003*\u0018\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00050\bj\u0002`\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0002\u001a8\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005*\u0018\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00050\bj\u0002`\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0013H\u0002\u001a:\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005*\u0018\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00050\bj\u0002`\u00142\u0006\u0010\u0015\u001a\u00020\u00032\b\b\u0002\u0010\u001a\u001a\u00020\u0013H\u0002\u001a1\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\u0018\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00050\bj\u0002`\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u001e\u001a\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0003H\u0002\u001a\u001c\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000f2\u0006\u0010$\u001a\u00020\u0003H\u0002\"\u001b\u0010&\u001a\u00020'8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b(\u0010)*0\b\u0002\u0010\u0007\"\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00050\b2\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00050\b\u00a8\u0006,"}, d2={"openSshConfigViaTool", "Lcom/intellij/ssh/config/SshConnectionConfig;", "host", "", "customSshCommand", "", "userHome", "MultiMap", "", "a", "Lcom/intellij/ssh/config/ToolResult;", "initialHost", "timeout", "Ljava/time/Duration;", "a", "Lkotlin/Pair;", "sshGCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "a", "", "Lcom/intellij/ssh/config/MultiMap;", "key", "default", "(Ljava/util/Map;Ljava/lang/String;Ljava/lang/Boolean;)Z", "a", "J", "obligatory", "a", "a", "", "(Ljava/util/Map;Ljava/lang/String;)Ljava/lang/Long;", "a", "Ljava/nio/file/Path;", "path", "a", "Lcom/intellij/ssh/config/OpenSshConfigForwardInfo;", "raw", "a", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "J", "()Lcom/intellij/openapi/diagnostic/Logger;", "LOG$delegate", "Lkotlin/Lazy;", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nOpenSshConfigViaToolService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenSshConfigViaToolService.kt\ncom/intellij/ssh/config/OpenSshConfigViaToolServiceKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Grouping.kt\nkotlin/collections/GroupingKt__GroupingKt\n+ 5 extensions.kt\ncom/intellij/openapi/util/ExtensionsKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,500:1\n1#2:501\n1#2:532\n1#2:551\n1#2:564\n1063#3:502\n80#4,6:503\n22#5,2:509\n26#5,2:520\n60#6,5:511\n67#6,4:516\n13#6:579\n1617#7,9:522\n1869#7:531\n1870#7:533\n1626#7:534\n1011#7,2:535\n1563#7:537\n1634#7,3:538\n1617#7,9:541\n1869#7:550\n1870#7:552\n1626#7:553\n1617#7,9:554\n1869#7:563\n1870#7:565\n1626#7:566\n1563#7:567\n1634#7,3:568\n1563#7:571\n1634#7,3:572\n1563#7:575\n1634#7,3:576\n*S KotlinDebug\n*F\n+ 1 OpenSshConfigViaToolService.kt\ncom/intellij/ssh/config/OpenSshConfigViaToolServiceKt\n*L\n198#1:532\n242#1:551\n267#1:564\n158#1:502\n159#1:503,6\n383#1:509,2\n383#1:520,2\n409#1:511,5\n414#1:516,4\n498#1:579\n198#1:522,9\n198#1:531\n198#1:533\n198#1:534\n218#1:535,2\n238#1:537\n238#1:538,3\n242#1:541,9\n242#1:550\n242#1:552\n242#1:553\n267#1:554,9\n267#1:563\n267#1:565\n267#1:566\n268#1:567\n268#1:568,3\n294#1:571\n294#1:572,3\n299#1:575\n299#1:576,3\n*E\n"})
public final class OpenSshConfigViaToolServiceKt {
    @NotNull
    private static final Lazy LOG$delegate = LazyKt.lazy(OpenSshConfigViaToolServiceKt::a);

    @TestOnly
    @NotNull
    public static final SshConnectionConfig openSshConfigViaTool(@NotNull String host, @Nullable List<String> customSshCommand, @NotNull String userHome) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)userHome, (String)"userHome");
        Duration duration = Duration.ofMinutes(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
        return OpenSshConfigViaToolServiceKt.a(host, customSshCommand, userHome, duration).getResult();
    }

    private static final ToolResult a(String string, List<String> list, String string2, Duration duration) {
        Object object;
        CharSequence charSequence;
        Object object2;
        Object object3;
        int n;
        List<String> list2;
        List<String> list3;
        List<String> list4;
        boolean bl;
        List list5;
        boolean bl2;
        String string3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        Object e;
        Object object10;
        Object object11;
        Object object12;
        GeneralCommandLine generalCommandLine;
        Object object13;
        Object object14;
        Object object15;
        block14: {
            block13: {
                IdentityAgent identityAgent;
                boolean bl3 = false;
                object15 = new ArrayList();
                object14 = (Collection)object15;
                List<String> list6 = list;
                if (list6 == null) {
                    List<String> list7;
                    Object object16 = PathEnvironmentVariableUtil.findInPath((String)"ssh");
                    if (object16 != null && (object16 = ((File)object16).getAbsolutePath()) != null) {
                        object13 = object16;
                        boolean bl4 = false;
                        list7 = CollectionsKt.listOf((Object)object13);
                    } else {
                        list7 = list6 = null;
                    }
                    if (list7 == null) {
                        throw new SshConfigParseException("Can't find 'ssh' tool");
                    }
                }
                Iterable iterable = list6;
                CollectionsKt.addAll((Collection)object14, (Iterable)iterable);
                ((Collection)object15).add("-G");
                ((Collection)object15).add("-vvv");
                ((Collection)object15).add(string);
                generalCommandLine = new GeneralCommandLine((List)object15);
                Pair<String, String> pair = OpenSshConfigViaToolServiceKt.a(string, generalCommandLine, duration);
                object15 = (String)pair.component1();
                object14 = (String)pair.component2();
                object12 = SequencesKt.mapNotNull((Sequence)StringsKt.lineSequence((CharSequence)((CharSequence)object15)), OpenSshConfigViaToolServiceKt::J);
                boolean bl5 = false;
                object12 = (Grouping)new Grouping<Pair<? extends String, ? extends String>, String>(object12){
                    final /* synthetic */ Sequence $this_groupingBy;
                    {
                        this.$this_groupingBy = $receiver;
                    }

                    public Iterator<Pair<? extends String, ? extends String>> sourceIterator() {
                        return this.$this_groupingBy.iterator();
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public Object keyOf(Object element) {
                        Pair pair = (Pair)element;
                        boolean bl = false;
                        String string = (String)pair.component1();
                        String string2 = string.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                        return string2;
                    }
                };
                object11 = new HashMap();
                boolean bl6 = false;
                object10 = object12.sourceIterator();
                while (object10.hasNext()) {
                    e = object10.next();
                    object9 = object12.keyOf(e);
                    object8 = object11.get(object9);
                    if (object8 != null || !object11.containsKey(object9)) {
                        // empty if block
                    }
                    object7 = (Pair)e;
                    SmartList smartList = (SmartList)object8;
                    String cfr_ignored_0 = (String)object9;
                    Object object17 = object9;
                    Map map = object11;
                    boolean bl7 = false;
                    object6 = (String)object7.component2();
                    SmartList smartList2 = smartList;
                    if (smartList2 == null) {
                        smartList2 = new SmartList();
                    }
                    object4 = object5 = smartList2;
                    boolean bl8 = false;
                    object4.add(object6);
                    SmartList smartList3 = object5;
                    map.put(object17, smartList3);
                }
                object13 = object11;
                object12 = new LinkedHashSet();
                object11 = new SshConnectionConfig(string);
                string3 = OpenSshConfigViaToolServiceKt.a((Set<String>)object12, ((SshConnectionConfig)object11).getUser(), () -> OpenSshConfigViaToolServiceKt.a((Map)object13));
                object10 = OpenSshConfigViaToolServiceKt.a((Set<String>)object12, ((SshConnectionConfig)object11).getHost(), () -> OpenSshConfigViaToolServiceKt.J((Map)object13));
                Object object18 = (List)object13.get("identityagent");
                if (object18 != null && (object18 = (String)CollectionsKt.singleOrNull((List)object18)) != null) {
                    object7 = object18;
                    boolean bl9 = false;
                    identityAgent = new IdentityAgent((String)object7);
                } else {
                    identityAgent = null;
                }
                e = identityAgent;
                object9 = OpenSshConfigViaToolServiceKt.a((Set<String>)object12, ((SshConnectionConfig)object11).getAuthMethods(), () -> OpenSshConfigViaToolServiceKt.a((Map)object13, e, string2));
                object8 = OpenSshConfigViaToolServiceKt.a((Set<String>)object12, ((SshConnectionConfig)object11).getCiphers(), () -> OpenSshConfigViaToolServiceKt.X((Map)object13));
                bl2 = OpenSshConfigViaToolServiceKt.a((Set<String>)object12, ((SshConnectionConfig)object11).getCompression(), () -> OpenSshConfigViaToolServiceKt.J((Map)object13));
                object7 = OpenSshConfigViaToolServiceKt.a((Set<String>)object12, ((SshConnectionConfig)object11).getConnectTimeout(), () -> OpenSshConfigViaToolServiceKt.a((Map)object13));
                list5 = OpenSshConfigViaToolServiceKt.a((Set<String>)object12, CollectionsKt.emptyList(), () -> OpenSshConfigViaToolServiceKt.a((Map)object13, (Set)object12));
                bl = OpenSshConfigViaToolServiceKt.a((Set<String>)object12, ((SshConnectionConfig)object11).getForwardAgent(), () -> OpenSshConfigViaToolServiceKt.a((Map)object13));
                list4 = OpenSshConfigViaToolServiceKt.a((Set<String>)object12, ((SshConnectionConfig)object11).getHostKeyAlgorithms(), () -> OpenSshConfigViaToolServiceKt.a((Map)object13));
                object6 = OpenSshConfigViaToolServiceKt.a((Set<String>)object12, ((SshConnectionConfig)object11).getHostKeyVerifier(), () -> OpenSshConfigViaToolServiceKt.a((Map)object13, string2));
                object5 = OpenSshConfigViaToolServiceKt.a((Set<String>)object12, ((SshConnectionConfig)object11).getInitialLocalTcpForwardings(), () -> OpenSshConfigViaToolServiceKt.e((Map)object13));
                object4 = OpenSshConfigViaToolServiceKt.a((Set<String>)object12, ((SshConnectionConfig)object11).getInitialRemoteTcpForwardings(), () -> OpenSshConfigViaToolServiceKt.h((Map)object13));
                list3 = OpenSshConfigViaToolServiceKt.a((Set<String>)object12, ((SshConnectionConfig)object11).getKexAlgorithms(), () -> OpenSshConfigViaToolServiceKt.J((Map)object13));
                list2 = OpenSshConfigViaToolServiceKt.a((Set<String>)object12, ((SshConnectionConfig)object11).getMacs(), () -> OpenSshConfigViaToolServiceKt.b((Map)object13));
                n = ((Number)OpenSshConfigViaToolServiceKt.a((Set<String>)object12, ((SshConnectionConfig)object11).getPort(), () -> OpenSshConfigViaToolServiceKt.a((Map)object13))).intValue();
                boolean bl10 = false;
                object3 = (List)object13.get("proxyjump");
                if (object3 == null || (object3 = (String)CollectionsKt.singleOrNull((List)object3)) == null) break block13;
                object2 = object3;
                boolean bl11 = false;
                ProxyJumpOptions proxyJumpOptions = OpenSSHConfigUtil.parseJump((String)object2);
                object3 = proxyJumpOptions;
                if (proxyJumpOptions != null && (object3 = OpenSSHConfigUtil.toProxyCommand((ProxyJumpOptions)object3)) != null) break block14;
            }
            List list8 = (List)object13.get("proxycommand");
            object3 = list8 != null ? (String)CollectionsKt.singleOrNull((List)list8) : null;
        }
        SshProxyConfig.Command command = (charSequence = (CharSequence)(object = object3)) == null || charSequence.length() == 0 ? null : new SshProxyConfig.Command((String)object);
        ServerAlive serverAlive = OpenSshConfigViaToolServiceKt.a((Set<String>)object12, ((SshConnectionConfig)object11).getServerAlive(), () -> OpenSshConfigViaToolServiceKt.a((Map)object13));
        object2 = OpenSshConfigViaToolServiceKt.a((Set<String>)object12, ((SshConnectionConfig)object11).getX11Forwarding(), () -> OpenSshConfigViaToolServiceKt.a((Map)object13));
        if (!((Collection)object12).isEmpty()) {
            String string4 = "Got errors while was parsing output of `" + generalCommandLine.getCommandLineString() + "`\n";
            String string5 = CollectionsKt.joinToString$default((Iterable)((Iterable)object12), (CharSequence)"\n", (CharSequence)string4, null, (int)0, null, null, (int)60, null);
            string4 = new Attachment[]{new Attachment("stdout.txt", (String)object15), new Attachment("stderr.txt", (String)object14)};
            OpenSshConfigViaToolServiceKt.J().error(string5, (Attachment[])string4);
        }
        SshConnectionConfig sshConnectionConfig = new SshConnectionConfig((AuthMethods)object9, (List<String>)object8, bl2, (Duration)object7, bl, list5, (String)object10, list4, (SshHostKeyVerifier)object6, (IdentityAgent)e, (List<OpenSshConfigForwardInfo>)object5, (List<OpenSshConfigForwardInfo>)object4, list3, list2, n, command, serverAlive, string3, (X11Forwarding)object2);
        String string6 = generalCommandLine.getCommandLineString();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getCommandLineString(...)");
        return new ToolResult(sshConnectionConfig, (String)object15, (String)object14, string6);
    }

    static /* synthetic */ ToolResult openSshConfigViaToolImpl$default(String string, List list, String string2, Duration duration, int n, Object object) {
        if ((n & 4) != 0) {
            String string3 = SystemProperties.getUserHome();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getUserHome(...)");
            string2 = string3;
        }
        return OpenSshConfigViaToolServiceKt.a(string, list, string2, duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Pair<String, String> a(String string, GeneralCommandLine generalCommandLine, Duration duration) {
        StringBuilder stringBuilder;
        Disposable disposable = Disposer.newDisposable((String)("Read ssh_config for " + string + " via OpenSSH"));
        boolean bl = false;
        try {
            StringBuilder stringBuilder2;
            Disposable disposable2 = disposable;
            boolean bl2 = false;
            StringBuilder stringBuilder3 = new StringBuilder();
            Process process = generalCommandLine.createProcess();
            Intrinsics.checkNotNullExpressionValue((Object)process, (String)"createProcess(...)");
            Process process2 = process;
            try {
                String string2;
                boolean bl3;
                Object object;
                Object object2;
                String string3;
                stringBuilder2 = new StringBuilder();
                Integer n = (Integer)CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Integer>, Object>(process2, stringBuilder3, stringBuilder2, duration, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ Process $process;
                    final /* synthetic */ StringBuilder $stdoutBuilder;
                    final /* synthetic */ StringBuilder $stderrBuilder;
                    final /* synthetic */ Duration $timeout;
                    {
                        this.$process = $process;
                        this.$stdoutBuilder = $stdoutBuilder;
                        this.$stderrBuilder = $stderrBuilder;
                        this.$timeout = $timeout;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)this.$process.getInputStream(), (Object)this.$stdoutBuilder), TuplesKt.to((Object)this.$process.getErrorStream(), (Object)this.$stderrBuilder)};
                                for (Pair[] pairArray2 : CollectionsKt.listOf((Object[])pairArray2)) {
                                    InputStream inputStream2 = (InputStream)pairArray2.component1();
                                    StringBuilder stringBuilder = (StringBuilder)pairArray2.component2();
                                    BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(inputStream2, stringBuilder, null){
                                        int label;
                                        final /* synthetic */ InputStream $stream;
                                        final /* synthetic */ StringBuilder $destination;
                                        {
                                            this.$stream = $stream;
                                            this.$destination = $destination;
                                            super(2, $completion);
                                        }

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        public final Object invokeSuspend(Object $result) {
                                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    Closeable closeable = this.$stream;
                                                    Intrinsics.checkNotNull((Object)closeable);
                                                    Comparable<Charset> comparable = Charsets.UTF_8;
                                                    Reader reader = new InputStreamReader((InputStream)closeable, (Charset)comparable);
                                                    int n = 8192;
                                                    closeable = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
                                                    comparable = this.$destination;
                                                    boolean bl = false;
                                                    Closeable closeable2 = closeable;
                                                    int n2 = 8192;
                                                    closeable2 = closeable2 instanceof BufferedReader ? (BufferedReader)closeable2 : new BufferedReader((Reader)closeable2, n2);
                                                    Throwable throwable = null;
                                                    try {
                                                        BufferedReader bufferedReader = (BufferedReader)closeable2;
                                                        boolean bl2 = false;
                                                        Sequence sequence = TextStreamsKt.lineSequence((BufferedReader)bufferedReader);
                                                        boolean bl3 = false;
                                                        for (String string : sequence) {
                                                            Comparable<Charset> comparable2 = comparable;
                                                            synchronized (comparable2) {
                                                                boolean bl4 = false;
                                                                StringBuilder stringBuilder = ((StringBuilder)comparable).append(string).append('\n');
                                                            }
                                                        }
                                                        bufferedReader = Unit.INSTANCE;
                                                    }
                                                    catch (Throwable throwable2) {
                                                        throwable = throwable2;
                                                        throw throwable2;
                                                    }
                                                    finally {
                                                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable);
                                                    }
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (int)2, null);
                                }
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)coroutineScope);
                                this.label = 1;
                                Object object2 = TimeoutKt.withTimeoutOrNull((long)this.$timeout.toMillis(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Integer>, Object>(this.$process, null){
                                    int label;
                                    final /* synthetic */ Process $process;
                                    {
                                        this.$process = $process;
                                        super(2, $completion);
                                    }

                                    /*
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final Object invokeSuspend(Object $result) {
                                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                this.label = 1;
                                                Object object2 = ProcessKt.awaitExit((Process)this.$process, (Continuation)((Continuation)this));
                                                if (object2 != object) return object2;
                                                return object;
                                            }
                                            case 1: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object2 = $result;
                                                return object2;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Integer> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Integer> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
                Comparable<StringBuilder> comparable = stringBuilder2;
                synchronized (comparable) {
                    boolean bl4 = false;
                    String string4 = stringBuilder2.toString();
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 4] lbl21 : MonitorExitStatement: MONITOREXIT : var11_12
                    string3 = string4;
                }
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"synchronized(...)");
                String string5 = string3;
                if (!StringsKt.isBlank((CharSequence)string5)) {
                    object2 = OpenSshConfigViaToolServiceKt.J();
                    comparable = null;
                    boolean bl5 = false;
                    if (object2.isDebugEnabled()) {
                        object = object2;
                        bl3 = false;
                        object.debug("stderr of " + generalCommandLine.getCommandLineString() + ":\n" + string5, (Throwable)((Object)comparable));
                    }
                }
                StringBuilder stringBuilder4 = stringBuilder3;
                synchronized (stringBuilder4) {
                    bl3 = false;
                    String string6 = stringBuilder3.toString();
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 3, 5] lbl44 : MonitorExitStatement: MONITOREXIT : var12_16
                    string2 = string6;
                }
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"synchronized(...)");
                object2 = string2;
                comparable = OpenSshConfigViaToolServiceKt.J();
                boolean bl6 = false;
                if (comparable.isTraceEnabled()) {
                    object = comparable;
                    boolean bl7 = false;
                    object.trace("stdout of " + generalCommandLine.getCommandLineString() + ":\n" + (String)object2);
                }
                Comparable<StringBuilder> comparable2 = comparable = n;
                if (comparable2 == null || (Integer)comparable2 != 0) {
                    if (comparable == null) {
                        String string7 = generalCommandLine.getCommandLineString();
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getCommandLineString(...)");
                        throw new SshConfigParseException(string7, null, string5);
                    }
                    String string8 = generalCommandLine.getCommandLineString();
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getCommandLineString(...)");
                    throw new SshConfigParseException(string8, n, string5);
                }
                stringBuilder2 = TuplesKt.to((Object)object2, (Object)string5);
            }
            finally {
                process2.destroy();
            }
            stringBuilder = stringBuilder2;
        }
        finally {
            if (disposable != null) {
                Disposer.dispose((Disposable)disposable);
            }
        }
        return stringBuilder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean a(Map<String, ? extends List<String>> map, String string, Boolean bl) {
        String string2;
        String string3;
        List<String> list = map.get(string);
        if (list != null && (list = (String)CollectionsKt.singleOrNull(list)) != null) {
            String string4 = ((String)((Object)list)).toLowerCase(Locale.ROOT);
            string3 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string3 = null;
        }
        String string5 = string2 = string3;
        if (string5 != null) {
            switch (string5.hashCode()) {
                case 3521: {
                    if (string2.equals("no")) return false;
                    throw new ParsingError("Value of `" + string + "` is `" + string2 + "`, which is neither `yes`, nor `no`");
                }
                case 119527: {
                    if (string2.equals("yes")) return true;
                    throw new ParsingError("Value of `" + string + "` is `" + string2 + "`, which is neither `yes`, nor `no`");
                }
                case 3569038: {
                    if (string2.equals("true")) return true;
                    throw new ParsingError("Value of `" + string + "` is `" + string2 + "`, which is neither `yes`, nor `no`");
                }
                case 97196323: {
                    if (string2.equals("false")) return false;
                    throw new ParsingError("Value of `" + string + "` is `" + string2 + "`, which is neither `yes`, nor `no`");
                }
            }
            throw new ParsingError("Value of `" + string + "` is `" + string2 + "`, which is neither `yes`, nor `no`");
        }
        Boolean bl2 = bl;
        if (bl2 == null) throw new ParsingError("Value of `" + string + "` is not set, while expected `yes` or `no`");
        boolean bl3 = bl2;
        return bl3;
    }

    static /* synthetic */ boolean yesNo$default(Map map, String string, Boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = null;
        }
        return OpenSshConfigViaToolServiceKt.a((Map<String, ? extends List<String>>)map, string, bl);
    }

    private static final String a(Map<String, ? extends List<String>> map, String string) {
        List<String> list = map.get(string);
        if (list == null || (list = (String)CollectionsKt.singleOrNull(list)) == null) {
            throw new ParsingError("No single `" + string + "` in output");
        }
        return list;
    }

    private static final List<String> J(Map<String, ? extends List<String>> map, String string, boolean bl) {
        char[] cArray;
        List<String> list = map.get(string);
        if (list == null || (list = (String)CollectionsKt.singleOrNull(list)) == null || (list = StringsKt.split$default((CharSequence)((CharSequence)((Object)list)), (char[])(cArray = new char[]{','}), (boolean)false, (int)0, (int)6, null)) == null) {
            List list2;
            List list3 = list2 = CollectionsKt.emptyList();
            boolean bl2 = false;
            list = !bl ? list2 : null;
            if (list == null) {
                throw new ParsingError("No single `" + string + "` in output");
            }
        }
        return list;
    }

    private static final List<String> a(Map<String, ? extends List<String>> map, String string, boolean bl) {
        char[] cArray;
        List<String> list = map.get(string);
        if (list == null || (list = (String)CollectionsKt.singleOrNull(list)) == null || (list = StringsKt.split$default((CharSequence)((CharSequence)((Object)list)), (char[])(cArray = new char[]{' '}), (boolean)false, (int)0, (int)6, null)) == null) {
            List list2;
            List list3 = list2 = CollectionsKt.emptyList();
            boolean bl2 = false;
            list = !bl ? list2 : null;
            if (list == null) {
                throw new ParsingError("No single `" + string + "` in output");
            }
        }
        return list;
    }

    static /* synthetic */ List singleSpaceDelimited$default(Map map, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return OpenSshConfigViaToolServiceKt.a((Map<String, ? extends List<String>>)map, string, bl);
    }

    private static final Long a(Map<String, ? extends List<String>> map, String string) {
        Long l;
        List<String> list;
        block7: {
            block6: {
                list = map.get(string);
                if (list == null || (list = (String)CollectionsKt.singleOrNull(list)) == null) break block6;
                String string2 = ((String)((Object)list)).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                list = string2;
                if (string2 != null) break block7;
            }
            throw new ParsingError("No single `" + string + "` in output");
        }
        List<String> list2 = list;
        if (Intrinsics.areEqual((Object)list2, (Object)"none")) {
            l = null;
        } else {
            Long l2 = StringsKt.toLongOrNull((String)((Object)list2));
            if (l2 == null) {
                throw new ParsingError("Key `" + string + "` doesn't contain a long");
            }
            l = (long)l2;
        }
        return l;
    }

    private static final Path a(String string, String string2) {
        Path path2;
        try {
            Object object;
            if (StringsKt.startsWith$default((String)string, (String)"~/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)string, (String)"~\\", (boolean)false, (int)2, null)) {
                String string3 = string.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                object = string2 + string3;
            } else {
                object = string;
            }
            path2 = Path.of((String)object, new String[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            OpenSshConfigViaToolServiceKt.J().warn("Failed to parse path " + string);
            path2 = null;
        }
        return path2;
    }

    private static final OpenSshConfigForwardInfo a(String string) {
        Object object;
        try {
            OpenSshConfigForwardInfo openSshConfigForwardInfo;
            List list;
            boolean bl = false;
            MatchResult matchResult = new Regex("(?:\\[(.*)]:)?(\\d+) \\[(.*)]:?(\\d+)").matchEntire((CharSequence)string);
            if (matchResult != null && (list = matchResult.getGroupValues()) != null) {
                String string2;
                List list2 = list;
                boolean bl2 = false;
                String string3 = (String)list2.get(1);
                String string4 = (String)list2.get(2);
                String string5 = (String)list2.get(3);
                String string6 = (String)list2.get(4);
                String string7 = string2 = string3;
                boolean bl3 = false;
                String string8 = ((CharSequence)string7).length() > 0 ? string2 : null;
                if (string8 == null) {
                    string8 = "127.0.0.1";
                }
                string7 = string2 = string5;
                int n = Integer.parseInt(string4);
                String string9 = string8;
                bl3 = false;
                boolean bl4 = ((CharSequence)string7).length() > 0;
                String string10 = bl4 ? string2 : null;
                if (string10 == null) {
                    string10 = "127.0.0.1";
                }
                int n2 = Integer.parseInt(string6);
                String string11 = string10;
                int n3 = n;
                String string12 = string9;
                openSshConfigForwardInfo = new OpenSshConfigForwardInfo(string12, n3, string11, n2);
            } else {
                openSshConfigForwardInfo = null;
            }
            object = Result.constructor-impl(openSshConfigForwardInfo);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        OpenSshConfigForwardInfo openSshConfigForwardInfo = (OpenSshConfigForwardInfo)(Result.isFailure-impl((Object)object) ? null : object);
        if (openSshConfigForwardInfo == null) {
            throw new ParsingError("Failed to parse port forwarding `" + string + "`");
        }
        return openSshConfigForwardInfo;
    }

    private static final Pair<String, String> a(String string) {
        Object object = new char[]{'='};
        char[] cArray = object = (Object)StringsKt.split$default((CharSequence)string, (char[])object, (boolean)false, (int)2, (int)2, null);
        boolean bl = false;
        char[] cArray2 = cArray.size() == 2 ? object : null;
        if (cArray2 == null) {
            throw new ParsingError("Failed to find '=' in " + string);
        }
        char[] cArray3 = cArray2;
        String string2 = (String)cArray3.get(0);
        object = (String)cArray3.get(1);
        return TuplesKt.to((Object)string2, (Object)object);
    }

    private static final Logger J() {
        Lazy lazy = LOG$delegate;
        return (Logger)lazy.getValue();
    }

    private static final Pair J(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"line");
        char[] cArray = new char[]{' '};
        List list = StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)2, (int)2, null);
        return switch (list.size()) {
            case 0 -> null;
            case 1 -> TuplesKt.to(list.get(0), (Object)"");
            default -> TuplesKt.to(list.get(0), list.get(1));
        };
    }

    private static final <T> T a(Set<String> set, T t, Function0<? extends T> function0) {
        Object object;
        try {
            object = function0.invoke();
        }
        catch (ParsingError parsingError) {
            Collection collection = set;
            String string = parsingError.getMessage();
            Intrinsics.checkNotNull((Object)string);
            collection.add(string);
            object = t;
        }
        return (T)object;
    }

    private static final String a(Map map) {
        return OpenSshConfigViaToolServiceKt.a((Map<String, ? extends List<String>>)map, "user");
    }

    private static final String J(Map map) {
        return OpenSshConfigViaToolServiceKt.a((Map<String, ? extends List<String>>)map, "hostname");
    }

    private static final AuthMethods a(Map map, IdentityAgent identityAgent, String string) {
        List list;
        List list2 = new ArrayList();
        if (OpenSshConfigViaToolServiceKt.a((Map<String, ? extends List<String>>)map, "gssapiauthentication", (Boolean)false)) {
            ((Collection)list2).add(AuthMethod.GssApi.INSTANCE);
        }
        if (OpenSshConfigViaToolServiceKt.yesNo$default(map, "pubkeyauthentication", null, 2, null)) {
            List list3;
            List list4 = (List)map.get("identityfile");
            if (list4 != null) {
                Iterable iterable = list4;
                boolean bl = false;
                Iterable iterable2 = iterable;
                Collection collection = new ArrayList();
                boolean bl2 = false;
                Iterable iterable3 = iterable2;
                boolean bl3 = false;
                Iterator iterator = iterable3.iterator();
                while (iterator.hasNext()) {
                    Path path2;
                    Object t;
                    Object t2 = t = iterator.next();
                    boolean bl4 = false;
                    String string2 = (String)t2;
                    boolean bl5 = false;
                    if (OpenSshConfigViaToolServiceKt.a(string2, string) == null) continue;
                    boolean bl6 = false;
                    collection.add(path2);
                }
                list3 = (List)collection;
            } else {
                list3 = CollectionsKt.emptyList();
            }
            list = list3;
            IdentityAgent identityAgent2 = identityAgent;
            ((Collection)list2).add(new AuthMethod.PublicKey(list, (identityAgent2 != null ? identityAgent2.getType() : null) == IdentityAgent.Type.NONE ? AuthMethod.PublicKey.Agent.NO : (OpenSshConfigViaToolServiceKt.yesNo$default(map, "identitiesonly", null, 2, null) ? AuthMethod.PublicKey.Agent.ONLY_MENTIONED : AuthMethod.PublicKey.Agent.ALL)));
        }
        if (OpenSshConfigViaToolServiceKt.yesNo$default(map, "passwordauthentication", null, 2, null)) {
            ((Collection)list2).add(AuthMethod.Password.INSTANCE);
        }
        if (OpenSshConfigViaToolServiceKt.yesNo$default(map, "kbdinteractiveauthentication", null, 2, null)) {
            ((Collection)list2).add(AuthMethod.KeyboardInteractive.INSTANCE);
        }
        if (!((Collection)(list = OpenSshConfigViaToolServiceKt.J(map, "preferredauthentications", false))).isEmpty()) {
            list2.removeIf(arg_0 -> OpenSshConfigViaToolServiceKt.a(arg_0 -> OpenSshConfigViaToolServiceKt.a(list, arg_0), arg_0));
            List list5 = list2;
            boolean bl = false;
            if (list5.size() > 1) {
                CollectionsKt.sortWith((List)list5, (Comparator)new Comparator(list){
                    final /* synthetic */ List $preferredAuthentications$inlined;
                    {
                        this.$preferredAuthentications$inlined = list;
                    }

                    public final int compare(T a, T b) {
                        AuthMethod authMethod = (AuthMethod)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(this.$preferredAuthentications$inlined.indexOf(SshConnectionConfigKt.getOpenSshLabel(authMethod)));
                        authMethod = (AuthMethod)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(this.$preferredAuthentications$inlined.indexOf(SshConnectionConfigKt.getOpenSshLabel(authMethod))));
                    }
                });
            }
        }
        return AuthMethods.Companion.create(list2);
    }

    private static final boolean a(List list, AuthMethod authMethod) {
        Intrinsics.checkNotNullParameter((Object)authMethod, (String)"it");
        return !list.contains(SshConnectionConfigKt.getOpenSshLabel(authMethod));
    }

    private static final boolean a(Function1 function1, Object object) {
        return (Boolean)function1.invoke(object);
    }

    private static final List X(Map map) {
        return OpenSshConfigViaToolServiceKt.J(map, "ciphers", true);
    }

    private static final boolean J(Map map) {
        return OpenSshConfigViaToolServiceKt.yesNo$default(map, "compression", null, 2, null);
    }

    private static final Duration a(Map map) {
        Duration duration;
        Long l = OpenSshConfigViaToolServiceKt.a((Map<String, ? extends List<String>>)map, "connecttimeout");
        if (l != null) {
            long l2 = ((Number)l).longValue();
            boolean bl = false;
            duration = Duration.ofSeconds(l2);
        } else {
            duration = null;
        }
        return duration;
    }

    private static final List a(Map map, Set set) {
        Collection collection;
        Object object;
        List list = (List)map.get("sendenv");
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Iterable iterable = list;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t : iterable2) {
            object = (String)t;
            collection = collection2;
            boolean bl3 = false;
            collection.add(new EnvironmentVariable.Inherit((String)object));
        }
        Collection collection3 = (List)collection2;
        List list2 = (List)map.get("setenv");
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        iterable = list2;
        collection = collection3;
        bl = false;
        iterable2 = iterable;
        collection2 = new ArrayList();
        bl2 = false;
        Iterable iterable3 = iterable2;
        boolean bl4 = false;
        object = iterable3.iterator();
        while (object.hasNext()) {
            EnvironmentVariable.Certain certain;
            Object e;
            Object e2 = e = object.next();
            boolean bl5 = false;
            String string = (String)e2;
            boolean bl6 = false;
            if ((EnvironmentVariable.Certain)OpenSshConfigViaToolServiceKt.a(set, null, () -> OpenSshConfigViaToolServiceKt.a(string)) == null) continue;
            boolean bl7 = false;
            collection2.add(certain);
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)collection2));
    }

    private static final EnvironmentVariable.Certain a(String string) {
        Pair<String, String> pair = OpenSshConfigViaToolServiceKt.a(string);
        String string2 = (String)pair.component1();
        String string3 = (String)pair.component2();
        return new EnvironmentVariable.Certain(string2, string3);
    }

    private static final boolean a(Map map) {
        return OpenSshConfigViaToolServiceKt.yesNo$default(map, "forwardagent", null, 2, null);
    }

    private static final List a(Map map) {
        return OpenSshConfigViaToolServiceKt.J(map, "hostkeyalgorithms", true);
    }

    private static final SshHostKeyVerifier a(Map map, String string) {
        boolean bl = false;
        String string2 = "globalknownhostsfile";
        String string3 = "userknownhostsfile";
        Object object = CollectionsKt.plus((Collection)OpenSshConfigViaToolServiceKt.a((Map<String, ? extends List<String>>)map, string3, false), (Iterable)OpenSshConfigViaToolServiceKt.a((Map<String, ? extends List<String>>)map, string2, false));
        Iterable iterable = (Iterable)object;
        boolean bl2 = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl3 = false;
        Iterable iterable3 = iterable2;
        boolean bl4 = false;
        Object object2 = iterable3.iterator();
        while (object2.hasNext()) {
            Path path2;
            Object t;
            Object t2 = t = object2.next();
            boolean bl5 = false;
            String string4 = (String)t2;
            boolean bl6 = false;
            if (OpenSshConfigViaToolServiceKt.a(string4, string) == null) continue;
            boolean bl7 = false;
            collection.add(path2);
        }
        iterable = (List)collection;
        bl2 = false;
        iterable2 = iterable;
        collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        bl3 = false;
        for (Object e : iterable2) {
            object2 = (Path)e;
            Collection collection2 = collection;
            boolean bl8 = false;
            collection2.add(object2.toFile());
        }
        Iterable iterable4 = iterable = (List)collection;
        boolean bl9 = false;
        Iterable iterable5 = !((Collection)iterable4).isEmpty() ? iterable : null;
        if (iterable5 == null) {
            throw new ParsingError("Both `" + string2 + "` and `" + string3 + "` are empty");
        }
        Iterable iterable6 = iterable5;
        boolean bl10 = false;
        string3 = "stricthostkeychecking";
        String string5 = OpenSshConfigViaToolServiceKt.a((Map<String, ? extends List<String>>)map, string3).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
        SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking strictHostKeyChecking = switch (string5) {
            case "yes", "true" -> SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.YES;
            case "ask" -> SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.ASK;
            case "no", "false", "off" -> SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.NO;
            case "accept-new" -> SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.ACCEPT_NEW;
            default -> throw new ParsingError("Unexpected value for `" + string3 + "`: `" + (String)object + "`");
        };
        return new OpenSshLikeHostKeyVerifier((List)iterable6, strictHostKeyChecking, OpenSshConfigViaToolServiceKt.yesNo$default(map, "hashknownhosts", null, 2, null), false, 8, null);
    }

    private static final List e(Map map) {
        List list;
        List list2 = (List)map.get("localforward");
        if (list2 != null) {
            Iterable iterable = list2;
            boolean bl = false;
            Iterable iterable2 = iterable;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean bl2 = false;
            for (Object t : iterable2) {
                String string = (String)t;
                Collection collection2 = collection;
                boolean bl3 = false;
                collection2.add(OpenSshConfigViaToolServiceKt.a(string));
            }
            list = (List)collection;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final List h(Map map) {
        List list;
        List list2 = (List)map.get("remoteforward");
        if (list2 != null) {
            Iterable iterable = list2;
            boolean bl = false;
            Iterable iterable2 = iterable;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean bl2 = false;
            for (Object t : iterable2) {
                String string = (String)t;
                Collection collection2 = collection;
                boolean bl3 = false;
                collection2.add(OpenSshConfigViaToolServiceKt.a(string));
            }
            list = (List)collection;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final List J(Map map) {
        return OpenSshConfigViaToolServiceKt.J(map, "kexalgorithms", true);
    }

    private static final List b(Map map) {
        return OpenSshConfigViaToolServiceKt.J(map, "macs", true);
    }

    private static final int a(Map map) {
        String string = OpenSshConfigViaToolServiceKt.a((Map<String, ? extends List<String>>)map, "port");
        boolean bl = false;
        Integer n = StringsKt.toIntOrNull((String)string);
        if (n == null) {
            throw new ParsingError("Value of `port` is `" + string + "`, which is not a positive integer");
        }
        return n;
    }

    private static final ServerAlive a(Map map) {
        ServerAlive serverAlive;
        String string = "serveralivecountmax";
        String string2 = OpenSshConfigViaToolServiceKt.a((Map<String, ? extends List<String>>)map, string);
        boolean bl = false;
        Integer n = StringsKt.toIntOrNull((String)string2);
        if (n == null) {
            throw new ParsingError("Value of `" + string + " is `" + string2 + "`, which is not an integer");
        }
        int n2 = n;
        String string3 = "serveraliveinterval";
        String string4 = OpenSshConfigViaToolServiceKt.a((Map<String, ? extends List<String>>)map, string3);
        boolean bl2 = false;
        Long l = StringsKt.toLongOrNull((String)string4);
        if (l == null) {
            throw new ParsingError("Value of `" + string3 + " is `" + string4 + "`, which is not an integer");
        }
        long l2 = l;
        if (n2 <= 0 || l2 <= 0L) {
            serverAlive = null;
        } else {
            Duration duration = Duration.ofSeconds(l2);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
            serverAlive = new ServerAlive(duration, n2);
        }
        return serverAlive;
    }

    private static final X11Forwarding a(Map map) {
        return OpenSshConfigViaToolServiceKt.yesNo$default(map, "forwardx11", null, 2, null) ? new X11Forwarding(OpenSshConfigViaToolServiceKt.yesNo$default(map, "forwardx11trusted", null, 2, null), OpenSshConfigViaToolServiceKt.a((Map<String, ? extends List<String>>)map, "xauthlocation"), null, 4, null) : null;
    }

    private static final Logger a() {
        boolean bl = false;
        Logger logger = Logger.getInstance(OpenSshConfigViaToolService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    public static final /* synthetic */ ToolResult access$openSshConfigViaToolImpl(String initialHost, List customSshCommand, String userHome, Duration timeout) {
        return OpenSshConfigViaToolServiceKt.a(initialHost, customSshCommand, userHome, timeout);
    }

    public static final /* synthetic */ Logger access$getLOG() {
        return OpenSshConfigViaToolServiceKt.J();
    }
}

