/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.impl.sshj;

import com.intellij.ssh.impl.sshj.PlatformAuthPublickey;
import com.intellij.ssh.impl.sshj.SshjConnectionUtilKt;
import com.intellij.ssh.impl.sshj.UtilKt;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.Service;
import net.schmizz.sshj.userauth.UserAuth;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.method.AuthMethod;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bJ\"\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J>\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001e2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/ssh/impl/sshj/AuthMethodGroup;", "", "reusable", "", "AuthMethodGroup", "(Z)V", "queue", "Ljava/util/ArrayDeque;", "Lnet/schmizz/sshj/userauth/method/AuthMethod;", "triedReusableMethods", "Ljava/util/IdentityHashMap;", "add", "", "authMethod", "authenticate", "Lcom/intellij/ssh/impl/sshj/AuthMethodGroup$AuthResult;", "briefInfo", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "sshClient", "Lnet/schmizz/sshj/SSHClient;", "username", "", "a", "userAuth", "Lnet/schmizz/sshj/userauth/UserAuth;", "service", "Lnet/schmizz/sshj/Service;", "method", "timeoutMs", "", "AuthResult", "intellij.platform.ssh"})
final class AuthMethodGroup {
    private final boolean reusable;
    @NotNull
    private final ArrayDeque<AuthMethod> queue;
    @NotNull
    private final IdentityHashMap<AuthMethod, Boolean> triedReusableMethods;

    public AuthMethodGroup(boolean reusable) {
        this.reusable = reusable;
        this.queue = new ArrayDeque();
        this.triedReusableMethods = new IdentityHashMap();
    }

    public final void add(@NotNull AuthMethod authMethod) {
        Intrinsics.checkNotNullParameter((Object)authMethod, (String)"authMethod");
        this.queue.add(authMethod);
    }

    @NotNull
    public final AuthResult authenticate(@NotNull StringBuilder briefInfo, @NotNull SSHClient sshClient, @NotNull String username) {
        Intrinsics.checkNotNullParameter((Object)briefInfo, (String)"briefInfo");
        Intrinsics.checkNotNullParameter((Object)sshClient, (String)"sshClient");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        UserAuth userAuth = sshClient.getUserAuth();
        Service service = (Service)Service.class.cast(sshClient.getConnection());
        int n = sshClient.getTransport().getTimeoutMs();
        AuthResult authResult = AuthResult.WASTED;
        while (!((Collection)this.queue).isEmpty() && authResult != AuthResult.SUCCESS && authResult != AuthResult.PARTIAL_SUCCESS) {
            AuthMethod authMethod = this.queue.removeFirst();
            if (!((Map)this.triedReusableMethods).containsKey(authMethod)) {
                PlatformAuthPublickey.ValidationResult validationResult;
                StringBuilder stringBuilder = briefInfo.append("\n  => ");
                Intrinsics.checkNotNull((Object)authMethod);
                stringBuilder.append(SshjConnectionUtilKt.access$getDescriptiveName(authMethod)).append(" (");
                PlatformAuthPublickey platformAuthPublickey = authMethod instanceof PlatformAuthPublickey ? (PlatformAuthPublickey)authMethod : null;
                PlatformAuthPublickey.ValidationResult validationResult2 = validationResult = platformAuthPublickey != null ? platformAuthPublickey.checkValidity() : null;
                authResult = switch (validationResult2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[validationResult2.ordinal()]) {
                    case -1, 1 -> {
                        Intrinsics.checkNotNull((Object)userAuth);
                        yield this.a(userAuth, username, service, authMethod, n, briefInfo);
                    }
                    case 2, 3, 4 -> {
                        briefInfo.append(validationResult.getDescription());
                        yield AuthResult.FAILURE;
                    }
                    default -> throw new NoWhenBranchMatchedException();
                };
                briefInfo.append(")");
                continue;
            }
            authResult = AuthResult.FAILURE;
        }
        return authResult;
    }

    private final AuthResult a(UserAuth userAuth, String string, Service service, AuthMethod authMethod, int n, StringBuilder stringBuilder) {
        AuthResult authResult = AuthResult.FAILURE;
        try {
            if (userAuth.authenticate(string, service, authMethod, n)) {
                stringBuilder.append("success");
                authResult = AuthResult.SUCCESS;
            } else {
                if (userAuth.hadPartialSuccess()) {
                    stringBuilder.append("partial success");
                    this.triedReusableMethods.clear();
                    authResult = AuthResult.PARTIAL_SUCCESS;
                } else {
                    stringBuilder.append("failure");
                }
                StringBuilder stringBuilder2 = stringBuilder.append(", new auth methods allowed by the server: ");
                Collection collection = userAuth.getAllowedMethods();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAllowedMethods(...)");
                stringBuilder2.append(CollectionsKt.joinToString$default((Iterable)collection, null, null, null, (int)0, null, null, (int)63, null));
            }
            if (this.reusable) {
                ((Map)this.triedReusableMethods).put(authMethod, true);
                this.queue.addLast(authMethod);
            } else if (authResult != AuthResult.SUCCESS && authMethod.shouldRetry()) {
                this.queue.addFirst(authMethod);
            }
        }
        catch (UserAuthException userAuthException) {
            UtilKt.getSSHJ_LOG().warn("While was authenticating " + authMethod, (Throwable)userAuthException);
            stringBuilder.append("user auth exception: " + userAuthException.getMessage());
        }
        catch (Throwable throwable) {
            stringBuilder.append("exception: " + throwable.getMessage());
            throw throwable;
        }
        return authResult;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ssh/impl/sshj/AuthMethodGroup$AuthResult;", "", "AuthMethodGroup$AuthResult", "(Ljava/lang/String;I)V", "SUCCESS", "PARTIAL_SUCCESS", "FAILURE", "WASTED", "intellij.platform.ssh"})
    public static final class AuthResult
    extends Enum<AuthResult> {
        public static final /* enum */ AuthResult SUCCESS = new AuthResult();
        public static final /* enum */ AuthResult PARTIAL_SUCCESS = new AuthResult();
        public static final /* enum */ AuthResult FAILURE = new AuthResult();
        public static final /* enum */ AuthResult WASTED = new AuthResult();
        private static final /* synthetic */ AuthResult[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static AuthResult[] values() {
            return (AuthResult[])$VALUES.clone();
        }

        public static AuthResult valueOf(String value) {
            return Enum.valueOf(AuthResult.class, value);
        }

        @NotNull
        public static EnumEntries<AuthResult> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = authResultArray = new AuthResult[]{AuthResult.SUCCESS, AuthResult.PARTIAL_SUCCESS, AuthResult.FAILURE, AuthResult.WASTED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PlatformAuthPublickey.ValidationResult.values().length];
            try {
                nArray[PlatformAuthPublickey.ValidationResult.OK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlatformAuthPublickey.ValidationResult.CORRUPTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlatformAuthPublickey.ValidationResult.EMPTY_PASSWORD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlatformAuthPublickey.ValidationResult.WRONG_PASSPHRASE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

