/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter.blocks;

import com.intellij.embedding.EmbeddingElementType;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSElementTypesImpl;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.flow.FlowJSElementTypesImpl;
import com.intellij.lang.javascript.formatter.JSBlockContext;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.SpacingStrategy;
import com.intellij.lang.javascript.formatter.blocks.SubBlockVisitor;
import com.intellij.lang.javascript.formatter.blocks.alignment.ASTNodeBasedAlignmentFactory;
import com.intellij.lang.javascript.formatter.blocks.alignment.CompositeAlignmentFactory;
import com.intellij.lang.javascript.formatter.blocks.alignment.ES6ImportAlignmentFactory;
import com.intellij.lang.javascript.formatter.blocks.alignment.JSBinaryOperatorAlignmentFactory;
import com.intellij.lang.javascript.formatter.blocks.alignment.JSDefaultParameterValueAlignmentFactory;
import com.intellij.lang.javascript.formatter.blocks.alignment.JSPropertyAlignmentFactory;
import com.intellij.lang.javascript.formatter.blocks.alignment.JSVarStatementAlignmentFactory;
import com.intellij.lang.javascript.formatter.chainedMethods.CallChainBlockBuilder;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.types.JSClassElementTypeBase;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.lang.javascript.types.JSPropertyElementType;
import com.intellij.lang.javascript.types.TypeScriptModuleElementType;
import com.intellij.lang.typescript.BasicTypeScriptElementTypes;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSBlock
extends AbstractBlock {
    public static final TokenSet CALL_CHAIN_DOT_LIKE_TYPES = TokenSet.orSet((TokenSet[])new TokenSet[]{JSElementTypes.REFERENCE_QUALIFIER_DELIMITERS, TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.COLON_COLON})});
    @NotNull
    protected final ASTNode myNode;
    @NotNull
    protected final JSCodeStyleSettings myDialectSettings;
    private final CommonCodeStyleSettings myCommonSettings;
    @Nullable
    private Alignment myAlignment;
    @Nullable
    private final Indent myIndent;
    @Nullable
    private final Wrap myWrap;
    protected final ASTNodeBasedAlignmentFactory mySharedAlignmentFactory;
    private final SpacingStrategy mySpacingStrategy;
    @NotNull
    protected final JSBlockContext myBlockContext;

    public JSBlock(@NotNull ASTNode node, @Nullable Alignment alignment, @Nullable Indent indent, @Nullable Wrap wrap, @NotNull CodeStyleSettings topSettings) {
        if (node == null) {
            JSBlock.$$$reportNull$$$0(0);
        }
        if (topSettings == null) {
            JSBlock.$$$reportNull$$$0(1);
        }
        this(node, alignment, indent, wrap, null, JSBlockContext.createDefault(topSettings));
    }

    public JSBlock(@NotNull ASTNode node, @Nullable Alignment alignment, @Nullable Indent indent, @Nullable Wrap wrap, @Nullable ASTNodeBasedAlignmentFactory sharedAlignmentFactory, @NotNull JSBlockContext jsBlockContext) {
        if (node == null) {
            JSBlock.$$$reportNull$$$0(2);
        }
        if (jsBlockContext == null) {
            JSBlock.$$$reportNull$$$0(3);
        }
        super(node, wrap, alignment);
        this.myAlignment = alignment;
        this.myIndent = indent;
        this.myNode = node;
        this.myWrap = wrap;
        this.myBlockContext = jsBlockContext;
        this.myDialectSettings = jsBlockContext.getDialectSettings();
        this.myCommonSettings = jsBlockContext.getCommonSettings();
        this.mySharedAlignmentFactory = this.getSharedAlignmentFactory(sharedAlignmentFactory, this.myDialectSettings);
        this.mySpacingStrategy = this.myBlockContext.createSpacingStrategy(node);
    }

    public boolean processInjections() {
        return !this.isBuildIndentsOnly();
    }

    @NotNull
    public ASTNode getNode() {
        ASTNode aSTNode = this.myNode;
        if (aSTNode == null) {
            JSBlock.$$$reportNull$$$0(4);
        }
        return aSTNode;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myNode.getTextRange();
        if (textRange == null) {
            JSBlock.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    protected List<Block> buildChildren() {
        List<Block> subBlocks = this.buildChainBlocks();
        if (subBlocks != null) {
            return this.myBlockContext.modifySubBlocksIfNeeded(subBlocks);
        }
        SubBlockVisitor visitor = this.createSubBlockVisitor();
        visitor.visit(this.myNode);
        return this.myBlockContext.modifySubBlocksIfNeeded(visitor.getBlocks());
    }

    protected SubBlockVisitor createSubBlockVisitor() {
        return this.myBlockContext.createSubBlockVisitor(this, this.mySharedAlignmentFactory);
    }

    @Nullable
    private List<Block> buildChainBlocks() {
        IElementType elementType = this.myNode.getElementType();
        if (this.isChainedCallsFormattingSupported() && (elementType == JSElementTypes.CALL_EXPRESSION || elementType == JSElementTypes.BIND_EXPRESSION || JSElementTypes.NEW_EXPRESSIONS.contains(elementType))) {
            CommonCodeStyleSettings commonJsSettings = this.myCommonSettings;
            JSCodeStyleSettings jsSettings = this.myDialectSettings;
            CallChainBlockBuilder builder = new CallChainBlockBuilder(this.myNode, this.mySpacingStrategy, jsSettings.INDENT_CHAINED_CALLS ? Indent.Type.CONTINUATION : Indent.Type.NONE, commonJsSettings.METHOD_CALL_CHAIN_WRAP, commonJsSettings.CALL_PARAMETERS_WRAP, commonJsSettings.PREFER_PARAMETERS_WRAP, commonJsSettings.ALIGN_MULTILINE_CHAINED_METHODS, commonJsSettings.ALIGN_MULTILINE_PARAMETERS_IN_CALLS, jsSettings.CHAINED_CALL_DOT_ON_NEW_LINE, jsSettings.USE_CHAINED_CALLS_GROUP_INDENTS){

                @Override
                protected boolean shouldFlatten(@NotNull IElementType elementType) {
                    if (elementType == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return elementType == JSElementTypes.REFERENCE_EXPRESSION || elementType == JSElementTypes.CALL_EXPRESSION || elementType == JSElementTypes.BIND_EXPRESSION;
                }

                @Override
                protected boolean isLeftParen(@NotNull IElementType elementType) {
                    if (elementType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return elementType == JSTokenTypes.LPAR;
                }

                @Override
                protected boolean isRightParen(@NotNull IElementType elementType) {
                    if (elementType == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return elementType == JSTokenTypes.RPAR;
                }

                @Override
                protected boolean isDot(@NotNull IElementType elementType) {
                    if (elementType == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return CALL_CHAIN_DOT_LIKE_TYPES.contains(elementType);
                }

                @Override
                protected boolean isIdentifier(@NotNull IElementType elementType) {
                    if (elementType == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return JSKeywordSets.IDENTIFIER_NAMES.contains(elementType);
                }

                @Override
                protected boolean isEndOfLineComment(@NotNull IElementType elementType) {
                    if (elementType == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    return elementType == JSTokenTypes.END_OF_LINE_COMMENT;
                }

                @Override
                protected boolean isComment(@NotNull IElementType elementType) {
                    if (elementType == null) {
                        1.$$$reportNull$$$0(6);
                    }
                    return JSElementTypes.COMMENTS.contains(elementType);
                }

                @Override
                protected Block createSubBlock(@NotNull ASTNode node, @NotNull Indent indent) {
                    if (node == null) {
                        1.$$$reportNull$$$0(7);
                    }
                    if (indent == null) {
                        1.$$$reportNull$$$0(8);
                    }
                    return JSBlock.this.myBlockContext.createBlock(node, null, null, indent, JSBlock.this.mySharedAlignmentFactory, null);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "elementType";
                            break;
                        }
                        case 7: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "node";
                            break;
                        }
                        case 8: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "indent";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/lang/javascript/formatter/blocks/JSBlock$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "shouldFlatten";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isLeftParen";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isRightParen";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isDot";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isIdentifier";
                            break;
                        }
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isEndOfLineComment";
                            break;
                        }
                        case 6: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isComment";
                            break;
                        }
                        case 7: 
                        case 8: {
                            objectArray = objectArray2;
                            objectArray2[2] = "createSubBlock";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            return builder.buildBlocks();
        }
        return null;
    }

    protected boolean isChainedCallsFormattingSupported() {
        return false;
    }

    protected ASTNodeBasedAlignmentFactory getSharedAlignmentFactory(@Nullable ASTNodeBasedAlignmentFactory sharedAlignmentFactory, @NotNull JSCodeStyleSettings jsCodeStyleSettings) {
        IElementType nodeType;
        if (jsCodeStyleSettings == null) {
            JSBlock.$$$reportNull$$$0(6);
        }
        if ((nodeType = this.myNode.getElementType()) == JSElementTypes.OBJECT_LITERAL_EXPRESSION || nodeType == JSElementTypes.ARRAY_LITERAL_EXPRESSION) {
            JSPropertyAlignmentFactory propertyAlignmentFactory = new JSPropertyAlignmentFactory(jsCodeStyleSettings, this.myAlignment);
            this.myAlignment = null;
            return propertyAlignmentFactory;
        }
        if (JSElementTypes.DESTRUCTURING_OBJECT == nodeType) {
            JSPropertyAlignmentFactory propertyAlignmentFactory = new JSPropertyAlignmentFactory(jsCodeStyleSettings, this.myAlignment);
            JSVarStatementAlignmentFactory statementAlignmentFactory = new JSVarStatementAlignmentFactory(jsCodeStyleSettings);
            CompositeAlignmentFactory alignmentFactory = new CompositeAlignmentFactory(propertyAlignmentFactory, statementAlignmentFactory);
            this.myAlignment = null;
            return alignmentFactory;
        }
        if (BasicTypeScriptElementTypes.PARAMETER_LISTS.contains(nodeType)) {
            return new JSDefaultParameterValueAlignmentFactory(jsCodeStyleSettings);
        }
        if (nodeType instanceof JSFileElementType || JSElementTypes.BLOCK_STATEMENTS.contains(nodeType) || JSExtendedLanguagesTokenSetProvider.EMBEDDED_CONTENTS.contains(nodeType)) {
            return new CompositeAlignmentFactory(new JSVarStatementAlignmentFactory(jsCodeStyleSettings), new ES6ImportAlignmentFactory(jsCodeStyleSettings));
        }
        if (nodeType == JSElementTypes.BINARY_EXPRESSION) {
            return JSBinaryOperatorAlignmentFactory.getInstance(this.myNode, sharedAlignmentFactory, this.myCommonSettings);
        }
        return sharedAlignmentFactory;
    }

    @Nullable
    public Wrap getWrap() {
        return this.myWrap;
    }

    @Nullable
    public Indent getIndent() {
        return this.myIndent;
    }

    @Nullable
    public Alignment getAlignment() {
        return this.myAlignment;
    }

    @Nullable
    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            JSBlock.$$$reportNull$$$0(7);
        }
        return this.mySpacingStrategy.getSpacing(child1, child2);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        IElementType blockElementType = this.myNode.getElementType();
        if (blockElementType == JSElementTypes.DOC_COMMENT) {
            return new ChildAttributes(Indent.getSpaceIndent((int)1), null);
        }
        Indent indent = this.getChildIndent(newChildIndex);
        Alignment alignment = JSBlock.getChildAlignment(newChildIndex, this.getSubBlocks(), blockElementType);
        return new ChildAttributes(indent, alignment);
    }

    @Nullable
    private Indent getChildIndent(int newChildIndex) {
        IElementType prevElementType;
        IElementType blockElementType = this.myNode.getElementType();
        ASTNode parent = this.myNode.getTreeParent();
        IElementType parentElementType = parent != null ? parent.getElementType() : null;
        JSBlock prevJSBlock = JSBlock.getPreviousJSBlock(this.getSubBlocks(), newChildIndex);
        IElementType iElementType = prevElementType = prevJSBlock != null ? prevJSBlock.getNode().getElementType() : null;
        if (JSElementTypesImpl.ATTRIBUTE_LISTS.contains(blockElementType) || JSElementTypesImpl.ATTRIBUTE_LISTS.contains(prevElementType)) {
            return Indent.getNoneIndent();
        }
        if (JSElementTypes.BLOCK_STATEMENTS.contains(blockElementType)) {
            if (parentElementType == JSElementTypes.INSTANCE.getFUNCTION_DECLARATION() || parentElementType == FlowJSElementTypesImpl.FLOW_JS_FUNCTION) {
                return this.myCommonSettings.METHOD_BRACE_STYLE == 3 ? Indent.getNoneIndent() : Indent.getNormalIndent();
            }
            return this.myCommonSettings.BRACE_STYLE == 3 ? Indent.getNoneIndent() : Indent.getNormalIndent();
        }
        if (blockElementType instanceof JSClassElementTypeBase || blockElementType == JSElementTypes.OBJECT_LITERAL_EXPRESSION || blockElementType == TypeScriptElementTypes.OBJECT_TYPE || blockElementType == JSElementTypes.TYPESCRIPT_ENUM || blockElementType instanceof TypeScriptModuleElementType || blockElementType == JSElementTypes.TYPESCRIPT_TYPE_ALIAS) {
            return Indent.getNormalIndent();
        }
        if (blockElementType instanceof JSFileElementType || blockElementType instanceof EmbeddingElementType || this.myNode.getPsi() instanceof JSFile) {
            return Indent.getNoneIndent();
        }
        if (blockElementType == JSElementTypes.IF_STATEMENT) {
            return Indent.getContinuationIndent();
        }
        if (BasicTypeScriptElementTypes.VAR_STATEMENTS.contains(blockElementType)) {
            if (parentElementType == JSElementTypes.TYPESCRIPT_ENUM) {
                return Indent.getNoneIndent();
            }
            if (!JSBlock.isStatementDocCommentBlock(prevJSBlock)) {
                return Indent.getContinuationIndent();
            }
        } else if (JSElementTypes.EXPORT_DECLARATION == blockElementType || JSElementTypes.NAMED_IMPORTS == blockElementType) {
            return Indent.getContinuationIndent();
        }
        if (JSElementTypes.FUNCTION_EXPRESSIONS.contains(blockElementType) && JSTokenTypes.ARROWS.contains(prevElementType)) {
            return Indent.getContinuationIndent();
        }
        if (JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS.contains(blockElementType) || JSElementTypes.FUNCTION_EXPRESSIONS.contains(blockElementType)) {
            return Indent.getNoneIndent();
        }
        if (blockElementType == JSElementTypes.CALL_EXPRESSION) {
            return this.myDialectSettings.INDENT_CHAINED_CALLS ? null : Indent.getNoneIndent();
        }
        if (blockElementType instanceof JSPropertyElementType) {
            return Indent.getNoneIndent();
        }
        return null;
    }

    @Nullable
    private static Alignment getChildAlignment(int newChildIndex, @NotNull List<Block> subBlocks, @NotNull IElementType blockElementType) {
        int i;
        if (subBlocks == null) {
            JSBlock.$$$reportNull$$$0(8);
        }
        if (blockElementType == null) {
            JSBlock.$$$reportNull$$$0(9);
        }
        Alignment alignment = null;
        for (i = 0; i < newChildIndex && i != subBlocks.size(); ++i) {
            IElementType childType;
            Block subBlock = subBlocks.get(i);
            Alignment childAlignment = subBlock.getAlignment();
            if (childAlignment == null) continue;
            IElementType iElementType = childType = subBlock instanceof JSBlock ? ((JSBlock)subBlock).getNode().getElementType() : null;
            if (blockElementType == JSElementTypes.ARRAY_LITERAL_EXPRESSION && childType == JSTokenTypes.LBRACKET || blockElementType == JSElementTypes.OBJECT_LITERAL_EXPRESSION && childType == JSTokenTypes.LBRACE || childType == JSTokenTypes.END_OF_LINE_COMMENT) break;
            alignment = childAlignment;
            break;
        }
        if (blockElementType == JSElementTypes.FOR_STATEMENT || blockElementType == JSElementTypes.FOR_IN_STATEMENT) {
            for (i = 0; i < newChildIndex; ++i) {
                Block block = subBlocks.get(i);
                if (!(block instanceof JSBlock) || ((JSBlock)block).getNode().getElementType() != JSTokenTypes.RPAR) continue;
                alignment = null;
                break;
            }
        }
        return alignment;
    }

    @Nullable
    private static JSBlock getJSBlockByIndex(@NotNull List<Block> subBlocks, int index) {
        if (subBlocks == null) {
            JSBlock.$$$reportNull$$$0(10);
        }
        if (index < 0 || index >= subBlocks.size()) {
            return null;
        }
        Block prevBlock = subBlocks.get(index);
        return prevBlock instanceof JSBlock ? (JSBlock)prevBlock : null;
    }

    private static boolean isStatementDocCommentBlock(@Nullable JSBlock block) {
        ASTNode parent;
        ASTNode node;
        return block != null && (node = block.getNode()).getElementType() == JSElementTypes.DOC_COMMENT && (parent = node.getTreeParent()) != null && parent.getFirstChildNode() == node;
    }

    public boolean isLeaf() {
        if (this.myNode.getElementType() == JSElementTypes.DOC_COMMENT) {
            return false;
        }
        return this.myNode.getFirstChildNode() == null;
    }

    @Nullable
    static JSBlock getPreviousJSBlock(List<Block> blocks, int newChildIndex) {
        return JSBlock.getJSBlockByIndex(blocks, newChildIndex - 1);
    }

    static Indent calculateIndentInSwitch(@Nullable JSBlock prevBlock, @NotNull CommonCodeStyleSettings commonSettings) {
        ASTNode caseChild;
        Indent indentFromCase;
        boolean indentCase;
        if (commonSettings == null) {
            JSBlock.$$$reportNull$$$0(11);
        }
        Indent defaultIndent = (indentCase = commonSettings.INDENT_CASE_FROM_SWITCH) ? Indent.getNormalIndent() : Indent.getNoneIndent();
        Indent indent = indentFromCase = indentCase ? JSBlock.getIndentWithNormal(commonSettings) : Indent.getNormalIndent();
        if (prevBlock == null) {
            return defaultIndent;
        }
        ASTNode prevNode = prevBlock.getNode();
        if (prevNode.getPsi() instanceof PsiWhiteSpace) {
            prevNode = prevNode.getTreePrev();
        }
        if (prevNode == null) {
            return defaultIndent;
        }
        if (JSExtendedLanguagesTokenSetProvider.CASE_CLAUSES.contains(prevNode.getElementType()) ? (caseChild = prevNode.getLastChildNode()) != null && (caseChild.getElementType() == JSElementTypes.BREAK_STATEMENT || caseChild.getElementType() == JSElementTypes.RETURN_STATEMENT) : prevNode.getElementType() == JSTokenTypes.LBRACE) {
            return defaultIndent;
        }
        return indentFromCase;
    }

    @NotNull
    private static Indent getIndentWithNormal(@NotNull CommonCodeStyleSettings commonSettings) {
        if (commonSettings == null) {
            JSBlock.$$$reportNull$$$0(12);
        }
        CommonCodeStyleSettings.IndentOptions indentOptions = commonSettings.getIndentOptions();
        assert (indentOptions != null);
        Indent indent = Indent.getSpaceIndent((int)(indentOptions.INDENT_SIZE * 2));
        if (indent == null) {
            JSBlock.$$$reportNull$$$0(13);
        }
        return indent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsBlockContext";
                break;
            }
            case 4: 
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/formatter/blocks/JSBlock";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsCodeStyleSettings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subBlocks";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockElementType";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/formatter/blocks/JSBlock";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentWithNormal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 13: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSharedAlignmentFactory";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getChildAlignment";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getJSBlockByIndex";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "calculateIndentInSwitch";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getIndentWithNormal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 13 -> new IllegalStateException(string);
        };
    }
}

