/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.resolve.JSEvaluationLogger;
import com.intellij.lang.javascript.psi.resolve.JSEvaluatorComplexityTracker;
import com.intellij.lang.javascript.psi.resolve.complexity.JSNamedEvaluationTask;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSComplexityAwareRecursionGuard<K> {
    @NotNull
    private final RecursionGuard<K> myDelegate;

    public JSComplexityAwareRecursionGuard(@NotNull @NonNls String id) {
        if (id == null) {
            JSComplexityAwareRecursionGuard.$$$reportNull$$$0(0);
        }
        this.myDelegate = RecursionManager.createGuard((String)id);
    }

    @Nullable
    public <V> V getCachedValue(final @NotNull K place, @NotNull Supplier<@Nullable JSComplexityAwareCachedValue<V>> getValueFromCache, @NotNull @NotNull Consumer<? super @NotNull JSComplexityAwareCachedValue<V>> cacheNewValue, final @NotNull Function<? super K, ? extends V> provider) {
        if (place == null) {
            JSComplexityAwareRecursionGuard.$$$reportNull$$$0(1);
        }
        if (getValueFromCache == null) {
            JSComplexityAwareRecursionGuard.$$$reportNull$$$0(2);
        }
        if (cacheNewValue == null) {
            JSComplexityAwareRecursionGuard.$$$reportNull$$$0(3);
        }
        if (provider == null) {
            JSComplexityAwareRecursionGuard.$$$reportNull$$$0(4);
        }
        JSComplexityAwareCachedValue<V> valueFromCache = getValueFromCache.get();
        JSEvaluatorComplexityTracker complexityTracker = JSEvaluatorComplexityTracker.getDefaultInstance();
        if (valueFromCache != null && valueFromCache.myDepthUsed <= complexityTracker.getAvailableDepth()) {
            complexityTracker.useDepth(valueFromCache.myDepthUsed);
            JSEvaluationLogger.getInstance().cachedValueUsed(valueFromCache.myDepthUsed, place, valueFromCache.getValue());
            return (V)valueFromCache.myValue;
        }
        int ownDepth = JSEvaluatorComplexityTracker.isDepthLimitForced() ? 1 : 0;
        RecursionGuard.StackStamp stamp = RecursionManager.markStack();
        JSComplexityAwareCachedValue value = complexityTracker.runTask(ownDepth, new JSNamedEvaluationTask<V>(){

            @Override
            public V get() {
                return JSComplexityAwareRecursionGuard.this.doPreventingRecursion(place, true, () -> provider.apply(place));
            }

            public String toString() {
                return "Get cached value for " + JSEvaluationLogger.toPresentable(place);
            }
        });
        if (value == null) {
            return null;
        }
        if (stamp.mayCacheNow()) {
            cacheNewValue.accept(value);
        }
        return (V)value.getValue();
    }

    @Nullable
    public <V> V doPreventingRecursion(@NotNull K place, boolean memoize, @NotNull Computable<? extends V> computation) {
        if (place == null) {
            JSComplexityAwareRecursionGuard.$$$reportNull$$$0(5);
        }
        if (computation == null) {
            JSComplexityAwareRecursionGuard.$$$reportNull$$$0(6);
        }
        return (V)this.myDelegate.doPreventingRecursion(place, memoize, computation);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getValueFromCache";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheNewValue";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSComplexityAwareRecursionGuard";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getCachedValue";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "doPreventingRecursion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class JSComplexityAwareCachedValue<K> {
        private final int myDepthUsed;
        private final K myValue;

        public JSComplexityAwareCachedValue(int depthUsed, @Nullable K value) {
            if (depthUsed < 0) {
                throw new IllegalArgumentException("depthUsed = " + depthUsed);
            }
            this.myDepthUsed = depthUsed;
            this.myValue = value;
        }

        @Nullable
        public K getValue() {
            return this.myValue;
        }

        public int getDepthUsed() {
            return this.myDepthUsed;
        }
    }
}

