/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.util.xml.ui;

import com.intellij.javaee.web.util.xml.ui.editors.BasicDomElementEditor;
import com.intellij.javaee.web.util.xml.ui.editors.DomElementEditor;
import com.intellij.javaee.web.util.xml.ui.editors.GenericValueEditor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import java.util.HashMap;
import java.util.Map;

public final class DomElementEditorsFactory {
    private static final Logger LOG = Logger.getInstance((String)DomElementEditorsFactory.class.getName());
    private final Map<Class, Class<? extends DomElementEditor>> myEditorsByClass = new HashMap<Class, Class<? extends DomElementEditor>>();

    public static DomElementEditorsFactory getDomElementEditorsFactory() {
        return DomElementEditorsFactoryHolder.ourInstance;
    }

    private DomElementEditorsFactory() {
        this.registerEditor(GenericDomValue.class, GenericValueEditor.class);
    }

    public DomElementEditor getEditor(Class<? extends DomElement> domElementClass) {
        Class<? extends DomElementEditor> customClass = null;
        for (Class aClass : this.myEditorsByClass.keySet()) {
            if (!aClass.isAssignableFrom(domElementClass)) continue;
            customClass = this.myEditorsByClass.get(aClass);
            break;
        }
        if (customClass != null) {
            try {
                return (DomElementEditor)customClass.newInstance();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        return new BasicDomElementEditor();
    }

    public void registerEditor(Class domElementClass, Class<? extends DomElementEditor> editorClass) {
        this.myEditorsByClass.put(domElementClass, editorClass);
    }

    private static class DomElementEditorsFactoryHolder {
        private static final DomElementEditorsFactory ourInstance = new DomElementEditorsFactory();

        private DomElementEditorsFactoryHolder() {
        }
    }
}

