/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.config.webXml;

import com.intellij.javaee.model.converters.ContextParamsProvider;
import com.intellij.javaee.model.xml.Listener;
import com.intellij.javaee.model.xml.ParamValue;
import com.intellij.javaee.web.WebCommonClassNames;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.model.xml.Filter;
import com.intellij.javaee.web.model.xml.Servlet;
import com.intellij.javaee.web.model.xml.WebApp;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.model.converters.SpringBeanResolveConverterForDefiniteClasses;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.ExtendClass;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.PsiClassConverter;
import com.intellij.util.xml.converters.values.ClassArrayConverter;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringWebContextParamsProvider
extends ContextParamsProvider {
    private static final String CONTEXT_INITIALIZER_CLASSES = "contextInitializerClasses";
    private static final String WEB_APP_ROOT_KEY = "webAppRootKey";
    private static final Set<String> SERVLET_PARAM_NAMES = Set.of("contextConfigLocation", "contextClass", "contextInitializerClasses", "namespace");
    private static final Set<String> INIT_PARAM_NAMES = Set.of("contextConfigLocation", "webAppRootKey");
    private static final Set<String> INIT_PARAM_NAMES_WITH_CONTEXT_LOADER = Set.of("contextConfigLocation", "contextInitializerClasses", "webAppRootKey");
    private static final Converter SPRING_BEAN_FILTER_CONVERTER = new SpringBeanResolveConverterForDefiniteClasses(){

        @Nullable
        protected String[] getClassNames(ConvertContext context) {
            return WebCommonClassNames.SERVLET_FILTER.all();
        }

        @Nullable
        protected CommonSpringModel getSpringModel(ConvertContext context) {
            Module module = context.getModule();
            return module == null ? null : SpringManager.getInstance((Project)module.getProject()).getCombinedModel(module);
        }
    };

    @NotNull
    public Set<String> getContextParamNames(@NotNull Module module, ConvertContext convertContext) {
        if (module == null) {
            SpringWebContextParamsProvider.$$$reportNull$$$0(0);
        }
        if (!SpringWebContextParamsProvider.isRelevantModule(module)) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                SpringWebContextParamsProvider.$$$reportNull$$$0(1);
            }
            return set;
        }
        if (SpringWebContextParamsProvider.isFrameworkServlet(convertContext)) {
            Set<String> set = SERVLET_PARAM_NAMES;
            if (set == null) {
                SpringWebContextParamsProvider.$$$reportNull$$$0(2);
            }
            return set;
        }
        if (SpringWebContextParamsProvider.hasContextLoaderListener(convertContext)) {
            Set<String> set = INIT_PARAM_NAMES_WITH_CONTEXT_LOADER;
            if (set == null) {
                SpringWebContextParamsProvider.$$$reportNull$$$0(3);
            }
            return set;
        }
        Set<String> set = INIT_PARAM_NAMES;
        if (set == null) {
            SpringWebContextParamsProvider.$$$reportNull$$$0(4);
        }
        return set;
    }

    private static boolean isRelevantModule(Module module) {
        return !WebFacet.getInstances((Module)module).isEmpty() && SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.context.ContextLoaderListener") != null;
    }

    private static boolean isFrameworkServlet(ConvertContext convertContext) {
        Servlet servlet = (Servlet)convertContext.getInvocationElement().getParentOfType(Servlet.class, true);
        return servlet != null && InheritanceUtil.isInheritor((PsiClass)((PsiClass)servlet.getServletClass().getValue()), (String)"org.springframework.web.servlet.FrameworkServlet");
    }

    private static boolean hasContextLoaderListener(ConvertContext convertContext) {
        WebApp webApp = (WebApp)convertContext.getInvocationElement().getParentOfType(WebApp.class, true);
        if (webApp == null) {
            return false;
        }
        for (Listener listener : webApp.getListeners()) {
            if (!InheritanceUtil.isInheritor((PsiClass)((PsiClass)listener.getListenerClass().getValue()), (String)"org.springframework.web.context.ContextLoader")) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Converter getContextParamValueConverter(@Nullable Module module, ParamValue paramValue, String paramName) {
        if ("contextClass".equals(paramName)) {
            return SpringWebContextParamsProvider.createClassConverter("org.springframework.web.context.ConfigurableWebApplicationContext");
        }
        if (CONTEXT_INITIALIZER_CLASSES.equals(paramName)) {
            return ClassArrayConverter.getClassArrayConverter();
        }
        if ("targetBeanName".equals(paramName) && SpringWebContextParamsProvider.isInDelegatingFilterProxy(paramValue)) {
            return SPRING_BEAN_FILTER_CONVERTER;
        }
        return null;
    }

    private static boolean isInDelegatingFilterProxy(ParamValue paramValue) {
        Filter filter = (Filter)paramValue.getParentOfType(Filter.class, true);
        if (filter == null) {
            return false;
        }
        return InheritanceUtil.isInheritor((PsiClass)((PsiClass)filter.getFilterClass().getValue()), (String)"org.springframework.web.filter.DelegatingFilterProxy");
    }

    private static Converter createClassConverter(final String ... extendClasses) {
        if (extendClasses == null) {
            SpringWebContextParamsProvider.$$$reportNull$$$0(5);
        }
        return new PsiClassConverter(){

            protected JavaClassReferenceProvider createClassReferenceProvider(GenericDomValue<PsiClass> genericDomValue, ConvertContext context, ExtendClass extendClass) {
                JavaClassReferenceProvider provider = super.createClassReferenceProvider(genericDomValue, context, extendClass);
                provider.setOption(JavaClassReferenceProvider.SUPER_CLASSES, List.of(extendClasses));
                provider.setOption(JavaClassReferenceProvider.INSTANTIATABLE, (Object)Boolean.TRUE);
                provider.setOption(JavaClassReferenceProvider.CONCRETE, (Object)Boolean.TRUE);
                return provider;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/config/webXml/SpringWebContextParamsProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extendClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/config/webXml/SpringWebContextParamsProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextParamNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContextParamNames";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createClassConverter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

