/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.nodes;

import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.view.KubernetesResourceRefreshable;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapper;
import com.intellij.kubernetes.view.navigation.KubernetesResourceNavigationData;
import com.intellij.kubernetes.view.nodes.ContentServiceViewDescriptorBase;
import com.intellij.kubernetes.view.ui.actions.ActionUtilsKt;
import com.intellij.kubernetes.view.ui.actions.KubernetesNodeActionsKt;
import com.intellij.kubernetes.view.ui.actions.SelectedKubernetesResource;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.UiDataProvider;
import io.kubernetes.client.common.KubernetesObject;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0006\b\u0001\u0010\u0003 \u00012\b\u0012\u0004\u0012\u0002H\u00030\u00042\b\u0012\u0004\u0012\u0002H\u00010\u00052\u00020\u0006BH\u0012\u000b\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00028\u0000\u0012\u0010\u0010\u0011\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00028\u0000H\u0096@\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020 H\u0016J\b\u0010\"\u001a\u00020#H$J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0014J\u0010\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*H\u0016R\u001c\u0010\u0010\u001a\u00028\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0019\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001b\u0010\u0011\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006+"}, d2={"Lcom/intellij/kubernetes/view/nodes/KubernetesServiceViewDescriptor;", "T", "Lio/kubernetes/client/common/KubernetesObject;", "C", "Lcom/intellij/kubernetes/view/nodes/ContentServiceViewDescriptorBase;", "Lcom/intellij/kubernetes/view/KubernetesResourceRefreshable;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "icon", "Ljavax/swing/Icon;", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "parentCoroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "resource", "mapper", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;", "<init>", "(Ljava/lang/String;Ljavax/swing/Icon;Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;Lkotlinx/coroutines/CoroutineScope;Lio/kubernetes/client/common/KubernetesObject;Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;)V", "getResource", "()Lio/kubernetes/client/common/KubernetesObject;", "setResource", "(Lio/kubernetes/client/common/KubernetesObject;)V", "Lio/kubernetes/client/common/KubernetesObject;", "getMapper", "()Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;", "refresh", "", "(Lio/kubernetes/client/common/KubernetesObject;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getToolbarActions", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "getPopupActions", "createCustomActions", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "shouldNavigate", "", "navigationData", "Lcom/intellij/kubernetes/view/navigation/KubernetesResourceNavigationData;", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "intellij.clouds.kubernetes"})
public abstract class KubernetesServiceViewDescriptor<T extends KubernetesObject, C>
extends ContentServiceViewDescriptorBase<C>
implements KubernetesResourceRefreshable<T>,
UiDataProvider {
    @NotNull
    private T resource;
    @NotNull
    private final KubernetesResourceMapper<T, ?> mapper;

    public KubernetesServiceViewDescriptor(@NotNull String name, @Nullable Icon icon, @NotNull KubernetesApiModelInterface apiModel2, @NotNull CoroutineScope parentCoroutineScope, @NotNull T resource, @NotNull KubernetesResourceMapper<T, ?> mapper) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)parentCoroutineScope, (String)"parentCoroutineScope");
        Intrinsics.checkNotNullParameter(resource, (String)"resource");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        super(name, icon, apiModel2, parentCoroutineScope);
        this.resource = resource;
        this.mapper = mapper;
    }

    @NotNull
    public final T getResource() {
        return this.resource;
    }

    public final void setResource(@NotNull T t) {
        Intrinsics.checkNotNullParameter(t, (String)"<set-?>");
        this.resource = t;
    }

    @NotNull
    public final KubernetesResourceMapper<T, ?> getMapper() {
        return this.mapper;
    }

    @Override
    @Nullable
    public Object refresh(@NotNull T resource, @NotNull Continuation<? super Unit> $completion) {
        return KubernetesServiceViewDescriptor.refresh$suspendImpl(this, resource, $completion);
    }

    static /* synthetic */ <T extends KubernetesObject, C> Object refresh$suspendImpl(KubernetesServiceViewDescriptor<T, ? extends C> $this, T resource, Continuation<? super Unit> $completion) {
        $this.resource = resource;
        if ($this.getContentInitializer().isInitialized()) {
            Object object = $this.getContentInitializer().getValue();
            KubernetesResourceRefreshable kubernetesResourceRefreshable = object instanceof KubernetesResourceRefreshable ? (KubernetesResourceRefreshable)object : null;
            if (kubernetesResourceRefreshable != null) {
                Object object2 = kubernetesResourceRefreshable.refresh(resource, $completion);
                if (object2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object2;
                }
                return Unit.INSTANCE;
            }
        }
        return Unit.INSTANCE;
    }

    @NotNull
    public ActionGroup getToolbarActions() {
        AnAction[] anActionArray = new AnAction[]{KubernetesNodeActionsKt.createResourceCommonActions(), Separator.create(), this.createCustomActions()};
        return (ActionGroup)new DefaultActionGroup(anActionArray);
    }

    @NotNull
    public ActionGroup getPopupActions() {
        AnAction[] anActionArray = new AnAction[]{KubernetesNodeActionsKt.createResourceCommonActions(), Separator.create(), this.createCustomActions()};
        return (ActionGroup)new DefaultActionGroup(anActionArray);
    }

    @NotNull
    protected abstract DefaultActionGroup createCustomActions();

    @Override
    protected boolean shouldNavigate(@NotNull KubernetesResourceNavigationData navigationData) {
        Intrinsics.checkNotNullParameter((Object)navigationData, (String)"navigationData");
        return this.mapper.isAcceptedFor(this.resource, navigationData, (Function0<KubernetesApiModelInterface>)((Function0)() -> KubernetesServiceViewDescriptor.shouldNavigate$lambda$0(this)));
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        sink.set(ActionUtilsKt.getKUBERNETES_CONTEXT(), (Object)this.getApiModel().getCurrentContextObject());
        sink.set(ActionUtilsKt.getKUBERNETES_RESOURCES(), (Object)CollectionsKt.listOf((Object)new SelectedKubernetesResource(this.mapper.getEntity(), false, (KubernetesObject)this.resource)));
    }

    private static final KubernetesApiModelInterface shouldNavigate$lambda$0(KubernetesServiceViewDescriptor this$0) {
        return this$0.getApiModel();
    }
}

