/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.nodes.workloads;

import com.intellij.kubernetes.api.Context;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesContainerObject;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1ContainerState;
import io.kubernetes.client.openapi.models.V1ContainerStatus;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Pod;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\b\u0016\u0018\u0000 ,2\u00020\u0001:\u0001,B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u0014\u0010\u001b\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001dR\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\"R\u0014\u0010#\u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\"R\u0016\u0010%\u001a\u0004\u0018\u00010\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001dR\u0014\u0010'\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\"\u00a8\u0006-"}, d2={"Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObjectImpl;", "Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;", "container", "Lio/kubernetes/client/openapi/models/V1Container;", "containerStatus", "Lio/kubernetes/client/openapi/models/V1ContainerStatus;", "parentPod", "Lio/kubernetes/client/openapi/models/V1Pod;", "context", "Lcom/intellij/kubernetes/api/Context;", "<init>", "(Lio/kubernetes/client/openapi/models/V1Container;Lio/kubernetes/client/openapi/models/V1ContainerStatus;Lio/kubernetes/client/openapi/models/V1Pod;Lcom/intellij/kubernetes/api/Context;)V", "getContainer$intellij_clouds_kubernetes", "()Lio/kubernetes/client/openapi/models/V1Container;", "getContainerStatus", "()Lio/kubernetes/client/openapi/models/V1ContainerStatus;", "getParentPod", "()Lio/kubernetes/client/openapi/models/V1Pod;", "getContext", "()Lcom/intellij/kubernetes/api/Context;", "containerSpec", "getContainerSpec", "getMetadata", "Lio/kubernetes/client/openapi/models/V1ObjectMeta;", "getApiVersion", "", "getKind", "name", "getName", "()Ljava/lang/String;", "image", "getImage", "isReady", "", "()Z", "started", "getStarted", "containerId", "getContainerId", "restartCount", "", "getRestartCount", "()I", "isRunning", "Companion", "intellij.clouds.kubernetes"})
public non-sealed class KubernetesContainerObjectImpl
extends KubernetesContainerObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final V1Container container;
    @NotNull
    private final V1ContainerStatus containerStatus;
    @NotNull
    private final V1Pod parentPod;
    @NotNull
    private final Context context;
    @NotNull
    private final V1Container containerSpec;

    public KubernetesContainerObjectImpl(@NotNull V1Container container, @NotNull V1ContainerStatus containerStatus, @NotNull V1Pod parentPod, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)containerStatus, (String)"containerStatus");
        Intrinsics.checkNotNullParameter((Object)parentPod, (String)"parentPod");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(null);
        this.container = container;
        this.containerStatus = containerStatus;
        this.parentPod = parentPod;
        this.context = context;
        this.containerSpec = this.container;
    }

    @NotNull
    public final V1Container getContainer$intellij_clouds_kubernetes() {
        return this.container;
    }

    @Override
    @NotNull
    public V1ContainerStatus getContainerStatus() {
        return this.containerStatus;
    }

    @Override
    @NotNull
    public V1Pod getParentPod() {
        return this.parentPod;
    }

    @Override
    @NotNull
    public Context getContext() {
        return this.context;
    }

    @Override
    @NotNull
    public V1Container getContainerSpec() {
        return this.containerSpec;
    }

    @Nullable
    public V1ObjectMeta getMetadata() {
        return this.getParentPod().getMetadata();
    }

    @Nullable
    public String getApiVersion() {
        return this.getParentPod().getApiVersion();
    }

    @Nullable
    public String getKind() {
        return "V1Container";
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.container.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @Override
    @Nullable
    public String getImage() {
        return this.container.getImage();
    }

    @Override
    public boolean isReady() {
        Boolean bl = this.getContainerStatus().getReady();
        return bl != null ? bl : false;
    }

    @Override
    public boolean getStarted() {
        Boolean bl = this.getContainerStatus().getStarted();
        return bl != null ? bl : false;
    }

    @Override
    @Nullable
    public String getContainerId() {
        return this.getContainerStatus().getContainerID();
    }

    @Override
    public int getRestartCount() {
        Integer n = this.getContainerStatus().getRestartCount();
        return n != null ? n : 0;
    }

    @Override
    public boolean isRunning() {
        V1ContainerState v1ContainerState = this.getContainerStatus().getState();
        return (v1ContainerState != null ? v1ContainerState.getRunning() : null) != null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObjectImpl$Companion;", "", "<init>", "()V", "createContainerObject", "Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;", "context", "Lcom/intellij/kubernetes/api/Context;", "pod", "Lio/kubernetes/client/openapi/models/V1Pod;", "containerName", "", "intellij.clouds.kubernetes"})
    @SourceDebugExtension(value={"SMAP\nKubernetesContainerObject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesContainerObject.kt\ncom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObjectImpl$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,209:1\n1#2:210\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final KubernetesContainerObject createContainerObject(@NotNull Context context, @NotNull V1Pod pod, @NotNull String containerName) {
            V1ContainerStatus containerStatus;
            Object object;
            V1Container container;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)pod, (String)"pod");
            Intrinsics.checkNotNullParameter((Object)containerName, (String)"containerName");
            Object object2 = pod.getSpec();
            if (object2 != null && (object2 = object2.getContainers()) != null) {
                Object object3;
                block7: {
                    Iterable iterable = (Iterable)object2;
                    for (Object object4 : iterable) {
                        V1Container it = (V1Container)object4;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)containerName)) continue;
                        object3 = object4;
                        break block7;
                    }
                    object3 = null;
                }
                v2 = (V1Container)object3;
            } else {
                v2 = container = null;
            }
            if ((object = pod.getStatus()) != null && (object = object.getContainerStatuses()) != null) {
                Object v4;
                block8: {
                    Object object4;
                    Iterable iterable = (Iterable)object;
                    object4 = iterable.iterator();
                    while (object4.hasNext()) {
                        Object e = object4.next();
                        V1ContainerStatus it = (V1ContainerStatus)e;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)containerName)) continue;
                        v4 = e;
                        break block8;
                    }
                    v4 = null;
                }
                v5 = v4;
            } else {
                v5 = containerStatus = null;
            }
            if (container != null && containerStatus != null) {
                return new KubernetesContainerObjectImpl(container, containerStatus, pod, context);
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

