/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.meta;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMixinElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaReference;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.meta.BasicResolveAssistant;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicMetaReferenceDesc<S extends BasicElement, T extends BasicElement> {
    private final Object myBaseOrScope;
    public final Class<T> valueClass;
    public final BasicMetaObject<? extends T>[] targets;
    private final boolean myBackRef;

    public BasicMetaReferenceDesc(Class<T> valueClass, BasicMetaReference<S, ?> base, BasicMetaObject<? extends T>[] targets, boolean backRef) {
        this((Class<? extends T>)valueClass, (Object)base, targets, backRef);
    }

    public BasicMetaReferenceDesc(Class<T> valueClass, BasicMetaObject<?> scope, BasicMetaObject<? extends T>[] targets, boolean backRef) {
        this((Class<? extends T>)valueClass, (Object)scope, targets, backRef);
    }

    private BasicMetaReferenceDesc(Class<T> valueClass, Object baseOrScope, BasicMetaObject<? extends T>[] targets, boolean backRef) {
        this.myBaseOrScope = baseOrScope;
        this.valueClass = valueClass;
        this.targets = targets;
        this.myBackRef = backRef;
    }

    public boolean isBackRef() {
        return this.myBackRef;
    }

    @NotNull
    public <T2 extends BasicElement> BasicMetaReferenceDesc<S, T2> dummyJoin(BasicMetaReferenceDesc<T, T2> desc2) {
        return new BasicMetaReferenceDesc<S, T>(desc2.valueClass, this.myBaseOrScope, desc2.targets, this.myBackRef || desc2.myBackRef);
    }

    @NotNull
    public BasicMetaObject<?> getScope() {
        BasicMetaObject<?> scope = this.getScopeNoSearch();
        if (scope == null) {
            throw new AssertionError((Object)"Should not happen! Class is stored inside Vm model only");
        }
        BasicMetaObject<?> basicMetaObject = scope;
        if (basicMetaObject == null) {
            BasicMetaReferenceDesc.$$$reportNull$$$0(0);
        }
        return basicMetaObject;
    }

    @Nullable
    private BasicMetaObject<?> getScopeNoSearch() {
        BasicMetaReference<S, ?> base = this.getBaseRef();
        if (base != null) {
            return base.getReferenceDesc().getScope();
        }
        if (this.myBaseOrScope instanceof BasicMetaObject) {
            return (BasicMetaObject)this.myBaseOrScope;
        }
        return null;
    }

    @Nullable
    public BasicMetaReference<S, ?> getBaseRef() {
        return this.myBaseOrScope instanceof BasicMetaReference ? (BasicMetaReference)this.myBaseOrScope : null;
    }

    @NotNull
    public JBIterable<Family<T>> candidateFamilies(S source, @NotNull BasicResolveAssistant assistant) {
        if (assistant == null) {
            BasicMetaReferenceDesc.$$$reportNull$$$0(1);
        }
        JBIterable<Family<T>> jBIterable = this.candidateFamiliesUnderRoots(this.getRoots((BasicElement)source, BasicMetaUtils.getMetaObject(source), assistant), assistant);
        if (jBIterable == null) {
            BasicMetaReferenceDesc.$$$reportNull$$$0(2);
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<Family<T>> candidateFamiliesUnderRoots(JBIterable<BasicElement> roots2, @NotNull BasicResolveAssistant assistant) {
        if (assistant == null) {
            BasicMetaReferenceDesc.$$$reportNull$$$0(3);
        }
        if (roots2 == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                BasicMetaReferenceDesc.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }
        BasicMetaObject<?> scope = this.getScope();
        HashSet inter = new HashSet();
        for (BasicMetaObject<? extends T> target : this.targets) {
            BasicMetaObject<?> o = assistant.getParent(target);
            while (o != null && o != scope) {
                inter.add(o);
                o = assistant.getParent(o);
            }
        }
        JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)((JBTreeTraverser)BasicMetaReferenceDesc.familiesTraverser(assistant).withRoots((Iterable)roots2.flatten(BasicMixinElement::getFamilies))).expand(f -> inter.contains(f.getMetaObject()))).filter(f -> ArrayUtil.indexOf((Object[])this.targets, f.getMetaObject()) != -1)).traverse().map(f -> assistant.access(f));
        if (jBIterable == null) {
            BasicMetaReferenceDesc.$$$reportNull$$$0(5);
        }
        return jBIterable;
    }

    @NotNull
    private static JBTreeTraverser<Family<?>> familiesTraverser(@NotNull BasicResolveAssistant assistant) {
        if (assistant == null) {
            BasicMetaReferenceDesc.$$$reportNull$$$0(6);
        }
        JBTreeTraverser jBTreeTraverser = JBTreeTraverser.from(f -> assistant.access(f).jbi().flatten(BasicMixinElement::getFamilies));
        if (jBTreeTraverser == null) {
            BasicMetaReferenceDesc.$$$reportNull$$$0(7);
        }
        return jBTreeTraverser;
    }

    @Nullable
    private JBIterable<BasicElement> getRoots(BasicElement source, BasicMetaObject<S> srcMeta, @NotNull BasicResolveAssistant assistant) {
        if (assistant == null) {
            BasicMetaReferenceDesc.$$$reportNull$$$0(8);
        }
        if (this.getBaseRef() != null) {
            BasicElement src = (BasicElement)JBIterable.generate((Object)source, assistant::getParent).filterMap(srcMeta::tryCast).first();
            if (src != null) {
                return JBIterable.of((Object)BasicMetaUtils.getResolveBase(src, this, assistant));
            }
        }
        BasicMetaObject<?> scope = this.getScope();
        BasicMetaObject meta = source.getMetaObject();
        if (JBIterable.generate((Object)meta, assistant::getParent).find(m -> m == scope) != null) {
            return JBIterable.generate((Object)source, assistant::getParent).filter(o -> o.getMetaObject() == scope);
        }
        HashSet expand = new HashSet();
        BasicMetaObject<?> m2 = assistant.getParent(scope);
        while (m2 != null) {
            expand.add(m2);
            if (m2 == meta) break;
            m2 = assistant.getParent(m2);
        }
        if (!expand.contains(meta)) {
            return null;
        }
        return ((JBTreeTraverser)((JBTreeTraverser)((JBTreeTraverser)BasicMetaReferenceDesc.familiesTraverser(assistant).withRoots(source.getFamilies())).expand(o -> expand.contains(o.getMetaObject()))).filter(o -> o.getMetaObject() == scope)).traverse().flatten(f -> assistant.access(f));
    }

    @NotNull
    public JBIterable<T> candidates(BasicElement source, BasicMetaObject<S> srcMeta, @NotNull BasicResolveAssistant assistant) {
        if (assistant == null) {
            BasicMetaReferenceDesc.$$$reportNull$$$0(9);
        }
        JBIterable jBIterable = this.candidateFamiliesUnderRoots(this.getRoots(source, srcMeta, assistant), assistant).flatten((Function)Functions.id());
        if (jBIterable == null) {
            BasicMetaReferenceDesc.$$$reportNull$$$0(10);
        }
        return jBIterable;
    }

    public String toString() {
        return this.valueClass.getSimpleName() + " reference";
    }

    public <U extends BasicElement> BasicMetaReferenceDesc<S, U> tryCast(@NotNull Class<U> clazz) {
        if (clazz == null) {
            BasicMetaReferenceDesc.$$$reportNull$$$0(11);
        }
        if (clazz.isAssignableFrom(this.valueClass)) {
            return this;
        }
        return null;
    }

    @Nullable
    public T tryCast(@Nullable BasicElement target) {
        return BasicMetaReferenceDesc.tryCast(target, this.targets);
    }

    @Nullable
    public BasicMetaObject<T> tryCastAsTarget(@Nullable BasicMetaObject<?> target) {
        return BasicMetaReferenceDesc.tryCastAsTarget(this.targets, target);
    }

    @Nullable
    public static <T extends BasicElement> T tryCast(@Nullable BasicElement target, BasicMetaObject<? extends T>[] targets) {
        if (target == null) {
            return null;
        }
        BasicMetaObject meta = target.getMetaObject();
        BasicMetaObject<? extends T> tgt = BasicMetaReferenceDesc.tryCastAsTarget(targets, meta);
        return tgt == null ? null : (T)tgt.tryCast(target);
    }

    @Nullable
    private static <T extends BasicElement> BasicMetaObject<T> tryCastAsTarget(BasicMetaObject<? extends T>[] targets, BasicMetaObject<?> meta) {
        int idx = ArrayUtil.indexOf((Object[])targets, meta);
        return idx == -1 ? null : targets[idx];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 6, 8, 9, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/meta/BasicMetaReferenceDesc";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assistant";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/meta/BasicMetaReferenceDesc";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "candidateFamilies";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "candidateFamiliesUnderRoots";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "familiesTraverser";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "candidates";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "candidateFamilies";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "candidateFamiliesUnderRoots";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "familiesTraverser";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "candidates";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "tryCast";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 6, 8, 9, 11 -> new IllegalArgumentException(string);
        };
    }
}

