/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.google.common.collect.Iterables;
import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcConsoleCore;
import com.intellij.database.console.JdbcConsoleProviderCore;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasNamed;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.script.MongoJSLanguage;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtilCore;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.NameChecker;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SqlDialects;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.EvaluationHelper;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.editor.SqlEditorOptions;
import com.intellij.sql.psi.SqlCodeFragment;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFileAttributes;
import com.intellij.sql.psi.SqlFileResolveMode;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.testFramework.ReadOnlyLightVirtualFile;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class DbSqlUtilCore {
    private static final FileAttribute ourResolveModeAttribute = new FileAttribute("sql.file.resolve.mode");

    protected DbSqlUtilCore() {
    }

    public static boolean stringsAreEscapedWithSlash(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbSqlUtilCore.$$$reportNull$$$0(0);
        }
        return dbms.isClickHouse() || dbms.isHive() || dbms.isMysql() || dbms.isRedshift() || dbms.isSnowflake() || dbms.isMongo() || dbms.isBigQuery();
    }

    public static boolean supportsEscapeStringLiterals(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbSqlUtilCore.$$$reportNull$$$0(1);
        }
        return dbms.isGreenplum() || dbms == Dbms.POSTGRES || dbms.isVertica();
    }

    @Nullable
    public static SqlLanguageDialect getSqlDialect(@Nullable PsiElement element) {
        SqlLanguageDialect language;
        if (element == null) {
            return null;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile instanceof SqlFile) {
            language = ((SqlFile)containingFile).getSqlLanguage();
        } else if (containingFile instanceof DummyHolder) {
            language = containingFile.getLanguage();
        } else {
            if (element instanceof DbElement) {
                return DbSqlUtilCore.getSqlDialect((DbElement)element);
            }
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
            language = LanguageUtil.getLanguageForPsi((Project)element.getProject(), (VirtualFile)virtualFile);
        }
        return language instanceof SqlLanguageDialect ? language : null;
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@Nullable DbElement element) {
        DbDataSource dataSource = element == null ? null : element.getDataSource();
        SqlLanguageDialect language = dataSource == null ? null : (SqlLanguageDialect)ObjectUtils.tryCast((Object)dataSource.getQueryLanguage(), SqlLanguageDialect.class);
        SqlLanguageDialect sqlLanguageDialect = language == null ? SqlDialects.getGenericDialect() : language;
        if (sqlLanguageDialect == null) {
            DbSqlUtilCore.$$$reportNull$$$0(2);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public static Language getLanguage(@Nullable DbElement element) {
        DbDataSource dataSource = element == null ? null : element.getDataSource();
        Object object = dataSource == null ? SqlDialects.getGenericDialect() : dataSource.getQueryLanguage();
        if (object == null) {
            DbSqlUtilCore.$$$reportNull$$$0(3);
        }
        return object;
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@NotNull Project project, @NotNull DasDataSource databaseSystem) {
        if (project == null) {
            DbSqlUtilCore.$$$reportNull$$$0(4);
        }
        if (databaseSystem == null) {
            DbSqlUtilCore.$$$reportNull$$$0(5);
        }
        if (databaseSystem instanceof DbDataSource) {
            return DbSqlUtilCore.getSqlDialect((DbDataSource)databaseSystem);
        }
        if (databaseSystem instanceof LocalDataSource) {
            return DbSqlUtilCore.getSqlDialect((LocalDataSource)databaseSystem);
        }
        DbDataSource dataSource = DbPsiFacade.getInstance((Project)project).findDataSource(databaseSystem.getUniqueId());
        return dataSource == null ? SqlDialects.getGenericDialect() : DbSqlUtilCore.getSqlDialect(dataSource);
    }

    @NotNull
    public static <T> JBIterable.SFun<T, T> checkCancelled(final int every) {
        return new JBIterable.SFun<T, T>(){
            int cnt = 0;

            public T fun(T o) {
                if (++this.cnt % every == 0) {
                    ProgressManager.checkCanceled();
                }
                return o;
            }
        };
    }

    @NotNull
    public static <E, T, U> JBIterable.SFun<E, U> track(final @Nullable T init, final @NotNull PairFunction<Function.Mono<T>, ? super E, ? extends U> fun) {
        if (fun == null) {
            DbSqlUtilCore.$$$reportNull$$$0(6);
        }
        return new JBIterable.SFun<E, U>(){
            T prev;
            {
                this.prev = init;
            }

            private T track(T t) {
                Object tmp = this.prev;
                this.prev = t;
                return tmp;
            }

            public U fun(E o) {
                return fun.fun(this::track, o);
            }
        };
    }

    public static boolean isQuoted(@Nullable DasObject object) {
        if (object instanceof DbElement) {
            return DbSqlUtilCore.isQuoted((DasObject)ObjectUtils.tryCast((Object)((DbElement)object).getDelegate(), DasObject.class));
        }
        if (object instanceof SqlDefinition) {
            return ((SqlDefinition)object).isNameQuoted();
        }
        if (object instanceof SqlNameElement) {
            return DbSqlUtilCore.isQuoted((SqlNameElement)object);
        }
        if (object instanceof BasicElement) {
            return BasicPaths.isQuoted((BasicElement)object);
        }
        return true;
    }

    public static boolean isQuoted(@Nullable SqlNameElement element) {
        return element != null && element.isQuotedIdentifier();
    }

    @Nullable
    public static DasObject getDasObject(@NotNull DasNamed named) {
        if (named == null) {
            DbSqlUtilCore.$$$reportNull$$$0(7);
        }
        if (named instanceof DasObject) {
            return (DasObject)named;
        }
        if (named instanceof DasSymbol) {
            return ((DasSymbol)named).getDasObject();
        }
        return null;
    }

    @Nullable
    public static PsiElement getPsiDelegate(@Nullable DasObject info) {
        DasObject delegate = info instanceof DbElement ? ((DbElement)info).getDelegate() : info;
        return delegate instanceof PsiElement ? (PsiElement)delegate : null;
    }

    public static boolean isSqlObject(@Nullable DasObject object) {
        if (object instanceof DbElement) {
            return DbSqlUtilCore.isSqlObject((DasObject)ObjectUtils.tryCast((Object)((DbElement)object).getDelegate(), DasObject.class));
        }
        if (object instanceof SqlElement) {
            return true;
        }
        if (object instanceof BasicNamedElement) {
            return ((BasicNamedElement)object).isNameScripted();
        }
        return false;
    }

    @NotNull
    public static <C extends DasNamed> Condition<C> byName(@Nullable String name, boolean quoted, @Nullable String id, @NotNull CasingProvider provider) {
        if (provider == null) {
            DbSqlUtilCore.$$$reportNull$$$0(8);
        }
        if (name == null) {
            Condition condition = Conditions.alwaysFalse();
            if (condition == null) {
                DbSqlUtilCore.$$$reportNull$$$0(9);
            }
            return condition;
        }
        NameChecker checker = new NameChecker(name, quoted, provider, null);
        Condition condition = named -> {
            DasObject dasObject = DbSqlUtilCore.getDasObject(named);
            return (id == null || dasObject != null && id.equalsIgnoreCase(ObjectPaths.getIdentity(dasObject))) && checker.checkName((DasNamed)named, null);
        };
        if (condition == null) {
            DbSqlUtilCore.$$$reportNull$$$0(10);
        }
        return condition;
    }

    @NotNull
    public static JBIterable<DbDataSource> getDataSourcesForResolve(@NotNull PsiFile sqlFile) {
        if (sqlFile == null) {
            DbSqlUtilCore.$$$reportNull$$$0(11);
        }
        return DbSqlUtilCore.getAppropriateDataSources(sqlFile, true, true);
    }

    @NotNull
    public static JBIterable<DbDataSource> getAppropriateDataSources(@NotNull PsiFile sqlFile, boolean forResolve, boolean matchingOnly) {
        DatabaseDialect dialect;
        if (sqlFile == null) {
            DbSqlUtilCore.$$$reportNull$$$0(12);
        }
        if (DbSqlUtilCore.isJSLanguage(sqlFile.getLanguage())) {
            dialect = (DatabaseDialect)ObjectUtils.notNull((Object)((DatabaseDialect)DatabaseDialect.EP.forDbms(Dbms.MONGO)), (Object)SqlDialects.getGenericDialect().getDatabaseDialect());
        } else {
            SqlLanguageDialect sqlDialect = (SqlLanguageDialect)ObjectUtils.notNull((Object)DbSqlUtilCore.getSqlDialect((PsiElement)sqlFile), (Object)SqlDialects.getGenericDialect());
            dialect = sqlDialect.getDatabaseDialect();
        }
        return DbSqlUtilCore.getAppropriateDataSources(dialect, PsiUtilCore.getVirtualFile((PsiElement)sqlFile), sqlFile.getProject(), forResolve, matchingOnly);
    }

    @NotNull
    public static JBIterable<DbDataSource> getAppropriateDataSources(@NotNull DatabaseDialect databaseDialect, @Nullable VirtualFile virtualFile, @NotNull Project project, boolean forResolve, boolean matchingOnly) {
        JBIterable sqlDataSources;
        if (databaseDialect == null) {
            DbSqlUtilCore.$$$reportNull$$$0(13);
        }
        if (project == null) {
            DbSqlUtilCore.$$$reportNull$$$0(14);
        }
        DbPsiFacade facade = DbPsiFacade.getInstance((Project)project);
        boolean isReadonly = virtualFile instanceof ReadOnlyLightVirtualFile;
        JBIterable resultAll = JBIterable.from((Iterable)facade.getDataSources()).filter(ds -> (!isReadonly || !(ds instanceof SqlDataSource)) && ds.isValid());
        JBIterable resultSelected = resultAll.filter(ds -> DbImplUtilCore.getDatabaseDialect((DbElement)ds).similarTo(databaseDialect));
        if (!isReadonly && forResolve && virtualFile != null && FileTypeRegistry.getInstance().isFileOfType(virtualFile, (FileType)SqlFileType.INSTANCE) && !(sqlDataSources = resultAll.filterMap(o -> o.getDelegate() instanceof SqlDataSource ? o : null).filter(o -> ((SqlDataSource)o.getDelegate()).containsFile(virtualFile)).collect()).isEmpty()) {
            JBIterable jBIterable = sqlDataSources;
            if (jBIterable == null) {
                DbSqlUtilCore.$$$reportNull$$$0(15);
            }
            return jBIterable;
        }
        JBIterable jBIterable = !matchingOnly && resultSelected.isEmpty() ? resultAll : resultSelected;
        if (jBIterable == null) {
            DbSqlUtilCore.$$$reportNull$$$0(16);
        }
        return jBIterable;
    }

    public static boolean isJSLanguage(@Nullable Language language) {
        if (language == MongoJSLanguage.INSTANCE) {
            return true;
        }
        while (language != null) {
            if (language.getID().equals("JavaScript")) {
                return true;
            }
            language = language.getBaseLanguage();
        }
        return false;
    }

    public static ObjectName getName(@Nullable DasObject object) {
        return object == null ? null : new ObjectName(object.getName(), DbSqlUtilCore.isQuoted(object));
    }

    public static ObjectName getName(@NotNull SqlReferenceExpression expression) {
        if (expression == null) {
            DbSqlUtilCore.$$$reportNull$$$0(17);
        }
        return new ObjectName(expression.getName(), expression.isQuoted());
    }

    @Nullable
    public static SqlLanguageDialect findSqlDialect(@NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            DbSqlUtilCore.$$$reportNull$$$0(18);
        }
        return DbSqlUtilCore.findSqlDialect(dialect.getDbms());
    }

    @Nullable
    public static SqlLanguageDialect findSqlDialect(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbSqlUtilCore.$$$reportNull$$$0(19);
        }
        return (SqlLanguageDialect)SqlLanguageDialect.EP.forDbms(dbms);
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@Nullable LocalDataSource dataSource) {
        SqlLanguageDialect dialect = DbSqlUtilCore.findSqlDialect(dataSource);
        SqlLanguageDialect sqlLanguageDialect = dialect == null ? SqlDialects.getGenericDialect() : dialect;
        if (sqlLanguageDialect == null) {
            DbSqlUtilCore.$$$reportNull$$$0(20);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@Nullable DbDataSource dataSource) {
        return DbSqlUtilCore.getSqlDialect((DbElement)dataSource);
    }

    @NotNull
    public static @Unmodifiable List<PsiElement> resolveToColumnList(@NotNull SqlReferenceExpression ref) {
        String text2;
        if (ref == null) {
            DbSqlUtilCore.$$$reportNull$$$0(21);
        }
        if (!"*".equals(text2 = StringUtil.notNullize((String)ref.getText())) && !text2.endsWith(".*")) {
            PsiElement resolve = ref.getReference().resolve();
            List list = ContainerUtil.createMaybeSingletonList((Object)resolve);
            if (list == null) {
                DbSqlUtilCore.$$$reportNull$$$0(22);
            }
            return list;
        }
        SqlTableType type = (SqlTableType)ObjectUtils.tryCast((Object)ref.getDasType(), SqlTableType.class);
        if (type == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                DbSqlUtilCore.$$$reportNull$$$0(23);
            }
            return list;
        }
        ArrayList<PsiElement> res = new ArrayList<PsiElement>(type.getColumnCount());
        for (int i2 = 0; i2 < type.getColumnCount(); ++i2) {
            res.add(type.getColumnElement(i2));
        }
        ArrayList<PsiElement> arrayList = res;
        if (arrayList == null) {
            DbSqlUtilCore.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    @NotNull
    public static Language getLanguage(@Nullable DbDataSource dataSource) {
        return DbSqlUtilCore.getLanguage((DbElement)dataSource);
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@Nullable DasDataSource dataSource) {
        DbDataSource dbDs;
        if (dataSource instanceof DbElement) {
            return DbSqlUtilCore.getSqlDialect((DbElement)dataSource);
        }
        if (dataSource instanceof LocalDataSource) {
            return DbSqlUtilCore.getSqlDialect((LocalDataSource)dataSource);
        }
        if (dataSource instanceof SqlDataSource && (dbDs = DbPsiFacade.getInstance((Project)((SqlDataSource)dataSource).getProject()).findDataSource(dataSource.getUniqueId())) != null) {
            return DbSqlUtilCore.getSqlDialect(dbDs);
        }
        SqlLanguageDialect dialect = dataSource == null ? null : DbSqlUtilCore.findSqlDialect(dataSource.getDbms());
        SqlLanguageDialect sqlLanguageDialect = dialect == null ? SqlDialects.getGenericDialect() : dialect;
        if (sqlLanguageDialect == null) {
            DbSqlUtilCore.$$$reportNull$$$0(25);
        }
        return sqlLanguageDialect;
    }

    @Nullable
    public static SqlLanguageDialect findSqlDialect(@Nullable LocalDataSource dataSource) {
        if (dataSource == null) {
            return null;
        }
        String defaultDialect = dataSource.getDefaultDialect();
        SqlLanguageDialect result = StringUtil.isEmpty((String)defaultDialect) ? null : SqlDialects.findDialectById(defaultDialect);
        return result != null ? result : DbSqlUtilCore.guessSqlDialect(dataSource);
    }

    @Nullable
    public static SqlLanguageDialect guessSqlDialect(@Nullable RawConnectionConfig connectionInfo) {
        DatabaseDialectEx dbDialect = connectionInfo == null ? null : DbImplUtilCore.guessDatabaseDialect(connectionInfo);
        return dbDialect == null ? null : DbSqlUtilCore.findSqlDialect(dbDialect);
    }

    @NotNull
    public static Dbms getDbms(@Nullable Language language) {
        Dbms dbms = language instanceof SqlLanguageDialect ? ((SqlLanguageDialect)language).getDbms() : (DbSqlUtilCore.isJSLanguage(language) ? Dbms.MONGO : Dbms.UNKNOWN);
        if (dbms == null) {
            DbSqlUtilCore.$$$reportNull$$$0(26);
        }
        return dbms;
    }

    @NotNull
    public static <C extends DasObject> Condition<C> byName(@Nullable DasObject obj, @Nullable String id, @NotNull CasingProvider provider) {
        if (provider == null) {
            DbSqlUtilCore.$$$reportNull$$$0(27);
        }
        return DbSqlUtilCore.byName(obj == null ? null : obj.getName(), DbSqlUtilCore.isQuoted(obj), id, provider);
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@NotNull Dbms dbms) {
        SqlLanguageDialect res;
        if (dbms == null) {
            DbSqlUtilCore.$$$reportNull$$$0(28);
        }
        SqlLanguageDialect sqlLanguageDialect = (res = DbSqlUtilCore.findSqlDialect(dbms)) == null ? SqlDialects.getGenericDialect() : res;
        if (sqlLanguageDialect == null) {
            DbSqlUtilCore.$$$reportNull$$$0(29);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public static Language getLanguage(@Nullable LocalDataSource dataSource) {
        Language language = DbSqlUtilCore.findLanguage(dataSource);
        Object object = language == null ? SqlDialects.getGenericDialect() : language;
        if (object == null) {
            DbSqlUtilCore.$$$reportNull$$$0(30);
        }
        return object;
    }

    @Nullable
    public static Language findLanguage(@Nullable LocalDataSource dataSource) {
        if (dataSource != null) {
            String defaultDialect = dataSource.getDefaultDialect();
            if (MongoJSLanguage.INSTANCE.getID().equals(defaultDialect) || dataSource.getDbms() == Dbms.MONGO) {
                return MongoJSLanguage.INSTANCE;
            }
        }
        return DbSqlUtilCore.findSqlDialect(dataSource);
    }

    @Contract(value="!null, _, _, _, _, _, _ -> !null")
    @Nullable
    public static String toStringLiteral(@Nullable String value, @NotNull Dbms dbms, boolean escapeSqlRegexSymbols, @Nullable String prefix, @Nullable String suffix, boolean multiline, @NotNull JdbcHelper helper) {
        SqlRegexDecorator sqlRegexDecorator;
        if (dbms == null) {
            DbSqlUtilCore.$$$reportNull$$$0(31);
        }
        if (helper == null) {
            DbSqlUtilCore.$$$reportNull$$$0(32);
        }
        if (value == null) {
            return null;
        }
        SqlRegexDecorator sqlRegexDecorator2 = escapeSqlRegexSymbols && helper.supportsEscape() ? SqlRegexDecorator.WITH_ESCAPE_CLAUSE : (sqlRegexDecorator = escapeSqlRegexSymbols ? SqlRegexDecorator.DEFAULT : SqlRegexDecorator.NONE);
        String string = dbms.isMongo() ? (prefix == null && escapeSqlRegexSymbols ? "^" : "") : (prefix = prefix);
        suffix = dbms.isMongo() ? (suffix == null && escapeSqlRegexSymbols ? "$" : "") : suffix;
        return DbSqlUtilCore.toStringLiteralInner(value, dbms, sqlRegexDecorator, StringUtil.notNullize((String)prefix), StringUtil.notNullize((String)suffix), multiline);
    }

    @NotNull
    private static String toStringLiteralInner(@NotNull String value, @NotNull Dbms dbms, @NotNull SqlRegexDecorator sqlRegexDecorator, @NotNull String prefix, @NotNull String suffix, boolean multiline) {
        char quote;
        if (value == null) {
            DbSqlUtilCore.$$$reportNull$$$0(33);
        }
        if (dbms == null) {
            DbSqlUtilCore.$$$reportNull$$$0(34);
        }
        if (sqlRegexDecorator == null) {
            DbSqlUtilCore.$$$reportNull$$$0(35);
        }
        if (prefix == null) {
            DbSqlUtilCore.$$$reportNull$$$0(36);
        }
        if (suffix == null) {
            DbSqlUtilCore.$$$reportNull$$$0(37);
        }
        char c2 = quote = dbms.isMongo() ? (char)'\"' : '\'';
        if ((((String)value).contains("\n") || ((String)value).contains("\t") || ((String)value).contains("\r")) && (DbSqlUtilCore.stringsAreEscapedWithSlash(dbms) || DbSqlUtilCore.supportsEscapeStringLiterals(dbms))) {
            value = StringUtil.escapeBackSlashes((String)value);
            value = sqlRegexDecorator.decorateInner((String)value, dbms);
            value = StringUtil.escapeChar((String)value, (char)quote);
            value = multiline ? value : StringUtil.escapeLineBreak((String)value);
            value = multiline ? value : StringUtil.replace((String)value, (String)"\t", (String)"\\t");
            value = quote + prefix + (String)value + suffix + quote;
            value = DbSqlUtilCore.supportsEscapeStringLiterals(dbms) ? "e" + (String)value : value;
        } else {
            String escapeChar;
            value = sqlRegexDecorator.decorateInner((String)value, dbms);
            String string = escapeChar = DbSqlUtilCore.stringsAreEscapedWithSlash(dbms) ? "\\" : "'";
            if (DbSqlUtilCore.stringsAreEscapedWithSlash(dbms)) {
                value = StringUtil.escapeBackSlashes((String)value);
            }
            value = StringUtil.replace((String)value, (String)String.valueOf(quote), (String)(escapeChar + quote));
            value = quote + prefix + (String)value + suffix + quote;
            value = dbms.in(Dbms.MSSQL_LIKE) ? "N" + (String)value : value;
        }
        String string = sqlRegexDecorator.decorateOuter((String)value, dbms);
        if (string == null) {
            DbSqlUtilCore.$$$reportNull$$$0(38);
        }
        return string;
    }

    @Nullable
    public static SqlResultSetExpression parseSqlQueryResultSetExpression(@NotNull Project project, @NotNull SqlLanguageDialect language, @NotNull String queryText, @Nullable Language hostLanguage) {
        EvaluationHelper helper;
        PsiElement resultSetExpression;
        if (project == null) {
            DbSqlUtilCore.$$$reportNull$$$0(39);
        }
        if (language == null) {
            DbSqlUtilCore.$$$reportNull$$$0(40);
        }
        if (queryText == null) {
            DbSqlUtilCore.$$$reportNull$$$0(41);
        }
        return (resultSetExpression = (helper = (EvaluationHelper)EvaluationHelper.EP.forLanguage((Language)language)).parseQueryResultSetExpression(project, (Language)language, queryText, hostLanguage)) instanceof SqlResultSetExpression ? (SqlResultSetExpression)resultSetExpression : null;
    }

    @Nullable
    public static <T> T getSqlFileAttributeAt(@NotNull PsiFile file, @NotNull Key<T> attr, int offset) {
        SqlFile sqlFile;
        if (file == null) {
            DbSqlUtilCore.$$$reportNull$$$0(42);
        }
        if (attr == null) {
            DbSqlUtilCore.$$$reportNull$$$0(43);
        }
        return (T)((sqlFile = (SqlFile)ObjectUtils.tryCast((Object)file, SqlFile.class)) != null ? sqlFile.getAttributeAt(attr, offset) : null);
    }

    @NotNull
    public static String getDelimiterAt(@Nullable PsiFile file, int offset) {
        String delim = file == null ? null : (String)DbSqlUtilCore.getSqlFileAttributeAt(file, SqlFileAttributes.DELIMITER, offset);
        String string = StringUtil.notNullize((String)delim, (String)";");
        if (string == null) {
            DbSqlUtilCore.$$$reportNull$$$0(44);
        }
        return string;
    }

    public static boolean delimiterNeedsSpacing(@NotNull String delim) {
        if (delim == null) {
            DbSqlUtilCore.$$$reportNull$$$0(45);
        }
        return !delim.equals(";");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static List<String> getQueries(@NotNull String text2, @NotNull Project project, @NotNull Language language) {
        if (text2 == null) {
            DbSqlUtilCore.$$$reportNull$$$0(46);
        }
        if (project == null) {
            DbSqlUtilCore.$$$reportNull$$$0(47);
        }
        if (language == null) {
            DbSqlUtilCore.$$$reportNull$$$0(48);
        }
        SqlPsiFacade facade = SqlPsiFacade.getInstance((Project)project);
        ScriptModel model = facade.createScriptModel(DbSqlUtilCore.createTemporaryFile(text2, project, language));
        List list = model.statements().transform(ScriptModelUtilCore.TO_QUERY).toList();
        List list2 = list;
        if (list2 == null) {
            DbSqlUtilCore.$$$reportNull$$$0(49);
        }
        return list2;
        finally {
            Disposer.dispose((Disposable)model);
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static PsiFile createTemporaryFile(@NotNull String text2, @NotNull Project project, @NotNull Language language) {
        if (text2 == null) {
            DbSqlUtilCore.$$$reportNull$$$0(50);
        }
        if (project == null) {
            DbSqlUtilCore.$$$reportNull$$$0(51);
        }
        if (language == null) {
            DbSqlUtilCore.$$$reportNull$$$0(52);
        }
        ReadOnlyLightVirtualFile file = new ReadOnlyLightVirtualFile("a", language, (CharSequence)text2);
        SingleRootFileViewProvider.doNotCheckFileSizeLimit((VirtualFile)file);
        SingleRootFileViewProvider viewProvider = new SingleRootFileViewProvider(PsiManager.getInstance((Project)project), (VirtualFile)file, false);
        PsiFile psi = viewProvider.getPsi(language);
        if (psi == null) {
            throw new AssertionError((Object)("language: " + language.getID() + "; text length: " + text2.length()));
        }
        PsiFile psiFile = psi;
        if (psiFile == null) {
            DbSqlUtilCore.$$$reportNull$$$0(53);
        }
        return psiFile;
    }

    @NotNull
    public static JBIterable<DasObject> findObjects(@NotNull DbDataSource dbDataSource, @NotNull ObjectPath path) {
        if (dbDataSource == null) {
            DbSqlUtilCore.$$$reportNull$$$0(54);
        }
        if (path == null) {
            DbSqlUtilCore.$$$reportNull$$$0(55);
        }
        JBIterable jBIterable = dbDataSource.findObjects(path);
        if (jBIterable == null) {
            DbSqlUtilCore.$$$reportNull$$$0(56);
        }
        return jBIterable;
    }

    public static boolean referencesTarget(@NotNull DasObject candidate, @NotNull DasObject target, @NotNull ObjectKind targetKind) {
        if (candidate == null) {
            DbSqlUtilCore.$$$reportNull$$$0(57);
        }
        if (target == null) {
            DbSqlUtilCore.$$$reportNull$$$0(58);
        }
        if (targetKind == null) {
            DbSqlUtilCore.$$$reportNull$$$0(59);
        }
        if (targetKind == ObjectKind.TABLE) {
            DasTable refTable;
            if (candidate instanceof DasForeignKey && target.equals((Object)(refTable = ((DasForeignKey)candidate).getRefTable()))) {
                return true;
            }
        } else if (targetKind == ObjectKind.COLUMN) {
            if (candidate instanceof DasConstraint) {
                if (ContainerUtil.find((Iterable)((DasConstraint)candidate).getColumnsRef().resolveObjects(), (Object)target) != null) {
                    return true;
                }
                if (candidate instanceof DasForeignKey && ContainerUtil.find((Iterable)((DasForeignKey)candidate).getRefColumns().resolveObjects(), (Object)target) != null) {
                    return true;
                }
            } else if (candidate instanceof DasIndex && ContainerUtil.find((Iterable)((DasIndex)candidate).getColumnsRef().resolveObjects(), (Object)target) != null) {
                return true;
            }
        } else if (candidate instanceof DasSynonym && ((DasSynonym)candidate).resolveTarget() == target) {
            return true;
        }
        return candidate instanceof BasicElement && target instanceof BasicElement && Iterables.contains(((BasicElement)candidate).getPredecessors(), (Object)target);
    }

    @Nullable
    public static DbDataSource getDbDataSource(@NotNull Project project, @NotNull DasDataSource dataSource) {
        if (project == null) {
            DbSqlUtilCore.$$$reportNull$$$0(60);
        }
        if (dataSource == null) {
            DbSqlUtilCore.$$$reportNull$$$0(61);
        }
        if (dataSource instanceof DbDataSource) {
            return (DbDataSource)dataSource;
        }
        return DbPsiFacade.getInstance((Project)project).findDataSource(dataSource.getUniqueId());
    }

    @Nullable
    public static DbElement findElement(@NotNull DbDataSource dbDataSource, @NotNull ObjectPath path) {
        if (dbDataSource == null) {
            DbSqlUtilCore.$$$reportNull$$$0(62);
        }
        if (path == null) {
            DbSqlUtilCore.$$$reportNull$$$0(63);
        }
        return dbDataSource.findElement(path);
    }

    @Nullable
    private static PsiFile getFileForResolveMode(@NotNull PsiElement element) {
        PsiElement context;
        PsiFile file;
        if (element == null) {
            DbSqlUtilCore.$$$reportNull$$$0(64);
        }
        if ((file = element.getContainingFile()) instanceof SqlCodeFragment && (context = file.getContext()) != null) {
            file = context.getContainingFile();
        }
        return file;
    }

    @NotNull
    public static SqlFileResolveMode getDefaultFileResolveMode(@NotNull PsiElement element) {
        PsiFile file;
        if (element == null) {
            DbSqlUtilCore.$$$reportNull$$$0(65);
        }
        if ((file = DbSqlUtilCore.getFileForResolveMode(element)) == null) {
            SqlFileResolveMode sqlFileResolveMode = SqlFileResolveMode.SCRIPT;
            if (sqlFileResolveMode == null) {
                DbSqlUtilCore.$$$reportNull$$$0(66);
            }
            return sqlFileResolveMode;
        }
        VirtualFile vFile = file.getVirtualFile();
        JdbcConsoleCore console = vFile != null ? JdbcConsoleProviderCore.getConsole(file.getProject(), vFile) : null;
        SqlFileResolveMode sqlFileResolveMode = console != null ? DatabaseSettings.getSettings().defaultConsoleResolveMode : SqlFileResolveMode.SCRIPT;
        if (sqlFileResolveMode == null) {
            DbSqlUtilCore.$$$reportNull$$$0(67);
        }
        return sqlFileResolveMode;
    }

    @NotNull
    public static SqlFileResolveMode getFileResolveMode(@NotNull PsiElement element) {
        String value;
        SqlFileResolveMode mode;
        PsiFile file;
        VirtualFile vFile;
        if (element == null) {
            DbSqlUtilCore.$$$reportNull$$$0(68);
        }
        VirtualFile virtualFile = vFile = (file = DbSqlUtilCore.getFileForResolveMode(element)) != null ? file.getVirtualFile() : null;
        if (vFile != null && (mode = SqlFileResolveMode.deserialize((String)(value = DbImplUtilCore.readVFSAttributeSafe(vFile, ourResolveModeAttribute)))) != null) {
            SqlFileResolveMode sqlFileResolveMode = mode;
            if (sqlFileResolveMode == null) {
                DbSqlUtilCore.$$$reportNull$$$0(69);
            }
            return sqlFileResolveMode;
        }
        return DbSqlUtilCore.getDefaultFileResolveMode(element);
    }

    public static void setFileResolveMode(@NotNull PsiElement element, @NotNull SqlFileResolveMode mode) {
        PsiFile file;
        if (element == null) {
            DbSqlUtilCore.$$$reportNull$$$0(70);
        }
        if (mode == null) {
            DbSqlUtilCore.$$$reportNull$$$0(71);
        }
        if ((file = DbSqlUtilCore.getFileForResolveMode(element)) == null) {
            return;
        }
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            return;
        }
        FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{vFile});
        DbImplUtilCore.writeVFSAttributeSafe(file.getVirtualFile(), ourResolveModeAttribute, mode.serialize());
    }

    @NotNull
    public static SqlEditorOptions.QualificationType getQualificationByParentKind(@NotNull ObjectKind kind) {
        if (kind == null) {
            DbSqlUtilCore.$$$reportNull$$$0(72);
        }
        SqlEditorOptions options = SqlEditorOptions.getInstance();
        if (kind == SqlDbElementType.LOCAL_ALIAS) {
            SqlEditorOptions.QualificationType qualificationType = options.getAliasQualification();
            if (qualificationType == null) {
                DbSqlUtilCore.$$$reportNull$$$0(73);
            }
            return qualificationType;
        }
        if (ModelConsts.TABLE_OR_VIEW_KINDS.contains(kind)) {
            SqlEditorOptions.QualificationType qualificationType = options.getTableQualification();
            if (qualificationType == null) {
                DbSqlUtilCore.$$$reportNull$$$0(74);
            }
            return qualificationType;
        }
        if (kind == ObjectKind.SCHEMA) {
            SqlEditorOptions.QualificationType qualificationType = options.getSchemaQualification();
            if (qualificationType == null) {
                DbSqlUtilCore.$$$reportNull$$$0(75);
            }
            return qualificationType;
        }
        if (kind == ObjectKind.DATABASE) {
            SqlEditorOptions.QualificationType qualificationType = options.getDatabaseQualification();
            if (qualificationType == null) {
                DbSqlUtilCore.$$$reportNull$$$0(76);
            }
            return qualificationType;
        }
        SqlEditorOptions.QualificationType qualificationType = SqlEditorOptions.QualificationType.NOT_QUALIFY;
        if (qualificationType == null) {
            DbSqlUtilCore.$$$reportNull$$$0(77);
        }
        return qualificationType;
    }

    @NotNull
    public static SqlEditorOptions.QualificationType getQualification(@NotNull ObjectKind kind, @NotNull Dbms dbms) {
        ObjectKind parentKind;
        if (kind == null) {
            DbSqlUtilCore.$$$reportNull$$$0(78);
        }
        if (dbms == null) {
            DbSqlUtilCore.$$$reportNull$$$0(79);
        }
        SqlEditorOptions.QualificationType qualificationType = (parentKind = (ObjectKind)DbImplUtilCore.getMetaModel(dbms).getParentKinds(kind).first()) != null ? DbSqlUtilCore.getQualificationByParentKind(parentKind) : SqlEditorOptions.QualificationType.NOT_QUALIFY;
        if (qualificationType == null) {
            DbSqlUtilCore.$$$reportNull$$$0(80);
        }
        return qualificationType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 9, 10, 15, 16, 20, 22, 23, 24, 25, 26, 29, 30, 38, 44, 49, 53, 56, 66, 67, 69, 73, 74, 75, 76, 77, 80 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 38: 
            case 44: 
            case 49: 
            case 53: 
            case 56: 
            case 66: 
            case 67: 
            case 69: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DbSqlUtilCore";
                break;
            }
            case 4: 
            case 14: 
            case 39: 
            case 47: 
            case 51: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseSystem";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "named";
                break;
            }
            case 8: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseDialect";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlRegexDecorator";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 40: 
            case 48: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delim";
                break;
            }
            case 46: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 54: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbDataSource";
                break;
            }
            case 55: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetKind";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 64: 
            case 65: 
            case 68: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 72: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DbSqlUtilCore";
                break;
            }
            case 2: 
            case 20: 
            case 25: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialect";
                break;
            }
            case 3: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "byName";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppropriateDataSources";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToColumnList";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "toStringLiteralInner";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelimiterAt";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueries";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemporaryFile";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "findObjects";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFileResolveMode";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileResolveMode";
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualificationByParentKind";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualification";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "stringsAreEscapedWithSlash";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "supportsEscapeStringLiterals";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 38: 
            case 44: 
            case 49: 
            case 53: 
            case 56: 
            case 66: 
            case 67: 
            case 69: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 80: {
                break;
            }
            case 4: 
            case 5: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getSqlDialect";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "track";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDasObject";
                break;
            }
            case 8: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "byName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourcesForResolve";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAppropriateDataSources";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findSqlDialect";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "resolveToColumnList";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "toStringLiteral";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "toStringLiteralInner";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "parseSqlQueryResultSetExpression";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getSqlFileAttributeAt";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "delimiterNeedsSpacing";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getQueries";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "createTemporaryFile";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "findObjects";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "referencesTarget";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getDbDataSource";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getFileForResolveMode";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultFileResolveMode";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getFileResolveMode";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "setFileResolveMode";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getQualificationByParentKind";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getQualification";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 9, 10, 15, 16, 20, 22, 23, 24, 25, 26, 29, 30, 38, 44, 49, 53, 56, 66, 67, 69, 73, 74, 75, 76, 77, 80 -> new IllegalStateException(string);
        };
    }

    public static enum SqlRegexDecorator {
        NONE(false, false),
        DEFAULT(true, false),
        WITH_ESCAPE_CLAUSE(true, true);

        private final boolean escapeSqlRegex;
        private final boolean appendEscapeClause;

        private SqlRegexDecorator(boolean escapeSqlRegex, boolean appendEscapeClause) {
            this.escapeSqlRegex = escapeSqlRegex;
            this.appendEscapeClause = appendEscapeClause;
        }

        @NotNull
        String decorateInner(@NotNull String value, @NotNull Dbms dbms) {
            if (value == null) {
                SqlRegexDecorator.$$$reportNull$$$0(0);
            }
            if (dbms == null) {
                SqlRegexDecorator.$$$reportNull$$$0(1);
            }
            if (!this.escapeSqlRegex) {
                String string = value;
                if (string == null) {
                    SqlRegexDecorator.$$$reportNull$$$0(2);
                }
                return string;
            }
            JdbcHelper helper = DbImplUtilCore.getJdbcHelper(dbms);
            if (!DbSqlUtilCore.stringsAreEscapedWithSlash(dbms) && !helper.supportsEscape()) {
                value = StringUtil.escapeBackSlashes((String)value);
            }
            String string = (String)helper.escapeSqlRegex((Object)value, true);
            if (string == null) {
                SqlRegexDecorator.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        String decorateOuter(@NotNull String value, @NotNull Dbms dbms) {
            if (value == null) {
                SqlRegexDecorator.$$$reportNull$$$0(4);
            }
            if (dbms == null) {
                SqlRegexDecorator.$$$reportNull$$$0(5);
            }
            if (!this.appendEscapeClause) {
                String string = value;
                if (string == null) {
                    SqlRegexDecorator.$$$reportNull$$$0(6);
                }
                return string;
            }
            JdbcHelper helper = DbImplUtilCore.getJdbcHelper(dbms);
            if (value.indexOf(helper.getEscapeChar()) == -1) {
                String string = value;
                if (string == null) {
                    SqlRegexDecorator.$$$reportNull$$$0(7);
                }
                return string;
            }
            String string = value + this.getTail(dbms);
            if (string == null) {
                SqlRegexDecorator.$$$reportNull$$$0(8);
            }
            return string;
        }

        @NotNull
        public String getTail(@NotNull Dbms dbms) {
            if (dbms == null) {
                SqlRegexDecorator.$$$reportNull$$$0(9);
            }
            if (!this.appendEscapeClause) {
                return "";
            }
            JdbcHelper helper = DbImplUtilCore.getJdbcHelper(dbms);
            String string = " ESCAPE '" + helper.getEscapeChar() + "'";
            if (string == null) {
                SqlRegexDecorator.$$$reportNull$$$0(10);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 6, 7, 8, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: 
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/util/DbSqlUtilCore$SqlRegexDecorator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/util/DbSqlUtilCore$SqlRegexDecorator";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "decorateInner";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "decorateOuter";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTail";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "decorateInner";
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "decorateOuter";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getTail";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 6, 7, 8, 10 -> new IllegalStateException(string);
            };
        }
    }
}

