/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.core.events.storage.mvstore;

import com.intellij.util.PlatformUtils;
import java.io.Closeable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.h2.mvstore.MVStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u001a\u0010\u0010\t\u001a\u00020\n2\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000e"}, d2={"MVSTORE_DB_VERSION", "", "PROVENANCE_MVSTORE_FILENAME", "", "getPROVENANCE_MVSTORE_FILENAME", "()Ljava/lang/String;", "getDatabaseFile", "Ljava/nio/file/Path;", "path", "openStore", "Lorg/h2/mvstore/MVStore;", "cleanupMvStoreArtifacts", "", "dbDir", "intellij.code.provenance.core"})
@SourceDebugExtension(value={"SMAP\nutil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 util.kt\ncom/intellij/code/provenance/core/events/storage/mvstore/UtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
public final class UtilKt {
    private static final int MVSTORE_DB_VERSION = 2;
    @NotNull
    private static final String PROVENANCE_MVSTORE_FILENAME = "provenance-events-mvstore-" + PlatformUtils.getPlatformPrefix() + "-v2.mv";

    @NotNull
    public static final String getPROVENANCE_MVSTORE_FILENAME() {
        return PROVENANCE_MVSTORE_FILENAME;
    }

    @NotNull
    public static final Path getDatabaseFile(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path2 = path.resolve(PROVENANCE_MVSTORE_FILENAME);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return path2;
    }

    @NotNull
    public static final MVStore openStore(@Nullable Path path) {
        Path path2;
        Path path3 = path;
        if (path3 != null) {
            Path it = path3;
            boolean bl = false;
            path2 = UtilKt.getDatabaseFile(path);
        } else {
            path2 = null;
        }
        Path dbFile = path2;
        MVStore.Builder builder = new MVStore.Builder();
        if (dbFile != null) {
            builder.fileName("nio:" + dbFile.toAbsolutePath());
        }
        builder.autoCommitDisabled();
        builder.compress();
        MVStore store = builder.open();
        store.setVersionsToKeep(0);
        Intrinsics.checkNotNull((Object)store);
        return store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void cleanupMvStoreArtifacts(@NotNull Path dbDir) {
        Intrinsics.checkNotNullParameter((Object)dbDir, (String)"dbDir");
        if (!Files.isDirectory(dbDir, new LinkOption[0])) {
            return;
        }
        String base = PROVENANCE_MVSTORE_FILENAME;
        Closeable closeable = Files.newDirectoryStream(dbDir, arg_0 -> UtilKt.cleanupMvStoreArtifacts$lambda$1(arg_0 -> UtilKt.cleanupMvStoreArtifacts$lambda$0(base, arg_0), arg_0));
        Throwable throwable = null;
        try {
            DirectoryStream ds = (DirectoryStream)closeable;
            boolean bl = false;
            Iterator iterator = ds.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Path p = (Path)iterator2.next();
                try {
                    Files.deleteIfExists(p);
                }
                catch (Exception exception) {}
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final boolean cleanupMvStoreArtifacts$lambda$0(String $base, Path p) {
        String name = ((Object)p.getFileName()).toString();
        return Intrinsics.areEqual((Object)name, (Object)$base) || StringsKt.startsWith$default((String)name, (String)($base + "."), (boolean)false, (int)2, null);
    }

    private static final boolean cleanupMvStoreArtifacts$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

