/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l = 137856984302904L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(1418963820 + 25239, 1418963820 + (char)-27141, (int)l));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1418963820 + 25238, -1418963820 + -((char)-31954), (int)l));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l;
            block2: {
                l = 129145258185394L;
                thread = Thread.currentThread();
                boolean bl2 = SshAgentIpcService.X();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (bl2) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl3 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-113375550 + -((char)-21193), 113506620 - (char)-32, (int)l) + string + WindowsNamedPipeAgentIpc.b(-113375550 + -((char)-21192), -113375550 + -((char)-13021), (int)l) + thread3 + WindowsNamedPipeAgentIpc.b(-113375550 + -((char)-21195), -113375550 + -((char)-29476), (int)l) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        block17: {
            boolean bl;
            block19: {
                block18: {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
                    boolean bl2;
                    long l;
                    block15: {
                        block16: {
                            l = 60312783578985L;
                            Object object = this.lock;
                            bl2 = SshAgentIpcService.X();
                            synchronized (object) {
                                boolean bl3;
                                boolean bl4 = false;
                                try {
                                    bl3 = this.connectionThread == null;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                if (!bl3) {
                                    boolean bl5 = false;
                                    String string = WindowsNamedPipeAgentIpc.b(-1442163210 + -10655, 1442163210 + 21416, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1442163210 + -10658, -1442163210 + -13023, (int)l) + this.state;
                                    throw new IllegalArgumentException(string.toString());
                                }
                                this.connectionThread = Thread.currentThread();
                                Unit unit = Unit.INSTANCE;
                            }
                            try {
                                try {
                                    WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                                    Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1442163210 + -10657, 1442163210 - 5945, (int)l));
                                    this.hPipe = hANDLE;
                                    windowsNamedPipeAgentIpc = this;
                                    if (bl2) break block15;
                                    if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                                    }
                                    break block16;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-1442163210 + -10652, -1442163210 + -13134, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1442163210 + -10651, 1442163210 - 6787, (int)l) + ErrorToolsKt.kernel32LastError());
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        this.state = NamedPipeState.Open;
                        windowsNamedPipeAgentIpc = this;
                    }
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
                    boolean bl6 = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1442163210 + -10654, 1442163210 + 21590, (int)l));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1442163210 + -10652, -1442163210 + -13134, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1442163210 + -10653, -1442163210 + -14486, (int)l));
                            if (ActionTimestamp.X() != 0) break block17;
                            if (!bl2) break block18;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = false;
                        break block19;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = true;
            }
            SshAgentIpcService.J(bl);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                boolean bl;
                block6: {
                    long l = 76892379523419L;
                    bl = SshAgentIpcService.J();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (!bl) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (!bl) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        Object object;
        Object object2;
        boolean bl;
        long l;
        block25: {
            block26: {
                l = 111997164747054L;
                this.assertConnectionThread();
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl2;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            bl = SshAgentIpcService.J();
                            boolean bl3 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (!bl) break block23;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl4 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1597481160 + (char)-28335, 1597481160 + (char)-14381, (int)l));
                            logger.info(WindowsNamedPipeAgentIpc.b(1597481160 + (char)-28331, 1597481160 + (char)-25561, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(1597481160 + (char)-28336, -1597481160 + -24971, (int)l) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl2 = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl2) {
                        boolean bl5 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1597481160 + (char)-28331, 1597481160 + (char)-25561, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(1597481160 + (char)-28333, -1597481160 + -((char)-28035), (int)l) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl6 = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1597481160 + (char)-28335, 1597481160 + (char)-14381, (int)l));
                    logger.info(WindowsNamedPipeAgentIpc.b(1597481160 + (char)-28331, 1597481160 + (char)-25561, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(1597481160 + (char)-28334, -1597481160 + -((char)-22217), (int)l));
                    object2 = Kernel32.INSTANCE;
                    if (!bl) break block25;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl7 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1597481160 + (char)-28335, 1597481160 + (char)-14381, (int)l));
                    logger.info(WindowsNamedPipeAgentIpc.b(1597481160 + (char)-28331, 1597481160 + (char)-25561, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(1597481160 + (char)-28355, 1597481160 + (char)-27752, (int)l));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(1597481160 + (char)-28331, 1597481160 + (char)-25561, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(1597481160 + (char)-28356, -1597481160 + -26856, (int)l) + ErrorToolsKt.prettyHRESULT((int)n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl8;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block27: {
                block28: {
                    boolean bl9 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (!bl) break block27;
                    try {
                        block29: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block28;
                            break block29;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl8 = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl8) {
                boolean bl10 = false;
                String string = WindowsNamedPipeAgentIpc.b(1597481160 + (char)-28331, 1597481160 + (char)-25561, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(1597481160 + (char)-28333, -1597481160 + -((char)-28035), (int)l) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl11 = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1597481160 + (char)-28335, 1597481160 + (char)-14381, (int)l));
        logger.info(WindowsNamedPipeAgentIpc.b(1597481160 + (char)-28331, 1597481160 + (char)-25561, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(1597481160 + (char)-28353, -1597481160 + -((char)-30312), (int)l));
        long l2 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l2);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        SshAgentIpc.Streams streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
            final /* synthetic */ PipeReadableByteChannel $read;
            final /* synthetic */ PipeWritableByteChannel $write;
            final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
            private static final String[] a;
            private static final String[] b;
            {
                this.$read = $read;
                this.$write = $write;
                this.this$0 = $receiver;
            }

            public InputStream getInputStream() {
                long l = 43852316534825L;
                InputStream inputStream = Channels.newInputStream(this.$read);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(700438080 - 15375, -700438080 - -2718, (int)l));
                return inputStream;
            }

            public OutputStream getOutputStream() {
                long l = 119412702252380L;
                OutputStream outputStream = Channels.newOutputStream(this.$write);
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-273412020 + -((char)-28409), 273412020 + (char)-8788, (int)l));
                return outputStream;
            }

            public void close() {
                WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var5 = new String[2];
                    var3_1 = 0;
                    var2_2 = "Q\u00fd\u00a5\u00a2\u009b\u0095\u0082\u00ba\u00a8\u0082\u00c3\u0017\u00f4a\u00f9\u00b2g\u000e\u00f6\u0014\u00e0K\u0093rFMD$\u00f2WMy\u00e7UZ\u00bf\u00fei\u00c2>";
                    var4_3 = "Q\u00fd\u00a5\u00a2\u009b\u0095\u0082\u00ba\u00a8\u0082\u00c3\u0017\u00f4a\u00f9\u00b2g\u000e\u00f6\u0014\u00e0K\u0093rFMD$\u00f2WMy\u00e7UZ\u00bf\u00fei\u00c2>".length();
                    var1_4 = 19;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl9:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = new String(v0).intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                    v3 = v2.length;
                    var6_6 = 0;
                    v4 = 105;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl67
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_6;
                        while (true) {
                            switch (var6_6 % 7) {
                                case 0: {
                                    v11 = 9;
                                    break;
                                }
                                case 1: {
                                    v11 = 53;
                                    break;
                                }
                                case 2: {
                                    v11 = 62;
                                    break;
                                }
                                case 3: {
                                    v11 = 127;
                                    break;
                                }
                                case 4: {
                                    v11 = 91;
                                    break;
                                }
                                case 5: {
                                    v11 = 122;
                                    break;
                                }
                                default: {
                                    v11 = 8;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_6;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl67:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_6);
                    ** while (true)
                }
                accept.3.a = var5;
                accept.3.b = new String[2];
            }

            private static String a(int n2, int n3, int n4) {
                int n5 = (n2 ^ n4 ^ 0x7218) & 0xFFFF;
                if (b[n5] == null) {
                    int n6;
                    char[] cArray = a[n5].toCharArray();
                    int n7 = switch (cArray[0] & 0xFF) {
                        case 0 -> 23;
                        case 1 -> 125;
                        case 2 -> 123;
                        case 3 -> 44;
                        case 4 -> 202;
                        case 5 -> 65;
                        case 6 -> 142;
                        case 7 -> 140;
                        case 8 -> 36;
                        case 9 -> 255;
                        case 10 -> 9;
                        case 11 -> 171;
                        case 12 -> 42;
                        case 13 -> 168;
                        case 14 -> 212;
                        case 15 -> 130;
                        case 16 -> 126;
                        case 17 -> 95;
                        case 18 -> 124;
                        case 19 -> 136;
                        case 20 -> 215;
                        case 21 -> 254;
                        case 22 -> 249;
                        case 23 -> 181;
                        case 24 -> 222;
                        case 25 -> 148;
                        case 26 -> 15;
                        case 27 -> 72;
                        case 28 -> 240;
                        case 29 -> 167;
                        case 30 -> 233;
                        case 31 -> 19;
                        case 32 -> 175;
                        case 33 -> 103;
                        case 34 -> 54;
                        case 35 -> 86;
                        case 36 -> 224;
                        case 37 -> 98;
                        case 38 -> 214;
                        case 39 -> 205;
                        case 40 -> 139;
                        case 41 -> 173;
                        case 42 -> 110;
                        case 43 -> 26;
                        case 44 -> 77;
                        case 45 -> 235;
                        case 46 -> 190;
                        case 47 -> 253;
                        case 48 -> 107;
                        case 49 -> 24;
                        case 50 -> 230;
                        case 51 -> 122;
                        case 52 -> 31;
                        case 53 -> 183;
                        case 54 -> 45;
                        case 55 -> 94;
                        case 56 -> 116;
                        case 57 -> 117;
                        case 58 -> 237;
                        case 59 -> 213;
                        case 60 -> 166;
                        case 61 -> 30;
                        case 62 -> 176;
                        case 63 -> 227;
                        case 64 -> 185;
                        case 65 -> 180;
                        case 66 -> 41;
                        case 67 -> 67;
                        case 68 -> 232;
                        case 69 -> 177;
                        case 70 -> 218;
                        case 71 -> 163;
                        case 72 -> 39;
                        case 73 -> 38;
                        case 74 -> 37;
                        case 75 -> 93;
                        case 76 -> 106;
                        case 77 -> 221;
                        case 78 -> 159;
                        case 79 -> 18;
                        case 80 -> 58;
                        case 81 -> 61;
                        case 82 -> 100;
                        case 83 -> 46;
                        case 84 -> 14;
                        case 85 -> 225;
                        case 86 -> 7;
                        case 87 -> 64;
                        case 88 -> 155;
                        case 89 -> 40;
                        case 90 -> 188;
                        case 91 -> 82;
                        case 92 -> 114;
                        case 93 -> 131;
                        case 94 -> 194;
                        case 95 -> 10;
                        case 96 -> 152;
                        case 97 -> 137;
                        case 98 -> 92;
                        case 99 -> 248;
                        case 100 -> 35;
                        case 101 -> 219;
                        case 102 -> 75;
                        case 103 -> 115;
                        case 104 -> 79;
                        case 105 -> 179;
                        case 106 -> 49;
                        case 107 -> 208;
                        case 108 -> 104;
                        case 109 -> 170;
                        case 110 -> 239;
                        case 111 -> 186;
                        case 112 -> 141;
                        case 113 -> 6;
                        case 114 -> 134;
                        case 115 -> 32;
                        case 116 -> 76;
                        case 117 -> 50;
                        case 118 -> 47;
                        case 119 -> 87;
                        case 120 -> 48;
                        case 121 -> 34;
                        case 122 -> 20;
                        case 123 -> 245;
                        case 124 -> 16;
                        case 125 -> 68;
                        case 126 -> 52;
                        case 127 -> 199;
                        case 128 -> 78;
                        case 129 -> 1;
                        case 130 -> 105;
                        case 131 -> 33;
                        case 132 -> 151;
                        case 133 -> 172;
                        case 134 -> 200;
                        case 135 -> 133;
                        case 136 -> 162;
                        case 137 -> 21;
                        case 138 -> 62;
                        case 139 -> 99;
                        case 140 -> 108;
                        case 141 -> 203;
                        case 142 -> 71;
                        case 143 -> 85;
                        case 144 -> 169;
                        case 145 -> 28;
                        case 146 -> 60;
                        case 147 -> 5;
                        case 148 -> 27;
                        case 149 -> 80;
                        case 150 -> 22;
                        case 151 -> 251;
                        case 152 -> 187;
                        case 153 -> 158;
                        case 154 -> 97;
                        case 155 -> 112;
                        case 156 -> 73;
                        case 157 -> 244;
                        case 158 -> 84;
                        case 159 -> 8;
                        case 160 -> 156;
                        case 161 -> 138;
                        case 162 -> 70;
                        case 163 -> 0;
                        case 164 -> 229;
                        case 165 -> 4;
                        case 166 -> 246;
                        case 167 -> 74;
                        case 168 -> 25;
                        case 169 -> 132;
                        case 170 -> 127;
                        case 171 -> 91;
                        case 172 -> 96;
                        case 173 -> 161;
                        case 174 -> 160;
                        case 175 -> 198;
                        case 176 -> 234;
                        case 177 -> 51;
                        case 178 -> 204;
                        case 179 -> 236;
                        case 180 -> 90;
                        case 181 -> 66;
                        case 182 -> 211;
                        case 183 -> 57;
                        case 184 -> 154;
                        case 185 -> 69;
                        case 186 -> 150;
                        case 187 -> 121;
                        case 188 -> 43;
                        case 189 -> 238;
                        case 190 -> 201;
                        case 191 -> 17;
                        case 192 -> 209;
                        case 193 -> 29;
                        case 194 -> 217;
                        case 195 -> 241;
                        case 196 -> 3;
                        case 197 -> 63;
                        case 198 -> 243;
                        case 199 -> 13;
                        case 200 -> 128;
                        case 201 -> 231;
                        case 202 -> 119;
                        case 203 -> 11;
                        case 204 -> 193;
                        case 205 -> 191;
                        case 206 -> 146;
                        case 207 -> 55;
                        case 208 -> 247;
                        case 209 -> 216;
                        case 210 -> 102;
                        case 211 -> 189;
                        case 212 -> 53;
                        case 213 -> 56;
                        case 214 -> 101;
                        case 215 -> 197;
                        case 216 -> 164;
                        case 217 -> 228;
                        case 218 -> 109;
                        case 219 -> 143;
                        case 220 -> 129;
                        case 221 -> 111;
                        case 222 -> 83;
                        case 223 -> 157;
                        case 224 -> 223;
                        case 225 -> 135;
                        case 226 -> 178;
                        case 227 -> 174;
                        case 228 -> 89;
                        case 229 -> 118;
                        case 230 -> 165;
                        case 231 -> 88;
                        case 232 -> 182;
                        case 233 -> 144;
                        case 234 -> 149;
                        case 235 -> 196;
                        case 236 -> 195;
                        case 237 -> 207;
                        case 238 -> 210;
                        case 239 -> 2;
                        case 240 -> 120;
                        case 241 -> 113;
                        case 242 -> 192;
                        case 243 -> 12;
                        case 244 -> 220;
                        case 245 -> 242;
                        case 246 -> 226;
                        case 247 -> 206;
                        case 248 -> 59;
                        case 249 -> 81;
                        case 250 -> 145;
                        case 251 -> 184;
                        case 252 -> 153;
                        case 253 -> 252;
                        case 254 -> 250;
                        default -> 147;
                    };
                    int n8 = ((n3 ^= n4) & 0xFF) - n7;
                    if (n8 < 0) {
                        n8 += 256;
                    }
                    if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                        n6 += 256;
                    }
                    int n9 = 0;
                    while (n9 < cArray.length) {
                        int n10 = n9 % 2;
                        int n11 = n9;
                        char[] cArray2 = cArray;
                        char c2 = cArray[n11];
                        if (n10 == 0) {
                            cArray2[n11] = (char)(c2 ^ n8);
                            n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                        } else {
                            cArray2[n11] = (char)(c2 ^ n6);
                            n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                        }
                        ++n9;
                    }
                    accept.3.b[n5] = new String(cArray).intern();
                }
                return b[n5];
            }
        };
        if (!bl) {
            int n3 = ActionTimestamp.J();
            ActionTimestamp.J(++n3);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l2;
            block2: {
                block3: {
                    l2 = 79675280166142L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    boolean bl2 = SshAgentIpcService.J();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (!bl2) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-658102470 + -24433, -658102470 + -((char)-30225), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-658102470 + -24429, -658102470 + -24059, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-658102470 + -24420, 658102470 + 16255, (int)l2) + uLONG);
                    l = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-658102470 + -24433, -658102470 + -((char)-30225), (int)l2));
            logger.warn(WindowsNamedPipeAgentIpc.b(-658102470 + -24429, -658102470 + -24059, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-658102470 + -24425, -658102470 + -14830, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n3));
            l = -1L;
        }
        long l3 = l;
        return l3;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    boolean bl2;
                    block13: {
                        long l = 115655869185906L;
                        boolean bl3 = SshAgentIpcService.J();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(989840640 + 12124, -989840640 - -16914, (int)l));
                        bl2 = bl3;
                        try {
                            try {
                                try {
                                    try {
                                        if (!bl2 || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (!bl2) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(989840640 + 12127, 989840640 + 11581, (int)l);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (!bl2) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        boolean bl;
        long l;
        block25: {
            block26: {
                l = 114354809237315L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl2;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    bl = SshAgentIpcService.J();
                                    boolean bl3 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (!bl) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (!bl) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl4 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1304932920 + 29244, 1304932920 + (char)-13122, (int)l));
                            logger.info(WindowsNamedPipeAgentIpc.b(1304932920 + 29240, 1304932920 + 30794, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(1304932920 + 29239, 1304932920 + (char)-26791, (int)l));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl2 = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl2) {
                        boolean bl5 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1304932920 + 29240, 1304932920 + 30794, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(1304932920 + 29246, -1304932920 + -29426, (int)l) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl6 = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1304932920 + 29244, 1304932920 + (char)-13122, (int)l));
                    logger.info(WindowsNamedPipeAgentIpc.b(1304932920 + 29240, 1304932920 + 30794, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(1304932920 + 29224, 1304932920 + 31664, (int)l));
                    object = Kernel32.INSTANCE;
                    if (!bl) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl6 = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1304932920 + 29244, 1304932920 + (char)-13122, (int)l));
                logger.warn(WindowsNamedPipeAgentIpc.b(1304932920 + 29240, 1304932920 + 30794, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(1304932920 + 29225, 1304932920 + (char)-20943, (int)l) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl7 = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (!bl) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl8 = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1304932920 + 29244, 1304932920 + (char)-13122, (int)l));
        logger.info(WindowsNamedPipeAgentIpc.b(1304932920 + 29240, 1304932920 + 30794, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(1304932920 + 29226, 1304932920 + (char)-17253, (int)l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l;
            block15: {
                boolean bl2;
                block16: {
                    l = 140100747550248L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                bl2 = SshAgentIpcService.X();
                                boolean bl3 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (bl2) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl4 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1085652810 + -11159, -1085652810 - -3815, (int)l));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1085652810 + -11163, -1085652810 + -9421, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1085652810 + -11182, -1085652810 + -11764, (int)l) + this.state + WindowsNamedPipeAgentIpc.b(-1085652810 + -11175, -1085652810 - -7080, (int)l));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1085652810 + -11159, -1085652810 - -3815, (int)l));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1085652810 + -11163, -1085652810 + -9421, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1085652810 + -11176, 1085652810 + 15609, (int)l));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (bl2) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (bl2) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl5 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1085652810 + -11159, -1085652810 - -3815, (int)l));
                        logger.info(WindowsNamedPipeAgentIpc.b(-1085652810 + -11163, -1085652810 + -9421, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1085652810 + -11177, -1085652810 + -10582, (int)l) + ErrorToolsKt.prettyHRESULT((int)n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1085652810 + -11159, -1085652810 - -3815, (int)l));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1085652810 + -11163, -1085652810 + -9421, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1085652810 + -11178, -1085652810 - -178, (int)l));
                    if (bl2) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1085652810 + -11159, -1085652810 - -3815, (int)l));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1085652810 + -11163, -1085652810 + -9421, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1085652810 + -11139, 1085652810 + 1561, (int)l) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1085652810 + -11140, 1085652810 + 5363, (int)l));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u00b0\u00f3\u00f4\u00be\u00ac6\u0018a\u0014\u00b2J\u008cn]\u00a4\u0089)\u00a3<\u009a\u00b6\u00d1\u00fc\"2]w\u008b'\u0006\u00b4\u009ft3\u00d6\u00c6\u0018\u0095\u00f1\b)O\u0089\u00c9Lc\u00ed\u008d\u00fcUJ\u00e0f\u00ac\u0094\u009b\u00c6m0%\u001e\t\u00d3\u00d9^\u009d\u00ee\u0080\u00e5%\u00da\u0005\fecl.\b\u008cas\u009d\u000etJ\u00cb\u0014\u00e2\u00a7\u00feH~h\u00d8'\u00e7 \u00b9\u0081\u00ff\u00b9\\w\u0080\f\u00c9\n\u0005F\u00ea*\u009d\u0007\u001e\u00f0\u00d1\u00e9\u009e\u00e2\u00bb\u00dep$~.\tm\u00d4E\u00d1\u00f9\u00f3\u00e3\u00de\u00ce\u001c]V\u0012^\u0094;^\u00ce\u0010\u009b\u0018`b\u0084\u0016\u00e4<\u001eE\u00e4\u00932\u00d2\u0001\u008e\t^\u00829\u00e7Q\u00e84\u00b7\u000e\u0010\u00fdj\u00ac,\u001d\u00df\u00d7\u0005xb(w\u00abN2\u001d?cI\u0093\u008d\u00a0\u00d0\u0013q\u00ec\u008fr\u00ccY\u009a\u00fe!K\u0088\u00c8t%\u001b[\u00d0\u00c2f\u0083\u0088\u008b\u00ee\u001aj\u00fd[T\u0089\u000e6S\u00f9\u00ac7\u00dd\u00b56t\u0016\u0010\u00c3\u001b)\u00a1\u00aeW!\u0019|\u00ad3(\u00f4d\u00fa\bn\u00a5/\u0005\u0085g;\u00a9\fL\u00c7{R\u0012\u00ef'\u00bfO}\u009c\u0090F\u0099\u00b5\u00c1\u001cE&\u00cd\u0086\u0012V=1&-\u000e\u00f1\u00a9\u00f5\u0094t\u00bcIk\u00a8\u00f2Bv\u0007\u008a6\u0000M\u0082\ty\u00e2q\u0016\u00179\u00b7:5\u00ef\u00f5\u00ba:\u00b4\u00a1w\u0003\u0086\u0004%bL\u008bs[O\u00ca\u00e1aT\u0012\u00c2:\u00c5$:\u001f\u008c\u0094f6\u0013\u00ae\u00e0\u00d2\u00e3*\u00d6\u0083r\u0098\u00ad\u00e9\u009f\u001cR\u00e93z51~b\u000ep\u0010VQ\u000b\u00f3:\u008c\u00ed\u00ec\u0018\u00f8A\u00b4\u00ae\u00e9\u0015G\u0005\u001a\t9\u00ec\u00ae\u00a2@2\u00bfK\u00e1-\u00c2\t\u0089\u0094M\u0081\u00e6)\u00dfG\fL^\u00e1I;\u00d6\u0017p$\u00a2f)3P\u00cfp4\u0087\u00b9eQ\u001b'u\u00a0P\u00b8\u00db\u00a2\u0007Q\u00afd\u00b5\u00db\u0004)v\u0007\u00f8u\u00e2\u0010\u00a77\u00ed\u0007\u0019.\u00ba\u0017K8f(\u00af\u0083N\u00f5\u00a6\u00bc\u00a0\u00b7\u009bQ\u00f3\u00da\u00f18\u0001{Rk\u009e\u00e3;}\u009d\u0002\u0094\u00f12\u0001\u008f\u00ec\u00fb1\u00f8H\u00ce\u00ea#wEO\u000fT\u00d6\u007fvh\u00a0\u00dc\u00f7a\u00d4\r;\u008ePp\"\u00a6\u0096#v\u00bb\u00a6\u00f5\u00d3A\n\u0082\u0087\u00ff\u001e\u00e6\u00f2B\u00de\u00b8Tt\u00b5\u00bb\u0080SI\u00b1\u00b3\u00ec\u00e8\u00ee\u00af\u008f\u0003\u000ej\u00de\u00b8w\u0090\u0080\u00c3\u00f3\u0082Tq+\rX\u001bU\u009cX:w\u009c\u00aa,\u00f8(\u00b3\u00a5\u0005\u00bf\u009f\u00d0\u00c50\u00f5\u0015\u00e6\u00a9\u009a\u00a5<\u0080\t\nW\u00de\u00dcu\u00f3\u0091\u00e9\u00a7;;\u0018~\u00ac=1\u00daA>\u00c9t]\u00e0\u0094\u00d6\u00ca\u0019_b\u00c0\u00d6r\u00fa\u000eB\u0002)\u00e7\u00cd\u000b\u001d\u00be\u00cbU~U\u00bf\u00001\u00a8\u00cd\u00f7=\u00f5{\u001bg\u00d0\u00c3\u00c6\u0012\u001a\u00dd\u00c8\u0013\u00b4\u0092\u00fcv\u00c6\u0015Bx\u00d6|h\u00dd\u00fb\tzp\u00bd\u00a7\u00cb/1\u0014\u0013";
                var4_3 = "\u00b0\u00f3\u00f4\u00be\u00ac6\u0018a\u0014\u00b2J\u008cn]\u00a4\u0089)\u00a3<\u009a\u00b6\u00d1\u00fc\"2]w\u008b'\u0006\u00b4\u009ft3\u00d6\u00c6\u0018\u0095\u00f1\b)O\u0089\u00c9Lc\u00ed\u008d\u00fcUJ\u00e0f\u00ac\u0094\u009b\u00c6m0%\u001e\t\u00d3\u00d9^\u009d\u00ee\u0080\u00e5%\u00da\u0005\fecl.\b\u008cas\u009d\u000etJ\u00cb\u0014\u00e2\u00a7\u00feH~h\u00d8'\u00e7 \u00b9\u0081\u00ff\u00b9\\w\u0080\f\u00c9\n\u0005F\u00ea*\u009d\u0007\u001e\u00f0\u00d1\u00e9\u009e\u00e2\u00bb\u00dep$~.\tm\u00d4E\u00d1\u00f9\u00f3\u00e3\u00de\u00ce\u001c]V\u0012^\u0094;^\u00ce\u0010\u009b\u0018`b\u0084\u0016\u00e4<\u001eE\u00e4\u00932\u00d2\u0001\u008e\t^\u00829\u00e7Q\u00e84\u00b7\u000e\u0010\u00fdj\u00ac,\u001d\u00df\u00d7\u0005xb(w\u00abN2\u001d?cI\u0093\u008d\u00a0\u00d0\u0013q\u00ec\u008fr\u00ccY\u009a\u00fe!K\u0088\u00c8t%\u001b[\u00d0\u00c2f\u0083\u0088\u008b\u00ee\u001aj\u00fd[T\u0089\u000e6S\u00f9\u00ac7\u00dd\u00b56t\u0016\u0010\u00c3\u001b)\u00a1\u00aeW!\u0019|\u00ad3(\u00f4d\u00fa\bn\u00a5/\u0005\u0085g;\u00a9\fL\u00c7{R\u0012\u00ef'\u00bfO}\u009c\u0090F\u0099\u00b5\u00c1\u001cE&\u00cd\u0086\u0012V=1&-\u000e\u00f1\u00a9\u00f5\u0094t\u00bcIk\u00a8\u00f2Bv\u0007\u008a6\u0000M\u0082\ty\u00e2q\u0016\u00179\u00b7:5\u00ef\u00f5\u00ba:\u00b4\u00a1w\u0003\u0086\u0004%bL\u008bs[O\u00ca\u00e1aT\u0012\u00c2:\u00c5$:\u001f\u008c\u0094f6\u0013\u00ae\u00e0\u00d2\u00e3*\u00d6\u0083r\u0098\u00ad\u00e9\u009f\u001cR\u00e93z51~b\u000ep\u0010VQ\u000b\u00f3:\u008c\u00ed\u00ec\u0018\u00f8A\u00b4\u00ae\u00e9\u0015G\u0005\u001a\t9\u00ec\u00ae\u00a2@2\u00bfK\u00e1-\u00c2\t\u0089\u0094M\u0081\u00e6)\u00dfG\fL^\u00e1I;\u00d6\u0017p$\u00a2f)3P\u00cfp4\u0087\u00b9eQ\u001b'u\u00a0P\u00b8\u00db\u00a2\u0007Q\u00afd\u00b5\u00db\u0004)v\u0007\u00f8u\u00e2\u0010\u00a77\u00ed\u0007\u0019.\u00ba\u0017K8f(\u00af\u0083N\u00f5\u00a6\u00bc\u00a0\u00b7\u009bQ\u00f3\u00da\u00f18\u0001{Rk\u009e\u00e3;}\u009d\u0002\u0094\u00f12\u0001\u008f\u00ec\u00fb1\u00f8H\u00ce\u00ea#wEO\u000fT\u00d6\u007fvh\u00a0\u00dc\u00f7a\u00d4\r;\u008ePp\"\u00a6\u0096#v\u00bb\u00a6\u00f5\u00d3A\n\u0082\u0087\u00ff\u001e\u00e6\u00f2B\u00de\u00b8Tt\u00b5\u00bb\u0080SI\u00b1\u00b3\u00ec\u00e8\u00ee\u00af\u008f\u0003\u000ej\u00de\u00b8w\u0090\u0080\u00c3\u00f3\u0082Tq+\rX\u001bU\u009cX:w\u009c\u00aa,\u00f8(\u00b3\u00a5\u0005\u00bf\u009f\u00d0\u00c50\u00f5\u0015\u00e6\u00a9\u009a\u00a5<\u0080\t\nW\u00de\u00dcu\u00f3\u0091\u00e9\u00a7;;\u0018~\u00ac=1\u00daA>\u00c9t]\u00e0\u0094\u00d6\u00ca\u0019_b\u00c0\u00d6r\u00fa\u000eB\u0002)\u00e7\u00cd\u000b\u001d\u00be\u00cbU~U\u00bf\u00001\u00a8\u00cd\u00f7=\u00f5{\u001bg\u00d0\u00c3\u00c6\u0012\u001a\u00dd\u00c8\u0013\u00b4\u0092\u00fcv\u00c6\u0015Bx\u00d6|h\u00dd\u00fb\tzp\u00bd\u00a7\u00cb/1\u0014\u0013".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 40;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u001e\u00c5\u00cb\u00e3Y\u00ebV\u0085\u00ca?\f\u00de\u00d6\u00cf\u00c7\u0082\f\u007f\u008b\u009ch|\u00dd\u00c4-\u00e4@\u008e\u00ca\u0014\u008c!\u00b4\u00fc\u00a5\tic@\u008a\u0019\u009f^&,\u0096c\u001c\u00b3\u00b5";
                    var4_3 = "\u001e\u00c5\u00cb\u00e3Y\u00ebV\u0085\u00ca?\f\u00de\u00d6\u00cf\u00c7\u0082\f\u007f\u008b\u009ch|\u00dd\u00c4-\u00e4@\u008e\u00ca\u0014\u008c!\u00b4\u00fc\u00a5\tic@\u008a\u0019\u009f^&,\u0096c\u001c\u00b3\u00b5".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 125;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 15;
                            break;
                        }
                        case 1: {
                            v15 = 62;
                            break;
                        }
                        case 2: {
                            v15 = 32;
                            break;
                        }
                        case 3: {
                            v15 = 11;
                            break;
                        }
                        case 4: {
                            v15 = 53;
                            break;
                        }
                        case 5: {
                            v15 = 5;
                            break;
                        }
                        default: {
                            v15 = 40;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x4B3B) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 236;
                case 1 -> 246;
                case 2 -> 203;
                case 3 -> 53;
                case 4 -> 30;
                case 5 -> 230;
                case 6 -> 132;
                case 7 -> 15;
                case 8 -> 183;
                case 9 -> 243;
                case 10 -> 89;
                case 11 -> 227;
                case 12 -> 143;
                case 13 -> 133;
                case 14 -> 136;
                case 15 -> 29;
                case 16 -> 106;
                case 17 -> 33;
                case 18 -> 187;
                case 19 -> 214;
                case 20 -> 178;
                case 21 -> 7;
                case 22 -> 193;
                case 23 -> 153;
                case 24 -> 20;
                case 25 -> 114;
                case 26 -> 66;
                case 27 -> 102;
                case 28 -> 21;
                case 29 -> 207;
                case 30 -> 249;
                case 31 -> 223;
                case 32 -> 204;
                case 33 -> 129;
                case 34 -> 119;
                case 35 -> 131;
                case 36 -> 173;
                case 37 -> 60;
                case 38 -> 185;
                case 39 -> 70;
                case 40 -> 182;
                case 41 -> 189;
                case 42 -> 4;
                case 43 -> 128;
                case 44 -> 224;
                case 45 -> 239;
                case 46 -> 140;
                case 47 -> 107;
                case 48 -> 32;
                case 49 -> 45;
                case 50 -> 126;
                case 51 -> 108;
                case 52 -> 121;
                case 53 -> 137;
                case 54 -> 255;
                case 55 -> 95;
                case 56 -> 36;
                case 57 -> 186;
                case 58 -> 91;
                case 59 -> 22;
                case 60 -> 252;
                case 61 -> 218;
                case 62 -> 2;
                case 63 -> 205;
                case 64 -> 208;
                case 65 -> 196;
                case 66 -> 231;
                case 67 -> 59;
                case 68 -> 5;
                case 69 -> 206;
                case 70 -> 100;
                case 71 -> 151;
                case 72 -> 52;
                case 73 -> 34;
                case 74 -> 167;
                case 75 -> 61;
                case 76 -> 37;
                case 77 -> 25;
                case 78 -> 194;
                case 79 -> 175;
                case 80 -> 92;
                case 81 -> 49;
                case 82 -> 164;
                case 83 -> 184;
                case 84 -> 141;
                case 85 -> 23;
                case 86 -> 28;
                case 87 -> 157;
                case 88 -> 123;
                case 89 -> 8;
                case 90 -> 83;
                case 91 -> 65;
                case 92 -> 152;
                case 93 -> 217;
                case 94 -> 82;
                case 95 -> 68;
                case 96 -> 97;
                case 97 -> 176;
                case 98 -> 40;
                case 99 -> 163;
                case 100 -> 226;
                case 101 -> 158;
                case 102 -> 156;
                case 103 -> 199;
                case 104 -> 99;
                case 105 -> 179;
                case 106 -> 192;
                case 107 -> 222;
                case 108 -> 245;
                case 109 -> 67;
                case 110 -> 80;
                case 111 -> 47;
                case 112 -> 26;
                case 113 -> 125;
                case 114 -> 162;
                case 115 -> 98;
                case 116 -> 39;
                case 117 -> 144;
                case 118 -> 169;
                case 119 -> 43;
                case 120 -> 116;
                case 121 -> 198;
                case 122 -> 180;
                case 123 -> 87;
                case 124 -> 117;
                case 125 -> 57;
                case 126 -> 159;
                case 127 -> 171;
                case 128 -> 90;
                case 129 -> 111;
                case 130 -> 0;
                case 131 -> 174;
                case 132 -> 154;
                case 133 -> 27;
                case 134 -> 134;
                case 135 -> 9;
                case 136 -> 42;
                case 137 -> 38;
                case 138 -> 84;
                case 139 -> 56;
                case 140 -> 86;
                case 141 -> 63;
                case 142 -> 242;
                case 143 -> 112;
                case 144 -> 76;
                case 145 -> 79;
                case 146 -> 35;
                case 147 -> 11;
                case 148 -> 12;
                case 149 -> 130;
                case 150 -> 145;
                case 151 -> 120;
                case 152 -> 200;
                case 153 -> 93;
                case 154 -> 191;
                case 155 -> 238;
                case 156 -> 14;
                case 157 -> 220;
                case 158 -> 212;
                case 159 -> 211;
                case 160 -> 161;
                case 161 -> 139;
                case 162 -> 72;
                case 163 -> 104;
                case 164 -> 115;
                case 165 -> 188;
                case 166 -> 81;
                case 167 -> 77;
                case 168 -> 73;
                case 169 -> 244;
                case 170 -> 85;
                case 171 -> 237;
                case 172 -> 44;
                case 173 -> 234;
                case 174 -> 135;
                case 175 -> 213;
                case 176 -> 170;
                case 177 -> 55;
                case 178 -> 155;
                case 179 -> 168;
                case 180 -> 58;
                case 181 -> 197;
                case 182 -> 105;
                case 183 -> 216;
                case 184 -> 201;
                case 185 -> 235;
                case 186 -> 64;
                case 187 -> 148;
                case 188 -> 46;
                case 189 -> 250;
                case 190 -> 202;
                case 191 -> 228;
                case 192 -> 78;
                case 193 -> 241;
                case 194 -> 113;
                case 195 -> 209;
                case 196 -> 165;
                case 197 -> 50;
                case 198 -> 122;
                case 199 -> 16;
                case 200 -> 190;
                case 201 -> 166;
                case 202 -> 96;
                case 203 -> 51;
                case 204 -> 172;
                case 205 -> 251;
                case 206 -> 3;
                case 207 -> 233;
                case 208 -> 138;
                case 209 -> 118;
                case 210 -> 210;
                case 211 -> 181;
                case 212 -> 160;
                case 213 -> 48;
                case 214 -> 41;
                case 215 -> 1;
                case 216 -> 229;
                case 217 -> 71;
                case 218 -> 248;
                case 219 -> 103;
                case 220 -> 147;
                case 221 -> 215;
                case 222 -> 24;
                case 223 -> 177;
                case 224 -> 127;
                case 225 -> 17;
                case 226 -> 74;
                case 227 -> 109;
                case 228 -> 225;
                case 229 -> 54;
                case 230 -> 232;
                case 231 -> 31;
                case 232 -> 254;
                case 233 -> 10;
                case 234 -> 221;
                case 235 -> 150;
                case 236 -> 110;
                case 237 -> 69;
                case 238 -> 88;
                case 239 -> 75;
                case 240 -> 146;
                case 241 -> 101;
                case 242 -> 6;
                case 243 -> 18;
                case 244 -> 124;
                case 245 -> 219;
                case 246 -> 253;
                case 247 -> 62;
                case 248 -> 240;
                case 249 -> 195;
                case 250 -> 142;
                case 251 -> 149;
                case 252 -> 13;
                case 253 -> 247;
                case 254 -> 94;
                default -> 19;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l = 110473330000146L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1818727320 + (char)-7232, -1818727320 + -((char)-25868), (int)l));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        boolean bl2;
                        block4: {
                            l = 129699361727753L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            bl2 = SshAgentIpcService.J();
                            try {
                                hANDLE2 = hANDLE;
                                if (!bl2) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (!bl2) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl3 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(60685410 - 10528, 60685410 - 14178, (int)l));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(60685410 - 10529, 60685410 - 20001, (int)l) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(60685410 - 10530, 60685410 - 6124, (int)l));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00b8\u00c3\u0092\u001f\u0085%\u0099&\u0010\u0095,\u00c6C\u00b5\u0015fyF\u008aH\u008f\u0080\u00f5rb";
                    var4_3 = "\u00b8\u00c3\u0092\u001f\u0085%\u0099&\u0010\u0095,\u00c6C\u00b5\u0015fyF\u008aH\u008f\u0080\u00f5rb".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 67;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "t\u00f4\u00e5\u0017\u00f55NB\u00b5\u00ad-\u001f\u0083}c_\u0090\u001b\u0082c\u00d9\u00d48\u00b6:\u00eb-\u00a6\u0010\u00ba\u0083\u008f}\u00d5\u000f\u0093\u00d2\u00cb\u0013\u001a\u00c7+_\u00c1tg1\u00812m\u0017\u00cd\u00cb|\u0086\u00abt\u001b\t";
                        var4_3 = "t\u00f4\u00e5\u0017\u00f55NB\u00b5\u00ad-\u001f\u0083}c_\u0090\u001b\u0082c\u00d9\u00d48\u00b6:\u00eb-\u00a6\u0010\u00ba\u0083\u008f}\u00d5\u000f\u0093\u00d2\u00cb\u0013\u001a\u00c7+_\u00c1tg1\u00812m\u0017\u00cd\u00cb|\u0086\u00abt\u001b\t".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 76;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 45;
                                break;
                            }
                            case 1: {
                                v15 = 121;
                                break;
                            }
                            case 2: {
                                v15 = 5;
                                break;
                            }
                            case 3: {
                                v15 = 66;
                                break;
                            }
                            case 4: {
                                v15 = 114;
                                break;
                            }
                            case 5: {
                                v15 = 13;
                                break;
                            }
                            default: {
                                v15 = 98;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFF64A) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 114;
                    case 1 -> 246;
                    case 2 -> 158;
                    case 3 -> 37;
                    case 4 -> 195;
                    case 5 -> 2;
                    case 6 -> 247;
                    case 7 -> 228;
                    case 8 -> 156;
                    case 9 -> 202;
                    case 10 -> 139;
                    case 11 -> 220;
                    case 12 -> 39;
                    case 13 -> 164;
                    case 14 -> 14;
                    case 15 -> 188;
                    case 16 -> 233;
                    case 17 -> 218;
                    case 18 -> 161;
                    case 19 -> 8;
                    case 20 -> 186;
                    case 21 -> 227;
                    case 22 -> 245;
                    case 23 -> 81;
                    case 24 -> 165;
                    case 25 -> 136;
                    case 26 -> 50;
                    case 27 -> 210;
                    case 28 -> 5;
                    case 29 -> 90;
                    case 30 -> 88;
                    case 31 -> 76;
                    case 32 -> 70;
                    case 33 -> 102;
                    case 34 -> 120;
                    case 35 -> 72;
                    case 36 -> 167;
                    case 37 -> 44;
                    case 38 -> 216;
                    case 39 -> 243;
                    case 40 -> 62;
                    case 41 -> 74;
                    case 42 -> 238;
                    case 43 -> 43;
                    case 44 -> 42;
                    case 45 -> 51;
                    case 46 -> 26;
                    case 47 -> 106;
                    case 48 -> 173;
                    case 49 -> 25;
                    case 50 -> 162;
                    case 51 -> 147;
                    case 52 -> 191;
                    case 53 -> 9;
                    case 54 -> 169;
                    case 55 -> 41;
                    case 56 -> 55;
                    case 57 -> 100;
                    case 58 -> 21;
                    case 59 -> 205;
                    case 60 -> 84;
                    case 61 -> 4;
                    case 62 -> 200;
                    case 63 -> 3;
                    case 64 -> 190;
                    case 65 -> 148;
                    case 66 -> 214;
                    case 67 -> 171;
                    case 68 -> 96;
                    case 69 -> 128;
                    case 70 -> 137;
                    case 71 -> 183;
                    case 72 -> 110;
                    case 73 -> 182;
                    case 74 -> 127;
                    case 75 -> 252;
                    case 76 -> 129;
                    case 77 -> 98;
                    case 78 -> 187;
                    case 79 -> 159;
                    case 80 -> 197;
                    case 81 -> 89;
                    case 82 -> 232;
                    case 83 -> 250;
                    case 84 -> 229;
                    case 85 -> 71;
                    case 86 -> 16;
                    case 87 -> 0;
                    case 88 -> 18;
                    case 89 -> 134;
                    case 90 -> 119;
                    case 91 -> 7;
                    case 92 -> 168;
                    case 93 -> 59;
                    case 94 -> 78;
                    case 95 -> 53;
                    case 96 -> 144;
                    case 97 -> 23;
                    case 98 -> 201;
                    case 99 -> 10;
                    case 100 -> 212;
                    case 101 -> 83;
                    case 102 -> 222;
                    case 103 -> 131;
                    case 104 -> 123;
                    case 105 -> 56;
                    case 106 -> 150;
                    case 107 -> 249;
                    case 108 -> 240;
                    case 109 -> 235;
                    case 110 -> 198;
                    case 111 -> 146;
                    case 112 -> 219;
                    case 113 -> 251;
                    case 114 -> 160;
                    case 115 -> 224;
                    case 116 -> 241;
                    case 117 -> 208;
                    case 118 -> 24;
                    case 119 -> 209;
                    case 120 -> 94;
                    case 121 -> 52;
                    case 122 -> 207;
                    case 123 -> 248;
                    case 124 -> 93;
                    case 125 -> 54;
                    case 126 -> 211;
                    case 127 -> 104;
                    case 128 -> 113;
                    case 129 -> 194;
                    case 130 -> 75;
                    case 131 -> 221;
                    case 132 -> 34;
                    case 133 -> 60;
                    case 134 -> 117;
                    case 135 -> 166;
                    case 136 -> 79;
                    case 137 -> 130;
                    case 138 -> 203;
                    case 139 -> 1;
                    case 140 -> 103;
                    case 141 -> 46;
                    case 142 -> 47;
                    case 143 -> 133;
                    case 144 -> 255;
                    case 145 -> 125;
                    case 146 -> 154;
                    case 147 -> 231;
                    case 148 -> 143;
                    case 149 -> 13;
                    case 150 -> 118;
                    case 151 -> 199;
                    case 152 -> 80;
                    case 153 -> 28;
                    case 154 -> 223;
                    case 155 -> 181;
                    case 156 -> 170;
                    case 157 -> 126;
                    case 158 -> 115;
                    case 159 -> 196;
                    case 160 -> 116;
                    case 161 -> 38;
                    case 162 -> 242;
                    case 163 -> 215;
                    case 164 -> 141;
                    case 165 -> 138;
                    case 166 -> 6;
                    case 167 -> 77;
                    case 168 -> 68;
                    case 169 -> 66;
                    case 170 -> 92;
                    case 171 -> 11;
                    case 172 -> 17;
                    case 173 -> 67;
                    case 174 -> 85;
                    case 175 -> 58;
                    case 176 -> 31;
                    case 177 -> 64;
                    case 178 -> 73;
                    case 179 -> 234;
                    case 180 -> 12;
                    case 181 -> 157;
                    case 182 -> 180;
                    case 183 -> 236;
                    case 184 -> 111;
                    case 185 -> 121;
                    case 186 -> 178;
                    case 187 -> 49;
                    case 188 -> 108;
                    case 189 -> 149;
                    case 190 -> 153;
                    case 191 -> 99;
                    case 192 -> 105;
                    case 193 -> 174;
                    case 194 -> 155;
                    case 195 -> 226;
                    case 196 -> 86;
                    case 197 -> 48;
                    case 198 -> 185;
                    case 199 -> 122;
                    case 200 -> 36;
                    case 201 -> 65;
                    case 202 -> 29;
                    case 203 -> 145;
                    case 204 -> 151;
                    case 205 -> 97;
                    case 206 -> 230;
                    case 207 -> 193;
                    case 208 -> 254;
                    case 209 -> 63;
                    case 210 -> 179;
                    case 211 -> 20;
                    case 212 -> 32;
                    case 213 -> 40;
                    case 214 -> 192;
                    case 215 -> 244;
                    case 216 -> 35;
                    case 217 -> 33;
                    case 218 -> 253;
                    case 219 -> 82;
                    case 220 -> 30;
                    case 221 -> 175;
                    case 222 -> 142;
                    case 223 -> 135;
                    case 224 -> 225;
                    case 225 -> 239;
                    case 226 -> 177;
                    case 227 -> 176;
                    case 228 -> 140;
                    case 229 -> 22;
                    case 230 -> 61;
                    case 231 -> 57;
                    case 232 -> 206;
                    case 233 -> 124;
                    case 234 -> 101;
                    case 235 -> 152;
                    case 236 -> 95;
                    case 237 -> 132;
                    case 238 -> 112;
                    case 239 -> 213;
                    case 240 -> 163;
                    case 241 -> 45;
                    case 242 -> 91;
                    case 243 -> 107;
                    case 244 -> 15;
                    case 245 -> 184;
                    case 246 -> 172;
                    case 247 -> 217;
                    case 248 -> 204;
                    case 249 -> 19;
                    case 250 -> 237;
                    case 251 -> 109;
                    case 252 -> 69;
                    case 253 -> 189;
                    case 254 -> 87;
                    default -> 27;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 98388065663484L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "!U,V$ zx\t&_?\\ibgd\u0019";
                    var5_4 = "!U,V$ zx\t&_?\\ibgd\u0019".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 47;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 101;
                                    break;
                                }
                                case 1: {
                                    v11 = 31;
                                    break;
                                }
                                case 2: {
                                    v11 = 113;
                                    break;
                                }
                                case 3: {
                                    v11 = 23;
                                    break;
                                }
                                case 4: {
                                    v11 = 110;
                                    break;
                                }
                                case 5: {
                                    v11 = 99;
                                    break;
                                }
                                default: {
                                    v11 = 102;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 49184945256706L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "D(1\u0002Vg\u0000\u0004B6=\u0018\nN)6\u0018Ze\u0018d(?\tN)6\u0018Ze\u0018h\"\rI/+\u0015Ph\u0002h%,\u001fQa";
                    var5_4 = "D(1\u0002Vg\u0000\u0004B6=\u0018\nN)6\u0018Ze\u0018d(?\tN)6\u0018Ze\u0018h\"\rI/+\u0015Ph\u0002h%,\u001fQa".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 43;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "?[Ft'\u0019z\u0006?[Ft+\u0013";
                        var5_4 = "?[Ft'\u0019z\u0006?[Ft+\u0013".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 90;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 38;
                                break;
                            }
                            case 1: {
                                v15 = 109;
                                break;
                            }
                            case 2: {
                                v15 = 115;
                                break;
                            }
                            case 3: {
                                v15 = 93;
                                break;
                            }
                            case 4: {
                                v15 = 20;
                                break;
                            }
                            case 5: {
                                v15 = 45;
                                break;
                            }
                            default: {
                                v15 = 71;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l = 68820699403270L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(1856606550 - (char)-26063, 1856606550 - (char)-4923, (int)l));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l = 100315611622981L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00e5]\u009d\u00d9\u00c6\u0003\u00ac\u00c8\u0000\u0005\u00c78\u00ff\u00b1i\r0\u00017\u00dc\u0085N9\b\u00ec\u00a2/\u00f6\u00b7\u0010\u007f\u00eb\u0019j\u007f\rM]\u00ab\u008c$~0\u00b9Cc\u0005\u00ba\u00dfPM\u009c3\u009b\u00a1e\u00f5%\u00ba6\u00bf\u00b9-\u00edc\u00cfK\u0090\"ML<g\u00d6\u00f8o\u0095\u0098*$\u00abS\u008e\n\n\u0016W\u001b X\u008e\u001b[\u0092\u00c0\u009e\u0011\u009f\u000fk\u00dd\u0087f\u00c2";
                    var4_3 = "\u00e5]\u009d\u00d9\u00c6\u0003\u00ac\u00c8\u0000\u0005\u00c78\u00ff\u00b1i\r0\u00017\u00dc\u0085N9\b\u00ec\u00a2/\u00f6\u00b7\u0010\u007f\u00eb\u0019j\u007f\rM]\u00ab\u008c$~0\u00b9Cc\u0005\u00ba\u00dfPM\u009c3\u009b\u00a1e\u00f5%\u00ba6\u00bf\u00b9-\u00edc\u00cfK\u0090\"ML<g\u00d6\u00f8o\u0095\u0098*$\u00abS\u008e\n\n\u0016W\u001b X\u008e\u001b[\u0092\u00c0\u009e\u0011\u009f\u000fk\u00dd\u0087f\u00c2".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 113;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u0001\u00f7\u0094\u00ab\u008cwqPno\u00de@-<\u00a2\u0091L\rW\u00e2uhd\u0083\\\u00b9}\u0088\u00bb\u00e9\u00cd\u00a9\u00d6-A\u008dr\u00ca|\u0084\u00e5\u0084\u008d\u00c0\u00dbw\u008b#\u0087aJ\u00c6\u00dd\u0093\u00ad\u001a\u001b\u00c6w\u0099\u00d8(\u00aa\u0014\u0013\u00d8\u00c9\u0083\u00ed\u00e0\u0091O\u00a7\u00f5lj\u001d}\u00e2\u00f7\u0001w\u00cfX\u0093\u00993\u00f1\u00d9\u00c9\u009f\u001c>";
                        var4_3 = "\u0001\u00f7\u0094\u00ab\u008cwqPno\u00de@-<\u00a2\u0091L\rW\u00e2uhd\u0083\\\u00b9}\u0088\u00bb\u00e9\u00cd\u00a9\u00d6-A\u008dr\u00ca|\u0084\u00e5\u0084\u008d\u00c0\u00dbw\u008b#\u0087aJ\u00c6\u00dd\u0093\u00ad\u001a\u001b\u00c6w\u0099\u00d8(\u00aa\u0014\u0013\u00d8\u00c9\u0083\u00ed\u00e0\u0091O\u00a7\u00f5lj\u001d}\u00e2\u00f7\u0001w\u00cfX\u0093\u00993\u00f1\u00d9\u00c9\u009f\u001c>".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 115;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 91;
                                break;
                            }
                            case 1: {
                                v15 = 76;
                                break;
                            }
                            case 2: {
                                v15 = 61;
                                break;
                            }
                            case 3: {
                                v15 = 65;
                                break;
                            }
                            case 4: {
                                v15 = 48;
                                break;
                            }
                            case 5: {
                                v15 = 36;
                                break;
                            }
                            default: {
                                v15 = 44;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFA323) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 182;
                    case 1 -> 59;
                    case 2 -> 22;
                    case 3 -> 34;
                    case 4 -> 132;
                    case 5 -> 180;
                    case 6 -> 3;
                    case 7 -> 17;
                    case 8 -> 18;
                    case 9 -> 135;
                    case 10 -> 101;
                    case 11 -> 183;
                    case 12 -> 39;
                    case 13 -> 119;
                    case 14 -> 239;
                    case 15 -> 93;
                    case 16 -> 13;
                    case 17 -> 235;
                    case 18 -> 150;
                    case 19 -> 118;
                    case 20 -> 108;
                    case 21 -> 156;
                    case 22 -> 107;
                    case 23 -> 27;
                    case 24 -> 143;
                    case 25 -> 86;
                    case 26 -> 73;
                    case 27 -> 208;
                    case 28 -> 125;
                    case 29 -> 64;
                    case 30 -> 56;
                    case 31 -> 224;
                    case 32 -> 198;
                    case 33 -> 111;
                    case 34 -> 117;
                    case 35 -> 195;
                    case 36 -> 87;
                    case 37 -> 142;
                    case 38 -> 193;
                    case 39 -> 165;
                    case 40 -> 77;
                    case 41 -> 43;
                    case 42 -> 55;
                    case 43 -> 36;
                    case 44 -> 9;
                    case 45 -> 176;
                    case 46 -> 206;
                    case 47 -> 179;
                    case 48 -> 162;
                    case 49 -> 65;
                    case 50 -> 84;
                    case 51 -> 69;
                    case 52 -> 255;
                    case 53 -> 242;
                    case 54 -> 29;
                    case 55 -> 204;
                    case 56 -> 38;
                    case 57 -> 57;
                    case 58 -> 159;
                    case 59 -> 140;
                    case 60 -> 144;
                    case 61 -> 250;
                    case 62 -> 200;
                    case 63 -> 74;
                    case 64 -> 82;
                    case 65 -> 218;
                    case 66 -> 72;
                    case 67 -> 178;
                    case 68 -> 31;
                    case 69 -> 1;
                    case 70 -> 154;
                    case 71 -> 16;
                    case 72 -> 212;
                    case 73 -> 63;
                    case 74 -> 21;
                    case 75 -> 88;
                    case 76 -> 83;
                    case 77 -> 95;
                    case 78 -> 11;
                    case 79 -> 191;
                    case 80 -> 10;
                    case 81 -> 24;
                    case 82 -> 126;
                    case 83 -> 145;
                    case 84 -> 146;
                    case 85 -> 128;
                    case 86 -> 227;
                    case 87 -> 75;
                    case 88 -> 33;
                    case 89 -> 12;
                    case 90 -> 61;
                    case 91 -> 161;
                    case 92 -> 215;
                    case 93 -> 85;
                    case 94 -> 78;
                    case 95 -> 129;
                    case 96 -> 44;
                    case 97 -> 149;
                    case 98 -> 232;
                    case 99 -> 131;
                    case 100 -> 164;
                    case 101 -> 4;
                    case 102 -> 28;
                    case 103 -> 163;
                    case 104 -> 240;
                    case 105 -> 58;
                    case 106 -> 97;
                    case 107 -> 169;
                    case 108 -> 231;
                    case 109 -> 96;
                    case 110 -> 105;
                    case 111 -> 138;
                    case 112 -> 90;
                    case 113 -> 190;
                    case 114 -> 32;
                    case 115 -> 100;
                    case 116 -> 168;
                    case 117 -> 166;
                    case 118 -> 91;
                    case 119 -> 116;
                    case 120 -> 248;
                    case 121 -> 40;
                    case 122 -> 15;
                    case 123 -> 104;
                    case 124 -> 124;
                    case 125 -> 219;
                    case 126 -> 147;
                    case 127 -> 41;
                    case 128 -> 70;
                    case 129 -> 203;
                    case 130 -> 7;
                    case 131 -> 229;
                    case 132 -> 194;
                    case 133 -> 186;
                    case 134 -> 98;
                    case 135 -> 54;
                    case 136 -> 20;
                    case 137 -> 177;
                    case 138 -> 211;
                    case 139 -> 187;
                    case 140 -> 141;
                    case 141 -> 226;
                    case 142 -> 68;
                    case 143 -> 110;
                    case 144 -> 89;
                    case 145 -> 127;
                    case 146 -> 19;
                    case 147 -> 185;
                    case 148 -> 148;
                    case 149 -> 49;
                    case 150 -> 115;
                    case 151 -> 234;
                    case 152 -> 47;
                    case 153 -> 241;
                    case 154 -> 253;
                    case 155 -> 175;
                    case 156 -> 189;
                    case 157 -> 103;
                    case 158 -> 37;
                    case 159 -> 251;
                    case 160 -> 60;
                    case 161 -> 102;
                    case 162 -> 213;
                    case 163 -> 243;
                    case 164 -> 136;
                    case 165 -> 247;
                    case 166 -> 152;
                    case 167 -> 48;
                    case 168 -> 217;
                    case 169 -> 53;
                    case 170 -> 151;
                    case 171 -> 167;
                    case 172 -> 50;
                    case 173 -> 158;
                    case 174 -> 228;
                    case 175 -> 30;
                    case 176 -> 66;
                    case 177 -> 71;
                    case 178 -> 199;
                    case 179 -> 172;
                    case 180 -> 214;
                    case 181 -> 94;
                    case 182 -> 170;
                    case 183 -> 254;
                    case 184 -> 171;
                    case 185 -> 230;
                    case 186 -> 134;
                    case 187 -> 223;
                    case 188 -> 25;
                    case 189 -> 99;
                    case 190 -> 197;
                    case 191 -> 173;
                    case 192 -> 252;
                    case 193 -> 113;
                    case 194 -> 196;
                    case 195 -> 123;
                    case 196 -> 52;
                    case 197 -> 192;
                    case 198 -> 114;
                    case 199 -> 188;
                    case 200 -> 236;
                    case 201 -> 8;
                    case 202 -> 137;
                    case 203 -> 157;
                    case 204 -> 79;
                    case 205 -> 139;
                    case 206 -> 80;
                    case 207 -> 233;
                    case 208 -> 0;
                    case 209 -> 174;
                    case 210 -> 155;
                    case 211 -> 122;
                    case 212 -> 245;
                    case 213 -> 201;
                    case 214 -> 67;
                    case 215 -> 184;
                    case 216 -> 133;
                    case 217 -> 26;
                    case 218 -> 246;
                    case 219 -> 45;
                    case 220 -> 6;
                    case 221 -> 130;
                    case 222 -> 106;
                    case 223 -> 153;
                    case 224 -> 181;
                    case 225 -> 205;
                    case 226 -> 222;
                    case 227 -> 160;
                    case 228 -> 207;
                    case 229 -> 237;
                    case 230 -> 202;
                    case 231 -> 62;
                    case 232 -> 238;
                    case 233 -> 92;
                    case 234 -> 220;
                    case 235 -> 46;
                    case 236 -> 14;
                    case 237 -> 81;
                    case 238 -> 209;
                    case 239 -> 2;
                    case 240 -> 51;
                    case 241 -> 76;
                    case 242 -> 249;
                    case 243 -> 244;
                    case 244 -> 42;
                    case 245 -> 121;
                    case 246 -> 216;
                    case 247 -> 225;
                    case 248 -> 221;
                    case 249 -> 23;
                    case 250 -> 5;
                    case 251 -> 35;
                    case 252 -> 120;
                    case 253 -> 112;
                    case 254 -> 210;
                    default -> 109;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l = 3872480358751L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(1580179920 - 19086, 1580179920 - 25902, (int)l));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l = 3981130070164L;
                    boolean bl = SshAgentIpcService.J();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(304606680 + 28848, -304606680 + -30503, (int)l));
                    boolean bl2 = bl;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (!bl2) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l = 89418907439195L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "KC\u00a9\u0081s\u00032\u00bf\u00d0";
                var4_3 = "KC\u00a9\u0081s\u00032\u00bf\u00d0".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 70;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 33;
                                break;
                            }
                            case 1: {
                                v11 = 127;
                                break;
                            }
                            case 2: {
                                v11 = 66;
                                break;
                            }
                            case 3: {
                                v11 = 109;
                                break;
                            }
                            case 4: {
                                v11 = 61;
                                break;
                            }
                            case 5: {
                                v11 = 75;
                                break;
                            }
                            default: {
                                v11 = 25;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFA61D) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 6;
                    case 1 -> 233;
                    case 2 -> 102;
                    case 3 -> 230;
                    case 4 -> 190;
                    case 5 -> 239;
                    case 6 -> 134;
                    case 7 -> 37;
                    case 8 -> 232;
                    case 9 -> 121;
                    case 10 -> 231;
                    case 11 -> 15;
                    case 12 -> 203;
                    case 13 -> 114;
                    case 14 -> 250;
                    case 15 -> 10;
                    case 16 -> 212;
                    case 17 -> 164;
                    case 18 -> 124;
                    case 19 -> 87;
                    case 20 -> 228;
                    case 21 -> 116;
                    case 22 -> 249;
                    case 23 -> 50;
                    case 24 -> 34;
                    case 25 -> 57;
                    case 26 -> 170;
                    case 27 -> 144;
                    case 28 -> 73;
                    case 29 -> 96;
                    case 30 -> 223;
                    case 31 -> 88;
                    case 32 -> 129;
                    case 33 -> 41;
                    case 34 -> 65;
                    case 35 -> 45;
                    case 36 -> 204;
                    case 37 -> 158;
                    case 38 -> 9;
                    case 39 -> 14;
                    case 40 -> 193;
                    case 41 -> 175;
                    case 42 -> 252;
                    case 43 -> 162;
                    case 44 -> 176;
                    case 45 -> 234;
                    case 46 -> 226;
                    case 47 -> 64;
                    case 48 -> 56;
                    case 49 -> 205;
                    case 50 -> 59;
                    case 51 -> 126;
                    case 52 -> 101;
                    case 53 -> 113;
                    case 54 -> 194;
                    case 55 -> 62;
                    case 56 -> 55;
                    case 57 -> 29;
                    case 58 -> 157;
                    case 59 -> 156;
                    case 60 -> 42;
                    case 61 -> 137;
                    case 62 -> 138;
                    case 63 -> 76;
                    case 64 -> 24;
                    case 65 -> 120;
                    case 66 -> 0;
                    case 67 -> 214;
                    case 68 -> 149;
                    case 69 -> 145;
                    case 70 -> 210;
                    case 71 -> 63;
                    case 72 -> 166;
                    case 73 -> 184;
                    case 74 -> 27;
                    case 75 -> 100;
                    case 76 -> 35;
                    case 77 -> 119;
                    case 78 -> 23;
                    case 79 -> 66;
                    case 80 -> 3;
                    case 81 -> 108;
                    case 82 -> 189;
                    case 83 -> 181;
                    case 84 -> 221;
                    case 85 -> 111;
                    case 86 -> 135;
                    case 87 -> 198;
                    case 88 -> 90;
                    case 89 -> 1;
                    case 90 -> 235;
                    case 91 -> 159;
                    case 92 -> 112;
                    case 93 -> 251;
                    case 94 -> 33;
                    case 95 -> 104;
                    case 96 -> 118;
                    case 97 -> 16;
                    case 98 -> 131;
                    case 99 -> 77;
                    case 100 -> 206;
                    case 101 -> 247;
                    case 102 -> 240;
                    case 103 -> 140;
                    case 104 -> 225;
                    case 105 -> 25;
                    case 106 -> 155;
                    case 107 -> 196;
                    case 108 -> 18;
                    case 109 -> 61;
                    case 110 -> 169;
                    case 111 -> 122;
                    case 112 -> 173;
                    case 113 -> 52;
                    case 114 -> 132;
                    case 115 -> 36;
                    case 116 -> 171;
                    case 117 -> 209;
                    case 118 -> 191;
                    case 119 -> 186;
                    case 120 -> 220;
                    case 121 -> 123;
                    case 122 -> 195;
                    case 123 -> 243;
                    case 124 -> 46;
                    case 125 -> 54;
                    case 126 -> 69;
                    case 127 -> 174;
                    case 128 -> 151;
                    case 129 -> 21;
                    case 130 -> 218;
                    case 131 -> 115;
                    case 132 -> 147;
                    case 133 -> 72;
                    case 134 -> 71;
                    case 135 -> 81;
                    case 136 -> 31;
                    case 137 -> 165;
                    case 138 -> 141;
                    case 139 -> 219;
                    case 140 -> 179;
                    case 141 -> 5;
                    case 142 -> 117;
                    case 143 -> 143;
                    case 144 -> 139;
                    case 145 -> 172;
                    case 146 -> 74;
                    case 147 -> 255;
                    case 148 -> 28;
                    case 149 -> 154;
                    case 150 -> 199;
                    case 151 -> 79;
                    case 152 -> 93;
                    case 153 -> 32;
                    case 154 -> 238;
                    case 155 -> 68;
                    case 156 -> 20;
                    case 157 -> 30;
                    case 158 -> 95;
                    case 159 -> 110;
                    case 160 -> 241;
                    case 161 -> 58;
                    case 162 -> 185;
                    case 163 -> 160;
                    case 164 -> 7;
                    case 165 -> 103;
                    case 166 -> 222;
                    case 167 -> 253;
                    case 168 -> 94;
                    case 169 -> 127;
                    case 170 -> 12;
                    case 171 -> 244;
                    case 172 -> 136;
                    case 173 -> 107;
                    case 174 -> 67;
                    case 175 -> 40;
                    case 176 -> 106;
                    case 177 -> 148;
                    case 178 -> 19;
                    case 179 -> 152;
                    case 180 -> 213;
                    case 181 -> 168;
                    case 182 -> 202;
                    case 183 -> 133;
                    case 184 -> 60;
                    case 185 -> 167;
                    case 186 -> 227;
                    case 187 -> 187;
                    case 188 -> 70;
                    case 189 -> 80;
                    case 190 -> 211;
                    case 191 -> 83;
                    case 192 -> 201;
                    case 193 -> 128;
                    case 194 -> 216;
                    case 195 -> 43;
                    case 196 -> 192;
                    case 197 -> 22;
                    case 198 -> 51;
                    case 199 -> 153;
                    case 200 -> 245;
                    case 201 -> 125;
                    case 202 -> 53;
                    case 203 -> 38;
                    case 204 -> 207;
                    case 205 -> 178;
                    case 206 -> 248;
                    case 207 -> 85;
                    case 208 -> 49;
                    case 209 -> 8;
                    case 210 -> 89;
                    case 211 -> 217;
                    case 212 -> 82;
                    case 213 -> 224;
                    case 214 -> 4;
                    case 215 -> 161;
                    case 216 -> 84;
                    case 217 -> 146;
                    case 218 -> 246;
                    case 219 -> 242;
                    case 220 -> 130;
                    case 221 -> 26;
                    case 222 -> 200;
                    case 223 -> 17;
                    case 224 -> 44;
                    case 225 -> 177;
                    case 226 -> 163;
                    case 227 -> 215;
                    case 228 -> 11;
                    case 229 -> 183;
                    case 230 -> 2;
                    case 231 -> 75;
                    case 232 -> 188;
                    case 233 -> 97;
                    case 234 -> 13;
                    case 235 -> 92;
                    case 236 -> 237;
                    case 237 -> 48;
                    case 238 -> 109;
                    case 239 -> 47;
                    case 240 -> 86;
                    case 241 -> 98;
                    case 242 -> 105;
                    case 243 -> 180;
                    case 244 -> 254;
                    case 245 -> 182;
                    case 246 -> 99;
                    case 247 -> 142;
                    case 248 -> 236;
                    case 249 -> 197;
                    case 250 -> 39;
                    case 251 -> 150;
                    case 252 -> 91;
                    case 253 -> 208;
                    case 254 -> 229;
                    default -> 78;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

