/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nwjs;

import com.google.gson.stream.JsonReader;
import com.intellij.execution.ExecutionException;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.URLUtil;
import com.jetbrains.nwjs.NwjsProcessState;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.sourcemap.SourceResolver;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\nH\u0002\u001a\u001a\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\nH\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "SKIPPED_CONSOLE_MESSAGE_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "PACKAGE_JSON", "", "getMainUrl", "packageJsonPath", "Ljava/nio/file/Path;", "getMainUrlFromManifest", "parent", "parseRawUrl", "Lcom/intellij/util/Url;", "url", "parentPath", "intellij.javascript.debugger.backend"})
public final class NwjsProcessStateKt {
    @NotNull
    private static final Logger LOG;
    private static final Pattern SKIPPED_CONSOLE_MESSAGE_PATTERN;
    @NotNull
    public static final String PACKAGE_JSON = "package.json";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String getMainUrl(Path packageJsonPath) {
        Object object = packageJsonPath;
        Object object2 = Charsets.UTF_8;
        Unit unit = new Unit[]{};
        object = new InputStreamReader(Files.newInputStream((Path)object, Arrays.copyOf(unit, ((OpenOption[])unit).length)), (Charset)object2);
        object2 = null;
        try {
            InputStreamReader reader = (InputStreamReader)object;
            boolean bl = false;
            JsonReader jsonReader = new JsonReader((Reader)reader);
            jsonReader.beginObject();
            while (jsonReader.hasNext()) {
                if (Intrinsics.areEqual((Object)jsonReader.nextName(), (Object)"main")) {
                    String string = jsonReader.nextString();
                    return string;
                }
                jsonReader.skipValue();
            }
            unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        return null;
    }

    private static final String getMainUrlFromManifest(Path parent) {
        Path packageJsonPath = parent.resolve(PACKAGE_JSON);
        Intrinsics.checkNotNull((Object)packageJsonPath);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(packageJsonPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return NwjsProcessStateKt.getMainUrl(packageJsonPath);
        }
        throw new ExecutionException(JSDebuggerBundle.message("nwjs.error.manifest.not.found", new Object[0]));
    }

    private static final Url parseRawUrl(String url, Path parentPath) {
        if (url == null) {
            throw new ExecutionException(JSDebuggerBundle.message("nwjs.error.cannot.get.main.url", new Object[0]));
        }
        Object absoluteUrl = URLUtil.containsScheme((String)url) || SourceResolver.Companion.isAbsolute(url) ? url : "file://" + parentPath + "/" + url;
        Url parsedUrl = Urls.parseEncoded((String)absoluteUrl);
        if (parsedUrl == null) {
            Object[] objectArray = new Object[]{absoluteUrl};
            throw new ExecutionException(JSDebuggerBundle.message("nwjs.error.cannot.parse.main.url", objectArray));
        }
        if (parsedUrl.isInLocalFileSystem()) {
            Path path = Paths.get(parsedUrl.getPath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            Path path2 = path;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.isRegularFile(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                throw new ExecutionException(JSDebuggerBundle.message("nwjs.error.main.file.not.valid", new Object[0]));
            }
        }
        return parsedUrl;
    }

    public static final /* synthetic */ String access$getMainUrlFromManifest(Path parent) {
        return NwjsProcessStateKt.getMainUrlFromManifest(parent);
    }

    public static final /* synthetic */ Url access$parseRawUrl(String url, Path parentPath) {
        return NwjsProcessStateKt.parseRawUrl(url, parentPath);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ Pattern access$getSKIPPED_CONSOLE_MESSAGE_PATTERN$p() {
        return SKIPPED_CONSOLE_MESSAGE_PATTERN;
    }

    static {
        Logger logger = Logger.getInstance(NwjsProcessState.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        SKIPPED_CONSOLE_MESSAGE_PATTERN = Pattern.compile("^\\[\\d+:\\d+/\\d+:[A-Z]+:CONSOLE");
    }
}

