/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.layout;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.constants.PageElementPosition;
import com.openhtmltopdf.css.newmatch.PageInfo;
import com.openhtmltopdf.css.style.CalculatedStyle;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.css.style.EmptyStyle;
import com.openhtmltopdf.layout.BlockFormattingContext;
import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.layout.LayoutState;
import com.openhtmltopdf.layout.PaintingInfo;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.BoxDimensions;
import com.openhtmltopdf.render.LineBox;
import com.openhtmltopdf.render.PageBox;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.render.ViewportBox;
import com.openhtmltopdf.render.displaylist.TransformCreator;
import com.openhtmltopdf.util.SearchUtil;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public class Layer {
    public static final short PAGED_MODE_SCREEN = 1;
    public static final short PAGED_MODE_PRINT = 2;
    private Layer _parent;
    private boolean _stackingContext;
    private List<Layer> _children;
    private BlockBox _master;
    private List<BlockBox> _floats;
    private boolean _requiresLayout;
    private List<PageBox> _pages;
    private PageBox _lastRequestedPage = null;
    private Set<BlockBox> _pageSequences;
    private List<BlockBox> _sortedPageSequences;
    private Map<String, List<BlockBox>> _runningBlocks;
    private boolean _forDeletion;
    private boolean _hasFixedAncester;
    private AffineTransform _ctm;
    private final boolean _hasLocalTransform;
    private boolean _isolated;
    public static final int POSITIVE = 1;
    public static final int ZERO = 2;
    public static final int NEGATIVE = 3;
    public static final int AUTO = 4;
    private static final int MAX_REAR_SEARCH = 5;

    public Layer(BlockBox master, CssContext c) {
        this(null, master, c);
        this.setStackingContext(true);
    }

    public Layer(BlockBox master, CssContext c, boolean isolated) {
        this(master, c);
        if (isolated) {
            this.setIsolated(true);
        }
    }

    private void setIsolated(boolean b) {
        this._isolated = b;
    }

    public Layer(Layer parent, BlockBox master, CssContext c) {
        this._parent = parent;
        this._master = master;
        this.setStackingContext(master.getStyle().isPositioned() && !master.getStyle().isAutoZIndex() || !master.getStyle().isIdent(CSSName.TRANSFORM, IdentValue.NONE));
        master.setLayer(this);
        master.setContainingLayer(this);
        this._hasLocalTransform = !master.getStyle().isIdent(CSSName.TRANSFORM, IdentValue.NONE);
        this._hasFixedAncester = parent != null && parent._hasFixedAncester || master.getStyle().isFixed();
    }

    public void propagateCurrentTransformationMatrix(CssContext c) {
        AffineTransform parentCtm = this._parent == null ? null : this._parent._ctm;
        this._ctm = this._hasLocalTransform ? TransformCreator.createDocumentCoordinatesTransform(this.getMaster(), c, parentCtm) : parentCtm;
        for (Layer child : this.getChildren()) {
            child.propagateCurrentTransformationMatrix(c);
        }
    }

    public AffineTransform getCurrentTransformMatrix() {
        return this._ctm;
    }

    public boolean hasLocalTransform() {
        return this._hasLocalTransform;
    }

    public void setForDeletion(boolean forDeletion) {
        this._forDeletion = forDeletion;
    }

    public boolean isForDeletion() {
        return this._forDeletion;
    }

    public boolean hasFixedAncester() {
        return this._hasFixedAncester;
    }

    public Layer getParent() {
        return this._parent;
    }

    public boolean isStackingContext() {
        return this._stackingContext;
    }

    public void setStackingContext(boolean stackingContext) {
        this._stackingContext = stackingContext;
    }

    public int getZIndex() {
        if (this._master.getStyle().isIdent(CSSName.Z_INDEX, IdentValue.AUTO)) {
            return 0;
        }
        return (int)this._master.getStyle().asFloat(CSSName.Z_INDEX);
    }

    public boolean isZIndexAuto() {
        return this._master.getStyle().isIdent(CSSName.Z_INDEX, IdentValue.AUTO);
    }

    public BlockBox getMaster() {
        return this._master;
    }

    public void addChild(Layer layer) {
        if (this._children == null) {
            this._children = new ArrayList<Layer>();
        }
        this._children.add(layer);
    }

    public static PageBox createPageBox(CssContext c, String pseudoPage) {
        PageBox result = new PageBox();
        String pageName = null;
        if (c instanceof LayoutContext) {
            pageName = ((LayoutContext)c).getPageName();
        }
        PageInfo pageInfo = c.getCss().getPageStyle(pageName, pseudoPage);
        result.setPageInfo(pageInfo);
        CalculatedStyle cs = new EmptyStyle().deriveStyle(pageInfo.getPageStyle());
        result.setStyle(cs);
        result.setOuterPageWidth(result.getWidth(c));
        return result;
    }

    public void removeFloat(BlockBox floater) {
        if (this._floats != null) {
            this._floats.remove(floater);
        }
    }

    public void addFloat(BlockBox floater, BlockFormattingContext bfc) {
        if (this._floats == null) {
            this._floats = new ArrayList<BlockBox>();
        }
        this._floats.add(floater);
        floater.getFloatedBoxData().setDrawingLayer(this);
    }

    public List<Layer> collectLayers(int which) {
        ArrayList<Layer> result = new ArrayList<Layer>();
        List<Layer> children = this.getChildren();
        result.addAll(this.getStackingContextLayers(which));
        for (Layer child : children) {
            if (child.isStackingContext()) continue;
            if (!child.isForDeletion() && !child._isolated) {
                if (which == 4 && child.isZIndexAuto()) {
                    result.add(child);
                } else if (which == 3 && child.getZIndex() < 0) {
                    result.add(child);
                } else if (which == 1 && child.getZIndex() > 0) {
                    result.add(child);
                } else if (which == 2 && !child.isZIndexAuto() && child.getZIndex() == 0) {
                    result.add(child);
                }
            }
            result.addAll(child.collectLayers(which));
        }
        return result;
    }

    private List<Layer> getStackingContextLayers(int which) {
        ArrayList<Layer> result = new ArrayList<Layer>();
        List<Layer> children = this.getChildren();
        for (Layer target : children) {
            if (target.isForDeletion() || target._isolated || !target.isStackingContext()) continue;
            if (!target.isZIndexAuto()) {
                int zIndex = target.getZIndex();
                if (which == 3 && zIndex < 0) {
                    result.add(target);
                    continue;
                }
                if (which == 1 && zIndex > 0) {
                    result.add(target);
                    continue;
                }
                if (which != 2 || zIndex != 0) continue;
                result.add(target);
                continue;
            }
            if (which != 4) continue;
            result.add(target);
        }
        return result;
    }

    public List<Layer> getSortedLayers(int which) {
        List<Layer> result = this.collectLayers(which);
        Collections.sort(result, (l1, l2) -> l1.getZIndex() - l2.getZIndex());
        return result;
    }

    public Dimension getPaintingDimension(LayoutContext c) {
        return this.calcPaintingDimension(c).getOuterMarginCorner();
    }

    public List<BlockBox> getFloats() {
        return this._floats == null ? Collections.emptyList() : this._floats;
    }

    public void positionFixedLayer(RenderingContext c) {
        Rectangle rect = c.getFixedRectangle(true);
        BlockBox fixed = this.getMaster();
        fixed.setX(0);
        fixed.setY(0);
        fixed.setAbsX(0);
        fixed.setAbsY(0);
        fixed.setContainingBlock(new ViewportBox(rect));
        fixed.positionAbsolute(c, 3);
        fixed.calcPaintingInfo(c, false);
    }

    public boolean isRootLayer() {
        return this.getParent() == null && this.isStackingContext();
    }

    private void moveIfGreater(Dimension result, Dimension test) {
        if (test.width > result.width) {
            result.width = test.width;
        }
        if (test.height > result.height) {
            result.height = test.height;
        }
    }

    public void positionChildren(LayoutContext c) {
        for (Layer child : this.getChildren()) {
            child.position(c);
        }
    }

    private PaintingInfo calcPaintingDimension(LayoutContext c) {
        this.getMaster().calcPaintingInfo(c, true);
        PaintingInfo result = this.getMaster().getPaintingInfo().copyOf();
        for (Layer child : this.getChildren()) {
            if (child.getMaster().getStyle().isFixed() || !child.getMaster().getStyle().isAbsolute()) continue;
            PaintingInfo info = child.calcPaintingDimension(c);
            this.moveIfGreater(result.getOuterMarginCorner(), info.getOuterMarginCorner());
        }
        return result;
    }

    public List<Layer> getChildren() {
        return this._children == null ? Collections.emptyList() : this._children;
    }

    private void remove(Layer layer) {
        boolean removed = false;
        if (this._children != null) {
            Iterator<Layer> i = this._children.iterator();
            while (i.hasNext()) {
                Layer child = i.next();
                if (child != layer) continue;
                removed = true;
                i.remove();
                break;
            }
        }
        if (!removed) {
            throw new RuntimeException("Could not find layer to remove");
        }
    }

    public void detach() {
        if (this.getParent() != null) {
            this.getParent().remove(this);
        }
        this.setForDeletion(true);
    }

    public boolean isRequiresLayout() {
        return this._requiresLayout;
    }

    public void setRequiresLayout(boolean requiresLayout) {
        this._requiresLayout = requiresLayout;
    }

    public void finish(LayoutContext c) {
        if (c.isPrint()) {
            this.layoutAbsoluteChildren(c);
        }
        this.positionChildren(c);
    }

    private void layoutAbsoluteChildren(LayoutContext c) {
        List<Layer> children = this.getChildren();
        if (children.size() > 0) {
            LayoutState state = c.captureLayoutState();
            for (int i = 0; i < children.size(); ++i) {
                Layer child = children.get(i);
                boolean isFixed = child.getMaster().getStyle().isFixed();
                if (!child.isRequiresLayout()) continue;
                this.layoutAbsoluteChild(c, child);
                if (!isFixed && child.getMaster().getStyle().isAvoidPageBreakInside() && child.getMaster().crossesPageBreak(c)) {
                    BlockBox master = child.getMaster();
                    master.reset(c);
                    master.setNeedPageClear(true);
                    this.layoutAbsoluteChild(c, child);
                    if (master.crossesPageBreak(c)) {
                        master.reset(c);
                        this.layoutAbsoluteChild(c, child);
                    }
                }
                child.setRequiresLayout(false);
                child.finish(c);
                if (isFixed) continue;
                c.getRootLayer().ensureHasPage(c, child.getMaster());
            }
            c.restoreLayoutState(state);
        }
    }

    private void position(LayoutContext c) {
        if (this.getMaster().getStyle().isAbsolute() && !c.isPrint()) {
            this.getMaster().positionAbsolute(c, 3);
        }
    }

    public List<PageBox> getPages() {
        if (this._pages == null) {
            return this._parent == null ? Collections.emptyList() : this._parent.getPages();
        }
        return this._pages;
    }

    public void setPages(List<PageBox> pages) {
        this._pages = pages;
    }

    public boolean isLastPage(PageBox pageBox) {
        return this._pages.get(this._pages.size() - 1) == pageBox;
    }

    private void layoutAbsoluteChild(LayoutContext c, Layer child) {
        BlockBox master = child.getMaster();
        if (child.getMaster().getStyle().isBottomAuto()) {
            master.positionAbsolute(c, 3);
            master.positionAbsoluteOnPage(c);
            c.reInit(true);
            child.getMaster().layout(c);
            master.positionAbsolute(c, 2);
        } else {
            c.reInit(true);
            master.layout(c);
            BoxDimensions before = master.getBoxDimensions();
            master.reset(c);
            BoxDimensions after = master.getBoxDimensions();
            master.setBoxDimensions(before);
            master.positionAbsolute(c, 3);
            master.positionAbsoluteOnPage(c);
            master.setBoxDimensions(after);
            c.reInit(true);
            child.getMaster().layout(c);
        }
    }

    public void removeLastPage() {
        PageBox pageBox = this._pages.remove(this._pages.size() - 1);
        if (pageBox == this.getLastRequestedPage()) {
            this.setLastRequestedPage(null);
        }
    }

    public void addPage(CssContext c) {
        List<PageBox> pages;
        String pseudoPage = null;
        if (this._pages == null) {
            this._pages = new ArrayList<PageBox>();
        }
        pseudoPage = (pages = this.getPages()).size() == 0 ? "first" : (pages.size() % 2 == 0 ? "right" : "left");
        PageBox pageBox = Layer.createPageBox(c, pseudoPage);
        if (pages.size() == 0) {
            pageBox.setTopAndBottom(c, 0);
        } else {
            PageBox previous = pages.get(pages.size() - 1);
            pageBox.setTopAndBottom(c, previous.getBottom());
        }
        pageBox.setPageNo(pages.size());
        pages.add(pageBox);
    }

    public PageBox getFirstPage(CssContext c, int absY) {
        List<PageBox> pages;
        PageBox page = this.getPage(c, absY);
        if (page == null && absY < 0 && !(pages = this.getPages()).isEmpty()) {
            return pages.get(0);
        }
        return page;
    }

    public PageBox getFirstPage(CssContext c, Box box) {
        if (box instanceof LineBox) {
            LineBox lb = (LineBox)box;
            return this.getPage(c, lb.getMinPaintingTop());
        }
        return this.getPage(c, box.getAbsY());
    }

    public PageBox getLastPage(CssContext c, Box box) {
        return this.getPage(c, box.getAbsY() + box.getHeight() - 1);
    }

    public void ensureHasPage(CssContext c, Box box) {
        this.getLastPage(c, box);
    }

    public List<PageBox> getPages(CssContext c, int top, int bottom) {
        PageBox first;
        if (top > bottom) {
            int temp = top;
            top = bottom;
            bottom = temp;
        }
        if ((first = this.getPage(c, top)) == null) {
            return null;
        }
        if (bottom < first.getBottom()) {
            return Collections.singletonList(first);
        }
        ArrayList<PageBox> pages = new ArrayList<PageBox>();
        pages.add(first);
        int current = first.getBottom() + 1;
        PageBox curPage = first;
        while (bottom > curPage.getBottom()) {
            curPage = this.getPage(c, current);
            current = curPage.getBottom() + 1;
            pages.add(curPage);
        }
        return pages;
    }

    private SearchUtil.IntComparator pageFinder(List<PageBox> pages, int yOffset, Predicate<PageBox> matcher) {
        return idx -> {
            PageBox pageBox = (PageBox)pages.get(idx);
            if (matcher.test(pageBox)) {
                return 0;
            }
            return pageBox.getTop() < yOffset ? -1 : 1;
        };
    }

    private Predicate<PageBox> pagePredicate(int yOffset) {
        return pageBox -> yOffset >= pageBox.getTop() && yOffset < pageBox.getBottom();
    }

    public PageBox getPage(CssContext c, int yOffset) {
        return this.getPage(c, yOffset, true);
    }

    public PageBox getPage(CssContext c, int yOffset, boolean addPages) {
        List<PageBox> pages = this.getPages();
        if (yOffset < 0) {
            return null;
        }
        PageBox lastRequested = this.getLastRequestedPage();
        Predicate<PageBox> predicate = this.pagePredicate(yOffset);
        if (lastRequested != null && predicate.test(lastRequested)) {
            return lastRequested;
        }
        PageBox last = pages.get(pages.size() - 1);
        if (yOffset < last.getBottom()) {
            PageBox needle;
            int pageIdx = this.searchLastPages(pages, predicate, 5);
            if (pageIdx < 0) {
                int needleIndex = SearchUtil.intBinarySearch(this.pageFinder(pages, yOffset, predicate), 0, pages.size() - 5);
                needle = pages.get(needleIndex);
            } else {
                needle = pages.get(pageIdx);
            }
            this.setLastRequestedPage(needle);
            return needle;
        }
        this.addPagesUntilPosition(c, yOffset);
        PageBox result = pages.get(pages.size() - 1);
        this.setLastRequestedPage(result);
        return result;
    }

    public int getPageIndex(int yOffset) {
        Predicate<PageBox> predicate;
        List<PageBox> pages = this.getPages();
        int pageIdx = this.searchLastPages(pages, predicate = this.pagePredicate(yOffset), 5);
        if (pageIdx >= 0) {
            return pageIdx;
        }
        return SearchUtil.intBinarySearch(this.pageFinder(pages, yOffset, predicate), 0, pages.size() - 5);
    }

    private int searchLastPages(List<PageBox> pages, Predicate<PageBox> predicate, int maxRearPages) {
        int count = pages.size();
        for (int i = count - 1; i >= 0 && i >= count - maxRearPages; --i) {
            PageBox pageBox = pages.get(i);
            if (!predicate.test(pageBox)) continue;
            this.setLastRequestedPage(pageBox);
            return i;
        }
        return -1;
    }

    private void addPagesUntilPosition(CssContext c, int position) {
        List<PageBox> pages = this.getPages();
        PageBox last = pages.get(pages.size() - 1);
        while (position >= last.getBottom()) {
            this.addPage(c);
            last = pages.get(pages.size() - 1);
        }
    }

    public void trimEmptyPages(CssContext c, int maxYHeight) {
        PageBox page;
        List<PageBox> pages = this.getPages();
        for (int i = pages.size() - 1; i > 0 && (page = pages.get(i)).getTop() >= maxYHeight; --i) {
            if (page == this.getLastRequestedPage()) {
                this.setLastRequestedPage(null);
            }
            pages.remove(i);
        }
    }

    public void trimPageCount(int newPageCount) {
        while (this._pages.size() > newPageCount) {
            PageBox pageBox = this._pages.remove(this._pages.size() - 1);
            if (pageBox != this.getLastRequestedPage()) continue;
            this.setLastRequestedPage(null);
        }
    }

    public void assignPagePaintingPositions(CssContext cssCtx, short mode) {
        this.assignPagePaintingPositions(cssCtx, mode, 0);
    }

    public void assignPagePaintingPositions(CssContext cssCtx, int mode, int additionalClearance) {
        List<PageBox> pages = this.getPages();
        int paintingTop = additionalClearance;
        for (PageBox page : pages) {
            page.setPaintingTop(paintingTop);
            if (mode == 1) {
                page.setPaintingBottom(paintingTop + page.getHeight(cssCtx));
            } else if (mode == 2) {
                page.setPaintingBottom(paintingTop + page.getContentHeight(cssCtx));
            } else {
                throw new IllegalArgumentException("Illegal mode");
            }
            paintingTop = page.getPaintingBottom() + additionalClearance;
        }
    }

    public int getMaxPageWidth(CssContext cssCtx, int additionalClearance) {
        List<PageBox> pages = this.getPages();
        int maxWidth = 0;
        for (PageBox page : pages) {
            int pageWidth = page.getWidth(cssCtx) + additionalClearance * 2;
            if (pageWidth <= maxWidth) continue;
            maxWidth = pageWidth;
        }
        return maxWidth;
    }

    public PageBox getLastPage() {
        List<PageBox> pages = this.getPages();
        return pages.size() == 0 ? null : pages.get(pages.size() - 1);
    }

    public boolean crossesPageBreak(LayoutContext c, int top, int bottom) {
        if (top < 0) {
            return false;
        }
        PageBox page = this.getPage(c, top);
        if (c.isInFloatBottom()) {
            return bottom >= page.getBottom();
        }
        return bottom >= page.getBottom(c) - c.getExtraSpaceBottom();
    }

    public Layer findRoot() {
        if (this.isRootLayer()) {
            return this;
        }
        return this.getParent().findRoot();
    }

    public void addRunningBlock(BlockBox block) {
        String identifier;
        List<BlockBox> blocks;
        if (this._runningBlocks == null) {
            this._runningBlocks = new HashMap<String, List<BlockBox>>();
        }
        if ((blocks = this._runningBlocks.get(identifier = block.getStyle().getRunningName())) == null) {
            blocks = new ArrayList<BlockBox>();
            this._runningBlocks.put(identifier, blocks);
        }
        blocks.add(block);
        Collections.sort(blocks, (b1, b2) -> b1.getAbsY() - b2.getAbsY());
    }

    public void removeRunningBlock(BlockBox block) {
        if (this._runningBlocks == null) {
            return;
        }
        String identifier = block.getStyle().getRunningName();
        List<BlockBox> blocks = this._runningBlocks.get(identifier);
        if (blocks == null) {
            return;
        }
        blocks.remove(block);
    }

    public BlockBox getRunningBlock(String identifer, PageBox page, PageElementPosition which) {
        if (this._runningBlocks == null) {
            return null;
        }
        List<BlockBox> blocks = this._runningBlocks.get(identifer);
        if (blocks == null) {
            return null;
        }
        if (which == PageElementPosition.START) {
            BlockBox prev = null;
            for (BlockBox b : blocks) {
                if (b.getStaticEquivalent().getAbsY() >= page.getTop()) break;
                prev = b;
            }
            return prev;
        }
        if (which == PageElementPosition.FIRST) {
            for (BlockBox b : blocks) {
                int absY = b.getStaticEquivalent().getAbsY();
                if (absY < page.getTop() || absY >= page.getBottom()) continue;
                return b;
            }
            return this.getRunningBlock(identifer, page, PageElementPosition.START);
        }
        if (which == PageElementPosition.LAST) {
            BlockBox prev = null;
            for (BlockBox b : blocks) {
                if (b.getStaticEquivalent().getAbsY() > page.getBottom()) break;
                prev = b;
            }
            return prev;
        }
        if (which == PageElementPosition.LAST_EXCEPT) {
            BlockBox prev = null;
            for (BlockBox b : blocks) {
                int absY = b.getStaticEquivalent().getAbsY();
                if (absY >= page.getTop() && absY < page.getBottom()) {
                    return null;
                }
                if (absY > page.getBottom()) break;
                prev = b;
            }
            return prev;
        }
        throw new RuntimeException("bug: internal error");
    }

    public void layoutPages(LayoutContext c) {
        c.setRootDocumentLayer(c.getRootLayer());
        for (PageBox pageBox : this._pages) {
            pageBox.layout(c);
        }
    }

    public void addPageSequence(BlockBox start) {
        if (this._pageSequences == null) {
            this._pageSequences = new HashSet<BlockBox>();
        }
        this._pageSequences.add(start);
    }

    private List<BlockBox> getSortedPageSequences() {
        if (this._pageSequences == null) {
            return null;
        }
        if (this._sortedPageSequences == null) {
            ArrayList<BlockBox> result = new ArrayList<BlockBox>(this._pageSequences);
            Collections.sort(result, new Comparator<BlockBox>(){

                @Override
                public int compare(BlockBox b1, BlockBox b2) {
                    return b1.getAbsY() - b2.getAbsY();
                }
            });
            this._sortedPageSequences = result;
        }
        return this._sortedPageSequences;
    }

    public int getRelativePageNo(RenderingContext c, int absY) {
        List<BlockBox> sequences = this.getSortedPageSequences();
        int initial = 0;
        if (c.getInitialPageNo() > 0) {
            initial = c.getInitialPageNo() - 1;
        }
        if (sequences == null || sequences.isEmpty()) {
            return initial + this.getPage(c, absY).getPageNo();
        }
        BlockBox pageSequence = this.findPageSequence(sequences, absY);
        int sequenceStartAbsolutePageNo = this.getPage(c, pageSequence.getAbsY()).getPageNo();
        int absoluteRequiredPageNo = this.getPage(c, absY).getPageNo();
        return absoluteRequiredPageNo - sequenceStartAbsolutePageNo;
    }

    private BlockBox findPageSequence(List<BlockBox> sequences, int absY) {
        BlockBox result = null;
        for (int i = 0; i < sequences.size(); ++i) {
            result = sequences.get(i);
            if (i < sequences.size() - 1 && sequences.get(i + 1).getAbsY() > absY) break;
        }
        return result;
    }

    public int getRelativePageNo(RenderingContext c) {
        List<BlockBox> sequences = this.getSortedPageSequences();
        int initial = 0;
        if (c.getInitialPageNo() > 0) {
            initial = c.getInitialPageNo() - 1;
        }
        if (sequences == null) {
            return initial + c.getPageNo();
        }
        int sequenceStartIndex = this.getPageSequenceStart(c, sequences, c.getPage());
        if (sequenceStartIndex == -1) {
            return initial + c.getPageNo();
        }
        BlockBox block = sequences.get(sequenceStartIndex);
        return c.getPageNo() - this.getFirstPage((CssContext)c, block).getPageNo();
    }

    public int getRelativePageCount(RenderingContext c) {
        int lastPage;
        BlockBox block;
        int firstPage;
        List<BlockBox> sequences = this.getSortedPageSequences();
        int initial = 0;
        if (c.getInitialPageNo() > 0) {
            initial = c.getInitialPageNo() - 1;
        }
        if (sequences == null) {
            return initial + c.getPageCount();
        }
        int sequenceStartIndex = this.getPageSequenceStart(c, sequences, c.getPage());
        if (sequenceStartIndex == -1) {
            firstPage = 0;
        } else {
            block = sequences.get(sequenceStartIndex);
            firstPage = this.getFirstPage((CssContext)c, block).getPageNo();
        }
        if (sequenceStartIndex < sequences.size() - 1) {
            block = sequences.get(sequenceStartIndex + 1);
            lastPage = this.getFirstPage((CssContext)c, block).getPageNo();
        } else {
            lastPage = c.getPageCount();
        }
        int sequenceLength = lastPage - firstPage;
        if (sequenceStartIndex == -1) {
            sequenceLength += initial;
        }
        return sequenceLength;
    }

    private int getPageSequenceStart(RenderingContext c, List<BlockBox> sequences, PageBox page) {
        for (int i = sequences.size() - 1; i >= 0; --i) {
            BlockBox start = sequences.get(i);
            if (start.getAbsY() >= page.getBottom() - 1) continue;
            return i;
        }
        return -1;
    }

    private PageBox getLastRequestedPage() {
        return this._lastRequestedPage;
    }

    private void setLastRequestedPage(PageBox lastRequestedPage) {
        this._lastRequestedPage = lastRequestedPage;
    }

    public boolean isIsolated() {
        return this._isolated;
    }
}

