/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.highlighting;

import com.intellij.codeInsight.ClassUtil;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.java.codeserver.core.JavaPsiModuleUtil;
import com.intellij.java.codeserver.core.JavaPsiSingleFileSourceUtil;
import com.intellij.java.codeserver.highlighting.JavaErrorVisitor;
import com.intellij.java.codeserver.highlighting.errors.JavaCompilationError;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKind;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKinds;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.JavaFeature;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWalkingState;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.search.searches.ImplicitClassSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.JavaImplicitClassUtil;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

final class ClassChecker {
    @NotNull
    private final JavaErrorVisitor myVisitor;

    ClassChecker(@NotNull JavaErrorVisitor visitor) {
        if (visitor == null) {
            ClassChecker.$$$reportNull$$$0(0);
        }
        this.myVisitor = visitor;
    }

    void checkAbstractInstantiation(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiElement parent;
        if (ref == null) {
            ClassChecker.$$$reportNull$$$0(1);
        }
        if ((parent = ref.getParent()) instanceof PsiAnonymousClass) {
            PsiAnonymousClass aClass = (PsiAnonymousClass)parent;
            if (parent.getParent() instanceof PsiNewExpression && !PsiUtilCore.hasErrorElementChild((PsiElement)parent.getParent())) {
                this.checkClassWithAbstractMethods((PsiClass)aClass);
            }
        }
    }

    private void checkClassWithAbstractMethods(@NotNull PsiClass aClass) {
        PsiMethod abstractMethod;
        if (aClass == null) {
            ClassChecker.$$$reportNull$$$0(2);
        }
        if ((abstractMethod = ClassUtil.getAnyAbstractMethod((PsiClass)aClass)) == null) {
            return;
        }
        PsiClass containingClass = abstractMethod.getContainingClass();
        if (containingClass == null || containingClass == aClass) {
            return;
        }
        this.myVisitor.report(JavaErrorKinds.CLASS_NO_ABSTRACT_METHOD.create((PsiMember)aClass, abstractMethod));
    }

    void checkEnumWithAbstractMethods(@NotNull PsiEnumConstant enumConstant) {
        PsiClass enumClass;
        PsiEnumConstantInitializer initializingClass;
        PsiClass aClass;
        PsiMethod abstractMethod;
        if (enumConstant == null) {
            ClassChecker.$$$reportNull$$$0(3);
        }
        if ((abstractMethod = ClassUtil.getAnyAbstractMethod((PsiClass)(aClass = Objects.requireNonNullElse(initializingClass = enumConstant.getInitializingClass(), enumClass = enumConstant.getContainingClass())))) == null) {
            return;
        }
        PsiClass containingClass = abstractMethod.getContainingClass();
        if (containingClass == null || containingClass == initializingClass || containingClass != enumClass && initializingClass == null && !ClassChecker.hasEnumConstantsWithInitializer(enumClass)) {
            return;
        }
        this.myVisitor.report(JavaErrorKinds.CLASS_NO_ABSTRACT_METHOD.create((PsiMember)enumConstant, abstractMethod));
    }

    void checkExtendsDuplicate(@NotNull PsiJavaCodeReferenceElement element, PsiElement resolved) {
        PsiElement psiElement;
        if (element == null) {
            ClassChecker.$$$reportNull$$$0(4);
        }
        if (!((psiElement = element.getParent()) instanceof PsiReferenceList)) {
            return;
        }
        PsiReferenceList list = (PsiReferenceList)psiElement;
        if (!(list.getParent() instanceof PsiClass)) {
            return;
        }
        if (!(resolved instanceof PsiClass)) {
            return;
        }
        PsiClass aClass = (PsiClass)resolved;
        PsiManager manager = this.myVisitor.file().getManager();
        PsiJavaCodeReferenceElement sibling = (PsiJavaCodeReferenceElement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)element, PsiJavaCodeReferenceElement.class);
        while (true) {
            if (sibling == null) {
                return;
            }
            PsiElement target = sibling.resolve();
            if (manager.areElementsEquivalent(target, (PsiElement)aClass)) break;
            sibling = (PsiJavaCodeReferenceElement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)sibling, PsiJavaCodeReferenceElement.class);
        }
        this.myVisitor.report(JavaErrorKinds.CLASS_REFERENCE_LIST_DUPLICATE.create(element, aClass));
    }

    void checkClassExtendsForeignInnerClass(final @NotNull PsiJavaCodeReferenceElement extendRef, final @Nullable PsiElement resolved) {
        PsiClass containerClass;
        PsiElement parent;
        if (extendRef == null) {
            ClassChecker.$$$reportNull$$$0(5);
        }
        if (!((parent = extendRef.getParent()) instanceof PsiReferenceList)) {
            return;
        }
        PsiElement grand = parent.getParent();
        if (!(grand instanceof PsiClass)) {
            return;
        }
        final PsiClass aClass = (PsiClass)grand;
        if (aClass instanceof PsiTypeParameter) {
            PsiTypeParameter typeParameter = (PsiTypeParameter)aClass;
            PsiTypeParameterListOwner psiTypeParameterListOwner = typeParameter.getOwner();
            if (!(psiTypeParameterListOwner instanceof PsiClass)) {
                return;
            }
            PsiClass cls = (PsiClass)psiTypeParameterListOwner;
            containerClass = cls;
        } else {
            containerClass = aClass;
        }
        if (aClass.getExtendsList() != parent && aClass.getImplementsList() != parent) {
            return;
        }
        if (resolved != null && !(resolved instanceof PsiClass)) {
            this.myVisitor.report(JavaErrorKinds.CLASS_REFERENCE_LIST_NAME_EXPECTED.create(extendRef));
            return;
        }
        extendRef.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
                if (reference == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitReferenceElement(reference);
                PsiElement resolve = reference.resolve();
                if (resolve instanceof PsiClass) {
                    PsiClass base = (PsiClass)resolve;
                    PsiClass baseClass = base.getContainingClass();
                    if (baseClass != null && base.hasModifierProperty("private") && baseClass == containerClass && baseClass.getContainingClass() == null) {
                        ClassChecker.this.myVisitor.report(JavaErrorKinds.CLASS_REFERENCE_LIST_INNER_PRIVATE.create(reference, base));
                        this.stopWalking();
                        return;
                    }
                    if (!PsiUtil.isInnerClass((PsiClass)base)) {
                        return;
                    }
                    if (!(resolve != resolved || baseClass == null || PsiTreeUtil.isAncestor((PsiElement)baseClass, (PsiElement)extendRef, (boolean)true) && !aClass.hasModifierProperty("static") || InheritanceUtil.hasEnclosingInstanceInScope((PsiClass)baseClass, (PsiElement)extendRef, psiClass -> psiClass != aClass, (boolean)true) || ClassChecker.qualifiedNewCalledInConstructors(aClass))) {
                        ClassChecker.this.myVisitor.report(JavaErrorKinds.CLASS_REFERENCE_LIST_NO_ENCLOSING_INSTANCE.create(extendRef, baseClass));
                        this.stopWalking();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/java/codeserver/highlighting/ClassChecker$1", "visitReferenceElement"));
            }
        });
    }

    void checkClassMustBeAbstract(@NotNull PsiClass aClass) {
        boolean mustCheck;
        if (aClass == null) {
            ClassChecker.$$$reportNull$$$0(6);
        }
        boolean bl = aClass.isEnum() ? !ClassChecker.hasEnumConstantsWithInitializer(aClass) : (mustCheck = !aClass.hasModifierProperty("abstract") && aClass.getRBrace() != null);
        if (mustCheck) {
            this.checkClassWithAbstractMethods(aClass);
        }
    }

    void checkDuplicateNestedClass(PsiClass aClass) {
        boolean checkSiblings;
        PsiClass psiClass;
        String name = aClass.getName();
        if (name == null) {
            return;
        }
        PsiElement parent = aClass.getParent();
        if (parent instanceof PsiClass && !PsiUtil.isLocalOrAnonymousClass((PsiClass)(psiClass = (PsiClass)parent)) && !PsiUtil.isLocalOrAnonymousClass((PsiClass)aClass)) {
            List duplicates = ContainerUtil.filter((Object[])psiClass.getInnerClasses(), c -> Objects.equals(c.getName(), name));
            List duplicatesWithoutMe = ContainerUtil.filter((Collection)duplicates, c -> c != aClass);
            if (!duplicatesWithoutMe.isEmpty()) {
                this.myVisitor.report(JavaErrorKinds.CLASS_DUPLICATE.create(aClass, (PsiClass)duplicatesWithoutMe.get(0)));
                return;
            }
            checkSiblings = false;
        } else {
            checkSiblings = true;
        }
        if (!(parent instanceof PsiDeclarationStatement)) {
            parent = aClass;
        }
        while (parent != null && !(parent instanceof PsiFile)) {
            PsiClass psiClass2;
            PsiElement element;
            PsiElement psiElement = element = checkSiblings ? parent.getPrevSibling() : null;
            if (element == null && ((element = parent.getParent()) instanceof PsiMethod || element instanceof PsiClass || element instanceof PsiCodeBlock && element.getParent() instanceof PsiClassInitializer)) {
                checkSiblings = false;
            }
            parent = element;
            if (element instanceof PsiDeclarationStatement) {
                element = PsiTreeUtil.getChildOfType((PsiElement)element, PsiClass.class);
            }
            if (this.myVisitor.isApplicable(JavaFeature.IMPLICIT_CLASS_NAME_OUT_OF_SCOPE) && element instanceof PsiImplicitClass) {
                return;
            }
            if (!(element instanceof PsiClass) || !name.equals((psiClass2 = (PsiClass)element).getName())) continue;
            this.myVisitor.report(JavaErrorKinds.CLASS_DUPLICATE.create(aClass, psiClass2));
            return;
        }
    }

    void checkCyclicInheritance(@NotNull PsiClass aClass) {
        PsiClass circularClass;
        if (aClass == null) {
            ClassChecker.$$$reportNull$$$0(7);
        }
        if ((circularClass = InheritanceUtil.getCircularClass((PsiClass)aClass)) != null) {
            this.myVisitor.report(JavaErrorKinds.CLASS_CYCLIC_INHERITANCE.create(aClass, circularClass));
        }
    }

    void checkIllegalInstantiation(@NotNull PsiClass aClass, @NotNull PsiExpression highlightElement) {
        PsiNewExpression newExpression;
        if (aClass == null) {
            ClassChecker.$$$reportNull$$$0(8);
        }
        if (highlightElement == null) {
            ClassChecker.$$$reportNull$$$0(9);
        }
        if (highlightElement instanceof PsiNewExpression && (newExpression = (PsiNewExpression)highlightElement).isArrayCreation()) {
            return;
        }
        if (aClass.hasModifierProperty("abstract")) {
            this.myVisitor.report(JavaErrorKinds.INSTANTIATION_ABSTRACT.create(highlightElement, aClass));
        }
        if (aClass.isEnum()) {
            this.myVisitor.report(JavaErrorKinds.INSTANTIATION_ENUM.create(highlightElement));
        }
    }

    void checkDuplicateTopLevelClass(@NotNull PsiClass aClass) {
        Collection implicitClasses;
        PsiJavaFile javaFile;
        Module module;
        if (aClass == null) {
            ClassChecker.$$$reportNull$$$0(10);
        }
        if (aClass instanceof PsiImplicitClass) {
            return;
        }
        if (!(aClass.getParent() instanceof PsiFile)) {
            return;
        }
        String qualifiedName = aClass.getQualifiedName();
        if (qualifiedName == null) {
            return;
        }
        int numOfClassesToFind = 2;
        if (qualifiedName.contains("$")) {
            qualifiedName = qualifiedName.replace('$', '.');
            numOfClassesToFind = 1;
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass)) == null) {
            return;
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleScope((Module)module).intersectWith(aClass.getResolveScope());
        Object[] classes = JavaPsiFacade.getInstance((Project)this.myVisitor.project()).findClasses(qualifiedName, scope);
        PsiFile psiFile = aClass.getContainingFile();
        if (psiFile instanceof PsiJavaFile && (javaFile = (PsiJavaFile)psiFile).getPackageStatement() == null && !(implicitClasses = ImplicitClassSearch.search((String)qualifiedName, (Project)this.myVisitor.project(), (GlobalSearchScope)scope).findAll()).isEmpty()) {
            ArrayList newClasses = new ArrayList();
            ContainerUtil.addAll(newClasses, (Object[])classes);
            ContainerUtil.addAll(newClasses, (Iterable)implicitClasses);
            classes = newClasses.toArray(PsiClass.EMPTY_ARRAY);
        }
        if (classes.length < numOfClassesToFind) {
            return;
        }
        this.checkDuplicateClasses(aClass, (PsiClass[])classes);
    }

    void checkDuplicateClassesWithImplicit(@NotNull PsiJavaFile file) {
        if (file == null) {
            ClassChecker.$$$reportNull$$$0(11);
        }
        if (!this.myVisitor.isApplicable(JavaFeature.IMPLICIT_CLASSES)) {
            return;
        }
        PsiImplicitClass implicitClass = JavaImplicitClassUtil.getImplicitClassFor((PsiElement)file);
        if (implicitClass == null) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return;
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleScope((Module)module).intersectWith(implicitClass.getResolveScope());
        String qualifiedName = implicitClass.getQualifiedName();
        if (qualifiedName == null) {
            return;
        }
        PsiClass[] classes = JavaPsiFacade.getInstance((Project)this.myVisitor.project()).findClasses(qualifiedName, scope);
        this.checkDuplicateClasses((PsiClass)implicitClass, classes);
    }

    private void checkDuplicateClasses(@NotNull PsiClass aClass, @NotNull @NotNull PsiClass @NotNull [] classes) {
        if (aClass == null) {
            ClassChecker.$$$reportNull$$$0(12);
        }
        if (classes == null) {
            ClassChecker.$$$reportNull$$$0(13);
        }
        PsiManager manager = aClass.getManager();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass);
        if (module == null) {
            return;
        }
        ModuleFileIndex fileIndex = ModuleRootManager.getInstance((Module)module).getFileIndex();
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)aClass);
        if (virtualFile == null) {
            return;
        }
        boolean isTestSourceRoot = fileIndex.isInTestSourceContent(virtualFile);
        for (PsiClass dupClassCandidate : classes) {
            VirtualFile file;
            if (dupClassCandidate == aClass || (file = dupClassCandidate.getContainingFile().getVirtualFile()) == null || !manager.isInProject((PsiElement)dupClassCandidate) || fileIndex.isInTestSourceContent(file) != isTestSourceRoot) continue;
            this.myVisitor.report(JavaErrorKinds.CLASS_DUPLICATE_IN_OTHER_FILE.create(aClass, dupClassCandidate));
            return;
        }
    }

    void checkMustNotBeLocal(@NotNull PsiClass aClass) {
        JavaFeature feature;
        IElementType token;
        if (aClass == null) {
            ClassChecker.$$$reportNull$$$0(14);
        }
        if (aClass.isEnum()) {
            token = JavaTokenType.ENUM_KEYWORD;
            feature = JavaFeature.LOCAL_ENUMS;
        } else if (aClass.isInterface()) {
            token = JavaTokenType.INTERFACE_KEYWORD;
            feature = aClass.isAnnotationType() ? null : JavaFeature.LOCAL_INTERFACES;
        } else {
            return;
        }
        if (!PsiUtil.isLocalClass((PsiClass)aClass)) {
            return;
        }
        PsiElement anchor = Stream.iterate(aClass.getFirstChild(), Objects::nonNull, PsiElement::getNextSibling).filter(e -> {
            PsiKeyword keyword;
            return e instanceof PsiKeyword && (keyword = (PsiKeyword)e).getTokenType().equals(token);
        }).findFirst().orElseThrow();
        if (feature == null) {
            this.myVisitor.report(JavaErrorKinds.ANNOTATION_LOCAL.create(anchor));
        } else {
            this.myVisitor.checkFeature(anchor, feature);
        }
    }

    void checkClassAndPackageConflict(@NotNull PsiClass aClass) {
        String name;
        if (aClass == null) {
            ClassChecker.$$$reportNull$$$0(15);
        }
        if ((name = aClass.getQualifiedName()) == null) {
            return;
        }
        if ("java.lang".equals(name)) {
            this.myVisitor.report(JavaErrorKinds.CLASS_CLASHES_WITH_PACKAGE.create(aClass));
        } else {
            PsiDirectory directory;
            PsiJavaFile javaFile;
            PsiElement file = aClass.getParent();
            if (file instanceof PsiJavaFile && !(javaFile = (PsiJavaFile)file).getPackageName().isEmpty() && (directory = javaFile.getParent()) != null) {
                PsiDirectory subDirectory;
                String simpleName = aClass.getName();
                PsiDirectory psiDirectory = subDirectory = simpleName == null ? null : directory.findSubdirectory(simpleName);
                if (subDirectory != null && simpleName.equals(subDirectory.getName()) && PsiTreeUtil.findChildOfType((PsiElement)subDirectory, PsiJavaFile.class) != null) {
                    this.myVisitor.report(JavaErrorKinds.CLASS_CLASHES_WITH_PACKAGE.create(aClass));
                }
            }
        }
    }

    void checkPublicClassInRightFile(@NotNull PsiClass aClass) {
        if (aClass == null) {
            ClassChecker.$$$reportNull$$$0(16);
        }
        PsiFile containingFile = aClass.getContainingFile();
        if (aClass.getParent() != containingFile || !aClass.hasModifierProperty("public") || !(containingFile instanceof PsiJavaFile)) {
            return;
        }
        PsiJavaFile file = (PsiJavaFile)containingFile;
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null || virtualFile.getNameWithoutExtension().equals(aClass.getName())) {
            return;
        }
        if (JavaPsiSingleFileSourceUtil.isJavaHashBangScript((PsiFile)file)) {
            return;
        }
        this.myVisitor.report(JavaErrorKinds.CLASS_WRONG_FILE_NAME.create(aClass));
    }

    void checkSealedClassInheritors(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            ClassChecker.$$$reportNull$$$0(17);
        }
        if (psiClass.hasModifierProperty("sealed")) {
            Map<PsiJavaCodeReferenceElement, PsiClass> permittedClassesRefs;
            Collection<PsiClass> permittedClasses;
            boolean hasMissingInheritors;
            PsiIdentifier nameIdentifier = psiClass.getNameIdentifier();
            if (nameIdentifier == null) {
                return;
            }
            if (psiClass.isEnum()) {
                return;
            }
            Collection inheritors = DirectClassInheritorsSearch.searchAllSealedInheritors((PsiClass)psiClass, (SearchScope)GlobalSearchScope.allScope((Project)this.myVisitor.project()).union((SearchScope)GlobalSearchScope.fileScope((PsiFile)this.myVisitor.file()))).findAll();
            if (inheritors.isEmpty()) {
                this.myVisitor.report(JavaErrorKinds.CLASS_SEALED_NO_INHERITORS.create(psiClass));
                return;
            }
            PsiFile parentFile = psiClass.getContainingFile();
            PsiManager manager = parentFile.getManager();
            boolean hasOutsideClasses = ContainerUtil.exists((Iterable)inheritors, inheritor -> !manager.areElementsEquivalent((PsiElement)inheritor.getNavigationElement().getContainingFile(), (PsiElement)parentFile));
            if (hasOutsideClasses && (hasMissingInheritors = ContainerUtil.exists((Iterable)inheritors, arg_0 -> ClassChecker.lambda$checkSealedClassInheritors$4(permittedClasses = (permittedClassesRefs = ClassChecker.getPermittedClassesRefs(psiClass)).values(), arg_0)))) {
                this.myVisitor.report(JavaErrorKinds.CLASS_SEALED_INCOMPLETE_PERMITS.create(psiClass));
            }
        }
    }

    void checkSealedSuper(@NotNull PsiClass aClass) {
        PsiIdentifier nameIdentifier;
        if (aClass == null) {
            ClassChecker.$$$reportNull$$$0(18);
        }
        if (!((nameIdentifier = aClass.getNameIdentifier()) == null || aClass instanceof PsiTypeParameter || aClass.hasModifierProperty("sealed") || aClass.hasModifierProperty("non-sealed") || aClass.hasModifierProperty("final") || !Arrays.stream(aClass.getSuperTypes()).map(type -> type.resolve()).anyMatch(superClass -> superClass != null && superClass.hasModifierProperty("sealed")))) {
            boolean canBeFinal = !aClass.isInterface() && DirectClassInheritorsSearch.search((PsiClass)aClass).findFirst() == null;
            JavaErrorKind.Simple<PsiClass> errorKind = canBeFinal ? JavaErrorKinds.CLASS_SEALED_INHERITOR_EXPECTED_MODIFIERS_CAN_BE_FINAL : JavaErrorKinds.CLASS_SEALED_INHERITOR_EXPECTED_MODIFIERS;
            this.myVisitor.report(errorKind.create(aClass));
        }
    }

    void checkImplicitClassWellFormed(@NotNull PsiJavaFile file) {
        if (file == null) {
            ClassChecker.$$$reportNull$$$0(19);
        }
        if (!this.myVisitor.isApplicable(JavaFeature.IMPLICIT_CLASSES)) {
            return;
        }
        PsiImplicitClass implicitClass = JavaImplicitClassUtil.getImplicitClassFor((PsiElement)file);
        if (implicitClass == null) {
            return;
        }
        String name = implicitClass.getQualifiedName();
        if (!PsiNameHelper.getInstance((Project)this.myVisitor.project()).isIdentifier(name)) {
            this.myVisitor.report(JavaErrorKinds.CLASS_IMPLICIT_INVALID_FILE_NAME.create(file, implicitClass));
            return;
        }
        Object[] methods = implicitClass.findMethodsByName("main", false);
        boolean hasMainMethod = ContainerUtil.exists((Object[])methods, method -> PsiMethodUtil.isMainMethod((PsiMethod)method));
        if (!hasMainMethod) {
            if (file.getPackageStatement() != null) {
                return;
            }
            if (ClassChecker.hasErrorElementWithBraces((PsiElement)file)) {
                return;
            }
            this.myVisitor.report(JavaErrorKinds.CLASS_IMPLICIT_NO_MAIN_METHOD.create(file, implicitClass));
        }
    }

    private static boolean hasErrorElementWithBraces(@NotNull PsiElement parentElement) {
        if (parentElement == null) {
            ClassChecker.$$$reportNull$$$0(20);
        }
        Ref result = new Ref((Object)false);
        PsiWalkingState.processAll((PsiElement)parentElement, el -> {
            PsiErrorElement element;
            if (el instanceof PsiErrorElement && ((element = (PsiErrorElement)el).getText().contains("}") || element.getText().contains("{"))) {
                result.set((Object)true);
                return false;
            }
            return true;
        });
        return (Boolean)result.get();
    }

    void checkImplicitClassMember(@NotNull PsiMember member) {
        PsiNameIdentifierOwner owner;
        PsiElement nameIdentifier;
        if (member == null) {
            ClassChecker.$$$reportNull$$$0(21);
        }
        if (!(member.getContainingClass() instanceof PsiImplicitClass)) {
            return;
        }
        PsiMember anchor = member;
        if (member instanceof PsiNameIdentifierOwner && (nameIdentifier = (owner = (PsiNameIdentifierOwner)member).getNameIdentifier()) != null) {
            anchor = nameIdentifier;
        }
        this.myVisitor.checkFeature((PsiElement)anchor, JavaFeature.IMPLICIT_CLASSES);
    }

    void checkIllegalInstanceMemberInRecord(@NotNull PsiMember member) {
        PsiClass aClass;
        if (member == null) {
            ClassChecker.$$$reportNull$$$0(22);
        }
        if (!member.hasModifierProperty("static") && (aClass = member.getContainingClass()) != null && aClass.isRecord()) {
            JavaCompilationError<PsiField, Void> javaCompilationError;
            if (member instanceof PsiClassInitializer) {
                PsiClassInitializer initializer = (PsiClassInitializer)member;
                javaCompilationError = JavaErrorKinds.RECORD_INSTANCE_INITIALIZER.create(initializer);
            } else {
                javaCompilationError = JavaErrorKinds.RECORD_INSTANCE_FIELD.create((PsiField)member);
            }
            JavaCompilationError<PsiField, Void> error = javaCompilationError;
            this.myVisitor.report(error);
        }
    }

    void checkThingNotAllowedInInterface(@NotNull PsiMember member) {
        PsiMethod method;
        PsiClass aClass;
        if (member == null) {
            ClassChecker.$$$reportNull$$$0(23);
        }
        if ((aClass = member.getContainingClass()) == null || !aClass.isInterface()) {
            return;
        }
        if (member instanceof PsiMethod && (method = (PsiMethod)member).isConstructor()) {
            this.myVisitor.report(JavaErrorKinds.INTERFACE_CONSTRUCTOR.create(method));
        } else if (member instanceof PsiClassInitializer) {
            PsiClassInitializer initializer = (PsiClassInitializer)member;
            this.myVisitor.report(JavaErrorKinds.INTERFACE_CLASS_INITIALIZER.create(initializer));
        }
    }

    void checkInitializersInImplicitClass(@NotNull PsiClassInitializer initializer) {
        if (initializer == null) {
            ClassChecker.$$$reportNull$$$0(24);
        }
        if (initializer.getContainingClass() instanceof PsiImplicitClass && this.myVisitor.isApplicable(JavaFeature.IMPLICIT_CLASSES)) {
            this.myVisitor.report(JavaErrorKinds.CLASS_IMPLICIT_INITIALIZER.create(initializer));
        }
    }

    void checkPackageNotAllowedInImplicitClass(@NotNull PsiPackageStatement statement) {
        if (statement == null) {
            ClassChecker.$$$reportNull$$$0(25);
        }
        if (this.myVisitor.isApplicable(JavaFeature.IMPLICIT_CLASSES) && JavaImplicitClassUtil.isFileWithImplicitClass((PsiElement)this.myVisitor.file()) && !ClassChecker.hasErrorElementWithBraces((PsiElement)this.myVisitor.file())) {
            this.myVisitor.report(JavaErrorKinds.CLASS_IMPLICIT_PACKAGE.create(statement));
        }
    }

    void checkClassRestrictedKeyword(@NotNull PsiIdentifier identifier) {
        String className;
        if (identifier == null) {
            ClassChecker.$$$reportNull$$$0(26);
        }
        if (PsiTypesUtil.isRestrictedIdentifier((String)(className = identifier.getText()), (LanguageLevel)this.myVisitor.languageLevel())) {
            this.myVisitor.report(JavaErrorKinds.IDENTIFIER_RESTRICTED.create(identifier));
        }
    }

    void checkStaticDeclarationInInnerClass(@NotNull PsiKeyword keyword) {
        if (keyword == null) {
            ClassChecker.$$$reportNull$$$0(27);
        }
        if (!this.myVisitor.hasErrorResults()) {
            this.checkStaticClassDeclarationInInnerClass(keyword);
        }
        if (!this.myVisitor.hasErrorResults()) {
            this.checkStaticMemberInInnerClass(keyword);
        }
    }

    private void checkStaticClassDeclarationInInnerClass(@NotNull PsiKeyword keyword) {
        PsiElement psiElement;
        if (keyword == null) {
            ClassChecker.$$$reportNull$$$0(28);
        }
        if (!((psiElement = keyword.getParent()) instanceof PsiClass)) {
            return;
        }
        PsiClass curClass = (PsiClass)psiElement;
        if (!curClass.hasModifierProperty("static") || PsiUtilCore.hasErrorElementChild((PsiElement)curClass)) {
            return;
        }
        PsiElement psiElement2 = curClass.getParent();
        if (!(psiElement2 instanceof PsiClass)) {
            return;
        }
        PsiClass parentClass = (PsiClass)psiElement2;
        if (parentClass.hasModifierProperty("static")) {
            return;
        }
        PsiElement parent = parentClass.getParent();
        if (!(parent instanceof PsiClass || parent instanceof PsiDeclarationStatement || parent instanceof PsiNewExpression || parent instanceof PsiEnumConstant)) {
            return;
        }
        PsiKeyword context = keyword;
        PsiModifierList modifierList = curClass.getModifierList();
        if (modifierList != null) {
            for (PsiElement element = modifierList.getFirstChild(); element != null; element = element.getNextSibling()) {
                if (!Objects.equals(element.getText(), "static")) continue;
                context = element;
                break;
            }
        }
        this.myVisitor.checkFeature((PsiElement)context, JavaFeature.INNER_STATICS);
    }

    private void checkStaticMemberInInnerClass(@NotNull PsiKeyword keyword) {
        PsiField field;
        if (keyword == null) {
            ClassChecker.$$$reportNull$$$0(29);
        }
        if (!keyword.getTokenType().equals(JavaTokenType.STATIC_KEYWORD)) {
            return;
        }
        PsiElement psiElement = keyword.getParent();
        if (!(psiElement instanceof PsiModifierList)) {
            return;
        }
        PsiModifierList modifierList = (PsiModifierList)psiElement;
        PsiElement psiElement2 = modifierList.getParent();
        if (!(psiElement2 instanceof PsiMember)) {
            return;
        }
        PsiMember member = (PsiMember)psiElement2;
        if (member instanceof PsiClass) {
            return;
        }
        if (PsiUtilCore.hasErrorElementChild((PsiElement)member)) {
            return;
        }
        if (member instanceof PsiField && PsiUtil.isCompileTimeConstant((PsiVariable)(field = (PsiField)member))) {
            return;
        }
        PsiElement psiElement3 = member.getParent();
        if (!(psiElement3 instanceof PsiClass)) {
            return;
        }
        PsiClass psiClass = (PsiClass)psiElement3;
        if (psiClass.hasModifierProperty("static")) {
            return;
        }
        PsiElement classParent = psiClass.getParent();
        if (!(classParent instanceof PsiClass || classParent instanceof PsiDeclarationStatement || classParent instanceof PsiNewExpression || classParent instanceof PsiEnumConstant)) {
            return;
        }
        this.myVisitor.checkFeature((PsiElement)keyword, JavaFeature.INNER_STATICS);
    }

    void checkExtendsAllowed(@NotNull PsiReferenceList list) {
        PsiClass aClass;
        PsiElement psiElement;
        if (list == null) {
            ClassChecker.$$$reportNull$$$0(30);
        }
        if ((psiElement = list.getParent()) instanceof PsiClass && list.equals((Object)(aClass = (PsiClass)psiElement).getExtendsList())) {
            if (aClass.isRecord()) {
                this.myVisitor.report(JavaErrorKinds.RECORD_EXTENDS.create(list));
            } else if (aClass.isEnum()) {
                this.myVisitor.report(JavaErrorKinds.ENUM_EXTENDS.create(list));
            }
        }
    }

    void checkImplementsAllowed(@NotNull PsiReferenceList list) {
        boolean isImplements;
        PsiClass aClass;
        PsiElement psiElement;
        if (list == null) {
            ClassChecker.$$$reportNull$$$0(31);
        }
        if ((psiElement = list.getParent()) instanceof PsiClass && (aClass = (PsiClass)psiElement).isInterface() && (isImplements = list.equals((Object)aClass.getImplementsList()))) {
            this.myVisitor.report(JavaErrorKinds.INTERFACE_IMPLEMENTS.create(list));
        }
    }

    void checkClassExtendsOnlyOneClass(@NotNull PsiReferenceList list) {
        PsiElement psiElement;
        if (list == null) {
            ClassChecker.$$$reportNull$$$0(32);
        }
        if (!((psiElement = list.getParent()) instanceof PsiClass)) {
            return;
        }
        PsiClass aClass = (PsiClass)psiElement;
        PsiClassType[] referencedTypes = list.getReferencedTypes();
        if (!aClass.isInterface() && referencedTypes.length > 1 && aClass.getExtendsList() == list) {
            this.myVisitor.report(JavaErrorKinds.CLASS_CANNOT_EXTEND_MULTIPLE_CLASSES.create(list));
        }
    }

    void checkPermitsList(@NotNull PsiReferenceList list) {
        PsiClass aClass;
        PsiElement parent;
        if (list == null) {
            ClassChecker.$$$reportNull$$$0(33);
        }
        if (!((parent = list.getParent()) instanceof PsiClass) || !list.equals((Object)(aClass = (PsiClass)parent).getPermitsList())) {
            return;
        }
        this.myVisitor.checkFeature((PsiElement)list, JavaFeature.SEALED_CLASSES);
        if (this.myVisitor.hasErrorResults()) {
            return;
        }
        PsiIdentifier nameIdentifier = aClass.getNameIdentifier();
        if (nameIdentifier == null) {
            return;
        }
        if (aClass.isEnum() || aClass.isRecord() || aClass.isAnnotationType()) {
            JavaErrorKind.Simple<PsiReferenceList> description = aClass.isEnum() ? JavaErrorKinds.ENUM_PERMITS : (aClass.isRecord() ? JavaErrorKinds.RECORD_PERMITS : JavaErrorKinds.ANNOTATION_PERMITS);
            this.myVisitor.report(description.create(list));
            return;
        }
        if (!aClass.hasModifierProperty("sealed")) {
            this.myVisitor.report(JavaErrorKinds.CLASS_SEALED_PERMITS_ON_NON_SEALED.create(aClass));
            return;
        }
        PsiJavaModule currentModule = this.myVisitor.javaModule();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)this.myVisitor.project());
        for (PsiJavaCodeReferenceElement permitted : list.getReferenceElements()) {
            for (PsiAnnotation annotation : PsiTreeUtil.findChildrenOfType((PsiElement)permitted, PsiAnnotation.class)) {
                this.myVisitor.report(JavaErrorKinds.ANNOTATION_NOT_ALLOWED_IN_PERMIT_LIST.create(annotation));
            }
            PsiReferenceParameterList parameterList = permitted.getParameterList();
            if (parameterList != null && parameterList.getTypeParameterElements().length > 0) {
                this.myVisitor.report(JavaErrorKinds.TYPE_ARGUMENT_IN_PERMITS_LIST.create(parameterList));
                continue;
            }
            @Nullable PsiElement resolve = permitted.resolve();
            if (!(resolve instanceof PsiClass)) continue;
            PsiClass inheritorClass = (PsiClass)resolve;
            PsiManager manager = inheritorClass.getManager();
            if (!ContainerUtil.exists((Object[])inheritorClass.getSuperTypes(), type -> manager.areElementsEquivalent((PsiElement)aClass, (PsiElement)type.resolve()))) {
                this.myVisitor.report(JavaErrorKinds.CLASS_PERMITTED_NOT_DIRECT_SUBCLASS.create(permitted, new JavaErrorKinds.SuperclassSubclassContext(aClass, inheritorClass)));
                continue;
            }
            if (currentModule == null && !psiFacade.arePackagesTheSame((PsiElement)aClass, (PsiElement)inheritorClass)) {
                this.myVisitor.report(JavaErrorKinds.CLASS_EXTENDS_SEALED_ANOTHER_PACKAGE.create(permitted, new JavaErrorKinds.SuperclassSubclassContext(aClass, inheritorClass)));
                continue;
            }
            if (currentModule != null && !ClassChecker.areModulesTheSame(currentModule, JavaPsiModuleUtil.findDescriptorByElement((PsiElement)inheritorClass))) {
                this.myVisitor.report(JavaErrorKinds.CLASS_EXTENDS_SEALED_ANOTHER_MODULE.create(permitted, new JavaErrorKinds.SuperclassSubclassContext(aClass, inheritorClass)));
                continue;
            }
            if (inheritorClass instanceof PsiCompiledElement || ClassChecker.hasPermittedSubclassModifier(inheritorClass)) continue;
            this.myVisitor.report(JavaErrorKinds.CLASS_PERMITTED_MUST_HAVE_MODIFIER.create(permitted, inheritorClass));
        }
    }

    private static boolean areModulesTheSame(@NotNull PsiJavaModule module, PsiJavaModule module1) {
        if (module == null) {
            ClassChecker.$$$reportNull$$$0(34);
        }
        return module1 != null && module.getOriginalElement() == module1.getOriginalElement();
    }

    private static boolean hasPermittedSubclassModifier(@NotNull PsiClass psiClass) {
        PsiModifierList modifiers;
        if (psiClass == null) {
            ClassChecker.$$$reportNull$$$0(35);
        }
        if ((modifiers = psiClass.getModifierList()) == null) {
            return false;
        }
        return modifiers.hasModifierProperty("sealed") || modifiers.hasModifierProperty("non-sealed") || modifiers.hasModifierProperty("final");
    }

    void checkExtendsClassAndImplementsInterface(@NotNull PsiReferenceList referenceList, @NotNull PsiClass extendFrom, @NotNull PsiJavaCodeReferenceElement ref) {
        boolean mustBeInterface;
        if (referenceList == null) {
            ClassChecker.$$$reportNull$$$0(36);
        }
        if (extendFrom == null) {
            ClassChecker.$$$reportNull$$$0(37);
        }
        if (ref == null) {
            ClassChecker.$$$reportNull$$$0(38);
        }
        PsiClass aClass = (PsiClass)referenceList.getParent();
        boolean isImplements = referenceList.equals((Object)aClass.getImplementsList());
        boolean isInterface = aClass.isInterface();
        if (isInterface && isImplements) {
            return;
        }
        boolean bl = mustBeInterface = isImplements || isInterface;
        if (extendFrom.isInterface() == mustBeInterface) {
            return;
        }
        JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, PsiClass> error = isInterface ? JavaErrorKinds.INTERFACE_EXTENDS_CLASS : (isImplements ? JavaErrorKinds.CLASS_IMPLEMENTS_CLASS : JavaErrorKinds.CLASS_EXTENDS_INTERFACE);
        this.myVisitor.report(error.create(ref, aClass));
    }

    void checkValueClassExtends(@NotNull PsiClass superClass, @NotNull PsiClass psiClass, @NotNull PsiJavaCodeReferenceElement ref) {
        if (superClass == null) {
            ClassChecker.$$$reportNull$$$0(39);
        }
        if (psiClass == null) {
            ClassChecker.$$$reportNull$$$0(40);
        }
        if (ref == null) {
            ClassChecker.$$$reportNull$$$0(41);
        }
        if (psiClass.isValueClass() && !superClass.isValueClass() && !"java.lang.Object".equals(superClass.getQualifiedName())) {
            this.myVisitor.report(JavaErrorKinds.VALUE_CLASS_EXTENDS_NON_ABSTRACT.create(ref));
        }
    }

    void checkCannotInheritFromFinal(@NotNull PsiClass superClass, @NotNull PsiJavaCodeReferenceElement elementToHighlight) {
        if (superClass == null) {
            ClassChecker.$$$reportNull$$$0(42);
        }
        if (elementToHighlight == null) {
            ClassChecker.$$$reportNull$$$0(43);
        }
        if (superClass.hasModifierProperty("final") || superClass.isEnum()) {
            this.myVisitor.report(JavaErrorKinds.CLASS_EXTENDS_FINAL.create(elementToHighlight, superClass));
        }
    }

    void checkExtendsProhibitedClass(@NotNull PsiClass superClass, @NotNull PsiClass psiClass, @NotNull PsiJavaCodeReferenceElement elementToHighlight) {
        String qualifiedName;
        if (superClass == null) {
            ClassChecker.$$$reportNull$$$0(44);
        }
        if (psiClass == null) {
            ClassChecker.$$$reportNull$$$0(45);
        }
        if (elementToHighlight == null) {
            ClassChecker.$$$reportNull$$$0(46);
        }
        if ("java.lang.Enum".equals(qualifiedName = superClass.getQualifiedName()) && !psiClass.isEnum() || "java.lang.Record".equals(qualifiedName) && !psiClass.isRecord()) {
            this.myVisitor.report(JavaErrorKinds.CLASS_EXTENDS_PROHIBITED_CLASS.create(elementToHighlight, superClass));
        }
    }

    void checkAnonymousInheritFinal(@NotNull PsiNewExpression expression) {
        PsiAnonymousClass aClass;
        if (expression == null) {
            ClassChecker.$$$reportNull$$$0(47);
        }
        if ((aClass = (PsiAnonymousClass)PsiTreeUtil.getChildOfType((PsiElement)expression, PsiAnonymousClass.class)) == null) {
            return;
        }
        PsiClassType baseClassReference = aClass.getBaseClassType();
        PsiClass baseClass = baseClassReference.resolve();
        if (baseClass == null) {
            return;
        }
        this.checkCannotInheritFromFinal(baseClass, aClass.getBaseClassReference());
    }

    void checkAnonymousInheritProhibited(@NotNull PsiNewExpression expression) {
        PsiAnonymousClass aClass;
        if (expression == null) {
            ClassChecker.$$$reportNull$$$0(48);
        }
        if ((aClass = expression.getAnonymousClass()) != null) {
            PsiClass superClass = aClass.getSuperClass();
            PsiJavaCodeReferenceElement reference = expression.getClassOrAnonymousClassReference();
            if (superClass != null && reference != null) {
                this.checkExtendsProhibitedClass(superClass, (PsiClass)aClass, reference);
            }
        }
    }

    void checkAnonymousSealedProhibited(@NotNull PsiNewExpression newExpression) {
        PsiClass superClass;
        PsiAnonymousClass aClass;
        if (newExpression == null) {
            ClassChecker.$$$reportNull$$$0(49);
        }
        if ((aClass = newExpression.getAnonymousClass()) != null && (superClass = aClass.getBaseClassType().resolve()) != null && superClass.hasModifierProperty("sealed")) {
            this.myVisitor.report(JavaErrorKinds.CLASS_ANONYMOUS_EXTENDS_SEALED.create(aClass));
        }
    }

    void checkClassAlreadyImported(@NotNull PsiClass aClass) {
        PsiImportStatementBase[] importStatements;
        PsiFile file;
        if (aClass == null) {
            ClassChecker.$$$reportNull$$$0(50);
        }
        if (!((file = aClass.getContainingFile()) instanceof PsiJavaFile)) {
            return;
        }
        PsiJavaFile javaFile = (PsiJavaFile)file;
        if (aClass.getParent() != javaFile) {
            return;
        }
        PsiImportList importList = javaFile.getImportList();
        if (importList == null) {
            return;
        }
        for (PsiImportStatementBase importStatement : importStatements = importList.getAllImportStatements()) {
            PsiElement resolved;
            if (importStatement.isOnDemand() || !((resolved = importStatement.resolve()) instanceof PsiClass)) continue;
            PsiClass psiClass = (PsiClass)resolved;
            if (resolved.equals((Object)aClass) || !Comparing.equal((String)aClass.getName(), (String)psiClass.getName(), (boolean)true)) continue;
            this.myVisitor.report(JavaErrorKinds.CLASS_ALREADY_IMPORTED.create(aClass));
        }
    }

    void checkClassDoesNotCallSuperConstructorOrHandleExceptions(PsiClass aClass) {
        if (aClass.isEnum()) {
            return;
        }
        if (aClass.getConstructors().length != 0) {
            return;
        }
        this.checkBaseClassDefaultConstructorProblem(aClass, (PsiMember)aClass, PsiClassType.EMPTY_ARRAY);
    }

    void checkBaseClassDefaultConstructorProblem(@NotNull PsiClass aClass, @NotNull PsiMember anchor, PsiClassType @NotNull [] handledExceptions) {
        if (aClass == null) {
            ClassChecker.$$$reportNull$$$0(51);
        }
        if (anchor == null) {
            ClassChecker.$$$reportNull$$$0(52);
        }
        if (handledExceptions == null) {
            ClassChecker.$$$reportNull$$$0(53);
        }
        if (aClass instanceof PsiAnonymousClass) {
            return;
        }
        PsiClass baseClass = aClass.getSuperClass();
        if (baseClass == null) {
            return;
        }
        PsiMethod[] constructors = baseClass.getConstructors();
        if (constructors.length == 0) {
            return;
        }
        PsiElement resolved = JavaResolveUtil.resolveImaginarySuperCallInThisPlace((PsiMember)aClass, (Project)this.myVisitor.project(), (PsiClass)baseClass);
        List<PsiMethod> constructorCandidates = (resolved != null ? Collections.singletonList((PsiMethod)resolved) : Arrays.asList(constructors)).stream().filter(constructor -> {
            PsiParameter[] parameters = constructor.getParameterList().getParameters();
            return (parameters.length == 0 || parameters.length == 1 && parameters[0].isVarArgs()) && PsiResolveHelper.getInstance((Project)this.myVisitor.project()).isAccessible((PsiMember)constructor, (PsiElement)aClass, null);
        }).limit(2L).toList();
        if (constructorCandidates.size() >= 2) {
            JavaErrorKinds.AmbiguousImplicitConstructorCallContext context = new JavaErrorKinds.AmbiguousImplicitConstructorCallContext(aClass, constructorCandidates.get(0), constructorCandidates.get(1));
            this.myVisitor.report(JavaErrorKinds.CONSTRUCTOR_AMBIGUOUS_IMPLICIT_CALL.create(anchor, context));
        } else if (!constructorCandidates.isEmpty()) {
            this.checkDefaultConstructorThrowsException(constructorCandidates.get(0), anchor, handledExceptions);
        } else {
            if (baseClass.hasModifierProperty("final")) {
                return;
            }
            this.myVisitor.report(JavaErrorKinds.CONSTRUCTOR_NO_DEFAULT.create(anchor, baseClass));
        }
    }

    private void checkDefaultConstructorThrowsException(@NotNull PsiMethod constructor, @NotNull PsiMember anchor, PsiClassType[] handledExceptions) {
        if (constructor == null) {
            ClassChecker.$$$reportNull$$$0(54);
        }
        if (anchor == null) {
            ClassChecker.$$$reportNull$$$0(55);
        }
        PsiClassType[] referencedTypes = constructor.getThrowsList().getReferencedTypes();
        ArrayList<PsiClassType> exceptions = new ArrayList<PsiClassType>();
        for (PsiClassType referencedType : referencedTypes) {
            if (ExceptionUtil.isUncheckedException((PsiClassType)referencedType) || ExceptionUtil.isHandledBy((PsiClassType)referencedType, (PsiClassType[])handledExceptions)) continue;
            exceptions.add(referencedType);
        }
        if (!exceptions.isEmpty()) {
            this.myVisitor.report(JavaErrorKinds.EXCEPTION_UNHANDLED.create((PsiElement)anchor, exceptions));
        }
    }

    void checkConstructorCallsBaseClassConstructor(@NotNull PsiMethod constructor) {
        if (constructor == null) {
            ClassChecker.$$$reportNull$$$0(56);
        }
        if (!constructor.isConstructor()) {
            return;
        }
        PsiClass aClass = constructor.getContainingClass();
        if (aClass == null) {
            return;
        }
        if (aClass.isEnum()) {
            return;
        }
        PsiCodeBlock body = constructor.getBody();
        if (body == null) {
            return;
        }
        if (JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)constructor) != null) {
            return;
        }
        PsiClassType[] handledExceptions = constructor.getThrowsList().getReferencedTypes();
        this.checkBaseClassDefaultConstructorProblem(aClass, (PsiMember)constructor, handledExceptions);
    }

    void checkEnumSuperConstructorCall(@NotNull PsiMethodCallExpression expr) {
        PsiClass aClass;
        PsiMember constructor;
        PsiReferenceExpression methodExpression;
        PsiElement refNameElement;
        if (expr == null) {
            ClassChecker.$$$reportNull$$$0(57);
        }
        if ((refNameElement = (methodExpression = expr.getMethodExpression()).getReferenceNameElement()) != null && "super".equals(refNameElement.getText()) && (constructor = PsiUtil.findEnclosingConstructorOrInitializer((PsiElement)expr)) instanceof PsiMethod && (aClass = constructor.getContainingClass()) != null && aClass.isEnum()) {
            this.myVisitor.report(JavaErrorKinds.CALL_SUPER_ENUM_CONSTRUCTOR.create(expr));
        }
    }

    void checkSuperQualifierType(@NotNull PsiMethodCallExpression superCall) {
        if (superCall == null) {
            ClassChecker.$$$reportNull$$$0(58);
        }
        if (!JavaPsiConstructorUtil.isSuperConstructorCall((PsiElement)superCall)) {
            return;
        }
        PsiMethod ctr = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)superCall, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiMember.class});
        if (ctr == null) {
            return;
        }
        PsiClass aClass = ctr.getContainingClass();
        if (aClass == null) {
            return;
        }
        PsiClass targetClass = aClass.getSuperClass();
        if (targetClass == null) {
            return;
        }
        PsiExpression qualifier = superCall.getMethodExpression().getQualifierExpression();
        if (qualifier != null) {
            if (ClassChecker.isRealInnerClass(targetClass)) {
                PsiClass outerClass = targetClass.getContainingClass();
                if (outerClass != null) {
                    PsiClassType outerType = this.myVisitor.factory().createType(outerClass);
                    this.myVisitor.myExpressionChecker.checkAssignability((PsiType)outerType, null, qualifier, (PsiElement)qualifier);
                }
            } else {
                this.myVisitor.report(JavaErrorKinds.CALL_SUPER_QUALIFIER_NOT_INNER_CLASS.create(qualifier, targetClass));
            }
        }
    }

    private static boolean isRealInnerClass(PsiClass aClass) {
        if (PsiUtil.isInnerClass((PsiClass)aClass)) {
            return true;
        }
        if (!PsiUtil.isLocalOrAnonymousClass((PsiClass)aClass)) {
            return false;
        }
        if (aClass.hasModifierProperty("static")) {
            return false;
        }
        PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiMember.class, (boolean)true);
        return member != null && !member.hasModifierProperty("static");
    }

    private static @Unmodifiable @NotNull Map<PsiJavaCodeReferenceElement, PsiClass> getPermittedClassesRefs(@NotNull PsiClass psiClass) {
        PsiReferenceList permitsList;
        if (psiClass == null) {
            ClassChecker.$$$reportNull$$$0(59);
        }
        if ((permitsList = psiClass.getPermitsList()) == null) {
            Map<PsiJavaCodeReferenceElement, PsiClass> map = Collections.emptyMap();
            if (map == null) {
                ClassChecker.$$$reportNull$$$0(60);
            }
            return map;
        }
        Object[] classRefs = permitsList.getReferenceElements();
        Map map = ContainerUtil.map2Map((Object[])classRefs, r -> Pair.create((Object)r, (Object)((PsiClass)ObjectUtils.tryCast((Object)r.resolve(), PsiClass.class))));
        if (map == null) {
            ClassChecker.$$$reportNull$$$0(61);
        }
        return map;
    }

    private static boolean qualifiedNewCalledInConstructors(@NotNull PsiClass aClass) {
        PsiMethod[] constructors;
        if (aClass == null) {
            ClassChecker.$$$reportNull$$$0(62);
        }
        if ((constructors = aClass.getConstructors()).length == 0) {
            return false;
        }
        for (PsiMethod constructor : constructors) {
            PsiReferenceExpression referenceExpression;
            PsiExpression qualifierExpression;
            PsiMethodCallExpression methodCallExpression = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)constructor);
            if (methodCallExpression == null) {
                return false;
            }
            if (JavaPsiConstructorUtil.isChainedConstructorCall((PsiElement)methodCallExpression) || (qualifierExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)(referenceExpression = methodCallExpression.getMethodExpression()).getQualifierExpression())) != null) continue;
            return false;
        }
        return true;
    }

    private static boolean hasEnumConstantsWithInitializer(@NotNull PsiClass aClass) {
        if (aClass == null) {
            ClassChecker.$$$reportNull$$$0(63);
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)aClass, () -> {
            PsiField[] fields;
            for (PsiField field : fields = aClass.getFields()) {
                PsiEnumConstant constant;
                if (!(field instanceof PsiEnumConstant) || (constant = (PsiEnumConstant)field).getInitializingClass() == null) continue;
                return new CachedValueProvider.Result((Object)true, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
            return new CachedValueProvider.Result((Object)false, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    void checkImplicitThisReferenceBeforeSuper(@NotNull PsiClass aClass) {
        if (aClass == null) {
            ClassChecker.$$$reportNull$$$0(64);
        }
        if (this.myVisitor.sdkVersion().isAtLeast(JavaSdkVersion.JDK_1_7)) {
            return;
        }
        if (aClass instanceof PsiAnonymousClass || aClass instanceof PsiTypeParameter) {
            return;
        }
        PsiClass superClass = aClass.getSuperClass();
        if (superClass == null || !PsiUtil.isInnerClass((PsiClass)superClass)) {
            return;
        }
        PsiClass outerClass = superClass.getContainingClass();
        if (!InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)outerClass, (boolean)true)) {
            return;
        }
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            this.myVisitor.report(JavaErrorKinds.REFERENCE_MEMBER_BEFORE_CONSTRUCTOR.create((PsiElement)aClass, aClass.getName() + ".this"));
            return;
        }
        for (PsiMethod constructor : constructors) {
            PsiMethodCallExpression call = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)constructor);
            if (JavaPsiConstructorUtil.isSuperConstructorCall((PsiElement)call)) continue;
            this.myVisitor.report(JavaErrorKinds.REFERENCE_MEMBER_BEFORE_CONSTRUCTOR.create((PsiElement)constructor, aClass.getName() + ".this"));
            return;
        }
    }

    void checkExtendsSealedClass(@NotNull PsiClass aClass, @NotNull PsiClass superClass, @NotNull PsiJavaCodeReferenceElement elementToHighlight) {
        if (aClass == null) {
            ClassChecker.$$$reportNull$$$0(65);
        }
        if (superClass == null) {
            ClassChecker.$$$reportNull$$$0(66);
        }
        if (elementToHighlight == null) {
            ClassChecker.$$$reportNull$$$0(67);
        }
        if (superClass.hasModifierProperty("sealed")) {
            PsiManager manager;
            Object[] permittedTypes;
            if (PsiUtil.isLocalClass((PsiClass)aClass)) {
                this.myVisitor.report(JavaErrorKinds.CLASS_EXTENDS_SEALED_LOCAL.create(elementToHighlight, aClass));
                return;
            }
            if (!JavaPsiFacade.getInstance((Project)aClass.getProject()).arePackagesTheSame((PsiElement)aClass, (PsiElement)superClass) && JavaPsiModuleUtil.findDescriptorByElement((PsiElement)aClass) == null) {
                this.myVisitor.report(JavaErrorKinds.CLASS_EXTENDS_SEALED_ANOTHER_PACKAGE.create(elementToHighlight, new JavaErrorKinds.SuperclassSubclassContext(superClass, aClass)));
            }
            if ((permittedTypes = superClass.getPermitsListTypes()).length > 0 ? ContainerUtil.exists((Object[])permittedTypes, arg_0 -> ClassChecker.lambda$checkExtendsSealedClass$13(manager = superClass.getManager(), aClass, arg_0)) : aClass.getContainingFile() == superClass.getContainingFile()) {
                return;
            }
            PsiIdentifier identifier = aClass.getNameIdentifier();
            if (identifier == null) {
                return;
            }
            this.myVisitor.report(JavaErrorKinds.CLASS_EXTENDS_SEALED_NOT_PERMITTED.create(elementToHighlight, new JavaErrorKinds.SuperclassSubclassContext(superClass, aClass)));
        }
    }

    private static /* synthetic */ boolean lambda$checkExtendsSealedClass$13(PsiManager manager, PsiClass aClass, PsiClassType permittedType) {
        return manager.areElementsEquivalent((PsiElement)aClass, (PsiElement)permittedType.resolve());
    }

    private static /* synthetic */ boolean lambda$checkSealedClassInheritors$4(Collection permittedClasses, PsiClass inheritor) {
        return !permittedClasses.contains(inheritor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 60, 61 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 50: 
            case 51: 
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumConstant";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extendRef";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightElement";
                break;
            }
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 17: 
            case 35: 
            case 40: 
            case 45: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElement";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceList";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extendFrom";
                break;
            }
            case 39: 
            case 42: 
            case 44: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 43: 
            case 46: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToHighlight";
                break;
            }
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handledExceptions";
                break;
            }
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superCall";
                break;
            }
            case 60: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/java/codeserver/highlighting/ClassChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/java/codeserver/highlighting/ClassChecker";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getPermittedClassesRefs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkAbstractInstantiation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkClassWithAbstractMethods";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkEnumWithAbstractMethods";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkExtendsDuplicate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkClassExtendsForeignInnerClass";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkClassMustBeAbstract";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkCyclicInheritance";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkIllegalInstantiation";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkDuplicateTopLevelClass";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkDuplicateClassesWithImplicit";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkDuplicateClasses";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkMustNotBeLocal";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkClassAndPackageConflict";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkPublicClassInRightFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkSealedClassInheritors";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "checkSealedSuper";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkImplicitClassWellFormed";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "hasErrorElementWithBraces";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkImplicitClassMember";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "checkIllegalInstanceMemberInRecord";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "checkThingNotAllowedInInterface";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkInitializersInImplicitClass";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "checkPackageNotAllowedInImplicitClass";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "checkClassRestrictedKeyword";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "checkStaticDeclarationInInnerClass";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "checkStaticClassDeclarationInInnerClass";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "checkStaticMemberInInnerClass";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "checkExtendsAllowed";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "checkImplementsAllowed";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "checkClassExtendsOnlyOneClass";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "checkPermitsList";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "areModulesTheSame";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "hasPermittedSubclassModifier";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "checkExtendsClassAndImplementsInterface";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "checkValueClassExtends";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "checkCannotInheritFromFinal";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "checkExtendsProhibitedClass";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "checkAnonymousInheritFinal";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "checkAnonymousInheritProhibited";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "checkAnonymousSealedProhibited";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "checkClassAlreadyImported";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "checkBaseClassDefaultConstructorProblem";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "checkDefaultConstructorThrowsException";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "checkConstructorCallsBaseClassConstructor";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "checkEnumSuperConstructorCall";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "checkSuperQualifierType";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getPermittedClassesRefs";
                break;
            }
            case 60: 
            case 61: {
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedNewCalledInConstructors";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "hasEnumConstantsWithInitializer";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "checkImplicitThisReferenceBeforeSuper";
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "checkExtendsSealedClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 60, 61 -> new IllegalStateException(string);
        };
    }
}

