/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.highlighting;

import com.intellij.java.codeserver.highlighting.JavaErrorVisitor;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKind;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKinds;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalLoopStatement;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.controlFlow.AllVariablesControlFlowPolicy;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowOptions;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.impl.light.LightRecordCanonicalConstructor;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.BitUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ControlFlowChecker {
    @NotNull
    private final JavaErrorVisitor myVisitor;
    private final Map<PsiElement, Collection<PsiReferenceExpression>> myUninitializedVarProblems;
    private final Map<PsiElement, Collection<ControlFlowUtil.VariableInfo>> myFinalVarProblems;

    ControlFlowChecker(@NotNull JavaErrorVisitor visitor) {
        if (visitor == null) {
            ControlFlowChecker.$$$reportNull$$$0(0);
        }
        this.myUninitializedVarProblems = new HashMap<PsiElement, Collection<PsiReferenceExpression>>();
        this.myFinalVarProblems = new HashMap<PsiElement, Collection<ControlFlowUtil.VariableInfo>>();
        this.myVisitor = visitor;
    }

    void checkMissingReturn(@NotNull PsiCodeBlock codeBlock) {
        PsiType returnType;
        PsiElement gParent;
        if (codeBlock == null) {
            ControlFlowChecker.$$$reportNull$$$0(1);
        }
        if ((gParent = codeBlock.getParent()) instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)gParent;
            returnType = method.getReturnType();
        } else if (gParent instanceof PsiLambdaExpression) {
            PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)gParent;
            returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambdaExpression);
        } else {
            return;
        }
        if (returnType == null || PsiTypes.voidType().equals((Object)returnType.getDeepComponentType())) {
            return;
        }
        PsiElement psiElement = codeBlock.getParent();
        if (!(psiElement instanceof PsiParameterListOwner)) {
            return;
        }
        PsiParameterListOwner owner = (PsiParameterListOwner)psiElement;
        try {
            ControlFlow controlFlow = ControlFlowFactory.getControlFlowNoConstantEvaluate((PsiElement)codeBlock);
            if (!ControlFlowUtil.returnPresent((ControlFlow)controlFlow)) {
                PsiJavaToken rBrace = codeBlock.getRBrace();
                PsiJavaToken context = rBrace == null ? codeBlock.getLastChild() : rBrace;
                this.myVisitor.report(JavaErrorKinds.RETURN_MISSING.create((PsiElement)context, owner));
            }
        }
        catch (AnalysisCanceledException analysisCanceledException) {
            // empty catch block
        }
    }

    void checkUnreachableStatement(@Nullable PsiCodeBlock codeBlock) {
        if (codeBlock == null) {
            return;
        }
        try {
            AllVariablesControlFlowPolicy policy = AllVariablesControlFlowPolicy.getInstance();
            ControlFlow controlFlow = ControlFlowFactory.getControlFlow((PsiElement)codeBlock, (ControlFlowPolicy)policy, (ControlFlowOptions)ControlFlowOptions.NO_CONST_EVALUATE);
            PsiElement unreachableStatement = ControlFlowUtil.getUnreachableStatement((ControlFlow)controlFlow);
            if (unreachableStatement != null) {
                PsiElement parent;
                if (unreachableStatement instanceof PsiCodeBlock && unreachableStatement.getParent() instanceof PsiBlockStatement) {
                    unreachableStatement = unreachableStatement.getParent();
                }
                if (unreachableStatement instanceof PsiStatement && ((parent = unreachableStatement.getParent()) instanceof PsiWhileStatement || parent instanceof PsiForStatement)) {
                    PsiExpression condition = ((PsiConditionalLoopStatement)parent).getCondition();
                    PsiConstantEvaluationHelper evaluator = JavaPsiFacade.getInstance((Project)this.myVisitor.project()).getConstantEvaluationHelper();
                    if (Boolean.FALSE.equals(evaluator.computeConstantExpression((PsiElement)condition))) {
                        this.myVisitor.report(JavaErrorKinds.STATEMENT_UNREACHABLE_LOOP_BODY.create(condition));
                        return;
                    }
                }
                this.myVisitor.report(JavaErrorKinds.STATEMENT_UNREACHABLE.create(unreachableStatement));
            }
        }
        catch (IndexNotReadyException | AnalysisCanceledException throwable) {
            // empty catch block
        }
    }

    void checkInitializerCompleteNormally(@NotNull PsiClassInitializer initializer) {
        if (initializer == null) {
            ControlFlowChecker.$$$reportNull$$$0(2);
        }
        PsiCodeBlock body = initializer.getBody();
        try {
            ControlFlow controlFlow = ControlFlowFactory.getControlFlowNoConstantEvaluate((PsiElement)body);
            int completionReasons = ControlFlowUtil.getCompletionReasons((ControlFlow)controlFlow, (int)0, (int)controlFlow.getSize());
            if (!BitUtil.isSet((int)completionReasons, (int)1)) {
                this.myVisitor.report(JavaErrorKinds.CLASS_INITIALIZER_MUST_COMPLETE_NORMALLY.create(body));
            }
        }
        catch (AnalysisCanceledException analysisCanceledException) {
            // empty catch block
        }
    }

    void checkVariableMustBeFinal(@NotNull PsiVariable variable, @NotNull PsiJavaCodeReferenceElement context) {
        if (variable == null) {
            ControlFlowChecker.$$$reportNull$$$0(3);
        }
        if (context == null) {
            ControlFlowChecker.$$$reportNull$$$0(4);
        }
        if (variable.hasModifierProperty("final")) {
            return;
        }
        PsiElement scope = ControlFlowUtil.getScopeEnforcingEffectiveFinality((PsiVariable)variable, (PsiElement)context);
        if (scope == null) {
            return;
        }
        if (scope instanceof PsiClass) {
            boolean isToBeEffectivelyFinal;
            if (variable instanceof PsiParameter) {
                PsiParameter parameter = (PsiParameter)variable;
                PsiElement parent = variable.getParent();
                if (parent instanceof PsiParameterList && parent.getParent() instanceof PsiLambdaExpression && ControlFlowUtil.isEffectivelyFinal((PsiVariable)variable, (PsiElement)parameter.getDeclarationScope())) {
                    return;
                }
            }
            if ((isToBeEffectivelyFinal = this.myVisitor.isApplicable(JavaFeature.EFFECTIVELY_FINAL)) && ControlFlowUtil.isEffectivelyFinal((PsiVariable)variable, (PsiElement)scope, (PsiJavaCodeReferenceElement)context)) {
                return;
            }
            JavaErrorKind.Parameterized<PsiJavaCodeReferenceElement, PsiVariable> kind = isToBeEffectivelyFinal ? JavaErrorKinds.VARIABLE_MUST_BE_EFFECTIVELY_FINAL : JavaErrorKinds.VARIABLE_MUST_BE_FINAL;
            this.myVisitor.report(kind.create(context, variable));
        } else if (scope instanceof PsiLambdaExpression) {
            if (ControlFlowUtil.isEffectivelyFinal((PsiVariable)variable, (PsiElement)scope, (PsiJavaCodeReferenceElement)context)) {
                return;
            }
            this.myVisitor.report(JavaErrorKinds.VARIABLE_MUST_BE_EFFECTIVELY_FINAL_LAMBDA.create(context, variable));
        } else if (scope instanceof PsiSwitchLabelStatementBase) {
            PsiReferenceExpression ref;
            if (context instanceof PsiReferenceExpression && PsiUtil.isAccessedForWriting((PsiExpression)(ref = (PsiReferenceExpression)context))) {
                return;
            }
            if (ControlFlowUtil.isEffectivelyFinal((PsiVariable)variable, (PsiElement)scope, (PsiJavaCodeReferenceElement)context)) {
                return;
            }
            this.myVisitor.report(JavaErrorKinds.VARIABLE_MUST_BE_EFFECTIVELY_FINAL_GUARD.create(context, variable));
        }
    }

    void checkFinalFieldInitialized(@NotNull PsiField field) {
        if (field == null) {
            ControlFlowChecker.$$$reportNull$$$0(5);
        }
        if (!field.hasModifierProperty("final")) {
            return;
        }
        if (ControlFlowUtil.isFieldInitializedAfterObjectConstruction((PsiField)field)) {
            return;
        }
        if (PsiUtilCore.hasErrorElementChild((PsiElement)field)) {
            return;
        }
        this.myVisitor.report(JavaErrorKinds.FIELD_NOT_INITIALIZED.create(field));
    }

    void checkVariableInitializedBeforeUsage(@NotNull PsiVariable variable, @NotNull PsiReferenceExpression expression) {
        if (variable == null) {
            ControlFlowChecker.$$$reportNull$$$0(6);
        }
        if (expression == null) {
            ControlFlowChecker.$$$reportNull$$$0(7);
        }
        if (ControlFlowUtil.isInitializedBeforeUsage((PsiReferenceExpression)expression, (PsiVariable)variable, this.myUninitializedVarProblems, (boolean)false)) {
            return;
        }
        this.myVisitor.report(JavaErrorKinds.VARIABLE_NOT_INITIALIZED.create(expression, variable));
    }

    void checkFinalVariableMightAlreadyHaveBeenAssignedTo(@NotNull PsiVariable variable, @NotNull PsiReferenceExpression expression) {
        JavaErrorKind.Parameterized<PsiReferenceExpression, PsiVariable> kind;
        if (variable == null) {
            ControlFlowChecker.$$$reportNull$$$0(8);
        }
        if (expression == null) {
            ControlFlowChecker.$$$reportNull$$$0(9);
        }
        ControlFlowUtil.DoubleInitializationProblem problem = ControlFlowUtil.findFinalVariableAlreadyInitializedProblem((PsiVariable)variable, (PsiReferenceExpression)expression, this.myFinalVarProblems);
        switch (problem) {
            default: {
                throw new MatchException(null, null);
            }
            case NORMAL: {
                JavaErrorKind.Parameterized<PsiReferenceExpression, PsiVariable> parameterized = JavaErrorKinds.VARIABLE_ALREADY_ASSIGNED;
                break;
            }
            case IN_LOOP: {
                JavaErrorKind.Parameterized<PsiReferenceExpression, PsiVariable> parameterized = JavaErrorKinds.VARIABLE_ASSIGNED_IN_LOOP;
                break;
            }
            case IN_CONSTRUCTOR: {
                JavaErrorKind.Parameterized<PsiReferenceExpression, PsiVariable> parameterized = JavaErrorKinds.VARIABLE_ALREADY_ASSIGNED_CONSTRUCTOR;
                break;
            }
            case IN_FIELD_INITIALIZER: {
                JavaErrorKind.Parameterized<PsiReferenceExpression, PsiVariable> parameterized = JavaErrorKinds.VARIABLE_ALREADY_ASSIGNED_FIELD;
                break;
            }
            case IN_INITIALIZER: {
                JavaErrorKind.Parameterized<PsiReferenceExpression, PsiVariable> parameterized = JavaErrorKinds.VARIABLE_ALREADY_ASSIGNED_INITIALIZER;
                break;
            }
            case NO_PROBLEM: {
                JavaErrorKind.Parameterized<PsiReferenceExpression, PsiVariable> parameterized = kind = null;
            }
        }
        if (kind == null) {
            return;
        }
        this.myVisitor.report(kind.create(expression, variable));
    }

    private static PsiField findEnclosingFieldInitializer(@NotNull PsiElement entry) {
        if (entry == null) {
            ControlFlowChecker.$$$reportNull$$$0(10);
        }
        PsiElement element = entry;
        while (element != null) {
            PsiElement parent = element.getParent();
            if (parent instanceof PsiField) {
                PsiEnumConstant enumConstant;
                PsiField field = (PsiField)parent;
                if (element == field.getInitializer()) {
                    return field;
                }
                if (field instanceof PsiEnumConstant && element == (enumConstant = (PsiEnumConstant)field).getArgumentList()) {
                    return field;
                }
            }
            if (element instanceof PsiClass || element instanceof PsiMethod) {
                return null;
            }
            element = parent;
        }
        return null;
    }

    private static boolean isSameField(@NotNull PsiMember enclosingCtrOrInitializer, @NotNull PsiField field, @NotNull PsiReferenceExpression reference, @NotNull PsiFile containingFile) {
        if (enclosingCtrOrInitializer == null) {
            ControlFlowChecker.$$$reportNull$$$0(11);
        }
        if (field == null) {
            ControlFlowChecker.$$$reportNull$$$0(12);
        }
        if (reference == null) {
            ControlFlowChecker.$$$reportNull$$$0(13);
        }
        if (containingFile == null) {
            ControlFlowChecker.$$$reportNull$$$0(14);
        }
        if (!containingFile.getManager().areElementsEquivalent((PsiElement)enclosingCtrOrInitializer.getContainingClass(), (PsiElement)field.getContainingClass())) {
            return false;
        }
        return LocalsOrMyInstanceFieldsControlFlowPolicy.isLocalOrMyInstanceReference((PsiReferenceExpression)reference);
    }

    private static boolean canWriteToFinal(@NotNull PsiVariable variable, @NotNull PsiExpression expression, @NotNull PsiReferenceExpression reference, @NotNull PsiFile containingFile) {
        if (variable == null) {
            ControlFlowChecker.$$$reportNull$$$0(15);
        }
        if (expression == null) {
            ControlFlowChecker.$$$reportNull$$$0(16);
        }
        if (reference == null) {
            ControlFlowChecker.$$$reportNull$$$0(17);
        }
        if (containingFile == null) {
            ControlFlowChecker.$$$reportNull$$$0(18);
        }
        if (variable.hasInitializer()) {
            PsiField field;
            return variable instanceof PsiField && !PsiAugmentProvider.canTrustFieldInitializer((PsiField)(field = (PsiField)variable));
        }
        if (variable instanceof PsiParameter) {
            return false;
        }
        PsiElement scope = ControlFlowUtil.getScopeEnforcingEffectiveFinality((PsiVariable)variable, (PsiElement)expression);
        if (variable instanceof PsiField) {
            PsiMethod method;
            PsiField field = (PsiField)variable;
            if (ControlFlowChecker.findEnclosingFieldInitializer((PsiElement)expression) != null) {
                return true;
            }
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null) {
                return true;
            }
            if (scope != null && !containingFile.getManager().areElementsEquivalent(scope, (PsiElement)containingClass)) {
                return false;
            }
            PsiMember enclosingCtrOrInitializer = PsiUtil.findEnclosingConstructorOrInitializer((PsiElement)expression);
            return enclosingCtrOrInitializer != null && (!(enclosingCtrOrInitializer instanceof PsiMethod) || !JavaPsiRecordUtil.isCompactConstructor((PsiMethod)(method = (PsiMethod)enclosingCtrOrInitializer)) || !containingClass.isRecord()) && ControlFlowChecker.isSameField(enclosingCtrOrInitializer, field, reference, containingFile);
        }
        if (variable instanceof PsiLocalVariable) {
            boolean isAccessedFromOtherClass = scope != null;
            return !isAccessedFromOtherClass;
        }
        return true;
    }

    private static boolean hasWriteToFinalInsideLambda(@NotNull PsiVariable variable, @NotNull PsiJavaCodeReferenceElement context) {
        if (variable == null) {
            ControlFlowChecker.$$$reportNull$$$0(19);
        }
        if (context == null) {
            ControlFlowChecker.$$$reportNull$$$0(20);
        }
        return ControlFlowChecker.hasWriteToFinalInsideLambda(variable, (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)context, PsiLambdaExpression.class), context);
    }

    @Contract(value="_, null, _ -> false")
    private static boolean hasWriteToFinalInsideLambda(@NotNull PsiVariable variable, @Nullable PsiLambdaExpression lambdaExpression, @NotNull PsiJavaCodeReferenceElement context) {
        if (variable == null) {
            ControlFlowChecker.$$$reportNull$$$0(21);
        }
        if (context == null) {
            ControlFlowChecker.$$$reportNull$$$0(22);
        }
        if (lambdaExpression == null) {
            return false;
        }
        if (!PsiTreeUtil.isAncestor((PsiElement)lambdaExpression, (PsiElement)variable, (boolean)true)) {
            PsiElement parent = variable.getParent();
            if (parent instanceof PsiParameterList && parent.getParent() == lambdaExpression) {
                return false;
            }
            PsiSwitchLabelStatementBase label = (PsiSwitchLabelStatementBase)PsiTreeUtil.getParentOfType((PsiElement)context, PsiSwitchLabelStatementBase.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class});
            if (label != null && PsiTreeUtil.isAncestor((PsiElement)label.getGuardExpression(), (PsiElement)context, (boolean)false)) {
                return false;
            }
            return !ControlFlowUtil.isEffectivelyFinal((PsiVariable)variable, (PsiElement)lambdaExpression, (PsiJavaCodeReferenceElement)context);
        }
        return false;
    }

    void checkCannotWriteToFinal(@NotNull PsiExpression expression) {
        boolean canWrite;
        if (expression == null) {
            ControlFlowChecker.$$$reportNull$$$0(23);
        }
        PsiExpression operand = null;
        if (expression instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression;
            operand = assignment.getLExpression();
        } else if (PsiUtil.isIncrementDecrementOperation((PsiElement)expression)) {
            operand = ((PsiUnaryExpression)expression).getOperand();
        }
        PsiExpression psiExpression = PsiUtil.skipParenthesizedExprDown(operand);
        if (!(psiExpression instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReferenceExpression reference = (PsiReferenceExpression)psiExpression;
        PsiElement psiElement = reference.resolve();
        if (!(psiElement instanceof PsiVariable)) {
            return;
        }
        PsiVariable variable = (PsiVariable)psiElement;
        if (!variable.hasModifierProperty("final")) {
            return;
        }
        boolean bl = canWrite = ControlFlowChecker.canWriteToFinal(variable, expression, reference, this.myVisitor.file()) && !ControlFlowChecker.hasWriteToFinalInsideLambda(variable, (PsiJavaCodeReferenceElement)reference);
        if (canWrite) {
            return;
        }
        this.myVisitor.report(JavaErrorKinds.ASSIGNMENT_TO_FINAL_VARIABLE.create(reference, variable));
    }

    @Nullable
    static ControlFlow getControlFlow(@NotNull PsiElement context) {
        if (context == null) {
            ControlFlowChecker.$$$reportNull$$$0(24);
        }
        LocalsOrMyInstanceFieldsControlFlowPolicy policy = LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance();
        try {
            return ControlFlowFactory.getControlFlow((PsiElement)context, (ControlFlowPolicy)policy, (ControlFlowOptions)ControlFlowOptions.create((boolean)true, (boolean)true, (boolean)true));
        }
        catch (AnalysisCanceledException e) {
            return null;
        }
    }

    void checkRecordComponentInitialized(@NotNull PsiRecordComponent component) {
        PsiClass aClass;
        if (component == null) {
            ControlFlowChecker.$$$reportNull$$$0(25);
        }
        if ((aClass = component.getContainingClass()) == null) {
            return;
        }
        if (component.getNameIdentifier() == null) {
            return;
        }
        PsiMethod canonicalConstructor = JavaPsiRecordUtil.findCanonicalConstructor((PsiClass)aClass);
        if (canonicalConstructor == null || canonicalConstructor instanceof LightRecordCanonicalConstructor) {
            return;
        }
        if (JavaPsiRecordUtil.isCompactConstructor((PsiMethod)canonicalConstructor)) {
            return;
        }
        PsiCodeBlock body = canonicalConstructor.getBody();
        if (body == null) {
            return;
        }
        PsiField field = JavaPsiRecordUtil.getFieldForComponent((PsiRecordComponent)component);
        if (field == null) {
            return;
        }
        ControlFlow flow = ControlFlowChecker.getControlFlow((PsiElement)body);
        if (flow == null || ControlFlowUtil.isVariableDefinitelyAssigned((PsiVariable)field, (ControlFlow)flow)) {
            return;
        }
        this.myVisitor.report(JavaErrorKinds.RECORD_COMPONENT_NOT_INITIALIZED.create(component));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeBlock";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 15: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 4: 
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 7: 
            case 9: 
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enclosingCtrOrInitializer";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        objectArray2[1] = "com/intellij/java/codeserver/highlighting/ControlFlowChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMissingReturn";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkInitializerCompleteNormally";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkVariableMustBeFinal";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFinalFieldInitialized";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "checkVariableInitializedBeforeUsage";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFinalVariableMightAlreadyHaveBeenAssignedTo";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "findEnclosingFieldInitializer";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "isSameField";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "canWriteToFinal";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "hasWriteToFinalInsideLambda";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCannotWriteToFinal";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "getControlFlow";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRecordComponentInitialized";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

