/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.highlighting;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.core.JavaPsiBundle;
import com.intellij.java.codeserver.core.JavaPsiReferenceUtil;
import com.intellij.java.codeserver.highlighting.JavaErrorVisitor;
import com.intellij.java.codeserver.highlighting.errors.JavaAmbiguousCallContext;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKind;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKinds;
import com.intellij.java.codeserver.highlighting.errors.JavaIncompatibleTypeErrorContext;
import com.intellij.java.codeserver.highlighting.errors.JavaMismatchedCallContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.pom.java.JavaFeature;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.ImplicitVariable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConditionalLoopStatement;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDeconstructionPattern;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaParameterType;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimaryPattern;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiTemplateExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiUnnamedPattern;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.impl.IncompleteModelUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ImplicitClassSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.JavaPsiPatternUtil;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.util.TypesDistinctProver;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ExpressionChecker {
    @NotNull
    private final JavaErrorVisitor myVisitor;
    private final Map<PsiElement, PsiMethod> myInsideConstructorOfClassCache;

    ExpressionChecker(@NotNull JavaErrorVisitor visitor) {
        if (visitor == null) {
            ExpressionChecker.$$$reportNull$$$0(0);
        }
        this.myInsideConstructorOfClassCache = new HashMap<PsiElement, PsiMethod>();
        this.myVisitor = visitor;
    }

    void checkQualifiedNew(@NotNull PsiNewExpression expression, @Nullable PsiType type, @Nullable PsiClass aClass) {
        PsiElement refQualifier;
        PsiAnonymousClass anonymousClass;
        PsiClass baseClass;
        PsiExpression qualifier;
        if (expression == null) {
            ExpressionChecker.$$$reportNull$$$0(1);
        }
        if ((qualifier = expression.getQualifier()) == null) {
            return;
        }
        if (type instanceof PsiArrayType) {
            this.myVisitor.report(JavaErrorKinds.NEW_EXPRESSION_QUALIFIED_MALFORMED.create(expression));
            return;
        }
        if (aClass == null) {
            return;
        }
        if (aClass.hasModifierProperty("static")) {
            this.myVisitor.report(JavaErrorKinds.NEW_EXPRESSION_QUALIFIED_STATIC_CLASS.create(expression, aClass));
            return;
        }
        if (aClass instanceof PsiAnonymousClass && (baseClass = PsiUtil.resolveClassInType((PsiType)(anonymousClass = (PsiAnonymousClass)aClass).getBaseClassType())) != null && baseClass.isInterface()) {
            this.myVisitor.report(JavaErrorKinds.NEW_EXPRESSION_QUALIFIED_ANONYMOUS_IMPLEMENTS_INTERFACE.create(expression, aClass));
            return;
        }
        PsiJavaCodeReferenceElement reference = expression.getClassOrAnonymousClassReference();
        if (reference != null && (refQualifier = reference.getQualifier()) != null) {
            this.myVisitor.report(JavaErrorKinds.NEW_EXPRESSION_QUALIFIED_QUALIFIED_CLASS_REFERENCE.create(refQualifier));
        }
    }

    void checkCreateInnerClassFromStaticContext(@NotNull PsiNewExpression expression, @NotNull PsiClass aClass) {
        PsiAnonymousClass anonymousClass;
        if (expression == null) {
            ExpressionChecker.$$$reportNull$$$0(2);
        }
        if (aClass == null) {
            ExpressionChecker.$$$reportNull$$$0(3);
        }
        if (aClass instanceof PsiAnonymousClass && (aClass = (anonymousClass = (PsiAnonymousClass)aClass).getBaseClassType().resolve()) == null) {
            return;
        }
        PsiExpression qualifier = expression.getQualifier();
        Object placeToSearchEnclosingFrom = qualifier != null ? PsiUtil.resolveClassInType((PsiType)qualifier.getType()) : expression;
        if (placeToSearchEnclosingFrom == null) {
            return;
        }
        this.checkCreateInnerClassFromStaticContext((PsiElement)expression, (PsiElement)placeToSearchEnclosingFrom, aClass);
    }

    void checkCreateInnerClassFromStaticContext(@NotNull PsiElement element, @NotNull PsiElement placeToSearchEnclosingFrom, @NotNull PsiClass aClass) {
        if (element == null) {
            ExpressionChecker.$$$reportNull$$$0(4);
        }
        if (placeToSearchEnclosingFrom == null) {
            ExpressionChecker.$$$reportNull$$$0(5);
        }
        if (aClass == null) {
            ExpressionChecker.$$$reportNull$$$0(6);
        }
        if (aClass.hasModifierProperty("static")) {
            return;
        }
        PsiClass outerClass = aClass.getContainingClass();
        if (outerClass == null) {
            if (!(aClass.getParent() instanceof PsiDeclarationStatement)) {
                return;
            }
            PsiMember scope = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiMember.class);
            if (scope == null) {
                return;
            }
            if (scope.hasModifierProperty("static")) {
                PsiModifierListOwner enclosingStaticElement = PsiUtil.getEnclosingStaticElement((PsiElement)element, null);
                assert (enclosingStaticElement != null);
                if (enclosingStaticElement != scope) {
                    this.myVisitor.report(JavaErrorKinds.INSTANTIATION_LOCAL_CLASS_WRONG_STATIC_CONTEXT.create(element, aClass));
                }
                return;
            }
            outerClass = scope.getContainingClass();
            if (outerClass == null) {
                return;
            }
        }
        if (outerClass instanceof PsiSyntheticClass || InheritanceUtil.hasEnclosingInstanceInScope((PsiClass)outerClass, (PsiElement)placeToSearchEnclosingFrom, (boolean)true, (boolean)false)) {
            return;
        }
        this.checkIllegalEnclosingUsage(placeToSearchEnclosingFrom, aClass, outerClass, element);
    }

    void checkIllegalEnclosingUsage(@NotNull PsiElement place, @Nullable PsiClass aClass, @NotNull PsiClass outerClass, @NotNull PsiElement elementToHighlight) {
        if (place == null) {
            ExpressionChecker.$$$reportNull$$$0(7);
        }
        if (outerClass == null) {
            ExpressionChecker.$$$reportNull$$$0(8);
        }
        if (elementToHighlight == null) {
            ExpressionChecker.$$$reportNull$$$0(9);
        }
        JavaErrorKinds.ClassStaticReferenceErrorContext context = new JavaErrorKinds.ClassStaticReferenceErrorContext(outerClass, aClass, place);
        if (!PsiTreeUtil.isContextAncestor((PsiElement)outerClass, (PsiElement)place, (boolean)false)) {
            this.myVisitor.report(JavaErrorKinds.CLASS_NOT_ENCLOSING.create(elementToHighlight, context));
        } else if (context.enclosingStaticElement() != null) {
            this.myVisitor.report(JavaErrorKinds.CLASS_CANNOT_BE_REFERENCED_FROM_STATIC_CONTEXT.create(elementToHighlight, context));
        }
    }

    boolean checkAssignability(@Nullable PsiType lType, @Nullable PsiType rType, @Nullable PsiExpression expression, @NotNull PsiElement elementToHighlight) {
        if (elementToHighlight == null) {
            ExpressionChecker.$$$reportNull$$$0(10);
        }
        if (lType == rType) {
            return true;
        }
        if (expression == null ? rType == null || lType == null || TypeConversionUtil.isAssignable((PsiType)lType, (PsiType)rType) : TypeConversionUtil.areTypesAssignmentCompatible((PsiType)lType, (PsiExpression)expression) || PsiTreeUtil.hasErrorElements((PsiElement)expression)) {
            return true;
        }
        if (rType == null) {
            rType = expression.getType();
        }
        if (lType == null || lType == PsiTypes.nullType()) {
            return true;
        }
        if (expression != null && this.myVisitor.isIncompleteModel() && IncompleteModelUtil.isPotentiallyConvertible((PsiType)lType, (PsiExpression)expression)) {
            return true;
        }
        return this.myVisitor.reportIncompatibleType(lType, rType, elementToHighlight);
    }

    void checkMustBeBoolean(@NotNull PsiExpression expr) {
        PsiConditionalExpression condExpr;
        PsiConditionalLoopStatement statement;
        PsiElement parent;
        if (expr == null) {
            ExpressionChecker.$$$reportNull$$$0(11);
        }
        if ((parent = expr.getParent()) instanceof PsiIfStatement || parent instanceof PsiConditionalLoopStatement && expr.equals((Object)(statement = (PsiConditionalLoopStatement)parent).getCondition()) || parent instanceof PsiConditionalExpression && (condExpr = (PsiConditionalExpression)parent).getCondition() == expr) {
            if (expr.getNextSibling() instanceof PsiErrorElement) {
                return;
            }
            PsiType type = expr.getType();
            if (!TypeConversionUtil.isBooleanType((PsiType)type) && !PsiTreeUtil.hasErrorElements((PsiElement)expr)) {
                if (type == null && this.myVisitor.isIncompleteModel() && IncompleteModelUtil.mayHaveUnknownTypeDueToPendingReference((PsiExpression)expr)) {
                    return;
                }
                this.myVisitor.reportIncompatibleType((PsiType)PsiTypes.booleanType(), type, (PsiElement)expr);
            }
        }
    }

    void checkArrayInitializer(@NotNull PsiExpression initializer, @NotNull PsiArrayInitializerExpression initializerList) {
        PsiType arrayType;
        if (initializer == null) {
            ExpressionChecker.$$$reportNull$$$0(12);
        }
        if (initializerList == null) {
            ExpressionChecker.$$$reportNull$$$0(13);
        }
        if (!((arrayType = initializerList.getType()) instanceof PsiArrayType)) {
            return;
        }
        PsiArrayType theArrayType = (PsiArrayType)arrayType;
        PsiType componentType = theArrayType.getComponentType();
        PsiType initializerType = initializer.getType();
        this.checkArrayInitializerCompatibleTypes(initializer, initializerType, componentType);
    }

    private void checkArrayInitializerCompatibleTypes(@NotNull PsiExpression initializer, @Nullable PsiType initializerType, @NotNull PsiType componentType) {
        if (initializer == null) {
            ExpressionChecker.$$$reportNull$$$0(14);
        }
        if (componentType == null) {
            ExpressionChecker.$$$reportNull$$$0(15);
        }
        if (initializerType == null) {
            if (this.myVisitor.isIncompleteModel() && IncompleteModelUtil.mayHaveUnknownTypeDueToPendingReference((PsiExpression)initializer)) {
                return;
            }
            this.myVisitor.report(JavaErrorKinds.ARRAY_ILLEGAL_INITIALIZER.create(initializer, componentType));
        } else {
            PsiExpression expression = initializer instanceof PsiArrayInitializerExpression ? null : initializer;
            this.checkAssignability(componentType, initializerType, expression, (PsiElement)initializer);
        }
    }

    void checkExpressionRequired(@NotNull PsiReferenceExpression expression, @NotNull JavaResolveResult resultForIncompleteCode) {
        if (expression == null) {
            ExpressionChecker.$$$reportNull$$$0(16);
        }
        if (resultForIncompleteCode == null) {
            ExpressionChecker.$$$reportNull$$$0(17);
        }
        if (expression.getNextSibling() instanceof PsiErrorElement) {
            return;
        }
        PsiElement resolved = resultForIncompleteCode.getElement();
        if (resolved == null || resolved instanceof PsiVariable) {
            return;
        }
        PsiElement parent = expression.getParent();
        if (parent instanceof PsiReferenceExpression || parent instanceof PsiMethodCallExpression || parent instanceof PsiBreakStatement) {
            return;
        }
        this.myVisitor.report(JavaErrorKinds.EXPRESSION_EXPECTED.create(expression));
    }

    void checkArrayInitializerApplicable(@NotNull PsiArrayInitializerExpression expression) {
        PsiElement parent;
        if (expression == null) {
            ExpressionChecker.$$$reportNull$$$0(18);
        }
        if ((parent = expression.getParent()) instanceof PsiVariable) {
            boolean isInferredType;
            PsiVariable variable = (PsiVariable)parent;
            PsiTypeElement typeElement = variable.getTypeElement();
            boolean bl = isInferredType = typeElement != null && typeElement.isInferredType();
            if (!isInferredType && variable.getType() instanceof PsiArrayType) {
                return;
            }
        } else if (parent instanceof PsiNewExpression || parent instanceof PsiArrayInitializerExpression) {
            return;
        }
        this.myVisitor.report(JavaErrorKinds.ARRAY_INITIALIZER_NOT_ALLOWED.create(expression));
    }

    void checkValidArrayAccessExpression(@NotNull PsiArrayAccessExpression arrayAccessExpression) {
        PsiExpression indexExpression;
        PsiExpression arrayExpression;
        PsiType arrayExpressionType;
        if (arrayAccessExpression == null) {
            ExpressionChecker.$$$reportNull$$$0(19);
        }
        if ((arrayExpressionType = (arrayExpression = arrayAccessExpression.getArrayExpression()).getType()) != null && !(arrayExpressionType instanceof PsiArrayType)) {
            this.myVisitor.report(JavaErrorKinds.ARRAY_TYPE_EXPECTED.create(arrayExpression, arrayExpressionType));
        }
        if ((indexExpression = arrayAccessExpression.getIndexExpression()) != null) {
            this.checkAssignability((PsiType)PsiTypes.intType(), indexExpression.getType(), indexExpression, (PsiElement)indexExpression);
        }
    }

    void checkIllegalForwardReferenceToField(@NotNull PsiReferenceExpression expression, @NotNull PsiField referencedField) {
        JavaPsiReferenceUtil.ForwardReferenceProblem problem;
        if (expression == null) {
            ExpressionChecker.$$$reportNull$$$0(20);
        }
        if (referencedField == null) {
            ExpressionChecker.$$$reportNull$$$0(21);
        }
        if ((problem = JavaPsiReferenceUtil.checkForwardReference((PsiReferenceExpression)expression, (PsiField)referencedField, (boolean)false)) == JavaPsiReferenceUtil.ForwardReferenceProblem.LEGAL) {
            return;
        }
        JavaErrorKind.Parameterized<PsiReferenceExpression, PsiField> errorKind = referencedField instanceof PsiEnumConstant ? (problem == JavaPsiReferenceUtil.ForwardReferenceProblem.ILLEGAL_FORWARD_REFERENCE ? JavaErrorKinds.REFERENCE_ENUM_FORWARD : JavaErrorKinds.REFERENCE_ENUM_SELF) : (problem == JavaPsiReferenceUtil.ForwardReferenceProblem.ILLEGAL_FORWARD_REFERENCE ? JavaErrorKinds.REFERENCE_FIELD_FORWARD : JavaErrorKinds.REFERENCE_FIELD_SELF);
        this.myVisitor.report(errorKind.create(expression, referencedField));
    }

    /*
     * Enabled aggressive block sorting
     */
    void checkMethodCall(@NotNull PsiMethodCallExpression methodCall) {
        PsiSubstitutor substitutor;
        PsiElement resolved;
        PsiReferenceExpression referenceToMethod;
        block12: {
            block14: {
                PsiMethod resolvedMethod;
                JavaResolveResult resolveResult;
                PsiExpressionList list;
                block13: {
                    PsiClass containingClass;
                    if (methodCall == null) {
                        ExpressionChecker.$$$reportNull$$$0(22);
                    }
                    list = methodCall.getArgumentList();
                    referenceToMethod = methodCall.getMethodExpression();
                    JavaResolveResult[] results = referenceToMethod.multiResolve(true);
                    resolveResult = results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
                    resolved = resolveResult.getElement();
                    substitutor = resolveResult.getSubstitutor();
                    if (!(resolved instanceof PsiMethod)) break block13;
                    PsiMethod psiMethod = (PsiMethod)resolved;
                    if (!resolveResult.isValidResult()) break block13;
                    this.checkUnhandledExceptions((PsiElement)methodCall);
                    if (this.myVisitor.hasErrorResults()) {
                        return;
                    }
                    if (psiMethod.hasModifierProperty("static") && (containingClass = psiMethod.getContainingClass()) != null && containingClass.isInterface()) {
                        PsiElement element = (PsiElement)ObjectUtils.notNull((Object)referenceToMethod.getReferenceNameElement(), (Object)referenceToMethod);
                        this.myVisitor.checkFeature(element, JavaFeature.STATIC_INTERFACE_CALLS);
                        if (this.myVisitor.hasErrorResults()) {
                            return;
                        }
                        this.checkStaticInterfaceCallQualifier((PsiJavaCodeReferenceElement)referenceToMethod, resolveResult, containingClass);
                    }
                    MethodCandidateInfo methodInfo = (MethodCandidateInfo)resolveResult;
                    this.myVisitor.myGenericsChecker.checkInferredIntersections(substitutor, methodCall);
                    if (this.myVisitor.hasErrorResults()) {
                        return;
                    }
                    this.checkVarargParameterErasureToBeAccessible(methodInfo, (PsiCall)methodCall);
                    if (this.myVisitor.hasErrorResults()) {
                        return;
                    }
                    this.checkIncompatibleType((PsiCall)methodCall, methodInfo, (PsiElement)methodCall);
                    if (this.myVisitor.hasErrorResults()) {
                        return;
                    }
                    this.checkInferredReturnTypeAccessible(methodInfo, methodCall);
                    break block12;
                }
                MethodCandidateInfo candidateInfo = resolveResult instanceof MethodCandidateInfo ? (MethodCandidateInfo)resolveResult : null;
                PsiMethod psiMethod = resolvedMethod = candidateInfo != null ? candidateInfo.getElement() : null;
                if (!resolveResult.isAccessible() || !resolveResult.isStaticsScopeCorrect()) break block12;
                if (candidateInfo == null || candidateInfo.isApplicable()) break block14;
                if (candidateInfo.isTypeArgumentsApplicable()) {
                    this.checkIncompatibleCall(list, candidateInfo);
                    break block12;
                } else {
                    PsiReferenceParameterList typeArgumentList = methodCall.getTypeArgumentList();
                    PsiSubstitutor applicabilitySubstitutor = candidateInfo.getSubstitutor(false);
                    if (typeArgumentList.getTypeArguments().length == 0 && resolvedMethod.hasTypeParameters()) {
                        this.checkInferredTypeArguments((PsiTypeParameterListOwner)resolvedMethod, methodCall, applicabilitySubstitutor);
                        break block12;
                    } else {
                        this.myVisitor.myGenericsChecker.checkParameterizedReferenceTypeArguments(resolved, (PsiJavaCodeReferenceElement)referenceToMethod, applicabilitySubstitutor);
                    }
                }
                break block12;
            }
            this.myVisitor.report(JavaErrorKinds.CALL_EXPECTED.create(methodCall));
        }
        if (!this.myVisitor.hasErrorResults()) {
            this.myVisitor.myGenericsChecker.checkParameterizedReferenceTypeArguments(resolved, (PsiJavaCodeReferenceElement)referenceToMethod, substitutor);
        }
    }

    void checkInferredTypeArguments(@NotNull PsiTypeParameterListOwner listOwner, @NotNull PsiMethodCallExpression call, @NotNull PsiSubstitutor substitutor) {
        PsiTypeParameter[] typeParameters;
        Pair inferredTypeArgument;
        if (listOwner == null) {
            ExpressionChecker.$$$reportNull$$$0(23);
        }
        if (call == null) {
            ExpressionChecker.$$$reportNull$$$0(24);
        }
        if (substitutor == null) {
            ExpressionChecker.$$$reportNull$$$0(25);
        }
        if ((inferredTypeArgument = GenericsUtil.findTypeParameterWithBoundError((PsiTypeParameter[])(typeParameters = listOwner.getTypeParameters()), (PsiSubstitutor)substitutor, (PsiElement)call, (boolean)false)) != null) {
            PsiClass psiClass;
            PsiType extendsType = (PsiType)inferredTypeArgument.second;
            PsiTypeParameter typeParameter = (PsiTypeParameter)inferredTypeArgument.first;
            if (extendsType instanceof PsiClassType) {
                PsiClassType classType = (PsiClassType)extendsType;
                psiClass = classType.resolve();
            } else {
                psiClass = null;
            }
            PsiClass boundClass = psiClass;
            JavaErrorKind.Parameterized<PsiMethodCallExpression, JavaErrorKinds.TypeParameterBoundMismatchContext> kind = boundClass == null || typeParameter.isInterface() == boundClass.isInterface() ? JavaErrorKinds.TYPE_PARAMETER_INFERRED_TYPE_NOT_WITHIN_EXTEND_BOUND : JavaErrorKinds.TYPE_PARAMETER_INFERRED_TYPE_NOT_WITHIN_IMPLEMENT_BOUND;
            this.myVisitor.report(kind.create(call, new JavaErrorKinds.TypeParameterBoundMismatchContext(typeParameter, extendsType, Objects.requireNonNull(substitutor.substitute(typeParameter)))));
        }
    }

    private void checkIncompatibleCall(@NotNull PsiExpressionList list, @NotNull MethodCandidateInfo candidateInfo) {
        if (list == null) {
            ExpressionChecker.$$$reportNull$$$0(26);
        }
        if (candidateInfo == null) {
            ExpressionChecker.$$$reportNull$$$0(27);
        }
        if (PsiTreeUtil.hasErrorElements((PsiElement)list)) {
            return;
        }
        JavaMismatchedCallContext context = JavaMismatchedCallContext.create(list, candidateInfo);
        List<PsiExpression> mismatchedExpressions = context.mismatchedExpressions();
        if (mismatchedExpressions.isEmpty() && this.myVisitor.isIncompleteModel()) {
            return;
        }
        if (mismatchedExpressions.size() == list.getExpressions().length || mismatchedExpressions.isEmpty()) {
            PsiExpressionList anchor;
            Object object = anchor = list.getTextRange().isEmpty() ? (PsiElement)ObjectUtils.notNull((Object)list.getPrevSibling(), (Object)list) : list;
            if (!mismatchedExpressions.isEmpty() && !context.argCountMismatch() && ContainerUtil.and(mismatchedExpressions, e -> e.getType() instanceof PsiLambdaParameterType)) {
                return;
            }
            this.myVisitor.report(JavaErrorKinds.CALL_WRONG_ARGUMENTS.create((PsiElement)anchor, context));
        } else {
            for (PsiExpression wrongArg : mismatchedExpressions) {
                if (wrongArg.getType() instanceof PsiLambdaParameterType) continue;
                this.myVisitor.report(JavaErrorKinds.CALL_WRONG_ARGUMENTS.create((PsiElement)wrongArg, context));
            }
        }
    }

    private void checkInferredReturnTypeAccessible(@NotNull MethodCandidateInfo info, @NotNull PsiMethodCallExpression methodCall) {
        PsiClass targetType;
        PsiTypeParameter typeParameter;
        PsiMethod method;
        PsiClass targetClass;
        if (info == null) {
            ExpressionChecker.$$$reportNull$$$0(28);
        }
        if (methodCall == null) {
            ExpressionChecker.$$$reportNull$$$0(29);
        }
        if ((targetClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)(method = info.getElement()).getReturnType())) instanceof PsiTypeParameter && (typeParameter = (PsiTypeParameter)targetClass).getOwner() == method && (targetType = PsiUtil.resolveClassInClassTypeOnly((PsiType)InferenceSession.getTargetTypeByParent((PsiElement)methodCall))) != null && !PsiUtil.isAccessible((PsiMember)targetType, (PsiElement)methodCall, null)) {
            this.myVisitor.report(JavaErrorKinds.TYPE_INACCESSIBLE.create((PsiElement)methodCall.getArgumentList(), targetType));
        }
    }

    void checkTemplateExpression(@NotNull PsiTemplateExpression templateExpression) {
        if (templateExpression == null) {
            ExpressionChecker.$$$reportNull$$$0(30);
        }
        this.myVisitor.checkFeature((PsiElement)templateExpression, JavaFeature.STRING_TEMPLATES);
        if (this.myVisitor.hasErrorResults()) {
            return;
        }
        PsiExpression processor = templateExpression.getProcessor();
        if (processor == null) {
            this.myVisitor.report(JavaErrorKinds.STRING_TEMPLATE_PROCESSOR_MISSING.create(templateExpression));
            return;
        }
        PsiType type = processor.getType();
        if (type == null) {
            return;
        }
        PsiElementFactory factory = this.myVisitor.factory();
        PsiClassType processorType = factory.createTypeByFQClassName("java.lang.StringTemplate.Processor", processor.getResolveScope());
        if (!TypeConversionUtil.isAssignable((PsiType)processorType, (PsiType)type)) {
            if (this.myVisitor.isIncompleteModel() && IncompleteModelUtil.isPotentiallyConvertible((PsiType)processorType, (PsiExpression)processor)) {
                return;
            }
            this.myVisitor.reportIncompatibleType((PsiType)processorType, type, (PsiElement)processor);
            return;
        }
        PsiClass processorClass = processorType.resolve();
        if (processorClass == null) {
            return;
        }
        for (PsiClassType classType : PsiTypesUtil.getClassTypeComponents((PsiType)type)) {
            Map substitutionMap;
            PsiSubstitutor substitutor;
            PsiClassType.ClassResolveResult resolveResult;
            PsiClass aClass;
            if (!TypeConversionUtil.isAssignable((PsiType)processorType, (PsiType)classType) || (aClass = (resolveResult = classType.resolveGenerics()).getElement()) == null || (substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)processorClass, (PsiClass)aClass, (PsiSubstitutor)resolveResult.getSubstitutor())) == null || !(substitutionMap = substitutor.getSubstitutionMap()).isEmpty() && !substitutionMap.containsValue(null)) continue;
            this.myVisitor.report(JavaErrorKinds.STRING_TEMPLATE_RAW_PROCESSOR.create(processor, type));
            return;
        }
    }

    void checkNewExpression(@NotNull PsiNewExpression expression, PsiType type) {
        if (expression == null) {
            ExpressionChecker.$$$reportNull$$$0(31);
        }
        if (!(type instanceof PsiClassType)) {
            return;
        }
        PsiClassType classType = (PsiClassType)type;
        PsiClassType.ClassResolveResult typeResult = classType.resolveGenerics();
        PsiClass aClass = typeResult.getElement();
        if (aClass instanceof PsiAnonymousClass) {
            PsiAnonymousClass anonymousClass = (PsiAnonymousClass)aClass;
            classType = anonymousClass.getBaseClassType();
            typeResult = classType.resolveGenerics();
            aClass = typeResult.getElement();
        }
        if (aClass == null || aClass instanceof PsiTypeParameter) {
            return;
        }
        PsiJavaCodeReferenceElement classReference = expression.getClassOrAnonymousClassReference();
        this.checkConstructorCall(typeResult, (PsiConstructorCall)expression, classReference);
    }

    void checkAmbiguousConstructorCall(@NotNull PsiJavaCodeReferenceElement ref, PsiElement resolved) {
        if (ref == null) {
            ExpressionChecker.$$$reportNull$$$0(32);
        }
        if (resolved instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)resolved;
            PsiElement psiElement = ref.getParent();
            if (psiElement instanceof PsiNewExpression) {
                PsiNewExpression newExpression = (PsiNewExpression)psiElement;
                if (psiClass.getConstructors().length > 0) {
                    PsiType type;
                    PsiExpressionList argumentList = newExpression.getArgumentList();
                    if (newExpression.resolveMethod() == null && !PsiTreeUtil.findChildrenOfType((PsiElement)argumentList, PsiFunctionalExpression.class).isEmpty() && (type = newExpression.getType()) instanceof PsiClassType) {
                        PsiClassType classType = (PsiClassType)type;
                        this.checkConstructorCall(classType.resolveGenerics(), (PsiConstructorCall)newExpression, newExpression.getClassReference());
                    }
                }
            }
        }
    }

    void checkConstructorCallProblems(@NotNull PsiMethodCallExpression methodCall) {
        PsiMethod contextMethod;
        if (methodCall == null) {
            ExpressionChecker.$$$reportNull$$$0(33);
        }
        if (!JavaPsiConstructorUtil.isConstructorCall((PsiElement)methodCall)) {
            return;
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
        PsiMethod psiMethod = contextMethod = method != null ? method : (PsiMethod)PsiTreeUtil.getContextOfType((PsiElement)methodCall, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
        if (contextMethod == null || !contextMethod.isConstructor()) {
            this.myVisitor.report(JavaErrorKinds.CALL_CONSTRUCTOR_ONLY_ALLOWED_IN_CONSTRUCTOR.create(methodCall));
            return;
        }
        if (JavaPsiRecordUtil.isCompactConstructor((PsiMethod)contextMethod) || JavaPsiRecordUtil.isExplicitCanonicalConstructor((PsiMethod)contextMethod)) {
            this.myVisitor.report(JavaErrorKinds.CALL_CONSTRUCTOR_RECORD_IN_CANONICAL.create(methodCall));
            return;
        }
        if (method == null) {
            return;
        }
        PsiMethodCallExpression constructorCall = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)method);
        if (constructorCall != methodCall) {
            this.myVisitor.report(JavaErrorKinds.CALL_CONSTRUCTOR_DUPLICATE.create(methodCall));
            return;
        }
        PsiElement codeBlock = methodCall.getParent().getParent();
        if (!(codeBlock instanceof PsiCodeBlock) || !(codeBlock.getParent() instanceof PsiMethod)) {
            this.myVisitor.report(JavaErrorKinds.CALL_CONSTRUCTOR_MUST_BE_TOP_LEVEL_STATEMENT.create(methodCall));
            return;
        }
        PsiStatement prevStatement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)methodCall.getParent(), PsiStatement.class);
        if (prevStatement != null && !this.myVisitor.isApplicable(JavaFeature.STATEMENTS_BEFORE_SUPER)) {
            this.myVisitor.report(JavaErrorKinds.CALL_CONSTRUCTOR_MUST_BE_FIRST_STATEMENT.create(methodCall));
            return;
        }
        if (JavaPsiConstructorUtil.isChainedConstructorCall((PsiElement)methodCall) && JavaPsiConstructorUtil.isRecursivelyCalledConstructor((PsiMethod)method)) {
            this.myVisitor.report(JavaErrorKinds.CALL_CONSTRUCTOR_RECURSIVE.create(methodCall));
        }
    }

    void checkSuperAbstractMethodDirectCall(@NotNull PsiMethodCallExpression methodCallExpression) {
        PsiReferenceExpression expression;
        if (methodCallExpression == null) {
            ExpressionChecker.$$$reportNull$$$0(34);
        }
        if (!((expression = methodCallExpression.getMethodExpression()).getQualifierExpression() instanceof PsiSuperExpression)) {
            return;
        }
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method != null && method.hasModifierProperty("abstract")) {
            this.myVisitor.report(JavaErrorKinds.CALL_DIRECT_ABSTRACT_METHOD_ACCESS.create(methodCallExpression, method));
        }
    }

    @Nullable
    private PsiClass checkQualifier(@NotNull PsiQualifiedExpression expr) {
        PsiJavaCodeReferenceElement qualifier;
        if (expr == null) {
            ExpressionChecker.$$$reportNull$$$0(35);
        }
        if ((qualifier = expr.getQualifier()) != null) {
            PsiElement resolved = qualifier.advancedResolve(true).getElement();
            if (resolved instanceof PsiClass) {
                PsiClass cls = (PsiClass)resolved;
                return cls;
            }
            if (resolved != null) {
                this.myVisitor.report(JavaErrorKinds.EXPRESSION_QUALIFIED_CLASS_EXPECTED.create(qualifier));
            }
            return null;
        }
        return PsiUtil.getContainingClass((PsiElement)expr);
    }

    void checkThisExpressionInIllegalContext(@NotNull PsiThisExpression expr) {
        PsiClass aClass;
        if (expr == null) {
            ExpressionChecker.$$$reportNull$$$0(36);
        }
        if ((aClass = this.checkQualifier((PsiQualifiedExpression)expr)) == null) {
            return;
        }
        if (!InheritanceUtil.hasEnclosingInstanceInScope((PsiClass)aClass, (PsiElement)expr, (boolean)false, (boolean)false)) {
            this.checkIllegalEnclosingUsage((PsiElement)expr, null, aClass, (PsiElement)expr);
        }
    }

    void checkSuperExpressionInIllegalContext(@NotNull PsiSuperExpression expr) {
        PsiClass classT;
        PsiElement resolved;
        boolean extensionQualifier;
        if (expr == null) {
            ExpressionChecker.$$$reportNull$$$0(37);
        }
        PsiJavaCodeReferenceElement qualifier = expr.getQualifier();
        PsiElement parent = expr.getParent();
        if (!(parent instanceof PsiReferenceExpression)) {
            this.myVisitor.report(JavaErrorKinds.EXPRESSION_SUPER_DOT_EXPECTED.create(expr));
            return;
        }
        PsiReferenceExpression ref = (PsiReferenceExpression)parent;
        PsiClass aClass = this.checkQualifier((PsiQualifiedExpression)expr);
        if (aClass == null) {
            return;
        }
        boolean bl = extensionQualifier = qualifier != null && this.myVisitor.isApplicable(JavaFeature.EXTENSION_METHODS);
        if (!InheritanceUtil.hasEnclosingInstanceInScope((PsiClass)aClass, (PsiElement)expr, (boolean)false, (boolean)false)) {
            boolean resolvesToImmediateSuperInterface;
            boolean bl2 = resolvesToImmediateSuperInterface = extensionQualifier && aClass.equals((Object)PsiUtil.resolveClassInClassTypeOnly((PsiType)expr.getType())) && PsiUtil.getEnclosingStaticElement((PsiElement)expr, (PsiClass)PsiUtil.getContainingClass((PsiElement)expr)) == null;
            if (!resolvesToImmediateSuperInterface) {
                this.checkIllegalEnclosingUsage((PsiElement)expr, null, aClass, (PsiElement)expr);
                if (this.myVisitor.hasErrorResults()) {
                    return;
                }
            }
            if ((resolved = ref.resolve()) instanceof PsiField) {
                this.myVisitor.report(JavaErrorKinds.EXPRESSION_SUPER_NOT_ENCLOSING_CLASS.create(expr, aClass));
            }
        }
        if (extensionQualifier && aClass.isInterface() && (classT = PsiUtil.getContainingClass((PsiElement)expr)) != null) {
            PsiClass psiClass;
            resolved = ref.resolve();
            if (resolved instanceof PsiMethod) {
                PsiMethod psiMethod = (PsiMethod)resolved;
                psiClass = psiMethod.getContainingClass();
            } else {
                psiClass = null;
            }
            PsiClass containingClass = (PsiClass)ObjectUtils.notNull(psiClass, (Object)aClass);
            for (PsiClass superClass : classT.getSupers()) {
                PsiMethod psiMethod;
                if (!superClass.isInheritor(containingClass, true)) continue;
                if (superClass.isInheritor(aClass, true)) {
                    this.myVisitor.report(JavaErrorKinds.EXPRESSION_SUPER_BAD_QUALIFIER_REDUNDANT_EXTENDED.create(qualifier, new JavaErrorKinds.SuperclassSubclassContext(superClass, containingClass)));
                    return;
                }
                if (!(resolved instanceof PsiMethod) || MethodSignatureUtil.findMethodBySuperMethod((PsiClass)superClass, (PsiMethod)(psiMethod = (PsiMethod)resolved), (boolean)true) == resolved) continue;
                this.myVisitor.report(JavaErrorKinds.EXPRESSION_SUPER_BAD_QUALIFIER_METHOD_OVERRIDDEN.create(expr, superClass));
                return;
            }
            if (!classT.isInheritor(aClass, false)) {
                this.myVisitor.report(JavaErrorKinds.EXPRESSION_SUPER_NO_ENCLOSING_INSTANCE.create(qualifier, aClass));
            }
        }
    }

    void checkAssignmentCompatibleTypes(@NotNull PsiAssignmentExpression assignment) {
        if (assignment == null) {
            ExpressionChecker.$$$reportNull$$$0(38);
        }
        PsiExpression lExpr = assignment.getLExpression();
        PsiExpression rExpr = assignment.getRExpression();
        if (rExpr == null) {
            return;
        }
        PsiType lType = lExpr.getType();
        PsiType rType = rExpr.getType();
        if (rType == null) {
            return;
        }
        IElementType sign = assignment.getOperationTokenType();
        if (JavaTokenType.EQ.equals(sign)) {
            this.checkAssignability(lType, rType, rExpr, (PsiElement)rExpr);
        } else {
            IElementType opSign = TypeConversionUtil.convertEQtoOperation((IElementType)sign);
            PsiType type = TypeConversionUtil.calcTypeForBinaryExpression((PsiType)lType, (PsiType)rType, (IElementType)opSign, (boolean)true);
            if (type == null || lType == null || lType instanceof PsiLambdaParameterType || type instanceof PsiLambdaParameterType || TypeConversionUtil.areTypesConvertible((PsiType)type, (PsiType)lType)) {
                return;
            }
            if (this.myVisitor.isIncompleteModel() && IncompleteModelUtil.isPotentiallyConvertible((PsiType)lType, (PsiExpression)rExpr)) {
                return;
            }
            this.myVisitor.reportIncompatibleType(lType, type, (PsiElement)rExpr);
        }
    }

    void checkAssignmentOperatorApplicable(@NotNull PsiAssignmentExpression assignment) {
        PsiJavaToken operationSign;
        IElementType eqOpSign;
        IElementType opSign;
        if (assignment == null) {
            ExpressionChecker.$$$reportNull$$$0(39);
        }
        if ((opSign = TypeConversionUtil.convertEQtoOperation((IElementType)(eqOpSign = (operationSign = assignment.getOperationSign()).getTokenType()))) == null) {
            return;
        }
        PsiType lType = assignment.getLExpression().getType();
        PsiExpression rExpression = assignment.getRExpression();
        if (rExpression == null) {
            return;
        }
        PsiType rType = rExpression.getType();
        if (!TypeConversionUtil.isBinaryOperatorApplicable((IElementType)opSign, (PsiType)lType, (PsiType)rType, (boolean)true)) {
            if (lType instanceof PsiLambdaParameterType || rType instanceof PsiLambdaParameterType) {
                return;
            }
            this.myVisitor.report(JavaErrorKinds.BINARY_OPERATOR_NOT_APPLICABLE.create(operationSign, new JavaIncompatibleTypeErrorContext(lType, rType)));
        }
    }

    void checkUnaryOperatorApplicable(@NotNull PsiUnaryExpression unary) {
        if (unary == null) {
            ExpressionChecker.$$$reportNull$$$0(40);
        }
        PsiJavaToken token = unary.getOperationSign();
        PsiExpression operand = unary.getOperand();
        if (operand != null && !TypeConversionUtil.isUnaryOperatorApplicable((PsiJavaToken)token, (PsiExpression)operand)) {
            PsiType type = operand.getType();
            if (type == null || type instanceof PsiLambdaParameterType) {
                return;
            }
            this.myVisitor.report(JavaErrorKinds.UNARY_OPERATOR_NOT_APPLICABLE.create(unary, type));
        }
    }

    void checkPolyadicOperatorApplicable(@NotNull PsiPolyadicExpression expression) {
        if (expression == null) {
            ExpressionChecker.$$$reportNull$$$0(41);
        }
        PsiExpression[] operands = expression.getOperands();
        PsiType lType = operands[0].getType();
        IElementType operationSign = expression.getOperationTokenType();
        for (int i = 1; i < operands.length; ++i) {
            PsiExpression operand = operands[i];
            PsiType rType = operand.getType();
            if (lType instanceof PsiLambdaParameterType || rType instanceof PsiLambdaParameterType) {
                return;
            }
            if (!(TypeConversionUtil.isBinaryOperatorApplicable((IElementType)operationSign, (PsiType)lType, (PsiType)rType, (boolean)false) || this.myVisitor.isIncompleteModel() && IncompleteModelUtil.isPotentiallyConvertible((PsiType)lType, (PsiType)rType, (PsiElement)expression))) {
                PsiJavaToken token = expression.getTokenBeforeOperand(operand);
                assert (token != null) : expression;
                this.myVisitor.report(JavaErrorKinds.BINARY_OPERATOR_NOT_APPLICABLE.create(token, new JavaIncompatibleTypeErrorContext(lType, rType)));
                return;
            }
            lType = TypeConversionUtil.calcTypeForBinaryExpression((PsiType)lType, (PsiType)rType, (IElementType)operationSign, (boolean)true);
        }
    }

    void checkOutsideDeclaredCantBeAssignmentInGuard(@Nullable PsiExpression expressionVariable) {
        PsiReferenceExpression referenceExpression;
        PsiElement psiElement;
        if (expressionVariable == null) {
            return;
        }
        if (!PsiUtil.isAccessedForWriting((PsiExpression)expressionVariable)) {
            return;
        }
        PsiSwitchLabelStatementBase label = (PsiSwitchLabelStatementBase)PsiTreeUtil.getParentOfType((PsiElement)expressionVariable, PsiSwitchLabelStatementBase.class);
        if (label == null) {
            return;
        }
        PsiExpression guardingExpression = label.getGuardExpression();
        if (!PsiTreeUtil.isAncestor((PsiElement)guardingExpression, (PsiElement)expressionVariable, (boolean)false)) {
            return;
        }
        if (!(expressionVariable instanceof PsiReferenceExpression) || !((psiElement = (referenceExpression = (PsiReferenceExpression)expressionVariable).resolve()) instanceof PsiVariable)) {
            return;
        }
        PsiVariable psiVariable = (PsiVariable)psiElement;
        if (PsiTreeUtil.isAncestor((PsiElement)guardingExpression, (PsiElement)psiVariable, (boolean)false)) {
            return;
        }
        this.myVisitor.report(JavaErrorKinds.ASSIGNMENT_DECLARED_OUTSIDE_GUARD.create(expressionVariable, psiVariable));
    }

    void checkUnqualifiedSuperInDefaultMethod(@NotNull PsiReferenceExpression expr, @Nullable PsiExpression qualifier) {
        if (expr == null) {
            ExpressionChecker.$$$reportNull$$$0(42);
        }
        if (this.myVisitor.isApplicable(JavaFeature.EXTENSION_METHODS) && qualifier instanceof PsiSuperExpression) {
            PsiSuperExpression superExpression = (PsiSuperExpression)qualifier;
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expr, PsiMethod.class);
            if (method != null && method.hasModifierProperty("default") && superExpression.getQualifier() == null) {
                this.myVisitor.report(JavaErrorKinds.EXPRESSION_SUPER_UNQUALIFIED_DEFAULT_METHOD.create(expr, superExpression));
            }
        }
    }

    void checkUnderscore(@NotNull PsiIdentifier identifier) {
        if (identifier == null) {
            ExpressionChecker.$$$reportNull$$$0(43);
        }
        if ("_".equals(identifier.getText())) {
            PsiParameter parameter;
            PsiVariable var;
            PsiElement parent = identifier.getParent();
            LanguageLevel languageLevel = this.myVisitor.languageLevel();
            if (!(!languageLevel.isAtLeast(LanguageLevel.JDK_1_9) || parent instanceof PsiUnnamedPattern || parent instanceof PsiVariable && (var = (PsiVariable)parent).isUnnamed())) {
                JavaErrorKind.Simple<PsiIdentifier> text = this.myVisitor.isApplicable(JavaFeature.UNNAMED_PATTERNS_AND_VARIABLES) ? JavaErrorKinds.UNDERSCORE_IDENTIFIER_UNNAMED : JavaErrorKinds.UNDERSCORE_IDENTIFIER;
                this.myVisitor.report(text.create(identifier));
            } else if (this.myVisitor.isApplicable(JavaFeature.LAMBDA_EXPRESSIONS) && parent instanceof PsiParameter && (parameter = (PsiParameter)parent).getDeclarationScope() instanceof PsiLambdaExpression && !parameter.isUnnamed()) {
                this.myVisitor.report(JavaErrorKinds.UNDERSCORE_IDENTIFIER_LAMBDA.create(identifier));
            }
        }
    }

    void checkUnhandledCloserExceptions(@NotNull PsiResourceListElement resource) {
        List unhandled;
        if (resource == null) {
            ExpressionChecker.$$$reportNull$$$0(44);
        }
        if ((unhandled = ExceptionUtil.getUnhandledCloserExceptions((PsiResourceListElement)resource, null)).isEmpty()) {
            return;
        }
        if (!ExpressionChecker.shouldHighlightUnhandledException((PsiElement)resource)) {
            return;
        }
        this.myVisitor.report(JavaErrorKinds.EXCEPTION_UNHANDLED_CLOSE.create(resource, unhandled));
    }

    void checkVarTypeSelfReferencing(@NotNull PsiLocalVariable variable, @NotNull PsiReferenceExpression ref) {
        if (variable == null) {
            ExpressionChecker.$$$reportNull$$$0(45);
        }
        if (ref == null) {
            ExpressionChecker.$$$reportNull$$$0(46);
        }
        if (PsiTreeUtil.isAncestor((PsiElement)variable.getInitializer(), (PsiElement)ref, (boolean)false) && variable.getTypeElement().isInferredType()) {
            this.myVisitor.report(JavaErrorKinds.LVTI_SELF_REFERENCED.create(ref, variable));
        }
    }

    void checkVariableExpected(@NotNull PsiExpression expression) {
        PsiReferenceExpression ref;
        PsiExpression psiExpression;
        PsiExpression lValue;
        if (expression == null) {
            ExpressionChecker.$$$reportNull$$$0(47);
        }
        if (expression instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression;
            lValue = assignment.getLExpression();
        } else {
            lValue = PsiUtil.isIncrementDecrementOperation((PsiElement)expression) ? ((PsiUnaryExpression)expression).getOperand() : null;
        }
        if (!(lValue == null || TypeConversionUtil.isLValue((PsiExpression)lValue) || PsiTreeUtil.hasErrorElements((PsiElement)expression) || this.myVisitor.isIncompleteModel() && (psiExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)lValue)) instanceof PsiReferenceExpression && IncompleteModelUtil.canBePendingReference((PsiJavaCodeReferenceElement)(ref = (PsiReferenceExpression)psiExpression)))) {
            this.myVisitor.report(JavaErrorKinds.LVALUE_VARIABLE_EXPECTED.create(lValue));
        }
    }

    void checkInconvertibleTypeCast(@NotNull PsiTypeCastExpression expression) {
        PsiTypeElement castTypeElement;
        if (expression == null) {
            ExpressionChecker.$$$reportNull$$$0(48);
        }
        if ((castTypeElement = expression.getCastType()) == null) {
            return;
        }
        PsiType castType = castTypeElement.getType();
        PsiExpression operand = expression.getOperand();
        if (operand == null) {
            return;
        }
        PsiType operandType = operand.getType();
        if (operandType != null && !TypeConversionUtil.areTypesConvertible((PsiType)operandType, (PsiType)castType, (LanguageLevel)PsiUtil.getLanguageLevel((PsiElement)expression)) && !PsiUtil.isInSignaturePolymorphicCall((PsiTypeCastExpression)expression)) {
            if (this.myVisitor.isIncompleteModel() && IncompleteModelUtil.isPotentiallyConvertible((PsiType)castType, (PsiExpression)operand)) {
                return;
            }
            this.myVisitor.report(JavaErrorKinds.CAST_INCONVERTIBLE.create((PsiElement)expression, new JavaIncompatibleTypeErrorContext(operandType, castType)));
        }
    }

    void checkIntersectionInTypeCast(@NotNull PsiTypeCastExpression expression) {
        PsiTypeElement castTypeElement;
        if (expression == null) {
            ExpressionChecker.$$$reportNull$$$0(49);
        }
        if ((castTypeElement = expression.getCastType()) == null || !ExpressionChecker.isIntersection(castTypeElement, castTypeElement.getType())) {
            return;
        }
        this.myVisitor.checkFeature((PsiElement)expression, JavaFeature.INTERSECTION_CASTS);
        if (this.myVisitor.hasErrorResults()) {
            return;
        }
        PsiTypeElement[] conjuncts = (PsiTypeElement[])PsiTreeUtil.getChildrenOfType((PsiElement)castTypeElement, PsiTypeElement.class);
        if (conjuncts != null) {
            HashSet<PsiType> erasures = new HashSet<PsiType>(conjuncts.length);
            erasures.add(TypeConversionUtil.erasure((PsiType)conjuncts[0].getType()));
            ArrayList<PsiTypeElement> conjList = new ArrayList<PsiTypeElement>(Arrays.asList(conjuncts));
            for (int i = 1; i < conjuncts.length; ++i) {
                PsiTypeElement conjunct = conjuncts[i];
                PsiType conjType = conjunct.getType();
                if (conjType instanceof PsiClassType) {
                    PsiClassType classType = (PsiClassType)conjType;
                    PsiClass aClass = classType.resolve();
                    if (aClass != null && !aClass.isInterface()) {
                        this.myVisitor.report(JavaErrorKinds.CAST_INTERSECTION_NOT_INTERFACE.create(conjunct));
                        continue;
                    }
                } else {
                    this.myVisitor.report(JavaErrorKinds.CAST_INTERSECTION_UNEXPECTED_TYPE.create(conjunct));
                    continue;
                }
                if (erasures.add(TypeConversionUtil.erasure((PsiType)conjType))) continue;
                this.myVisitor.report(JavaErrorKinds.CAST_INTERSECTION_REPEATED_INTERFACE.create(conjunct));
            }
            if (this.myVisitor.hasErrorResults()) {
                return;
            }
            List typeList = ContainerUtil.map(conjList, PsiTypeElement::getType);
            Ref differentArguments = new Ref();
            PsiClass sameGenericParameterization = InferenceSession.findParameterizationOfTheSameGenericClass((List)typeList, pair -> {
                if (!TypesDistinctProver.provablyDistinct((PsiType)((PsiType)pair.first), (PsiType)((PsiType)pair.second))) {
                    return true;
                }
                differentArguments.set(pair);
                return false;
            });
            if (differentArguments.get() != null && sameGenericParameterization != null) {
                JavaErrorKinds.InheritTypeClashContext context = new JavaErrorKinds.InheritTypeClashContext(sameGenericParameterization, (PsiType)((Pair)differentArguments.get()).getFirst(), (PsiType)((Pair)differentArguments.get()).getSecond());
                this.myVisitor.report(JavaErrorKinds.CAST_INTERSECTION_INHERITANCE_CLASH.create(expression, context));
            }
        }
    }

    void checkResourceVariableIsFinal(@NotNull PsiResourceExpression resource) {
        PsiExpression expression;
        if (resource == null) {
            ExpressionChecker.$$$reportNull$$$0(50);
        }
        if ((expression = resource.getExpression()) instanceof PsiThisExpression) {
            return;
        }
        if (expression instanceof PsiReferenceExpression) {
            PsiReferenceExpression ref = (PsiReferenceExpression)expression;
            PsiElement target = ref.resolve();
            if (target == null) {
                return;
            }
            if (target instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)target;
                PsiModifierList modifierList = variable.getModifierList();
                if (modifierList != null && modifierList.hasModifierProperty("final")) {
                    return;
                }
                if (!(variable instanceof PsiField) && ControlFlowUtil.isEffectivelyFinal((PsiVariable)variable, (PsiElement)resource)) {
                    return;
                }
            }
            this.myVisitor.report(JavaErrorKinds.VARIABLE_MUST_BE_FINAL_RESOURCE.create(ref));
            return;
        }
        this.myVisitor.report(JavaErrorKinds.RESOURCE_DECLARATION_OR_VARIABLE_EXPECTED.create(expression));
    }

    void checkClassReferenceAfterQualifier(@NotNull PsiReferenceExpression expression, @Nullable PsiElement resolved) {
        if (expression == null) {
            ExpressionChecker.$$$reportNull$$$0(51);
        }
        if (!(resolved instanceof PsiClass)) {
            return;
        }
        PsiClass psiClass = (PsiClass)resolved;
        PsiExpression qualifier = expression.getQualifierExpression();
        if (qualifier == null) {
            return;
        }
        if (qualifier instanceof PsiReferenceExpression) {
            PsiReferenceExpression qExpression = (PsiReferenceExpression)qualifier;
            PsiElement qualifierResolved = qExpression.resolve();
            if (qualifierResolved instanceof PsiClass || qualifierResolved instanceof PsiPackage) {
                return;
            }
            if (qualifierResolved == null) {
                PsiElement qResolve;
                while ((qResolve = qExpression.resolve()) == null || qResolve instanceof PsiClass || qResolve instanceof PsiPackage) {
                    PsiReferenceExpression ref;
                    PsiExpression qualifierExpression = qExpression.getQualifierExpression();
                    if (qualifierExpression == null) {
                        return;
                    }
                    if (!(qualifierExpression instanceof PsiReferenceExpression)) break;
                    qExpression = ref = (PsiReferenceExpression)qualifierExpression;
                }
            }
        }
        this.myVisitor.report(JavaErrorKinds.CLASS_OR_PACKAGE_EXPECTED.create(expression, psiClass));
    }

    private static boolean isIntersection(@NotNull PsiTypeElement castTypeElement, @NotNull PsiType castType) {
        if (castTypeElement == null) {
            ExpressionChecker.$$$reportNull$$$0(52);
        }
        if (castType == null) {
            ExpressionChecker.$$$reportNull$$$0(53);
        }
        if (castType instanceof PsiIntersectionType) {
            return true;
        }
        return castType instanceof PsiClassType && PsiTreeUtil.getChildrenOfType((PsiElement)castTypeElement, PsiTypeElement.class) != null;
    }

    static boolean isArrayDeclaration(@NotNull PsiVariable variable) {
        if (variable == null) {
            ExpressionChecker.$$$reportNull$$$0(54);
        }
        return ContainerUtil.or((Object[])variable.getChildren(), e -> PsiUtil.isJavaToken((PsiElement)e, (IElementType)JavaTokenType.LBRACKET));
    }

    void checkUnnamedVariableDeclaration(@NotNull PsiVariable variable) {
        if (variable == null) {
            ExpressionChecker.$$$reportNull$$$0(55);
        }
        if (ExpressionChecker.isArrayDeclaration(variable)) {
            this.myVisitor.report(JavaErrorKinds.UNNAMED_VARIABLE_BRACKETS.create(variable));
            return;
        }
        if (variable instanceof PsiPatternVariable) {
            return;
        }
        if (variable instanceof PsiResourceVariable) {
            return;
        }
        if (variable instanceof PsiLocalVariable) {
            PsiLocalVariable local = (PsiLocalVariable)variable;
            if (local.getInitializer() == null) {
                this.myVisitor.report(JavaErrorKinds.UNNAMED_VARIABLE_WITHOUT_INITIALIZER.create(local));
            }
        } else if (variable instanceof PsiParameter) {
            PsiParameter parameter = (PsiParameter)variable;
            if (parameter.getDeclarationScope() instanceof PsiMethod) {
                this.myVisitor.report(JavaErrorKinds.UNNAMED_METHOD_PARAMETER_NOT_ALLOWED.create(parameter));
            }
        } else if (variable instanceof PsiField) {
            PsiField field = (PsiField)variable;
            this.myVisitor.report(JavaErrorKinds.UNNAMED_FIELD_NOT_ALLOWED.create(field));
        } else {
            this.myVisitor.report(JavaErrorKinds.UNNAMED_VARIABLE_NOT_ALLOWED_IN_THIS_CONTEXT.create(variable));
        }
    }

    @NotNull
    private static PsiJavaCodeReferenceElement getOuterReferenceParent(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiElement parent;
        if (ref == null) {
            ExpressionChecker.$$$reportNull$$$0(56);
        }
        PsiJavaCodeReferenceElement element = ref;
        while ((parent = element.getParent()) instanceof PsiJavaCodeReferenceElement) {
            element = (PsiJavaCodeReferenceElement)parent;
        }
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = element;
        if (psiJavaCodeReferenceElement == null) {
            ExpressionChecker.$$$reportNull$$$0(57);
        }
        return psiJavaCodeReferenceElement;
    }

    void checkReference(@NotNull PsiJavaCodeReferenceElement ref, @NotNull JavaResolveResult result) {
        PsiModifierListOwner owner;
        boolean skipValidityChecks;
        PsiClass psiClass;
        PsiElement psiElement;
        PsiElement refName;
        if (ref == null) {
            ExpressionChecker.$$$reportNull$$$0(58);
        }
        if (result == null) {
            ExpressionChecker.$$$reportNull$$$0(59);
        }
        if (!((refName = ref.getReferenceNameElement()) instanceof PsiIdentifier) && !(refName instanceof PsiKeyword)) {
            return;
        }
        PsiElement resolved = result.getElement();
        PsiElement refParent = ref.getParent();
        if (refParent instanceof PsiReferenceExpression && (psiElement = refParent.getParent()) instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression granny = (PsiMethodCallExpression)psiElement;
            PsiReferenceExpression referenceToMethod = granny.getMethodExpression();
            PsiExpression qualifierExpression = referenceToMethod.getQualifierExpression();
            if (qualifierExpression == ref && resolved != null && !(resolved instanceof PsiClass) && !(resolved instanceof PsiVariable)) {
                this.myVisitor.report(JavaErrorKinds.REFERENCE_QUALIFIER_NOT_EXPRESSION.create(qualifierExpression));
                return;
            }
        } else if (refParent instanceof PsiMethodCallExpression) {
            return;
        }
        if (resolved == null) {
            this.checkUnresolvedReference(ref, result);
            return;
        }
        if (resolved instanceof PsiClass && (psiClass = (PsiClass)resolved).getContainingClass() == null && PsiUtil.isFromDefaultPackage((PsiElement)resolved) && (PsiTreeUtil.getParentOfType((PsiElement)ref, PsiImportStatementBase.class) != null || PsiUtil.isModuleFile((PsiFile)this.myVisitor.file()) || !PsiUtil.isFromDefaultPackage((PsiElement)this.myVisitor.file()))) {
            this.myVisitor.report(JavaErrorKinds.REFERENCE_CLASS_IN_DEFAULT_PACKAGE.create(ref, psiClass));
        }
        if ((resolved instanceof PsiLocalVariable || resolved instanceof PsiParameter) && !(resolved instanceof ImplicitVariable)) {
            this.myVisitor.myControlFlowChecker.checkVariableMustBeFinal((PsiVariable)resolved, ref);
        }
        boolean bl = skipValidityChecks = PsiUtil.isInsideJavadocComment((PsiElement)ref) || PsiTreeUtil.getParentOfType((PsiElement)ref, PsiPackageStatement.class, (boolean)true) != null || resolved instanceof PsiPackage && ref.getParent() instanceof PsiJavaCodeReferenceElement;
        if (skipValidityChecks) {
            return;
        }
        if (!result.isAccessible() && resolved instanceof PsiModifierListOwner) {
            owner = (PsiModifierListOwner)resolved;
            this.myVisitor.myModifierChecker.reportAccessProblem((PsiElement)ref, owner, result);
            return;
        }
        if (!result.isStaticsScopeCorrect()) {
            this.myVisitor.report(JavaErrorKinds.REFERENCE_NON_STATIC_FROM_STATIC_CONTEXT.create(ref, resolved));
        }
        if (resolved instanceof PsiModifierListOwner) {
            owner = (PsiModifierListOwner)resolved;
            this.myVisitor.myModuleChecker.checkModuleAccess(owner, (PsiElement)ref);
        }
    }

    private void checkUnresolvedReference(@NotNull PsiJavaCodeReferenceElement ref, @NotNull JavaResolveResult result) {
        JavaResolveResult[] results;
        PsiJavaCodeReferenceElement parent;
        PsiElement outerParent;
        if (ref == null) {
            ExpressionChecker.$$$reportNull$$$0(60);
        }
        if (result == null) {
            ExpressionChecker.$$$reportNull$$$0(61);
        }
        if ((outerParent = (parent = ExpressionChecker.getOuterReferenceParent(ref)).getParent()) instanceof PsiPackageStatement || result.isPackagePrefixPackageReference() || PsiUtil.isInsideJavadocComment((PsiElement)ref) || parent.resolve() instanceof PsiMember || outerParent instanceof PsiPackageAccessibilityStatement) {
            return;
        }
        if ("module".equals(ref.getText()) && ref.getParent() instanceof PsiImportStatement && PsiUtil.isAvailable((JavaFeature)JavaFeature.MODULE_IMPORT_DECLARATIONS, (PsiElement)ref)) {
            PsiKeyword keyword;
            PsiElement importKeywordExpected = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)ref);
            PsiElement errorElementExpected = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)ref);
            if (importKeywordExpected instanceof PsiKeyword && (keyword = (PsiKeyword)importKeywordExpected).textMatches((CharSequence)"import") && errorElementExpected instanceof PsiErrorElement) {
                PsiErrorElement errorElement = (PsiErrorElement)errorElementExpected;
                if (JavaPsiBundle.message((String)"expected.identifier.or.semicolon", (Object[])new Object[0]).equals(errorElement.getErrorDescription())) {
                    return;
                }
            }
        }
        if ((results = ref.multiResolve(true)).length > 1) {
            if (ref instanceof PsiMethodReferenceExpression) {
                PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)ref;
                if (this.myVisitor.isIncompleteModel() && IncompleteModelUtil.isUnresolvedClassType((PsiType)methodRef.getFunctionalInterfaceType())) {
                    return;
                }
            }
            this.myVisitor.report(JavaErrorKinds.REFERENCE_AMBIGUOUS.create(ref, Arrays.asList(results)));
        } else {
            boolean definitelyIncorrect = false;
            if (ref instanceof PsiReferenceExpression) {
                PsiPrimitiveType primitiveType;
                PsiType type;
                PsiReferenceExpression expression = (PsiReferenceExpression)ref;
                PsiExpression qualifierExpression = expression.getQualifierExpression();
                if (qualifierExpression != null && (type = qualifierExpression.getType()) instanceof PsiPrimitiveType && !(primitiveType = (PsiPrimitiveType)type).equals((Object)PsiTypes.nullType())) {
                    this.myVisitor.report(JavaErrorKinds.REFERENCE_QUALIFIER_PRIMITIVE.create(ref, primitiveType));
                    return;
                }
            } else if (ImplicitClassSearch.search((String)ref.getQualifiedName(), (Project)this.myVisitor.project(), (GlobalSearchScope)ref.getResolveScope()).findFirst() != null) {
                this.myVisitor.report(JavaErrorKinds.REFERENCE_IMPLICIT_CLASS.create(ref));
                return;
            }
            if (!definitelyIncorrect && this.myVisitor.isIncompleteModel() && IncompleteModelUtil.canBePendingReference((PsiJavaCodeReferenceElement)ref)) {
                this.myVisitor.report(JavaErrorKinds.REFERENCE_PENDING.create(Objects.requireNonNull(ref.getReferenceNameElement())));
                return;
            }
            this.myVisitor.report(JavaErrorKinds.REFERENCE_UNRESOLVED.create(ref));
        }
    }

    static boolean favorParentReport(@NotNull PsiCall methodCall, @NotNull String errorMessage) {
        if (methodCall == null) {
            ExpressionChecker.$$$reportNull$$$0(62);
        }
        if (errorMessage == null) {
            ExpressionChecker.$$$reportNull$$$0(63);
        }
        return (errorMessage.equals(JavaPsiBundle.message((String)"error.incompatible.type.failed.to.resolve.argument", (Object[])new Object[0])) || errorMessage.equals(JavaPsiBundle.message((String)"error.incompatible.type.declaration.for.the.method.reference.not.found", (Object[])new Object[0]))) && ExpressionChecker.hasSurroundingInferenceError((PsiElement)methodCall);
    }

    static boolean hasSurroundingInferenceError(@NotNull PsiElement context) {
        PsiCall topCall;
        if (context == null) {
            ExpressionChecker.$$$reportNull$$$0(64);
        }
        if ((topCall = LambdaUtil.treeWalkUp((PsiElement)context)) == null) {
            return false;
        }
        while (context != topCall) {
            MethodCandidateInfo info;
            PsiMethodCallExpression call;
            JavaResolveResult javaResolveResult;
            if (!((context = context.getParent()) instanceof PsiMethodCallExpression) || !((javaResolveResult = (call = (PsiMethodCallExpression)context).resolveMethodGenerics()) instanceof MethodCandidateInfo) || (info = (MethodCandidateInfo)javaResolveResult).getInferenceErrorMessage() == null) continue;
            return true;
        }
        return false;
    }

    void checkIncompatibleType(@NotNull PsiCall methodCall, @NotNull MethodCandidateInfo resolveResult, @NotNull PsiElement elementToHighlight) {
        PsiType actualType;
        String errorMessage;
        if (methodCall == null) {
            ExpressionChecker.$$$reportNull$$$0(65);
        }
        if (resolveResult == null) {
            ExpressionChecker.$$$reportNull$$$0(66);
        }
        if (elementToHighlight == null) {
            ExpressionChecker.$$$reportNull$$$0(67);
        }
        if ((errorMessage = resolveResult.getInferenceErrorMessage()) == null) {
            return;
        }
        if (ExpressionChecker.favorParentReport(methodCall, errorMessage)) {
            return;
        }
        PsiMethod method = resolveResult.getElement();
        PsiType expectedTypeByParent = InferenceSession.getTargetTypeByParent((PsiElement)methodCall);
        PsiType psiType = actualType = methodCall instanceof PsiExpression ? ((PsiExpression)methodCall.copy()).getType() : resolveResult.getSubstitutor(false).substitute(method.getReturnType());
        if (expectedTypeByParent != null && actualType != null && !expectedTypeByParent.isAssignableFrom(actualType)) {
            this.myVisitor.report(JavaErrorKinds.TYPE_INCOMPATIBLE.create(elementToHighlight, new JavaIncompatibleTypeErrorContext(expectedTypeByParent, actualType, errorMessage)));
        } else {
            this.myVisitor.report(JavaErrorKinds.CALL_TYPE_INFERENCE_ERROR.create(methodCall, errorMessage));
        }
    }

    private void checkVarargParameterErasureToBeAccessible(@NotNull MethodCandidateInfo info, @NotNull PsiCall place) {
        if (info == null) {
            ExpressionChecker.$$$reportNull$$$0(68);
        }
        if (place == null) {
            ExpressionChecker.$$$reportNull$$$0(69);
        }
        PsiMethod method = info.getElement();
        if (info.isVarargs() || method.isVarArgs() && !PsiUtil.isLanguageLevel8OrHigher((PsiElement)place)) {
            PsiParameter[] parameters = method.getParameterList().getParameters();
            PsiType componentType = ((PsiEllipsisType)parameters[parameters.length - 1].getType()).getComponentType();
            PsiType substitutedTypeErasure = TypeConversionUtil.erasure((PsiType)info.getSubstitutor().substitute(componentType));
            PsiClass targetClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)substitutedTypeErasure);
            if (targetClass != null && !PsiUtil.isAccessible((PsiMember)targetClass, (PsiElement)place, null)) {
                this.myVisitor.report(JavaErrorKinds.CALL_FORMAL_VARARGS_ELEMENT_TYPE_INACCESSIBLE_HERE.create(place, targetClass));
            }
        }
    }

    void checkStaticInterfaceCallQualifier(@NotNull PsiJavaCodeReferenceElement referenceToMethod, @NotNull JavaResolveResult resolveResult, @NotNull PsiClass containingClass) {
        if (referenceToMethod == null) {
            ExpressionChecker.$$$reportNull$$$0(70);
        }
        if (resolveResult == null) {
            ExpressionChecker.$$$reportNull$$$0(71);
        }
        if (containingClass == null) {
            ExpressionChecker.$$$reportNull$$$0(72);
        }
        PsiElement scope = resolveResult.getCurrentFileResolveScope();
        PsiElement qualifierExpression = referenceToMethod.getQualifier();
        if (qualifierExpression == null && PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)referenceToMethod, (boolean)true)) {
            return;
        }
        PsiClass resolve = null;
        if (qualifierExpression == null && scope instanceof PsiImportStaticStatement) {
            PsiImportStaticStatement statement = (PsiImportStaticStatement)scope;
            resolve = statement.resolveTargetClass();
        } else if (qualifierExpression instanceof PsiJavaCodeReferenceElement) {
            PsiJavaCodeReferenceElement element = (PsiJavaCodeReferenceElement)qualifierExpression;
            resolve = element.resolve();
        }
        if (containingClass.getManager().areElementsEquivalent(resolve, (PsiElement)containingClass)) {
            return;
        }
        if (resolve instanceof PsiTypeParameter) {
            PsiTypeParameter typeParameter = (PsiTypeParameter)resolve;
            HashSet<PsiClass> classes = new HashSet<PsiClass>();
            for (PsiClassType type : typeParameter.getExtendsListTypes()) {
                PsiClass aClass = type.resolve();
                if (aClass == null) continue;
                classes.add(aClass);
            }
            if (classes.size() == 1 && classes.contains(containingClass)) {
                return;
            }
        }
        this.myVisitor.report(JavaErrorKinds.CALL_STATIC_INTERFACE_METHOD_QUALIFIER.create(referenceToMethod));
    }

    private static boolean shouldHighlightUnhandledException(@NotNull PsiElement element) {
        PsiMethod targetMethod;
        if (element == null) {
            ExpressionChecker.$$$reportNull$$$0(73);
        }
        return !FileTypeUtils.isInServerPageFile((PsiElement)element) || !((targetMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class})) instanceof SyntheticElement);
    }

    void checkUnhandledExceptions(@NotNull PsiElement element) {
        List unhandled;
        if (element == null) {
            ExpressionChecker.$$$reportNull$$$0(74);
        }
        if ((unhandled = ExceptionUtil.getOwnUnhandledExceptions((PsiElement)element)).isEmpty()) {
            return;
        }
        if ((unhandled = ContainerUtil.filter((Collection)unhandled, type -> type.resolve() != null)).isEmpty()) {
            return;
        }
        if (!ExpressionChecker.shouldHighlightUnhandledException(element)) {
            return;
        }
        this.myVisitor.report(JavaErrorKinds.EXCEPTION_UNHANDLED.create(element, unhandled));
    }

    void checkConstructorCall(@NotNull PsiClassType.ClassResolveResult typeResolveResult, @NotNull PsiConstructorCall constructorCall, @Nullable PsiJavaCodeReferenceElement classReference) {
        PsiMethod[] constructors;
        PsiNewExpression newExpression;
        PsiExpression qualifier;
        PsiExpressionList list;
        if (typeResolveResult == null) {
            ExpressionChecker.$$$reportNull$$$0(75);
        }
        if (constructorCall == null) {
            ExpressionChecker.$$$reportNull$$$0(76);
        }
        if ((list = constructorCall.getArgumentList()) == null) {
            return;
        }
        PsiClass aClass = typeResolveResult.getElement();
        if (aClass == null) {
            return;
        }
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)this.myVisitor.project()).getResolveHelper();
        PsiClass accessObjectClass = null;
        if (constructorCall instanceof PsiNewExpression && (qualifier = (newExpression = (PsiNewExpression)constructorCall).getQualifier()) != null) {
            accessObjectClass = (PsiClass)PsiUtil.getAccessObjectClass((PsiExpression)qualifier).getElement();
        }
        if (classReference != null && !resolveHelper.isAccessible((PsiMember)aClass, (PsiElement)constructorCall, accessObjectClass)) {
            this.myVisitor.myModifierChecker.reportAccessProblem((PsiElement)classReference, (PsiModifierListOwner)aClass, (JavaResolveResult)typeResolveResult);
        }
        if ((constructors = aClass.getConstructors()).length == 0) {
            if (classReference != null && aClass.hasModifierProperty("protected") && ExpressionChecker.callingProtectedConstructorFromDerivedClass(constructorCall, aClass)) {
                this.myVisitor.myModifierChecker.reportAccessProblem((PsiElement)classReference, (PsiModifierListOwner)aClass, (JavaResolveResult)typeResolveResult);
            } else if (aClass.isInterface() && constructorCall instanceof PsiNewExpression) {
                PsiNewExpression newExpression2 = (PsiNewExpression)constructorCall;
                PsiReferenceParameterList typeArgumentList = newExpression2.getTypeArgumentList();
                if (typeArgumentList.getTypeArguments().length > 0) {
                    this.myVisitor.report(JavaErrorKinds.NEW_EXPRESSION_ANONYMOUS_IMPLEMENTS_INTERFACE_WITH_TYPE_ARGUMENTS.create(typeArgumentList));
                }
                return;
            }
        }
        Object[] results = constructorCall.multiResolve(false);
        MethodCandidateInfo result = null;
        if (results.length == 1) {
            result = (MethodCandidateInfo)results[0];
        }
        PsiMethod constructor = result == null ? null : result.getElement();
        boolean applicable = true;
        try {
            JavaResolveResult staticFactory;
            PsiDiamondType psiDiamondType;
            if (constructorCall instanceof PsiNewExpression) {
                PsiNewExpression newExpression3 = (PsiNewExpression)constructorCall;
                psiDiamondType = PsiDiamondType.getDiamondType((PsiNewExpression)newExpression3);
            } else {
                psiDiamondType = null;
            }
            PsiDiamondType diamondType = psiDiamondType;
            JavaResolveResult javaResolveResult = staticFactory = diamondType != null ? diamondType.getStaticFactory() : null;
            if (staticFactory instanceof MethodCandidateInfo) {
                MethodCandidateInfo info = (MethodCandidateInfo)staticFactory;
                if (info.isApplicable()) {
                    result = info;
                    if (constructor == null) {
                        constructor = info.getElement();
                    }
                } else {
                    applicable = false;
                }
            } else {
                applicable = result != null && result.isApplicable();
            }
        }
        catch (IndexNotReadyException diamondType) {
            // empty catch block
        }
        if (constructor == null) {
            if (this.myVisitor.isIncompleteModel() && ContainerUtil.exists((Object[])results, r -> {
                MethodCandidateInfo info;
                return r instanceof MethodCandidateInfo && (info = (MethodCandidateInfo)r).isPotentiallyCompatible() == ThreeState.YES;
            }) && ContainerUtil.exists((Object[])list.getExpressions(), e -> IncompleteModelUtil.mayHaveUnknownTypeDueToPendingReference((PsiExpression)e))) {
                return;
            }
            this.myVisitor.report(JavaErrorKinds.NEW_EXPRESSION_UNRESOLVED_CONSTRUCTOR.create(constructorCall, new JavaErrorKinds.UnresolvedConstructorContext(aClass, (JavaResolveResult[])results)));
            return;
        }
        if (classReference != null && !constructor.isDefaultConstructor() && (!result.isAccessible() || constructor.hasModifierProperty("protected") && ExpressionChecker.callingProtectedConstructorFromDerivedClass(constructorCall, aClass))) {
            this.myVisitor.myModifierChecker.reportAccessProblem((PsiElement)classReference, (PsiModifierListOwner)constructor, (JavaResolveResult)result);
            return;
        }
        if (!applicable) {
            this.checkIncompatibleCall(list, result);
            if (this.myVisitor.hasErrorResults()) {
                return;
            }
        } else if (constructorCall instanceof PsiNewExpression) {
            PsiNewExpression newExpression4 = (PsiNewExpression)constructorCall;
            PsiReferenceParameterList typeArgumentList = newExpression4.getTypeArgumentList();
            this.myVisitor.myGenericsChecker.checkReferenceTypeArgumentList((PsiTypeParameterListOwner)constructor, typeArgumentList, result.getSubstitutor());
            if (this.myVisitor.hasErrorResults()) {
                return;
            }
        }
        this.checkVarargParameterErasureToBeAccessible(result, (PsiCall)constructorCall);
        if (this.myVisitor.hasErrorResults()) {
            return;
        }
        this.checkIncompatibleType((PsiCall)constructorCall, result, (PsiElement)constructorCall);
    }

    private static boolean callingProtectedConstructorFromDerivedClass(@NotNull PsiConstructorCall place, @NotNull PsiClass constructorClass) {
        PsiClass aClass;
        PsiNewExpression newExpression;
        if (place == null) {
            ExpressionChecker.$$$reportNull$$$0(77);
        }
        if (constructorClass == null) {
            ExpressionChecker.$$$reportNull$$$0(78);
        }
        if (place instanceof PsiNewExpression && (newExpression = (PsiNewExpression)place).getAnonymousClass() != null) {
            return false;
        }
        PsiConstructorCall curElement = place;
        PsiClass containingClass = constructorClass.getContainingClass();
        do {
            if ((aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)curElement, PsiClass.class)) == null) {
                return false;
            }
            curElement = aClass;
        } while (!aClass.isInheritor(constructorClass, true) && (containingClass == null || !aClass.isInheritor(containingClass, true)) || JavaPsiFacade.getInstance((Project)aClass.getProject()).arePackagesTheSame((PsiElement)aClass, (PsiElement)constructorClass));
        return true;
    }

    @NotNull
    private static Pair<MethodCandidateInfo, MethodCandidateInfo> findCandidates(JavaResolveResult @NotNull [] resolveResults) {
        if (resolveResults == null) {
            ExpressionChecker.$$$reportNull$$$0(79);
        }
        MethodCandidateInfo methodCandidate1 = null;
        MethodCandidateInfo methodCandidate2 = null;
        for (JavaResolveResult result : resolveResults) {
            MethodCandidateInfo candidate;
            if (!(result instanceof MethodCandidateInfo) || !(candidate = (MethodCandidateInfo)result).isApplicable() || candidate.getElement().isConstructor()) continue;
            if (methodCandidate1 == null) {
                methodCandidate1 = candidate;
                continue;
            }
            methodCandidate2 = candidate;
            break;
        }
        Pair pair = Pair.pair(methodCandidate1, methodCandidate2);
        if (pair == null) {
            ExpressionChecker.$$$reportNull$$$0(80);
        }
        return pair;
    }

    void checkAmbiguousMethodCallArguments(JavaResolveResult @NotNull [] resolveResults, @NotNull JavaResolveResult resolveResult, @NotNull PsiMethodCallExpression methodCall) {
        if (resolveResult == null) {
            ExpressionChecker.$$$reportNull$$$0(81);
        }
        if (methodCall == null) {
            ExpressionChecker.$$$reportNull$$$0(82);
        }
        if (resolveResults == null) {
            ExpressionChecker.$$$reportNull$$$0(83);
        }
        PsiExpressionList list = methodCall.getArgumentList();
        Pair<MethodCandidateInfo, MethodCandidateInfo> pair = ExpressionChecker.findCandidates(resolveResults);
        MethodCandidateInfo methodCandidate1 = (MethodCandidateInfo)pair.first;
        MethodCandidateInfo methodCandidate2 = (MethodCandidateInfo)pair.second;
        Object[] expressions = list.getExpressions();
        if (PsiTreeUtil.hasErrorElements((PsiElement)list)) {
            return;
        }
        if (methodCandidate2 != null) {
            if (this.myVisitor.isIncompleteModel() && ContainerUtil.exists((Object[])expressions, e -> IncompleteModelUtil.mayHaveUnknownTypeDueToPendingReference((PsiExpression)e))) {
                return;
            }
            this.myVisitor.report(JavaErrorKinds.CALL_AMBIGUOUS.create(methodCall, new JavaAmbiguousCallContext(resolveResults, methodCandidate1, methodCandidate2)));
        } else {
            if (!(resolveResult.getElement() == null || resolveResult.isAccessible() && resolveResult.isStaticsScopeCorrect())) {
                return;
            }
            if (!ContainerUtil.exists((Object[])resolveResults, result -> result instanceof MethodCandidateInfo && result.isAccessible())) {
                return;
            }
            if (this.myVisitor.isIncompleteModel() && ContainerUtil.exists((Object[])expressions, IncompleteModelUtil::mayHaveUnknownTypeDueToPendingReference)) {
                return;
            }
            if (ContainerUtil.exists((Object[])expressions, e -> e.getType() == null)) {
                return;
            }
            this.myVisitor.report(JavaErrorKinds.CALL_UNRESOLVED.create(methodCall, resolveResults));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void checkAmbiguousMethodCallIdentifier(JavaResolveResult @NotNull [] resolveResults, @NotNull JavaResolveResult resolveResult, @NotNull PsiMethodCallExpression methodCall) {
        PsiPrimitiveType primitiveType;
        PsiType psiType;
        if (resolveResult == null) {
            ExpressionChecker.$$$reportNull$$$0(84);
        }
        if (methodCall == null) {
            ExpressionChecker.$$$reportNull$$$0(85);
        }
        if (resolveResults == null) {
            ExpressionChecker.$$$reportNull$$$0(86);
        }
        PsiReferenceExpression referenceToMethod = methodCall.getMethodExpression();
        PsiElement element = resolveResult.getElement();
        MethodCandidateInfo methodCandidate2 = (MethodCandidateInfo)ExpressionChecker.findCandidates((JavaResolveResult[])resolveResults).second;
        if (methodCandidate2 != null) {
            return;
        }
        PsiElement anchor = (PsiElement)Objects.requireNonNullElse(referenceToMethod.getReferenceNameElement(), referenceToMethod);
        if (element instanceof PsiModifierListOwner) {
            PsiModifierListOwner owner = (PsiModifierListOwner)element;
            if (!resolveResult.isAccessible()) {
                this.myVisitor.myModifierChecker.reportAccessProblem((PsiElement)referenceToMethod, owner, resolveResult);
                return;
            }
        }
        if (element != null && !resolveResult.isStaticsScopeCorrect()) {
            PsiClass containingClass;
            PsiMethod psiMethod;
            if (element instanceof PsiMethod && (psiMethod = (PsiMethod)element).hasModifierProperty("static") && (containingClass = psiMethod.getContainingClass()) != null && containingClass.isInterface()) {
                this.myVisitor.checkFeature(anchor, JavaFeature.STATIC_INTERFACE_CALLS);
                if (this.myVisitor.hasErrorResults()) {
                    return;
                }
                this.checkStaticInterfaceCallQualifier((PsiJavaCodeReferenceElement)referenceToMethod, resolveResult, containingClass);
                if (this.myVisitor.hasErrorResults()) {
                    return;
                }
            }
            this.myVisitor.report(JavaErrorKinds.REFERENCE_NON_STATIC_FROM_STATIC_CONTEXT.create((PsiJavaCodeReferenceElement)referenceToMethod, element));
            return;
        }
        if (ContainerUtil.exists((Object[])resolveResults, result -> result instanceof MethodCandidateInfo && result.isAccessible())) return;
        PsiClass qualifierClass = RefactoringChangeUtil.getQualifierClass((PsiReferenceExpression)referenceToMethod);
        String className = qualifierClass != null ? qualifierClass.getName() : null;
        PsiExpression qualifierExpression = referenceToMethod.getQualifierExpression();
        if (className != null) {
            if (this.myVisitor.isIncompleteModel() && IncompleteModelUtil.canBePendingReference((PsiJavaCodeReferenceElement)referenceToMethod)) {
                this.myVisitor.report(JavaErrorKinds.REFERENCE_PENDING.create(anchor));
                return;
            }
            this.myVisitor.report(JavaErrorKinds.CALL_AMBIGUOUS_NO_MATCH.create(methodCall, resolveResults));
            return;
        }
        if (qualifierExpression != null && (psiType = qualifierExpression.getType()) instanceof PsiPrimitiveType && !(primitiveType = (PsiPrimitiveType)psiType).equals((Object)PsiTypes.nullType())) {
            this.myVisitor.report(JavaErrorKinds.CALL_QUALIFIER_PRIMITIVE.create(methodCall, primitiveType));
            return;
        }
        if (this.myVisitor.isIncompleteModel() && IncompleteModelUtil.canBePendingReference((PsiJavaCodeReferenceElement)referenceToMethod)) {
            this.myVisitor.report(JavaErrorKinds.REFERENCE_PENDING.create(anchor));
            return;
        }
        this.myVisitor.report(JavaErrorKinds.CALL_UNRESOLVED_NAME.create(methodCall, resolveResults));
    }

    void checkRestrictedIdentifierReference(@NotNull PsiJavaCodeReferenceElement ref, @NotNull PsiClass resolved) {
        String name;
        if (ref == null) {
            ExpressionChecker.$$$reportNull$$$0(87);
        }
        if (resolved == null) {
            ExpressionChecker.$$$reportNull$$$0(88);
        }
        if (PsiTypesUtil.isRestrictedIdentifier((String)(name = resolved.getName()), (LanguageLevel)this.myVisitor.languageLevel())) {
            this.myVisitor.report(JavaErrorKinds.TYPE_RESTRICTED_IDENTIFIER.create(ref));
        }
    }

    void checkInstanceOfApplicable(@NotNull PsiInstanceOfExpression expression) {
        if (expression == null) {
            ExpressionChecker.$$$reportNull$$$0(89);
        }
        PsiExpression operand = expression.getOperand();
        PsiTypeElement typeElement = expression.getCheckType();
        if (typeElement == null) {
            typeElement = JavaPsiPatternUtil.getPatternTypeElement((PsiCaseLabelElement)expression.getPattern());
        }
        if (typeElement == null) {
            return;
        }
        PsiType checkType = typeElement.getType();
        PsiType operandType = operand.getType();
        if (operandType == null) {
            return;
        }
        boolean operandIsPrimitive = TypeConversionUtil.isPrimitiveAndNotNull((PsiType)operandType);
        boolean checkIsPrimitive = TypeConversionUtil.isPrimitiveAndNotNull((PsiType)checkType);
        boolean convertible = TypeConversionUtil.areTypesConvertible((PsiType)operandType, (PsiType)checkType);
        boolean primitiveInPatternsEnabled = PsiUtil.isAvailable((JavaFeature)JavaFeature.PRIMITIVE_TYPES_IN_PATTERNS, (PsiElement)expression);
        if ((operandIsPrimitive || checkIsPrimitive) && !primitiveInPatternsEnabled || !convertible) {
            if (!convertible && this.myVisitor.isIncompleteModel() && IncompleteModelUtil.isPotentiallyConvertible((PsiType)checkType, (PsiExpression)operand)) {
                return;
            }
            if ((operandIsPrimitive || checkIsPrimitive) && !primitiveInPatternsEnabled && convertible) {
                this.myVisitor.checkFeature((PsiElement)expression, JavaFeature.PRIMITIVE_TYPES_IN_PATTERNS);
                if (this.myVisitor.hasErrorResults()) {
                    return;
                }
            }
            this.myVisitor.report(JavaErrorKinds.CAST_INCONVERTIBLE.create((PsiElement)expression, new JavaIncompatibleTypeErrorContext(operandType, checkType)));
            return;
        }
        PsiPrimaryPattern pattern = expression.getPattern();
        if (pattern instanceof PsiDeconstructionPattern) {
            PsiDeconstructionPattern deconstruction = (PsiDeconstructionPattern)pattern;
            this.myVisitor.myPatternChecker.checkDeconstructionErrors(deconstruction);
        }
    }

    void checkConditionalExpressionBranchTypesMatch(@NotNull PsiExpression expression, @Nullable PsiType type) {
        PsiElement parent;
        if (expression == null) {
            ExpressionChecker.$$$reportNull$$$0(90);
        }
        if (!((parent = expression.getParent()) instanceof PsiConditionalExpression)) {
            return;
        }
        PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)parent;
        if (conditionalExpression.getElseExpression() != expression) {
            return;
        }
        PsiExpression thenExpression = conditionalExpression.getThenExpression();
        assert (thenExpression != null);
        PsiType thenType = thenExpression.getType();
        if (thenType == null || type == null) {
            return;
        }
        if (conditionalExpression.getType() == null) {
            if (PsiUtil.isLanguageLevel8OrHigher((PsiElement)conditionalExpression) && PsiPolyExpressionUtil.isPolyExpression((PsiExpression)conditionalExpression)) {
                return;
            }
            this.myVisitor.reportIncompatibleType(thenType, type, (PsiElement)expression);
        }
    }

    void checkSelectFromTypeParameter(@NotNull PsiJavaCodeReferenceElement ref, @Nullable PsiElement resolved) {
        if (ref == null) {
            ExpressionChecker.$$$reportNull$$$0(91);
        }
        if ((ref.getParent() instanceof PsiJavaCodeReferenceElement || ref.isQualified()) && resolved instanceof PsiTypeParameter) {
            PsiClass containingClass;
            boolean canSelectFromTypeParameter = this.myVisitor.sdkVersion().isAtLeast(JavaSdkVersion.JDK_1_7);
            if (canSelectFromTypeParameter && (containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiClass.class)) != null && (PsiTreeUtil.isAncestor((PsiElement)containingClass.getExtendsList(), (PsiElement)ref, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)containingClass.getImplementsList(), (PsiElement)ref, (boolean)false))) {
                canSelectFromTypeParameter = false;
            }
            if (!canSelectFromTypeParameter) {
                this.myVisitor.report(JavaErrorKinds.REFERENCE_SELECT_FROM_TYPE_PARAMETER.create(ref));
            }
        }
    }

    private PsiMethod findSurroundingConstructor(@NotNull PsiElement entry) {
        PsiElement element;
        if (entry == null) {
            ExpressionChecker.$$$reportNull$$$0(92);
        }
        PsiMethod result = null;
        for (element = entry; element != null && !(element instanceof PsiFile) && (result = this.myInsideConstructorOfClassCache.get(element)) == null && !this.myInsideConstructorOfClassCache.containsKey(element); element = element.getParent()) {
            PsiMethod method;
            if (!(element instanceof PsiMethod) || !(method = (PsiMethod)element).isConstructor()) continue;
            result = method;
            break;
        }
        for (PsiElement e = entry; e != null && !(e instanceof PsiFile); e = e.getParent()) {
            this.myInsideConstructorOfClassCache.put(e, result);
            if (e == element) break;
        }
        return result;
    }

    private static boolean isOnSimpleAssignmentLeftHand(@NotNull PsiElement expr) {
        PsiAssignmentExpression assignment;
        PsiElement parent;
        if (expr == null) {
            ExpressionChecker.$$$reportNull$$$0(93);
        }
        return (parent = PsiTreeUtil.skipParentsOfType((PsiElement)expr, (Class[])new Class[]{PsiParenthesizedExpression.class})) instanceof PsiAssignmentExpression && JavaTokenType.EQ == (assignment = (PsiAssignmentExpression)parent).getOperationTokenType() && PsiTreeUtil.isAncestor((PsiElement)assignment.getLExpression(), (PsiElement)expr, (boolean)false);
    }

    private static boolean isThisOrSuperReference(@Nullable PsiExpression qualifierExpression, @NotNull PsiClass aClass) {
        if (aClass == null) {
            ExpressionChecker.$$$reportNull$$$0(94);
        }
        if (qualifierExpression == null) {
            return true;
        }
        if (!(qualifierExpression instanceof PsiQualifiedExpression)) {
            return false;
        }
        PsiQualifiedExpression expression = (PsiQualifiedExpression)qualifierExpression;
        PsiJavaCodeReferenceElement qualifier = expression.getQualifier();
        if (qualifier == null) {
            return true;
        }
        PsiElement resolved = qualifier.resolve();
        return resolved instanceof PsiClass && InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)((PsiClass)resolved), (boolean)true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void checkMemberReferencedBeforeConstructorCalled(@NotNull PsiElement expression, @Nullable PsiElement resolved) {
        PsiField field;
        PsiReferenceExpression ref;
        LanguageLevel languageLevel;
        PsiMember member;
        PsiElement psiElement;
        String resolvedName;
        PsiClass referencedClass;
        PsiMethod constructor;
        if (expression == null) {
            ExpressionChecker.$$$reportNull$$$0(95);
        }
        if ((constructor = this.findSurroundingConstructor(expression)) == null) {
            return;
        }
        PsiMethodCallExpression constructorCall = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)constructor);
        if (constructorCall == null) {
            return;
        }
        if (expression.getTextOffset() > constructorCall.getTextOffset() + constructorCall.getTextLength()) {
            return;
        }
        PsiElement parent = expression.getParent();
        if (expression instanceof PsiJavaCodeReferenceElement) {
            PsiType psiType;
            PsiMethod psiMethod;
            PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)expression;
            if ("this".equals(referenceElement.getReferenceName()) && resolved instanceof PsiMethod && (psiMethod = (PsiMethod)resolved).isConstructor()) {
                return;
            }
            PsiElement qualifier = referenceElement.getQualifier();
            if (qualifier instanceof PsiExpression) {
                PsiExpression psiExpression = (PsiExpression)qualifier;
                psiType = psiExpression.getType();
            } else {
                psiType = null;
            }
            referencedClass = PsiUtil.resolveClassInType(psiType);
            boolean isSuperCall = JavaPsiConstructorUtil.isSuperConstructorCall((PsiElement)parent);
            if (resolved == null && isSuperCall) {
                if (qualifier instanceof PsiReferenceExpression) {
                    PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
                    resolved = referenceExpression.resolve();
                    expression = qualifier;
                    referencedClass = PsiUtil.resolveClassInType((PsiType)referenceExpression.getType());
                } else if (qualifier == null) {
                    resolved = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiMember.class});
                    if (resolved instanceof PsiMethod) {
                        PsiMethod psiMethod2 = (PsiMethod)resolved;
                        referencedClass = psiMethod2.getContainingClass();
                    }
                } else if (qualifier instanceof PsiThisExpression) {
                    PsiThisExpression thisExpression = (PsiThisExpression)qualifier;
                    referencedClass = PsiUtil.resolveClassInType((PsiType)thisExpression.getType());
                }
            }
            if (resolved instanceof PsiField) {
                PsiField field2 = (PsiField)resolved;
                if (field2.hasModifierProperty("static")) {
                    return;
                }
                if (this.myVisitor.isApplicable(JavaFeature.STATEMENTS_BEFORE_SUPER) && this.myVisitor.languageLevel() != LanguageLevel.JDK_22_PREVIEW && ExpressionChecker.isOnSimpleAssignmentLeftHand(expression) && field2.getContainingClass() == PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class})) {
                    if (!field2.hasInitializer()) return;
                    this.myVisitor.report(JavaErrorKinds.FIELD_INITIALIZED_BEFORE_CONSTRUCTOR_CALL.create(expression, field2));
                    return;
                }
                resolvedName = PsiFormatUtil.formatVariable((PsiVariable)field2, (int)4097, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                referencedClass = field2.getContainingClass();
            } else if (resolved instanceof PsiMethod) {
                String name;
                PsiMethod method = (PsiMethod)resolved;
                if (method.hasModifierProperty("static")) {
                    return;
                }
                PsiElement nameElement = expression instanceof PsiThisExpression ? expression : ((PsiJavaCodeReferenceElement)expression).getReferenceNameElement();
                String string = name = nameElement == null ? null : nameElement.getText();
                if (isSuperCall) {
                    if (referencedClass == null) {
                        return;
                    }
                    if (qualifier == null) {
                        PsiClass superClass = referencedClass.getSuperClass();
                        if (superClass == null || !PsiUtil.isInnerClass((PsiClass)superClass) || !InheritanceUtil.isInheritorOrSelf((PsiClass)referencedClass, (PsiClass)superClass.getContainingClass(), (boolean)true)) return;
                        resolvedName = "this";
                    } else {
                        resolvedName = qualifier.getText();
                    }
                } else if ("this".equals(name)) {
                    resolvedName = "this";
                } else {
                    resolvedName = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4097, (int)0);
                    if (referencedClass == null) {
                        referencedClass = method.getContainingClass();
                    }
                }
            } else {
                if (!(resolved instanceof PsiClass)) return;
                aClass = (PsiClass)resolved;
                if (expression instanceof PsiReferenceExpression) {
                    return;
                }
                if (aClass.hasModifierProperty("static")) {
                    return;
                }
                referencedClass = aClass.getContainingClass();
                if (referencedClass == null) {
                    return;
                }
                resolvedName = PsiFormatUtil.formatClass((PsiClass)aClass, (int)1);
            }
        } else {
            Object object;
            if (!(expression instanceof PsiQualifiedExpression)) return;
            PsiQualifiedExpression qualifiedExpression = (PsiQualifiedExpression)expression;
            referencedClass = PsiUtil.resolveClassInType((PsiType)qualifiedExpression.getType());
            String keyword = expression instanceof PsiThisExpression ? "this" : "super";
            PsiJavaCodeReferenceElement qualifier = qualifiedExpression.getQualifier();
            if (qualifier != null && (psiElement = qualifier.resolve()) instanceof PsiClass) {
                aClass = (PsiClass)psiElement;
                object = PsiFormatUtil.formatClass((PsiClass)aClass, (int)1) + "." + keyword;
            } else {
                object = keyword;
            }
            resolvedName = object;
        }
        if (referencedClass == null || PsiTreeUtil.getParentOfType((PsiElement)expression, PsiReferenceParameterList.class, (boolean)true, (Class[])new Class[]{PsiExpression.class}) != null) {
            return;
        }
        PsiClass parentClass = constructor.getContainingClass();
        if (parentClass == null) {
            return;
        }
        if (resolved instanceof PsiMember && (member = (PsiMember)resolved).hasModifierProperty("private") && referencedClass != parentClass) {
            return;
        }
        if (!InheritanceUtil.isInheritorOrSelf((PsiClass)parentClass, (PsiClass)referencedClass, (boolean)true)) {
            return;
        }
        if (expression instanceof PsiReferenceExpression) {
            PsiReferenceExpression ref2 = (PsiReferenceExpression)expression;
            PsiExpression qualifier = ref2.getQualifierExpression();
            if (!ExpressionChecker.isThisOrSuperReference(qualifier, parentClass)) {
                return;
            }
            if ((qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression) && ((PsiQualifiedExpression)qualifier).getQualifier() != null) {
                return;
            }
        }
        if (expression instanceof PsiThisExpression && referencedClass != parentClass) {
            return;
        }
        if (expression instanceof PsiJavaCodeReferenceElement) {
            PsiNewExpression newExpression;
            if (!parentClass.equals((Object)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class)) && PsiTreeUtil.getParentOfType((PsiElement)expression, PsiTypeElement.class) != null) {
                return;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClassObjectAccessExpression.class) != null) {
                return;
            }
            if (parent instanceof PsiNewExpression && (newExpression = (PsiNewExpression)parent).isArrayCreation() && newExpression.getClassOrAnonymousClassReference() == expression) {
                return;
            }
            if (parent instanceof PsiThisExpression || parent instanceof PsiSuperExpression) {
                return;
            }
        }
        if (!(expression instanceof PsiThisExpression) && !(expression instanceof PsiSuperExpression) || ((PsiQualifiedExpression)expression).getQualifier() == null) {
            PsiClass expressionClass = PsiUtil.getContainingClass((PsiElement)expression);
            while (expressionClass != null && parentClass != expressionClass) {
                if (InheritanceUtil.isInheritorOrSelf((PsiClass)expressionClass, (PsiClass)referencedClass, (boolean)true)) {
                    return;
                }
                expressionClass = PsiUtil.getContainingClass((PsiElement)expressionClass);
            }
        }
        if (expression instanceof PsiThisExpression && JavaFeature.STATEMENTS_BEFORE_SUPER.isSufficient(languageLevel = PsiUtil.getLanguageLevel((PsiElement)expression)) && languageLevel != LanguageLevel.JDK_22_PREVIEW && ExpressionChecker.isOnSimpleAssignmentLeftHand(parent = PsiUtil.skipParenthesizedExprUp((PsiElement)parent)) && parent instanceof PsiReferenceExpression && (psiElement = (ref = (PsiReferenceExpression)parent).resolve()) instanceof PsiField && (field = (PsiField)psiElement).getContainingClass() == PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class})) {
            return;
        }
        JavaErrorKind.Parameterized<PsiElement, String> kind = resolved instanceof PsiMethod ? JavaErrorKinds.CALL_MEMBER_BEFORE_CONSTRUCTOR : JavaErrorKinds.REFERENCE_MEMBER_BEFORE_CONSTRUCTOR;
        this.myVisitor.report(kind.create(expression, resolvedName));
    }

    void checkPackageAndClassConflict(@NotNull PsiJavaCodeReferenceElement ref) {
        Module module;
        if (ref == null) {
            ExpressionChecker.$$$reportNull$$$0(96);
        }
        if (ref.isQualified() && ExpressionChecker.getOuterReferenceParent(ref).getParent() instanceof PsiPackageStatement && (module = ModuleUtilCore.findModuleForFile((PsiFile)this.myVisitor.file())) != null) {
            GlobalSearchScope scope = module.getModuleWithDependenciesAndLibrariesScope(false);
            PsiClass aClass = JavaPsiFacade.getInstance((Project)ref.getProject()).findClass(ref.getCanonicalText(), scope);
            if (aClass != null) {
                this.myVisitor.report(JavaErrorKinds.PACKAGE_CLASHES_WITH_CLASS.create(ref));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 57, 80 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 2: 
            case 16: 
            case 18: 
            case 20: 
            case 31: 
            case 41: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 89: 
            case 90: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 6: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 4: 
            case 73: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeToSearchEnclosingFrom";
                break;
            }
            case 7: 
            case 69: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerClass";
                break;
            }
            case 9: 
            case 10: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToHighlight";
                break;
            }
            case 11: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializerList";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultForIncompleteCode";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayAccessExpression";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedField";
                break;
            }
            case 22: 
            case 29: 
            case 33: 
            case 62: 
            case 65: 
            case 82: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOwner";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateInfo";
                break;
            }
            case 28: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateExpression";
                break;
            }
            case 32: 
            case 46: 
            case 56: 
            case 58: 
            case 60: 
            case 87: 
            case 91: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCallExpression";
                break;
            }
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unary";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 44: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 45: 
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "castTypeElement";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "castType";
                break;
            }
            case 57: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/java/codeserver/highlighting/ExpressionChecker";
                break;
            }
            case 59: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 66: 
            case 71: 
            case 81: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceToMethod";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeResolveResult";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorCall";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorClass";
                break;
            }
            case 79: 
            case 83: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/java/codeserver/highlighting/ExpressionChecker";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getOuterReferenceParent";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "findCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkQualifiedNew";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkCreateInnerClassFromStaticContext";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkIllegalEnclosingUsage";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkAssignability";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkMustBeBoolean";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkArrayInitializer";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkArrayInitializerCompatibleTypes";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkExpressionRequired";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "checkArrayInitializerApplicable";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkValidArrayAccessExpression";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkIllegalForwardReferenceToField";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodCall";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "checkInferredTypeArguments";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "checkIncompatibleCall";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "checkInferredReturnTypeAccessible";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "checkTemplateExpression";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "checkNewExpression";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "checkAmbiguousConstructorCall";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "checkConstructorCallProblems";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "checkSuperAbstractMethodDirectCall";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "checkQualifier";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "checkThisExpressionInIllegalContext";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "checkSuperExpressionInIllegalContext";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "checkAssignmentCompatibleTypes";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "checkAssignmentOperatorApplicable";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "checkUnaryOperatorApplicable";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "checkPolyadicOperatorApplicable";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "checkUnqualifiedSuperInDefaultMethod";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "checkUnderscore";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "checkUnhandledCloserExceptions";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "checkVarTypeSelfReferencing";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "checkVariableExpected";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "checkInconvertibleTypeCast";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "checkIntersectionInTypeCast";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "checkResourceVariableIsFinal";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "checkClassReferenceAfterQualifier";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isIntersection";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "isArrayDeclaration";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "checkUnnamedVariableDeclaration";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getOuterReferenceParent";
                break;
            }
            case 57: 
            case 80: {
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "checkReference";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "checkUnresolvedReference";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "favorParentReport";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "hasSurroundingInferenceError";
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "checkIncompatibleType";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "checkVarargParameterErasureToBeAccessible";
                break;
            }
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "checkStaticInterfaceCallQualifier";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "shouldHighlightUnhandledException";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "checkUnhandledExceptions";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "checkConstructorCall";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "callingProtectedConstructorFromDerivedClass";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "findCandidates";
                break;
            }
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "checkAmbiguousMethodCallArguments";
                break;
            }
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "checkAmbiguousMethodCallIdentifier";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "checkRestrictedIdentifierReference";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "checkInstanceOfApplicable";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "checkConditionalExpressionBranchTypesMatch";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "checkSelectFromTypeParameter";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "findSurroundingConstructor";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "isOnSimpleAssignmentLeftHand";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "isThisOrSuperReference";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "checkMemberReferencedBeforeConstructorCalled";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "checkPackageAndClassConflict";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 57, 80 -> new IllegalStateException(string);
        };
    }
}

